/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import mmmlibx.lib.FileManager;

public class MMM_Config {
    public static File configDir;
    public static String[] cfg_comment;
    public static int cfg_testi;
    public static byte cfg_testb;
    public static String cfg_tests;

    public static void init() {
        configDir = new File(FileManager.minecraftDir, "config");
    }

    protected static File getConfigFile(Class pClass) {
        return new File(configDir, pClass.getSimpleName() + ".cfg");
    }

    protected static List getConfigFields(Class pClass) {
        ArrayList<Field> llist = new ArrayList<Field>();
        Field[] lfeilds = pClass.getDeclaredFields();
        if (lfeilds != null) {
            for (Field lf : lfeilds) {
                int li = lf.getModifiers();
                if (!Modifier.isStatic(li) || Modifier.isPrivate(li) || !lf.getName().startsWith("cfg_")) continue;
                llist.add(lf);
            }
        }
        return llist;
    }

    public static void saveConfig(Class pClass) {
        File lfile = MMM_Config.getConfigFile(pClass);
        List llist = MMM_Config.getConfigFields(pClass);
        StringBuilder lsb = new StringBuilder();
        Properties lprop = new Properties();
        try {
            for (Field lf : llist) {
                if (lf.getName().equals("cfg_comment")) {
                    String[] ls;
                    for (String lt : ls = (String[])lf.get(null)) {
                        lsb.append(lt).append("\n");
                    }
                    continue;
                }
                lprop.setProperty(lf.getName(), lf.get(null).toString());
            }
            lprop.store(new FileOutputStream(lfile), lsb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig(Class pClass) {
        File lfile = MMM_Config.getConfigFile(pClass);
        if (!lfile.exists() || !lfile.isFile()) {
            return;
        }
        List llist = MMM_Config.getConfigFields(pClass);
        StringBuilder lsb = new StringBuilder();
        Properties lprop = new Properties();
        try {
            lprop.load(new FileInputStream(lfile));
            for (Field lf : llist) {
                if (!lprop.containsKey(lf.getName())) continue;
                String ls = lprop.getProperty(lf.getName());
                Class<Object> lc = lf.getType();
                if (lc.isAssignableFrom(String.class)) {
                    lf.set(null, ls);
                    continue;
                }
                if (lc.isAssignableFrom(Byte.TYPE)) {
                    lf.setByte(null, Byte.parseByte(ls));
                    continue;
                }
                if (lc.isAssignableFrom(Short.TYPE)) {
                    lf.setShort(null, Short.parseShort(ls));
                    continue;
                }
                if (lc.isAssignableFrom(Integer.TYPE)) {
                    if (ls.startsWith("0x")) {
                        lf.setInt(null, Integer.parseInt(ls, 16));
                        continue;
                    }
                    lf.setInt(null, Integer.parseInt(ls));
                    continue;
                }
                if (lc.isAssignableFrom(Long.TYPE)) {
                    if (ls.startsWith("0x")) {
                        lf.setLong(null, Long.parseLong(ls, 16));
                        continue;
                    }
                    lf.setLong(null, Long.parseLong(ls));
                    continue;
                }
                if (lc.isAssignableFrom(Boolean.TYPE)) {
                    lf.setBoolean(null, Boolean.parseBoolean(ls));
                    continue;
                }
                if (lc.isAssignableFrom(Float.TYPE)) {
                    lf.setFloat(null, Float.parseFloat(ls));
                    continue;
                }
                if (!lc.isAssignableFrom(Double.TYPE)) continue;
                lf.setDouble(null, Double.parseDouble(ls));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkConfig(Class pClass) {
        MMM_Config.loadConfig(pClass);
        MMM_Config.saveConfig(pClass);
    }

    static {
        cfg_comment = new String[]{"test code", "can br ?"};
        cfg_testi = 1;
        cfg_testb = (byte)2;
        cfg_tests = "test string";
    }
}

