/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mmmlibx.lib.Client;
import mmmlibx.lib.FileManager;
import mmmlibx.lib.ITextureEntity;
import mmmlibx.lib.MMMLib;
import mmmlibx.lib.MMM_Helper;
import mmmlibx.lib.MMM_TextureBox;
import mmmlibx.lib.MMM_TextureBoxBase;
import mmmlibx.lib.MMM_TextureBoxServer;
import mmmlibx.lib.multiModel.model.mc162.ModelMultiBase;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;

public class MMM_TextureManager {
    public static MMM_TextureManager instance = new MMM_TextureManager();
    public static String nameTextureIndex = "config/mod_MMM_textureList.cfg";
    public static String defaultModelName = "Orign";
    public static final int tx_oldwild = 16;
    public static final int tx_oldarmor1 = 17;
    public static final int tx_oldarmor2 = 18;
    public static final int tx_oldeye = 19;
    public static final int tx_gui = 32;
    public static final int tx_wild = 48;
    public static final int tx_armor1 = 64;
    public static final int tx_armor2 = 80;
    public static final int tx_eye = 96;
    public static final int tx_eyecontract = 96;
    public static final int tx_eyewild = 112;
    public static final int tx_armor1light = 128;
    public static final int tx_armor2light = 144;
    public static String[] armorFilenamePrefix;
    protected static String[] defNames;
    protected Map<String, ModelMultiBase[]> modelMap = new TreeMap<String, ModelMultiBase[]>();
    private List<MMM_TextureBox> textures = new ArrayList<MMM_TextureBox>();
    public Map<MMM_TextureBox, Integer> textureServerIndex = new HashMap<MMM_TextureBox, Integer>();
    public List<MMM_TextureBoxServer> textureServer = new ArrayList<MMM_TextureBoxServer>();
    protected Map<Class, MMM_TextureBox> defaultTextures = new HashMap<Class, MMM_TextureBox>();
    protected String[] requestString = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    protected int[] requestStringCounter = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected int[] requestIndex = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    protected int[] requestIndexCounter = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected Map<ITextureEntity, int[]> stackGetTexturePack = new HashMap<ITextureEntity, int[]>();
    protected Map<ITextureEntity, Object[]> stackSetTexturePack = new HashMap<ITextureEntity, Object[]>();
    protected List<String[]> searchPrefix = new ArrayList<String[]>();

    public void init() {
        FileManager.getModFile("mmmlibx", "littleMaidMob");
        FileManager.getModFile("mmmlibx", "mmmlibx");
        FileManager.getModFile("mmmlibx", "ModelMulti");
        this.addSearch("mmmlibx", "/assets/minecraft/textures/entity/ModelMulti/", "ModelMulti_");
        this.addSearch("mmmlibx", "/assets/minecraft/textures/entity/littleMaid/", "ModelMulti_");
        this.addSearch("mmmlibx", "/assets/minecraft/textures/entity/littleMaid/", "ModelLittleMaid_");
    }

    protected String[] getSearch(String pName) {
        for (String[] lss : this.searchPrefix) {
            if (!lss[0].equals(pName)) continue;
            return lss;
        }
        return null;
    }

    public void addSearch(String pName, String pTextureDir, String pClassPrefix) {
        this.searchPrefix.add(new String[]{pName, pTextureDir, pClassPrefix});
    }

    public MMM_TextureBox getTextureBox(String pName) {
        for (MMM_TextureBox ltb : MMM_TextureManager.getTextureList()) {
            if (!ltb.textureName.equals(pName)) continue;
            return ltb;
        }
        return null;
    }

    public static List<MMM_TextureBox> getTextureList() {
        return MMM_TextureManager.instance.textures;
    }

    public MMM_TextureBox getTextureBox(MMM_TextureBoxBase pBoxBase) {
        if (pBoxBase instanceof MMM_TextureBox) {
            return (MMM_TextureBox)pBoxBase;
        }
        if (pBoxBase instanceof MMM_TextureBoxServer) {
            return this.getTextureBox(pBoxBase.textureName);
        }
        return null;
    }

    public MMM_TextureBoxServer getTextureBoxServer(String pName) {
        for (MMM_TextureBoxServer lbox : this.textureServer) {
            if (!lbox.textureName.equals(pName)) continue;
            return lbox;
        }
        return null;
    }

    public MMM_TextureBoxServer getTextureBoxServer(int pIndex) {
        if (this.textureServer.size() > pIndex) {
            return this.textureServer.get(pIndex);
        }
        return null;
    }

    protected void getArmorPrefix() {
        armorFilenamePrefix = RenderBiped.field_82424_k;
    }

    public boolean loadTextures() {
        MMMLib.Debug("loadTexturePacks.", new Object[0]);
        if (MMM_Helper.isClient) {
            this.getArmorPrefix();
        }
        for (String[] lss : this.searchPrefix) {
            MMMLib.Debug("getTexture[%s:%s].", lss[0], lss[1]);
            for (File lf : FileManager.getFileList(lss[0])) {
                for (String[] lst : this.searchPrefix) {
                    boolean lflag = lf.isDirectory() ? this.addTexturesDir(lf, lst) : this.addTexturesZip(lf, lst);
                    MMMLib.Debug("getTexture-append-%s-%s.", lf.getName(), lflag ? "done" : "fail");
                }
            }
        }
        this.buildCrafterTexture();
        ModelMultiBase[] ldm = this.modelMap.get(defaultModelName);
        if (ldm == null && !this.modelMap.isEmpty()) {
            ldm = (ModelMultiBase[])this.modelMap.values().toArray()[0];
        }
        for (MMM_TextureBox mMM_TextureBox : this.textures) {
            if (mMM_TextureBox.modelName.isEmpty()) {
                mMM_TextureBox.setModels(defaultModelName, null, ldm);
                continue;
            }
            if (!this.modelMap.containsKey(mMM_TextureBox.modelName)) continue;
            mMM_TextureBox.setModels(mMM_TextureBox.modelName, this.modelMap.get(mMM_TextureBox.modelName), ldm);
        }
        for (Map.Entry entry : this.modelMap.entrySet()) {
            String ls = ((ModelMultiBase[])entry.getValue())[0].getUsingTexture();
            if (ls == null || this.getTextureBox(ls + "_" + (String)entry.getKey()) != null) continue;
            MMM_TextureBox lbox = null;
            for (MMM_TextureBox ltb : this.textures) {
                if (!ltb.packegeName.equals(ls)) continue;
                lbox = ltb;
                break;
            }
            if (lbox == null) continue;
            lbox = lbox.duplicate();
            lbox.setModels((String)entry.getKey(), null, (ModelMultiBase[])entry.getValue());
            this.textures.add(lbox);
        }
        MMMLib.Debug("Loaded Texture Lists.(%d)", this.textures.size());
        for (MMM_TextureBox mMM_TextureBox : this.textures) {
            MMMLib.Debug("texture: %s(%s) - hasModel:%b", mMM_TextureBox.textureName, mMM_TextureBox.fileName, mMM_TextureBox.models != null);
        }
        for (int li = this.textures.size() - 1; li >= 0; --li) {
            if (this.textures.get((int)li).models != null) continue;
            this.textures.remove(li);
        }
        MMMLib.Debug("Rebuild Texture Lists.(%d)", this.textures.size());
        for (MMM_TextureBox mMM_TextureBox : this.textures) {
            MMMLib.Debug("texture: %s(%s) - hasModel:%b", mMM_TextureBox.textureName, mMM_TextureBox.fileName, mMM_TextureBox.models != null);
        }
        this.setDefaultTexture(EntityLivingBase.class, this.getTextureBox("default_" + defaultModelName));
        return false;
    }

    public void buildCrafterTexture() {
        MMM_TextureBox lbox = new MMM_TextureBox("Crafter_Steve", new String[]{"", "", ""});
        lbox.fileName = "";
        lbox.addTexture(12, "/assets/minecraft/textures/entity/steve.png");
        if (armorFilenamePrefix != null && armorFilenamePrefix.length > 0) {
            for (String ls : armorFilenamePrefix) {
                HashMap<Integer, ResourceLocation> lmap = new HashMap<Integer, ResourceLocation>();
                lmap.put(64, new ResourceLocation("textures/models/armor/" + ls + "_layer_2.png"));
                lmap.put(80, new ResourceLocation("textures/models/armor/" + ls + "_layer_1.png"));
                lbox.armors.put(ls, lmap);
            }
        }
        this.textures.add(lbox);
    }

    public boolean loadTextureServer() {
        this.textureServer.clear();
        for (MMM_TextureBox lbox : MMM_TextureManager.getTextureList()) {
            this.textureServer.add(new MMM_TextureBoxServer(lbox));
        }
        File lfile = MinecraftServer.func_71276_C().func_71209_f(nameTextureIndex);
        if (lfile.exists() && lfile.isFile()) {
            try {
                String ls;
                FileReader fr = new FileReader(lfile);
                BufferedReader br = new BufferedReader(fr);
                while ((ls = br.readLine()) != null) {
                    String[] lt = ls.split(",");
                    if (lt.length < 7) continue;
                    MMM_TextureBoxServer lbox = this.getTextureBoxServer(lt[6]);
                    if (lbox == null) {
                        lbox = new MMM_TextureBoxServer();
                        this.textureServer.add(lbox);
                    }
                    lbox.contractColor = MMM_Helper.getHexToInt(lt[0]);
                    lbox.wildColor = MMM_Helper.getHexToInt(lt[1]);
                    lbox.setModelSize(Float.valueOf(lt[2]).floatValue(), Float.valueOf(lt[3]).floatValue(), Float.valueOf(lt[4]).floatValue(), Float.valueOf(lt[5]).floatValue());
                    lbox.textureName = lt[6];
                }
                br.close();
                fr.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MMMLib.Debug("Loaded ServerBoxList.(%d)", this.textureServer.size());
            for (int li = 0; li < this.textureServer.size(); ++li) {
                MMM_TextureBoxServer lbox = this.textureServer.get(li);
                MMMLib.Debug("%04d=%s:%04x:%04x", li, lbox.textureName, lbox.contractColor, lbox.wildColor);
            }
            return true;
        }
        return false;
    }

    public void saveTextureServer() {
        File lfile = MinecraftServer.func_71276_C().func_71209_f(nameTextureIndex);
        try {
            FileWriter fw = new FileWriter(lfile);
            BufferedWriter bw = new BufferedWriter(fw);
            for (MMM_TextureBoxServer lbox : this.textureServer) {
                bw.write(String.format("%04x,%04x,%f,%f,%f,%f,%s", lbox.getContractColorBits(), lbox.getWildColorBits(), Float.valueOf(lbox.getHeight(null)), Float.valueOf(lbox.getWidth(null)), Float.valueOf(lbox.getYOffset(null)), Float.valueOf(lbox.getMountedYOffset(null)), lbox.textureName));
                bw.newLine();
            }
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initTextureList(boolean pFlag) {
        MMMLib.Debug("Clear TextureBoxServer.", new Object[0]);
        this.textureServerIndex.clear();
        this.textureServer.clear();
        if (pFlag) {
            int li = 0;
            for (MMM_TextureBox lbc : MMM_TextureManager.getTextureList()) {
                MMM_TextureBoxServer lbs = new MMM_TextureBoxServer(lbc);
                this.textureServer.add(lbs);
                this.textureServerIndex.put(lbc, li++);
            }
            MMMLib.Debug("Rebuild TextureBoxServer(%d).", this.textureServer.size());
        }
    }

    protected void addModelClass(String fname, String[] pSearch) {
        int lfindprefix = fname.indexOf(pSearch[2]);
        if (lfindprefix > -1 && fname.endsWith(".class")) {
            String cn = fname.replace(".class", "");
            String pn = cn.substring(pSearch[2].length() + lfindprefix);
            if (this.modelMap.containsKey(pn)) {
                return;
            }
            ClassLoader lclassloader = MMMLib.class.getClassLoader();
            Package lpackage = MMMLib.class.getPackage();
            try {
                Class<?> lclass;
                if (lpackage != null) {
                    cn = cn.replace("/", ".");
                    System.out.println("MMM_TextureManager.addModelClass : " + cn);
                    lclass = lclassloader.loadClass(cn);
                } else {
                    lclass = Class.forName(cn);
                }
                if (!ModelMultiBase.class.isAssignableFrom(lclass) || Modifier.isAbstract(lclass.getModifiers())) {
                    MMMLib.Debug("getModelClass-fail.", new Object[0]);
                    return;
                }
                ModelMultiBase[] mlm = new ModelMultiBase[3];
                Constructor<?> cm = lclass.getConstructor(Float.TYPE);
                mlm[0] = (ModelMultiBase)cm.newInstance(Float.valueOf(0.0f));
                float[] lsize = mlm[0].getArmorModelsSize();
                mlm[1] = (ModelMultiBase)cm.newInstance(Float.valueOf(lsize[0]));
                mlm[2] = (ModelMultiBase)cm.newInstance(Float.valueOf(lsize[1]));
                this.modelMap.put(pn, mlm);
                MMMLib.Debug("getModelClass-%s:%s", pn, cn);
            }
            catch (Exception exception) {
                MMMLib.Debug("getModelClass-Exception: %s", fname);
                exception.printStackTrace();
            }
            catch (Error error) {
                MMMLib.Debug("getModelClass-Error: %s", fname);
                error.printStackTrace();
            }
        }
    }

    protected void addTextureName(String fname, String[] pSearch) {
        if (!fname.startsWith("/")) {
            fname = "/" + fname;
        }
        if (fname.startsWith(pSearch[1])) {
            int i = fname.lastIndexOf("/");
            if (pSearch[1].length() < i) {
                String pn = fname.substring(pSearch[1].length(), i);
                pn = pn.replace('/', '.');
                String fn = fname.substring(i);
                int lindex = this.getIndex(fn);
                if (lindex > -1) {
                    MMM_TextureBox lts;
                    String an = null;
                    if (lindex == 17) {
                        lindex = 64;
                        an = "default";
                    }
                    if (lindex == 18) {
                        lindex = 80;
                        an = "default";
                    }
                    if (lindex == 16) {
                        lindex = 60;
                    }
                    if ((lts = this.getTextureBox(pn)) == null) {
                        lts = new MMM_TextureBox(pn, pSearch);
                        this.textures.add(lts);
                        MMMLib.Debug("getTextureName-append-texturePack-%s", pn);
                    }
                    lts.addTexture(lindex, fname);
                }
            }
        }
    }

    protected boolean addTexturesZip(File file, String[] pSearch) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        try {
            ZipEntry zipentry;
            FileInputStream fileinputstream = new FileInputStream(file);
            ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                if (zipentry.isDirectory()) continue;
                if (zipentry.getName().endsWith(".class")) {
                    this.addModelClass(zipentry.getName(), pSearch);
                    continue;
                }
                this.addTextureName(zipentry.getName(), pSearch);
            }
            zipinputstream.close();
            fileinputstream.close();
            return true;
        }
        catch (Exception exception) {
            MMMLib.Debug("addTextureZip-Exception.", new Object[0]);
            return false;
        }
    }

    protected boolean addTexturesDir(File file, String[] pSearch) {
        if (file == null) {
            return false;
        }
        try {
            for (File t : file.listFiles()) {
                if (t.isDirectory()) {
                    this.addTexturesDir(t, pSearch);
                    continue;
                }
                if (t.getName().endsWith(".class")) {
                    this.addModelClass(t.getName(), pSearch);
                    continue;
                }
                String s = t.getPath().replace('\\', '/');
                int i = s.indexOf(pSearch[1]);
                if (i <= -1) continue;
                this.addTextureName(s.substring(i), pSearch);
            }
            return true;
        }
        catch (Exception e) {
            MMMLib.Debug("addTextureDebug-Exception.", new Object[0]);
            return false;
        }
    }

    protected int getIndex(String name) {
        for (int i = 0; i < defNames.length; ++i) {
            if (!name.endsWith(defNames[i])) continue;
            return i;
        }
        Pattern p = Pattern.compile("_([0-9a-f]+).png");
        Matcher m = p.matcher(name);
        if (m.find()) {
            return Integer.decode("0x" + m.group(1));
        }
        return -1;
    }

    public MMM_TextureBox getNextPackege(MMM_TextureBox pNowBox, int pColor) {
        boolean f = false;
        MMM_TextureBox lreturn = null;
        for (MMM_TextureBox ltb : MMM_TextureManager.getTextureList()) {
            if (ltb.hasColor(pColor)) {
                if (f) {
                    return ltb;
                }
                if (lreturn == null) {
                    lreturn = ltb;
                }
            }
            if (ltb != pNowBox) continue;
            f = true;
        }
        return lreturn == null ? null : lreturn;
    }

    public MMM_TextureBox getPrevPackege(MMM_TextureBox pNowBox, int pColor) {
        MMM_TextureBox lreturn = null;
        for (MMM_TextureBox ltb : MMM_TextureManager.getTextureList()) {
            if (ltb == pNowBox && lreturn != null) break;
            if (!ltb.hasColor(pColor)) continue;
            lreturn = ltb;
        }
        return lreturn == null ? null : lreturn;
    }

    public int getTextureCount() {
        return MMM_TextureManager.getTextureList().size();
    }

    public MMM_TextureBox getNextArmorPackege(MMM_TextureBox pNowBox) {
        boolean f = false;
        MMM_TextureBox lreturn = null;
        for (MMM_TextureBox ltb : MMM_TextureManager.getTextureList()) {
            if (ltb.hasArmor()) {
                if (f) {
                    return ltb;
                }
                if (lreturn == null) {
                    lreturn = ltb;
                }
            }
            if (ltb != pNowBox) continue;
            f = true;
        }
        return lreturn;
    }

    public MMM_TextureBox getPrevArmorPackege(MMM_TextureBox pNowBox) {
        MMM_TextureBox lreturn = null;
        for (MMM_TextureBox ltb : MMM_TextureManager.getTextureList()) {
            if (ltb == pNowBox && lreturn != null) break;
            if (!ltb.hasArmor()) continue;
            lreturn = ltb;
        }
        return lreturn;
    }

    public String getRandomTextureString(Random pRand) {
        return this.getRandomTexture((Random)pRand).textureName;
    }

    public MMM_TextureBoxServer getRandomTexture(Random pRand) {
        if (this.textureServer.isEmpty()) {
            return null;
        }
        ArrayList<MMM_TextureBoxServer> llist = new ArrayList<MMM_TextureBoxServer>();
        for (MMM_TextureBoxServer lbox : this.textureServer) {
            if (lbox.getWildColorBits() <= 0) continue;
            llist.add(lbox);
        }
        return (MMM_TextureBoxServer)llist.get(pRand.nextInt(llist.size()));
    }

    public int getIndexTextureBoxServer(ITextureEntity pEntity, String pPackName) {
        for (int li = 0; li < this.textureServer.size(); ++li) {
            if (!this.textureServer.get((int)li).textureName.equals(pPackName)) continue;
            return li;
        }
        MMM_TextureBox lbox = this.getDefaultTexture(pEntity);
        if (lbox != null) {
            pPackName = lbox.textureName;
            for (int li = 0; li < this.textureServer.size(); ++li) {
                if (!this.textureServer.get((int)li).textureName.equals(pPackName)) continue;
                return li;
            }
        }
        return 0;
    }

    public int getIndexTextureBoxServerIndex(MMM_TextureBox pBox) {
        return this.textureServerIndex.get(pBox);
    }

    public void setDefaultTexture(ITextureEntity pEntity, MMM_TextureBox pBox) {
        this.setDefaultTexture(pEntity.getClass(), pBox);
    }

    public void setDefaultTexture(Class pEntityClass, MMM_TextureBox pBox) {
        this.defaultTextures.put(pEntityClass, pBox);
        MMMLib.Debug("appendDefaultTexture:%s(%s)", pEntityClass.getSimpleName(), pBox == null ? "NULL" : pBox.textureName);
    }

    public MMM_TextureBox getDefaultTexture(ITextureEntity pEntity) {
        return this.getDefaultTexture(pEntity.getClass());
    }

    public MMM_TextureBox getDefaultTexture(Class pEntityClass) {
        if (this.defaultTextures.containsKey(pEntityClass)) {
            return this.defaultTextures.get(pEntityClass);
        }
        Class lsuper = pEntityClass.getSuperclass();
        if (lsuper != null) {
            MMM_TextureBox lbox = this.getDefaultTexture(lsuper);
            if (lbox != null) {
                this.setDefaultTexture(pEntityClass, lbox);
            }
            return lbox;
        }
        return null;
    }

    protected int getRequestStringIndex(String pVal) {
        int lblank = -1;
        for (int li = 0; li < this.requestString.length; ++li) {
            if (this.requestString[li] == null) {
                lblank = li;
                this.requestStringCounter[li] = 0;
                continue;
            }
            if (!this.requestString[li].equals(pVal)) continue;
            return -2;
        }
        if (lblank >= 0) {
            this.requestString[lblank] = pVal;
        } else {
            MMMLib.Debug("requestString Overflow!", new Object[0]);
        }
        return lblank;
    }

    protected String getRequestString(int pIndex) {
        String ls = this.requestString[pIndex];
        this.requestString[pIndex] = null;
        return ls;
    }

    protected int getRequestIndex(int pTextureServerBoxIndex) {
        int lblank = -1;
        for (int li = 0; li < this.requestIndex.length; ++li) {
            if (this.requestIndex[li] == -1) {
                lblank = li;
                this.requestIndexCounter[li] = 0;
                continue;
            }
            if (this.requestIndex[li] != pTextureServerBoxIndex) continue;
            return -2;
        }
        if (lblank >= 0) {
            this.requestIndex[lblank] = pTextureServerBoxIndex;
        } else {
            MMMLib.Debug("requestIndex Overflow!", new Object[0]);
        }
        return lblank;
    }

    protected boolean clearRequestIndex(int pTextureServerBoxIndex) {
        for (int li = 0; li < this.requestIndex.length; ++li) {
            if (this.requestIndex[li] != pTextureServerBoxIndex) continue;
            this.requestIndex[li] = -1;
            return true;
        }
        return false;
    }

    public MMM_TextureBox getTextureBoxServerIndex(int pIndex) {
        for (Map.Entry<MMM_TextureBox, Integer> le : this.textureServerIndex.entrySet()) {
            if (le.getValue() != pIndex) continue;
            return le.getKey();
        }
        return null;
    }

    public void postSetTexturePack(ITextureEntity pEntity, int pColor, MMM_TextureBoxBase[] pBox) {
        if (!(pEntity instanceof Entity)) {
            return;
        }
        int[] lindex = new int[pBox.length];
        boolean lflag = true;
        for (int li = 0; li < pBox.length; ++li) {
            lindex[li] = this.checkTextureBoxServer((MMM_TextureBox)pBox[li]);
            if (lindex[li] >= 0) continue;
            lflag = false;
        }
        if (lflag) {
            this.sendToServerSetTexturePackIndex(pEntity, pColor, lindex);
        } else {
            Object[] lo = new Object[1 + pBox.length];
            lo[0] = pColor;
            for (int li = 0; li < pBox.length; ++li) {
                lo[li + 1] = pBox[li];
            }
            this.stackSetTexturePack.put(pEntity, lo);
        }
    }

    public int checkTextureBoxServer(MMM_TextureBox pBox) {
        if (this.textureServerIndex.containsKey(pBox)) {
            return this.textureServerIndex.get(pBox);
        }
        int ll = this.getRequestStringIndex(pBox.textureName);
        if (ll > -1) {
            this.sendToServerGetTextureIndex(ll, pBox);
            return -1;
        }
        return ll;
    }

    protected void sendToServerSetTexturePackIndex(ITextureEntity pEntity, int pColor, int[] pIndex) {
        if (pEntity instanceof Entity) {
            byte[] ldata = new byte[6 + pIndex.length * 2];
            ldata[0] = -128;
            MMM_Helper.setInt(ldata, 1, ((Entity)pEntity).func_145782_y());
            ldata[5] = (byte)pColor;
            int li = 6;
            for (int ll : pIndex) {
                MMM_Helper.setShort(ldata, li, ll);
                li += 2;
            }
            Client.sendToServer(ldata);
        }
    }

    protected void reciveFromClientSetTexturePackIndex(Entity pEntity, byte[] pData) {
        if (pEntity instanceof ITextureEntity) {
            int lcount = (pData.length - 6) / 2;
            if (lcount < 1) {
                return;
            }
            int[] lindex = new int[lcount];
            for (int li = 0; li < lcount; ++li) {
                lindex[li] = MMM_Helper.getShort(pData, 6 + li * 2);
            }
            MMMLib.Debug("reciveFromClientSetTexturePackIndex: %d, %4x", pData[5], lindex[0]);
            ((ITextureEntity)pEntity).setTexturePackIndex(pData[5], lindex);
        }
    }

    protected void sendToServerGetTextureIndex(int pBufIndex, MMM_TextureBox pBox) {
        byte[] ldata = new byte[22 + pBox.textureName.length()];
        ldata[0] = 1;
        ldata[1] = (byte)pBufIndex;
        MMM_Helper.setShort(ldata, 2, pBox.getContractColorBits());
        MMM_Helper.setShort(ldata, 4, pBox.getWildColorBits());
        MMM_Helper.setFloat(ldata, 6, pBox.getHeight(null));
        MMM_Helper.setFloat(ldata, 10, pBox.getWidth(null));
        MMM_Helper.setFloat(ldata, 14, pBox.getYOffset(null));
        MMM_Helper.setFloat(ldata, 18, pBox.getMountedYOffset(null));
        MMM_Helper.setStr(ldata, 22, pBox.textureName);
        Client.sendToServer(ldata);
        MMMLib.Debug("Server_GetTextureIndex: %s", pBox.textureName);
    }

    protected void reciveFromClientGetTexturePackIndex(EntityPlayer player, byte[] pData) {
        int li;
        String lpackname = MMM_Helper.getStr(pData, 22);
        MMM_TextureBoxServer lboxsrv = this.getTextureBoxServer(lpackname);
        if (lboxsrv == null) {
            li = this.textureServer.size();
            lboxsrv = new MMM_TextureBoxServer();
            this.textureServer.add(lboxsrv);
        } else {
            li = this.textureServer.indexOf(lboxsrv);
        }
        lboxsrv.setValue(pData);
        byte[] ldata = new byte[4];
        ldata[0] = 1;
        ldata[1] = pData[1];
        MMM_Helper.setShort(ldata, 2, li);
        MMMLib.Debug("reciveFromClientGetTexturePackIndex: %s, %04x", lpackname, li);
        MMMLib.sendToClient(player, ldata);
    }

    protected void reciveFormServerSetTexturePackIndex(byte[] pData) {
        MMM_TextureBox lbox = this.getTextureBox(this.getRequestString(pData[1]));
        this.textureServerIndex.put(lbox, Integer.valueOf(MMM_Helper.getShort(pData, 2)));
        MMMLib.Debug("reciveFormServerSetTexturePackIndex: %s, %04x", lbox.textureName, (int)MMM_Helper.getShort(pData, 2));
        HashMap<ITextureEntity, Object[]> lmap = new HashMap<ITextureEntity, Object[]>(this.stackSetTexturePack);
        this.stackSetTexturePack.clear();
        for (Map.Entry le : lmap.entrySet()) {
            Object[] lo = (Object[])le.getValue();
            MMM_TextureBoxBase[] ls = new MMM_TextureBox[((Object[])le.getValue()).length - 1];
            int lc = (Integer)lo[0];
            for (int li = 1; li < lo.length; ++li) {
                ls[li - 1] = (MMM_TextureBox)lo[li];
            }
            this.postSetTexturePack((ITextureEntity)le.getKey(), lc, ls);
        }
    }

    public void postGetTexturePack(ITextureEntity pEntity, int[] pIndex) {
        MMM_TextureBox[] lbox = new MMM_TextureBox[pIndex.length];
        boolean lflag = true;
        for (int li = 0; li < pIndex.length; ++li) {
            lbox[li] = this.getTextureBoxServerIndex(pIndex[li]);
            if (lbox[li] != null) continue;
            if (this.getRequestIndex(pIndex[li]) > -1) {
                this.sendToServerGetTexturePackName(pIndex[li]);
            }
            lflag = false;
        }
        if (lflag) {
            pEntity.setTexturePackName(lbox);
        } else {
            this.stackGetTexturePack.put(pEntity, pIndex);
        }
    }

    protected void sendToServerGetTexturePackName(int pIndex) {
        if (pIndex < 0) {
            MMMLib.Debug("request range out.", new Object[0]);
            return;
        }
        byte[] ldata = new byte[3];
        ldata[0] = 2;
        MMM_Helper.setShort(ldata, 1, pIndex);
        Client.sendToServer(ldata);
    }

    protected void reciveFromClientGetTexturePackName(EntityPlayer player, byte[] pData) {
        short lindex = MMM_Helper.getShort(pData, 1);
        MMM_TextureBoxServer lboxserver = this.getTextureBoxServer(lindex);
        byte[] ldata = new byte[23 + lboxserver.textureName.length()];
        ldata[0] = 2;
        MMM_Helper.setShort(ldata, 1, lindex);
        MMM_Helper.setShort(ldata, 3, lboxserver.getContractColorBits());
        MMM_Helper.setShort(ldata, 5, lboxserver.getWildColorBits());
        MMM_Helper.setFloat(ldata, 7, lboxserver.getHeight(null));
        MMM_Helper.setFloat(ldata, 11, lboxserver.getWidth(null));
        MMM_Helper.setFloat(ldata, 15, lboxserver.getYOffset(null));
        MMM_Helper.setFloat(ldata, 19, lboxserver.getMountedYOffset(null));
        MMM_Helper.setStr(ldata, 23, lboxserver.textureName);
        MMMLib.sendToClient(player, ldata);
        MMMLib.Debug("SetTexturePackName:%04x - %s", lindex, lboxserver.textureName);
    }

    protected void reciveFromServerSetTexturePackName(byte[] pData) {
        String lpackname = MMM_Helper.getStr(pData, 23);
        MMM_TextureBox lbox = this.getTextureBox(lpackname);
        if (lbox == null) {
            lbox = this.getTextureBox("default_Orign").duplicate();
            lbox.textureName = lpackname;
            lbox.setModelSize(MMM_Helper.getFloat(pData, 7), MMM_Helper.getFloat(pData, 11), MMM_Helper.getFloat(pData, 15), MMM_Helper.getFloat(pData, 19));
            this.textures.add(lbox);
        }
        short lindex = MMM_Helper.getShort(pData, 1);
        this.textureServerIndex.put(lbox, Integer.valueOf(lindex));
        this.clearRequestIndex(lindex);
        HashMap<ITextureEntity, int[]> lmap = new HashMap<ITextureEntity, int[]>(this.stackGetTexturePack);
        this.stackGetTexturePack.clear();
        for (Map.Entry le : lmap.entrySet()) {
            this.postGetTexturePack((ITextureEntity)le.getKey(), (int[])le.getValue());
        }
    }

    protected void onUpdate() {
        for (int li = 0; li < this.requestString.length; ++li) {
            if (this.requestString[li] != null) {
                int n = li;
                int n2 = this.requestStringCounter[n];
                this.requestStringCounter[n] = n2 + 1;
                if (n2 > 600) {
                    this.requestString[li] = null;
                    this.requestStringCounter[li] = 0;
                }
            }
            if (this.requestIndex[li] == -1) continue;
            int n = li;
            int n3 = this.requestIndexCounter[n];
            this.requestIndexCounter[n] = n3 + 1;
            if (n3 <= 600) continue;
            this.requestIndex[li] = -1;
            this.requestIndexCounter[li] = 0;
        }
    }

    static {
        defNames = new String[]{"mob_littlemaid0.png", "mob_littlemaid1.png", "mob_littlemaid2.png", "mob_littlemaid3.png", "mob_littlemaid4.png", "mob_littlemaid5.png", "mob_littlemaid6.png", "mob_littlemaid7.png", "mob_littlemaid8.png", "mob_littlemaid9.png", "mob_littlemaida.png", "mob_littlemaidb.png", "mob_littlemaidc.png", "mob_littlemaidd.png", "mob_littlemaide.png", "mob_littlemaidf.png", "mob_littlemaidw.png", "mob_littlemaid_a00.png", "mob_littlemaid_a01.png"};
    }
}

