/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib.guns;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mmmlibx.lib.guns.GunsBase;
import mmmlibx.lib.guns.ItemBulletBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityBulletBase
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    protected EntityLivingBase thrower;
    protected String throwerName;
    protected Block inBlock;
    protected int inX = -1;
    protected int inY = -1;
    protected int inZ = -1;
    protected int ticksInGround = 1200;
    protected int ticksInAir = 0;
    protected boolean inGround;
    protected List<Entity> exclusionEntity = new ArrayList<Entity>();
    public ItemStack bullet;
    public ItemStack gun;
    public float speed;

    public EntityBulletBase(World pWorld) {
        super(pWorld);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70129_M = 0.0f;
        this.field_70155_l = 10.0;
    }

    public EntityBulletBase(World pWorld, double par2, double par4, double par6) {
        this(pWorld);
        this.func_70107_b(par2, par4, par6);
    }

    public EntityBulletBase(World pWorld, EntityLivingBase pEntity, ItemStack pGun, ItemStack pBullet, float pSpeed, float pf) {
        this(pWorld);
        this.thrower = pEntity;
        this.gun = pGun;
        this.bullet = pBullet;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(pEntity.field_70165_t, pEntity.field_70163_u + (double)pEntity.func_70047_e(), pEntity.field_70161_v, pEntity.field_70177_z, pEntity.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + this.appendAngle()) / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, pSpeed, pf);
    }

    protected float appendAngle() {
        return 0.0f;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    protected void func_70088_a() {
    }

    public void func_70186_c(double pMotionX, double pMotionY, double pMotionZ, float pSpeed, float pReaction) {
        float lf = MathHelper.func_76133_a((double)(pMotionX * pMotionX + pMotionY * pMotionY + pMotionZ * pMotionZ));
        pMotionX /= (double)lf;
        pMotionY /= (double)lf;
        pMotionZ /= (double)lf;
        pMotionX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)pReaction;
        pMotionY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)pReaction;
        pMotionZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)pReaction;
        this.field_70159_w = pMotionX *= (double)pSpeed;
        this.field_70181_x = pMotionY *= (double)pSpeed;
        this.field_70179_y = pMotionZ *= (double)pSpeed;
        float f3 = MathHelper.func_76133_a((double)(pMotionX * pMotionX + pMotionZ * pMotionZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(pMotionX, pMotionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(pMotionY, f3) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        double d1 = this.field_70121_D.func_72320_b() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        if (!this.inGround) {
            this.func_70107_b(par1, par3, par5);
            this.func_70101_b(par7, par8);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74768_a("xTile", this.inX);
        par1NBTTagCompound.func_74768_a("yTile", this.inY);
        par1NBTTagCompound.func_74768_a("zTile", this.inZ);
        par1NBTTagCompound.func_74768_a("inTile", Block.func_149682_b((Block)this.inBlock));
        par1NBTTagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.func_70005_c_();
        }
        par1NBTTagCompound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
        if (this.bullet != null) {
            NBTTagCompound lbullet = new NBTTagCompound();
            this.bullet.func_77955_b(lbullet);
            par1NBTTagCompound.func_74782_a("bullet", (NBTBase)lbullet);
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.inX = par1NBTTagCompound.func_74762_e("xTile");
        this.inY = par1NBTTagCompound.func_74762_e("yTile");
        this.inZ = par1NBTTagCompound.func_74762_e("zTile");
        this.inBlock = Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("inTile"));
        this.inGround = par1NBTTagCompound.func_74771_c("inGround") == 1;
        this.throwerName = par1NBTTagCompound.func_74779_i("ownerName");
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
        if (par1NBTTagCompound.func_74764_b("bullet")) {
            NBTTagCompound lbullet = par1NBTTagCompound.func_74775_l("bullet");
            this.bullet = ItemStack.func_77949_a((NBTTagCompound)lbullet);
        }
    }

    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
        }
        return this.thrower;
    }

    public void addExclusion(Entity pEntity) {
        this.exclusionEntity.add(pEntity);
    }

    public void func_70071_h_() {
        block13: {
            MovingObjectPosition movingobjectposition;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            super.func_70071_h_();
            if (this.inGround) {
                this.speed = 0.0f;
                if (this.field_70170_p.func_147439_a(this.inX, this.inY, this.inZ) != this.inBlock || --this.ticksInGround <= 0) {
                    this.func_70106_y();
                }
                return;
            }
            ++this.ticksInAir;
            Vec3 lvo = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 lvt = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            do {
                movingobjectposition = this.field_70170_p.func_147447_a(lvo, lvt, false, true, false);
                lvo = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
                lvt = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
                if (movingobjectposition != null) {
                    lvt = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K) {
                    Entity entity = null;
                    List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
                    double d0 = 0.0;
                    EntityLivingBase entitylivingbase = this.getThrower();
                    for (int j = 0; j < list.size(); ++j) {
                        double d1;
                        float f;
                        AxisAlignedBB axisalignedbb;
                        MovingObjectPosition movingobjectposition1;
                        Entity entity1 = (Entity)list.get(j);
                        if (this.exclusionEntity.contains(entity1) || !entity1.func_70067_L() || entity1 == entitylivingbase && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(lvo, lvt)) == null || !((d1 = lvo.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                        entity = entity1;
                        d0 = d1;
                    }
                    if (entity != null) {
                        movingobjectposition = new MovingObjectPosition(entity);
                    }
                }
                this.speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                if (movingobjectposition == null) break block13;
                if (movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || this.field_70170_p.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d) != Blocks.field_150427_aO) continue;
                this.func_70063_aa();
                break block13;
            } while (!this.onImpact(movingobjectposition));
            GunsBase.Debug("hit %f, %f, %f", this.field_70165_t, this.field_70163_u, this.field_70161_v);
            return;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f1) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f2 = 0.99f;
        float f3 = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            f2 = 0.8f;
        }
        this.field_70159_w *= (double)f2;
        this.field_70181_x *= (double)f2;
        this.field_70179_y *= (double)f2;
        this.field_70181_x -= (double)f3;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected boolean onImpact(MovingObjectPosition var1) {
        int lmeta;
        if (var1.field_72308_g != null) {
            if (this.bullet != null) {
                return ((ItemBulletBase)this.bullet.func_77973_b()).onHitEntity(var1, this, var1.field_72308_g);
            }
            var1.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.getThrower()), 1.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return true;
        }
        Block lblock = this.field_70170_p.func_147439_a(var1.field_72311_b, var1.field_72312_c, var1.field_72309_d);
        if (this.checkDestroyBlock(var1, var1.field_72311_b, var1.field_72312_c, var1.field_72309_d, lblock, lmeta = this.field_70170_p.func_72805_g(var1.field_72311_b, var1.field_72312_c, var1.field_72309_d))) {
            return this.onBreakBlock(var1, var1.field_72311_b, var1.field_72312_c, var1.field_72309_d, lblock, lmeta);
        }
        this.field_70165_t = var1.field_72307_f.field_72450_a;
        this.field_70163_u = var1.field_72307_f.field_72448_b;
        this.field_70161_v = var1.field_72307_f.field_72449_c;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.inGround = true;
        this.inBlock = lblock;
        this.inX = var1.field_72311_b;
        this.inY = var1.field_72312_c;
        this.inZ = var1.field_72309_d;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < 8; ++i) {
            this.field_70170_p.func_72869_a("smoke", var1.field_72307_f.field_72450_a, var1.field_72307_f.field_72448_b, var1.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
        }
        return true;
    }

    public boolean checkDestroyBlock(MovingObjectPosition var1, int pX, int pY, int pZ, Block pBlock, int pMetadata) {
        return pBlock instanceof BlockPane && pBlock.func_149688_o() == Material.field_151592_s || pBlock instanceof BlockFlowerPot || pBlock instanceof BlockTNT;
    }

    public boolean onBreakBlock(MovingObjectPosition var1, int pX, int pY, int pZ, Block pBlock, int pMetadata) {
        GunsBase.Debug("destroy: %d, %d, %d", pX, pY, pZ);
        if (pBlock instanceof BlockTNT) {
            this.removeBlock(pX, pY, pZ, pBlock, pMetadata);
            pBlock.func_149723_a(this.field_70170_p, pX, pY, pZ, new Explosion(this.field_70170_p, (Entity)this.getThrower(), (double)pX, (double)pY, (double)pZ, 0.0f));
            return true;
        }
        this.removeBlock(pX, pY, pZ, pBlock, pMetadata);
        pBlock.func_149664_b(this.field_70170_p, pX, pY, pZ, pMetadata);
        return false;
    }

    protected void removeBlock(int pX, int pY, int pZ, Block pBlock, int pMetadata) {
        this.field_70170_p.func_72926_e(2001, pX, pY, pZ, Block.func_149682_b((Block)pBlock) + (pMetadata << 12));
        this.field_70170_p.func_147468_f(pX, pY, pZ);
    }

    public void writeSpawnData(ByteBuf buffer) {
        PacketBuffer lpbuf = new PacketBuffer(buffer);
        lpbuf.writeInt(this.func_145782_y());
        lpbuf.writeBoolean(this.inGround);
        if (this.inGround) {
            lpbuf.writeInt(this.inX);
            lpbuf.writeInt(this.inY);
            lpbuf.writeInt(this.inZ);
            lpbuf.writeInt(Block.func_149682_b((Block)this.inBlock));
        } else {
            lpbuf.writeInt(Float.floatToIntBits((float)this.field_70159_w));
            lpbuf.writeInt(Float.floatToIntBits((float)this.field_70181_x));
            lpbuf.writeInt(Float.floatToIntBits((float)this.field_70179_y));
        }
        try {
            lpbuf.func_150788_a(this.bullet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        PacketBuffer lpbuf = new PacketBuffer(additionalData);
        Entity lentity = this.field_70170_p.func_73045_a(lpbuf.readInt());
        if (lentity instanceof EntityLivingBase) {
            this.thrower = (EntityLivingBase)lentity;
        }
        this.inGround = lpbuf.readBoolean();
        if (this.inGround) {
            this.inX = lpbuf.readInt();
            this.inY = lpbuf.readInt();
            this.inZ = lpbuf.readInt();
            this.inBlock = Block.func_149729_e((int)lpbuf.readInt());
        } else {
            this.field_70159_w = Float.intBitsToFloat(lpbuf.readInt());
            this.field_70181_x = Float.intBitsToFloat(lpbuf.readInt());
            this.field_70179_y = Float.intBitsToFloat(lpbuf.readInt());
            this.func_70016_h(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        try {
            this.bullet = lpbuf.func_150791_c();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getBulletColor() {
        if (this.bullet != null) {
            return ((ItemBulletBase)this.bullet.func_77973_b()).getBulletColor(this.bullet);
        }
        return 0x804000;
    }
}

