/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib.guns;

import mmmlibx.lib.guns.EntityBulletBase;
import mmmlibx.lib.guns.GunsBase;
import mmmlibx.lib.guns.ItemBulletBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemGunsBase
extends ItemBow {
    public static final String Tag_State = "State";
    public static final String Tag_MaxLoad = "MaxLoad";
    public static final String Tag_Magazin = "Magazin";
    public static final String Tag_Burst = "Burst";
    public static final String Tag_Cycle = "Cycle";
    public static final String Tag_ReloadTime = "ReloadTime";
    public static final String Tag_BurstCount = "BurstCount";
    public static final String Tag_CycleCount = "CycleCount";
    public static final String Tag_Efficiency = "Efficiency";
    public static final String Tag_Stability = "Stability";
    public static final String Tag_StabilityY = "StabilityY";
    public static final String Tag_StabilityYO = "StabilityYO";
    public static final String Tag_StabilityP = "StabilityP";
    public static final String Tag_StabilityPO = "StabilityPO";
    public static final String Tag_Accuracy = "Accuracy";
    protected static byte State_Ready = 0;
    protected static byte State_Empty = (byte)16;
    protected static byte State_Reload = (byte)32;
    protected static byte State_ReloadTac = (byte)48;
    protected static byte State_ReloadCre = (byte)64;
    protected static byte State_ReleseMag = (byte)80;
    protected static byte State_ReloadEnd = (byte)96;
    public String soundEmpty;
    public String soundRelease;
    public String soundReload;
    public float volume;
    public int reloadTime;
    public int burstCount;
    public short cycleCount;
    public float efficiency;
    public float stability;
    public float stabilityYaw;
    public float stabilityYawOffset;
    public float stabilityPitch;
    public float stabilityPitchOffset;
    public float accuracy;
    public String[] bullets;
    public String[] iconNames;
    protected IIcon[] icons;
    protected Item[] ammos;

    public ItemGunsBase() {
        this.field_77777_bU = 1;
        this.func_77664_n();
        this.volume = 0.5f;
        this.reloadTime = 40;
        this.burstCount = 0;
        this.cycleCount = (short)2;
        this.efficiency = 1.0f;
        this.stability = 1.0f;
        this.stabilityPitch = 5.0f;
        this.stabilityPitchOffset = 5.0f;
        this.stabilityYaw = 3.0f;
        this.stabilityYawOffset = 0.0f;
        this.accuracy = 1.0f;
        this.iconNames = new String[]{"", "", ""};
        this.bullets = new String[]{""};
        GunsBase.appendItem(this);
    }

    public void init() {
        this.ammos = new Item[this.bullets.length];
        for (int li = 0; li < this.bullets.length; ++li) {
            this.ammos[li] = (Item)Item.field_150901_e.func_82594_a(this.bullets[li]);
        }
    }

    public void playSoundEmpty(World pWorld, EntityPlayer pPlayer, ItemStack pGun) {
        pWorld.func_72956_a((Entity)pPlayer, this.soundEmpty, this.volume, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
    }

    public void playSoundRelease(World pWorld, EntityPlayer pPlayer, ItemStack pGun) {
        pWorld.func_72956_a((Entity)pPlayer, this.soundRelease, this.volume, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
    }

    public void playSoundReload(World pWorld, EntityPlayer pPlayer, ItemStack pGun) {
        pWorld.func_72956_a((Entity)pPlayer, this.soundReload, this.volume, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
    }

    public int getReloadTime(ItemStack pGun) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_ReloadTime)) {
            return pGun.func_77978_p().func_74762_e(Tag_ReloadTime);
        }
        return this.reloadTime;
    }

    public int getBurstCount(ItemStack pGun) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_BurstCount)) {
            return pGun.func_77978_p().func_74762_e(Tag_BurstCount);
        }
        return this.burstCount;
    }

    public short getCycleCount(ItemStack pGun) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_CycleCount)) {
            return pGun.func_77978_p().func_74765_d(Tag_CycleCount);
        }
        return this.cycleCount;
    }

    public float getEfficiency(ItemStack pGun, EntityPlayer pPlayer, int pUseCount) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_Efficiency)) {
            return pGun.func_77978_p().func_74760_g(Tag_Efficiency);
        }
        return this.efficiency;
    }

    public float getStability(ItemStack pGun, EntityPlayer pPlayer, int pUseCount) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_Stability)) {
            return pGun.func_77978_p().func_74760_g(Tag_Stability);
        }
        return this.stability;
    }

    public float getStabilityY(ItemStack pGun, EntityPlayer pPlayer, int pUseCount) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_StabilityY)) {
            return pGun.func_77978_p().func_74760_g(Tag_StabilityY);
        }
        return this.stabilityYaw;
    }

    public float getStabilityYO(ItemStack pGun, EntityPlayer pPlayer, int pUseCount) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_StabilityYO)) {
            return pGun.func_77978_p().func_74760_g(Tag_StabilityYO);
        }
        return this.stabilityYawOffset;
    }

    public float getStabilityP(ItemStack pGun, EntityPlayer pPlayer, int pUseCount) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_StabilityP)) {
            return pGun.func_77978_p().func_74760_g(Tag_StabilityP);
        }
        return this.stabilityPitch;
    }

    public float getStabilityPO(ItemStack pGun, EntityPlayer pPlayer, int pUseCount) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_StabilityPO)) {
            return pGun.func_77978_p().func_74760_g(Tag_StabilityPO);
        }
        return this.stabilityPitchOffset;
    }

    public float getAccuracy(ItemStack pGun, EntityPlayer pPlayer, int pUseCount) {
        if (pGun.func_77942_o() && pGun.func_77978_p().func_74764_b(Tag_Accuracy)) {
            return pGun.func_77978_p().func_74760_g(Tag_Accuracy);
        }
        return this.accuracy;
    }

    public int getMaxDamage(ItemStack stack) {
        NBTTagCompound ltag = this.getTagCompound(stack);
        if (ltag.func_74764_b(Tag_MaxLoad)) {
            return ltag.func_74762_e(Tag_MaxLoad);
        }
        return super.func_77612_l();
    }

    protected NBTTagCompound getTagCompound(ItemStack pGun) {
        if (!pGun.func_77942_o()) {
            pGun.func_77982_d(new NBTTagCompound());
        }
        return pGun.func_77978_p();
    }

    public boolean isSkipBlank() {
        return true;
    }

    public boolean isBurst(ItemStack pGun) {
        return this.getBurstCount(pGun) > 0;
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        this.icons = new IIcon[3];
        this.icons[0] = par1IconRegister.func_94245_a(this.iconNames[0]);
        this.icons[1] = par1IconRegister.func_94245_a(this.iconNames[1]);
        this.icons[2] = par1IconRegister.func_94245_a(this.iconNames[2]);
        this.field_77791_bV = this.icons[0];
    }

    public IIcon func_94599_c(int par1) {
        return this.field_77791_bV;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        byte li = this.getState(stack);
        if (li >= State_ReleseMag && li < State_ReloadEnd) {
            return this.icons[2];
        }
        if (li >= State_Empty && li < State_ReleseMag) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        GunsBase.Debug("%s - trigger", par3EntityPlayer instanceof EntityPlayerMP ? "MP" : "SP");
        byte li = this.getState(par1ItemStack);
        if (par3EntityPlayer.field_82175_bq) {
            this.setState(par1ItemStack, State_ReloadTac);
            GunsBase.Debug("Tactical Reload.", new Object[0]);
        } else if (this.isBurst(par1ItemStack)) {
            if (li >= State_Empty && li < State_Reload) {
                if (this.hasAmmo(par1ItemStack, par2World, par3EntityPlayer)) {
                    this.setState(par1ItemStack, State_Reload);
                    GunsBase.Debug("Reload.", new Object[0]);
                } else {
                    this.playSoundEmpty(par2World, par3EntityPlayer, par1ItemStack);
                    GunsBase.Debug("Empty.", new Object[0]);
                }
            } else if (li < State_Empty) {
                this.resetBolt(par1ItemStack);
                this.resetBurst(par1ItemStack);
            }
        } else if (this.isAmmoEmpty(par1ItemStack) && li < State_Reload && this.hasAmmo(par1ItemStack, par2World, par3EntityPlayer)) {
            this.setState(par1ItemStack, State_Reload);
            GunsBase.Debug("Reload.", new Object[0]);
        }
        GunsBase.Debug("%s - ItemStack: %s", par3EntityPlayer instanceof EntityPlayerMP ? "MP" : "SP", par1ItemStack.toString());
        GunsBase.setUncheckedItemStack(par1ItemStack, par3EntityPlayer);
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        byte li = this.getState(stack);
        if (li == State_Reload) {
            this.setState(stack, State_ReleseMag);
            this.releaseMagazin(stack, player.field_70170_p, player);
            GunsBase.setUncheckedItemStack(stack, player);
        }
        if (li == State_ReloadTac) {
            this.setState(stack, State_ReleseMag);
            this.releaseMagazin(stack, player.field_70170_p, player);
            GunsBase.setUncheckedItemStack(stack, player);
        }
        this.onFireTick(stack, player.field_70170_p, player, count, li);
    }

    public void onFireTick(ItemStack pGun, World pWorld, EntityPlayer pPlayer, int count, int pState) {
        if (this.isBurst(pGun) && pState == State_Ready && !this.isAmmoEmpty(pGun)) {
            if (this.checkBolt(pGun) && this.decBurst(pGun) > 0 && this.fireBullet(pGun, pWorld, pPlayer, count) <= 0) {
                this.setState(pGun, State_Empty);
            }
            GunsBase.setUncheckedItemStack(pGun, pPlayer);
        }
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        byte li = this.getState(par1ItemStack);
        if (li >= State_ReleseMag && li < State_ReloadEnd) {
            this.reloadMagazin(par1ItemStack, par2World, par3EntityPlayer);
            this.setState(par1ItemStack, State_ReloadEnd);
            GunsBase.setUncheckedItemStack(par1ItemStack, par3EntityPlayer);
        }
        return par1ItemStack;
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        byte li = this.getState(par1ItemStack);
        if (li == State_ReloadEnd) {
            if (this.isAmmoEmpty(par1ItemStack)) {
                this.setState(par1ItemStack, State_Empty);
            } else {
                this.setState(par1ItemStack, State_Ready);
            }
        } else if (!this.isBurst(par1ItemStack)) {
            if (!this.isAmmoEmpty(par1ItemStack)) {
                if (this.fireBullet(par1ItemStack, par2World, par3EntityPlayer, par4) <= 0) {
                    this.setState(par1ItemStack, State_Empty);
                }
            } else if (li < State_Reload) {
                this.playSoundEmpty(par2World, par3EntityPlayer, par1ItemStack);
            }
        }
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        byte li = this.getState(par1ItemStack);
        if (li >= State_Empty && li < State_ReloadEnd) {
            return this.getReloadTime(par1ItemStack);
        }
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        byte li = this.getState(par1ItemStack);
        if (li < State_ReloadTac) {
            return EnumAction.bow;
        }
        return EnumAction.block;
    }

    public boolean hasAmmo(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par3EntityPlayer.field_71075_bZ.field_75098_d || this.getAmmoIndex(par3EntityPlayer) > -1;
    }

    public int fireBullet(ItemStack pGun, World pWorld, EntityPlayer pPlayer, int pUseCount) {
        ItemStack lbullet;
        int ldamage = this.getDamage(pGun);
        int lmdamage = this.getMaxDamage(pGun);
        do {
            lbullet = this.getBullet(pGun, ldamage);
            this.setDamage(pGun, ++ldamage);
        } while (lbullet == null && !this.isSkipBlank() && ldamage < lmdamage);
        ldamage = lmdamage - ldamage;
        if (lbullet == null) {
            return ldamage;
        }
        ItemBulletBase libullet = null;
        if (lbullet.func_77973_b() instanceof ItemBulletBase) {
            libullet = (ItemBulletBase)lbullet.func_77973_b();
        }
        if (libullet != null) {
            libullet.playSoundFire(pWorld, pPlayer, pGun, lbullet);
        }
        if (!pWorld.field_72995_K) {
            GunsBase.Debug("Bulle: %s-%s", lbullet == null ? "NULL" : lbullet.toString(), lbullet.func_77942_o() ? lbullet.func_77978_p().toString() : "");
            if (libullet != null) {
                EntityBulletBase lentity = libullet.getBulletEntity(pGun, lbullet, pWorld, pPlayer, 72000 - pUseCount);
                pWorld.func_72838_d((Entity)lentity);
            }
        }
        if (libullet != null) {
            this.onRecoile(pGun, lbullet, pWorld, pPlayer, 72000 - pUseCount);
        }
        return ldamage;
    }

    public void onRecoile(ItemStack pGun, ItemStack pBullet, World pWorld, EntityPlayer pPlayer, int pUseCount) {
        float lsn = pPlayer.func_70093_af() ? 0.5f : 1.0f;
        pPlayer.field_70125_A -= (pPlayer.func_70681_au().nextFloat() * this.getStabilityP(pGun, pPlayer, pUseCount) + this.getStabilityPO(pGun, pPlayer, pUseCount)) * (lsn *= ((ItemBulletBase)pBullet.func_77973_b()).getReaction(pBullet));
        pPlayer.field_70177_z += (pPlayer.func_70681_au().nextFloat() * this.getStabilityY(pGun, pPlayer, pUseCount) + this.getStabilityYO(pGun, pPlayer, pUseCount)) * lsn;
        pPlayer.field_70159_w += (double)(MathHelper.func_76126_a((float)(pPlayer.field_70759_as * ((float)Math.PI / 180))) * (lsn *= this.getStability(pGun, pPlayer, pUseCount)));
        pPlayer.field_70179_y -= (double)(MathHelper.func_76134_b((float)(pPlayer.field_70759_as * ((float)Math.PI / 180))) * lsn);
    }

    public ItemStack getBullet(ItemStack pGun, int pIndex) {
        if (pGun.func_77942_o()) {
            NBTTagCompound ltag = pGun.func_77978_p();
            NBTTagCompound lbullet = ltag.func_74775_l(Tag_Magazin);
            String ls = String.format("%04d", pIndex);
            if (lbullet.func_74764_b(ls)) {
                return ItemStack.func_77949_a((NBTTagCompound)lbullet.func_74775_l(ls));
            }
        }
        return null;
    }

    public void setBullet(ItemStack pGun, int pIndex, ItemStack pBullet) {
        NBTTagCompound ltag = this.getTagCompound(pGun);
        NBTTagCompound lmagazin = ltag.func_74775_l(Tag_Magazin);
        ltag.func_74782_a(Tag_Magazin, (NBTBase)lmagazin);
        String ls = String.format("%04d", pIndex);
        if (pBullet == null) {
            lmagazin.func_82580_o(ls);
        } else {
            NBTTagCompound lbullet = ltag.func_74775_l(ls);
            lmagazin.func_74782_a(ls, (NBTBase)lbullet);
            pBullet.func_77955_b(lbullet);
        }
    }

    public void loadBullet(ItemStack pGun, ItemStack pBullet) {
        int li = this.getDamage(pGun);
        while (li > 0) {
            ItemStack lis = this.getBullet(pGun, --li);
            pGun.func_77964_b(li);
            if (lis != null) continue;
            this.setBullet(pGun, li, pBullet.func_77979_a(1));
            break;
        }
    }

    public boolean isAmmoEmpty(ItemStack pGun) {
        return this.getDamage(pGun) >= this.getMaxDamage(pGun);
    }

    public boolean checkAmmo(ItemStack pItemStack) {
        Item litem = pItemStack.func_77973_b();
        for (Item li : this.ammos) {
            if (litem != li) continue;
            return true;
        }
        return false;
    }

    public int getAmmoIndex(EntityPlayer pPlayer) {
        for (int li = 0; li < pPlayer.field_71071_by.field_70462_a.length; ++li) {
            ItemStack lis = pPlayer.field_71071_by.field_70462_a[li];
            if (lis == null || !this.checkAmmo(lis)) continue;
            return li;
        }
        return -1;
    }

    public void releaseMagazin(ItemStack pGun, World pWorld, EntityPlayer pPlayer) {
        int li;
        this.playSoundRelease(pWorld, pPlayer, pGun);
        if (!pPlayer.field_71075_bZ.field_75098_d) {
            for (li = 0; li < this.getDamage(pGun); ++li) {
                this.setBullet(pGun, li, null);
            }
        }
        GunsBase.Debug(pGun.toString(), new Object[0]);
        for (li = 0; li < this.getMaxDamage(pGun); ++li) {
            ItemStack lis = this.getBullet(pGun, li);
            GunsBase.Debug("%04d: %s", li, lis == null ? "null" : lis.toString());
        }
        this.setDamage(pGun, this.getMaxDamage(pGun));
    }

    public void reloadMagazin(ItemStack pGun, World pWorld, EntityPlayer pPlayer) {
        int li;
        while (this.getDamage(pGun) > 0 && (li = this.getAmmoIndex(pPlayer)) != -1) {
            ItemStack lis = pPlayer.field_71071_by.field_70462_a[li];
            this.loadBullet(pGun, lis);
            if (lis.field_77994_a > 0) continue;
            pPlayer.field_71071_by.func_70299_a(li, null);
        }
        this.playSoundReload(pWorld, pPlayer, pGun);
    }

    public void setState(ItemStack pGun, byte pState) {
        NBTTagCompound ltag = this.getTagCompound(pGun);
        ltag.func_74774_a(Tag_State, pState);
    }

    public byte getState(ItemStack pGun) {
        NBTTagCompound ltag = this.getTagCompound(pGun);
        return ltag.func_74771_c(Tag_State);
    }

    public boolean checkBolt(ItemStack pGun) {
        NBTTagCompound ltag = this.getTagCompound(pGun);
        short lval = ltag.func_74765_d(Tag_Cycle);
        if ((lval = (short)(lval - 1)) <= 0) {
            ltag.func_74777_a(Tag_Cycle, this.getCycleCount(pGun));
            return true;
        }
        ltag.func_74777_a(Tag_Cycle, lval);
        return false;
    }

    public void resetBolt(ItemStack pGun) {
        NBTTagCompound ltag = this.getTagCompound(pGun);
        ltag.func_74777_a(Tag_Cycle, this.getCycleCount(pGun));
    }

    public int decBurst(ItemStack pGun) {
        NBTTagCompound ltag = this.getTagCompound(pGun);
        int lburst = ltag.func_74762_e(Tag_Burst);
        if (lburst > 0) {
            ltag.func_74768_a(Tag_Burst, lburst - 1);
        }
        return lburst;
    }

    public void resetBurst(ItemStack pGun) {
        NBTTagCompound ltag = this.getTagCompound(pGun);
        ltag.func_74768_a(Tag_Burst, this.getBurstCount(pGun));
    }
}

