/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib.multiModel.MMMLoader;

import java.util.HashMap;
import java.util.Map;
import mmmlibx.lib.MMMLib;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class MMMTransformer
implements IClassTransformer,
Opcodes {
    private static String packege = "mmmlibx/lib/multiModel/model/mc162/";
    private static final Map<String, String> targets = new HashMap<String, String>(){
        {
            this.add("EquippedStabilizer");
            this.add("IModelBaseMMM");
            this.add("IModelCaps");
            this.add("ModelBase");
            this.add("ModelBaseDuo");
            this.add("ModelBaseNihil");
            this.add("ModelBaseSolo");
            this.add("ModelBox");
            this.add("ModelBoxBase");
            this.add("ModelCapsHelper");
            this.add("ModelLittleMaid_AC");
            this.add("ModelLittleMaid_Archetype");
            this.add("ModelLittleMaid_Orign");
            this.add("ModelLittleMaid_RX2");
            this.add("ModelLittleMaid_Aug");
            this.add("ModelLittleMaid_SR2");
            this.add("ModelLittleMaidBase");
            this.add("ModelMultiBase");
            this.add("ModelMultiMMMBase");
            this.add("ModelPlate");
            this.add("ModelRenderer");
            this.add("ModelStabilizerBase");
        }

        private void add(String pName) {
            String replaceName = pName;
            this.put("MMM_" + pName, packege + replaceName);
        }
    };
    public static boolean isEnable = false;
    private boolean isChange;

    public static void Debug(String pText, Object ... pData) {
        if (MMMLib.isDebugMessage) {
            System.out.println(String.format("MMMTransformer-" + pText, pData));
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        isEnable = true;
        if (basicClass != null && isEnable) {
            return this.replacer(name, transformedName, basicClass);
        }
        return basicClass;
    }

    private byte[] replacer(String name, String transformedName, byte[] basicClass) {
        ClassReader lcreader = new ClassReader(basicClass);
        String superName = lcreader.getSuperName();
        boolean replaceSuper = targets.containsKey(superName);
        this.isChange = false;
        ClassNode lcnode = new ClassNode();
        lcreader.accept((ClassVisitor)lcnode, 0);
        lcnode.superName = this.checkMMM(lcnode.superName);
        if (replaceSuper) {
            MMMTransformer.Debug("Load Old-MulitiModel: %s extends %s -> %s", name, superName, lcnode.superName);
        }
        for (FieldNode lfn : lcnode.fields) {
            lfn.desc = this.checkMMM(lfn.desc);
        }
        for (MethodNode lmn : lcnode.methods) {
            lmn.desc = this.checkMMM(lmn.desc);
            if (lmn.localVariables != null) {
                for (LocalVariableNode lvn : lmn.localVariables) {
                    if (lvn.desc != null) {
                        lvn.desc = this.checkMMM(lvn.desc);
                    }
                    if (lvn.name != null) {
                        lvn.name = this.checkMMM(lvn.name);
                    }
                    if (lvn.signature == null) continue;
                    lvn.signature = this.checkMMM(lvn.signature);
                }
            }
            for (AbstractInsnNode lin = lmn.instructions.getFirst(); lin != null; lin = lin.getNext()) {
                if (lin instanceof FieldInsnNode) {
                    ((FieldInsnNode)lin).desc = this.checkMMM(((FieldInsnNode)lin).desc);
                    ((FieldInsnNode)lin).name = this.checkMMM(((FieldInsnNode)lin).name);
                    ((FieldInsnNode)lin).owner = this.checkMMM(((FieldInsnNode)lin).owner);
                    continue;
                }
                if (lin instanceof InvokeDynamicInsnNode) {
                    ((InvokeDynamicInsnNode)lin).desc = this.checkMMM(((InvokeDynamicInsnNode)lin).desc);
                    ((InvokeDynamicInsnNode)lin).name = this.checkMMM(((InvokeDynamicInsnNode)lin).name);
                    continue;
                }
                if (lin instanceof MethodInsnNode) {
                    ((MethodInsnNode)lin).desc = this.checkMMM(((MethodInsnNode)lin).desc);
                    ((MethodInsnNode)lin).name = this.checkMMM(((MethodInsnNode)lin).name);
                    ((MethodInsnNode)lin).owner = this.checkMMM(((MethodInsnNode)lin).owner);
                    continue;
                }
                if (lin instanceof MultiANewArrayInsnNode) {
                    ((MultiANewArrayInsnNode)lin).desc = this.checkMMM(((MultiANewArrayInsnNode)lin).desc);
                    continue;
                }
                if (!(lin instanceof TypeInsnNode)) continue;
                ((TypeInsnNode)lin).desc = this.checkMMM(((TypeInsnNode)lin).desc);
            }
        }
        if (this.isChange) {
            ClassWriter lcwriter = new ClassWriter(3);
            lcnode.accept((ClassVisitor)lcwriter);
            byte[] lb = lcwriter.toByteArray();
            MMMTransformer.Debug("Replace: %s", name);
            return lb;
        }
        return basicClass;
    }

    private String checkMMM(String pText) {
        for (Map.Entry<String, String> le : targets.entrySet()) {
            if (pText.indexOf(le.getKey()) <= -1) continue;
            String result = pText.replace(le.getKey(), le.getValue());
            this.isChange = true;
            return result;
        }
        return pText;
    }
}

