/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib.multiModel.model.mc162;

import java.lang.reflect.Constructor;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import mmmlibx.lib.multiModel.model.mc162.IModelCaps;
import mmmlibx.lib.multiModel.model.mc162.ModelBase;
import mmmlibx.lib.multiModel.model.mc162.ModelBox;
import mmmlibx.lib.multiModel.model.mc162.ModelBoxBase;
import mmmlibx.lib.multiModel.model.mc162.ModelCapsHelper;
import mmmlibx.lib.multiModel.model.mc162.ModelMultiBase;
import mmmlibx.lib.multiModel.model.mc162.ModelPlate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import wrapper.W_Client;

public class ModelRenderer {
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    protected boolean compiled = false;
    protected int displayList = 0;
    public boolean mirror = false;
    public boolean showModel = true;
    public boolean isHidden = false;
    public boolean isRendering = true;
    public List<ModelBoxBase> cubeList;
    public List<ModelRenderer> childModels;
    public final String boxName;
    protected ModelBase baseModel;
    public ModelRenderer pearent;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public static final float radFactor = 57.295776f;
    public static final float degFactor = (float)Math.PI / 180;
    public int rotatePriority;
    public static final int RotXYZ = 0;
    public static final int RotXZY = 1;
    public static final int RotYXZ = 2;
    public static final int RotYZX = 3;
    public static final int RotZXY = 4;
    public static final int RotZYX = 5;
    protected ItemStack itemstack;
    public boolean adjust;
    public FloatBuffer matrix;
    public boolean isInvertX;
    private RenderBlocks renderBlocksIr = new RenderBlocks();

    public ModelRenderer(ModelBase pModelBase, String pName) {
        this.cubeList = new ArrayList<ModelBoxBase>();
        this.baseModel = pModelBase;
        pModelBase.boxList.add(this);
        this.boxName = pName;
        this.setTextureSize(pModelBase.textureWidth, pModelBase.textureHeight);
        this.rotatePriority = 0;
        this.itemstack = null;
        this.adjust = true;
        this.matrix = BufferUtils.createFloatBuffer((int)16);
        this.isInvertX = false;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
        this.pearent = null;
    }

    public ModelRenderer(ModelBase pModelBase, int px, int py) {
        this(pModelBase, null);
        this.setTextureOffset(px, py);
    }

    public ModelRenderer(ModelBase pModelBase) {
        this(pModelBase, null);
    }

    public ModelRenderer(ModelBase pModelBase, int px, int py, float pScaleX, float pScaleY, float pScaleZ) {
        this(pModelBase, px, py);
        this.scaleX = pScaleX;
        this.scaleY = pScaleY;
        this.scaleZ = pScaleZ;
    }

    public ModelRenderer(ModelBase pModelBase, float pScaleX, float pScaleY, float pScaleZ) {
        this(pModelBase);
        this.scaleX = pScaleX;
        this.scaleY = pScaleY;
        this.scaleZ = pScaleZ;
    }

    public void addChild(ModelRenderer pModelRenderer) {
        if (this.childModels == null) {
            this.childModels = new ArrayList<ModelRenderer>();
        }
        this.childModels.add(pModelRenderer);
        pModelRenderer.pearent = this;
    }

    public ModelRenderer setTextureOffset(int pOffsetX, int pOffsetY) {
        this.textureOffsetX = pOffsetX;
        this.textureOffsetY = pOffsetY;
        return this;
    }

    public ModelRenderer addBox(String pName, float pX, float pY, float pZ, int pWidth, int pHeight, int pDepth) {
        this.addParts(ModelBox.class, pName, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pDepth, Float.valueOf(0.0f));
        return this;
    }

    public ModelRenderer addBox(float pX, float pY, float pZ, int pWidth, int pHeight, int pDepth) {
        this.addParts(ModelBox.class, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pDepth, Float.valueOf(0.0f));
        return this;
    }

    public ModelRenderer addBox(float pX, float pY, float pZ, int pWidth, int pHeight, int pDepth, float pSizeAdjust) {
        this.addParts(ModelBox.class, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pDepth, Float.valueOf(pSizeAdjust));
        return this;
    }

    public ModelRenderer setRotationPoint(float pX, float pY, float pZ) {
        this.rotationPointX = pX;
        this.rotationPointY = pY;
        this.rotationPointZ = pZ;
        return this;
    }

    public void render(float par1, boolean pIsRender) {
        if (this.isHidden) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(par1);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
        if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            this.setRotation();
        }
        this.renderObject(par1, pIsRender);
        GL11.glPopMatrix();
    }

    public void render(float par1) {
        this.render(par1, true);
    }

    public void renderWithRotation(float par1) {
        if (this.isHidden) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(par1);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
        this.setRotation();
        GL11.glCallList((int)this.displayList);
        GL11.glPopMatrix();
    }

    public void postRender(float par1) {
        if (this.isHidden) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(par1);
        }
        if (this.pearent != null) {
            this.pearent.postRender(par1);
        }
        GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
        if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            this.setRotation();
        }
    }

    protected void compileDisplayList(float par1) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < this.cubeList.size(); ++i) {
            this.cubeList.get(i).render(tessellator, par1);
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public ModelRenderer setTextureSize(int pWidth, int pHeight) {
        this.textureWidth = pWidth;
        this.textureHeight = pHeight;
        return this;
    }

    public ModelRenderer addCubeList(ModelBoxBase pModelBoxBase) {
        this.cubeList.add(pModelBoxBase);
        return this;
    }

    protected ModelBoxBase getModelBoxBase(Class<? extends ModelBoxBase> pModelBoxBase, Object ... pArg) {
        try {
            Constructor<? extends ModelBoxBase> lconstructor = pModelBoxBase.getConstructor(ModelRenderer.class, Object[].class);
            return lconstructor.newInstance(this, pArg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Object[] getArg(Object ... pArg) {
        Object[] lobject = new Object[pArg.length + 2];
        lobject[0] = this.textureOffsetX;
        lobject[1] = this.textureOffsetY;
        for (int li = 0; li < pArg.length; ++li) {
            lobject[2 + li] = pArg[li];
        }
        return lobject;
    }

    public ModelRenderer addParts(Class<? extends ModelBoxBase> pModelBoxBase, String pName, Object ... pArg) {
        pName = this.boxName + "." + pName;
        TextureOffset ltextureoffset = this.baseModel.getTextureOffset(pName);
        this.setTextureOffset(ltextureoffset.field_78783_a, ltextureoffset.field_78782_b);
        this.addCubeList(this.getModelBoxBase(pModelBoxBase, this.getArg(pArg)).setBoxName(pName));
        return this;
    }

    public ModelRenderer addParts(Class<? extends ModelBoxBase> pModelBoxBase, Object ... pArg) {
        this.addCubeList(this.getModelBoxBase(pModelBoxBase, this.getArg(pArg)));
        return this;
    }

    public ModelRenderer addPartsTexture(Class<? extends ModelBoxBase> pModelBoxBase, String pName, Object ... pArg) {
        pName = this.boxName + "." + pName;
        this.addCubeList(this.getModelBoxBase(pModelBoxBase, pArg).setBoxName(pName));
        return this;
    }

    public ModelRenderer addPartsTexture(Class<? extends ModelBoxBase> pModelBoxBase, Object ... pArg) {
        this.addCubeList(this.getModelBoxBase(pModelBoxBase, pArg));
        return this;
    }

    public ModelRenderer addPlate(float pX, float pY, float pZ, int pWidth, int pHeight, int pFacePlane) {
        this.addParts(ModelPlate.class, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pFacePlane, Float.valueOf(0.0f));
        return this;
    }

    public ModelRenderer addPlate(float pX, float pY, float pZ, int pWidth, int pHeight, int pFacePlane, float pSizeAdjust) {
        this.addParts(ModelPlate.class, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pFacePlane, Float.valueOf(pSizeAdjust));
        return this;
    }

    public ModelRenderer addPlate(String pName, float pX, float pY, float pZ, int pWidth, int pHeight, int pFacePlane) {
        this.addParts(ModelPlate.class, pName, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pFacePlane, Float.valueOf(0.0f));
        return this;
    }

    public void clearCubeList() {
        this.cubeList.clear();
        this.compiled = false;
        if (this.childModels != null) {
            this.childModels.clear();
        }
    }

    public boolean renderItems(ModelMultiBase pModelMulti, IModelCaps pEntityCaps, boolean pRealBlock, int pIndex) {
        ItemStack[] litemstacks = (ItemStack[])ModelCapsHelper.getCapsValue(pEntityCaps, 309, new Object[0]);
        if (litemstacks == null) {
            return false;
        }
        EnumAction[] lactions = (EnumAction[])ModelCapsHelper.getCapsValue(pEntityCaps, 310, new Object[0]);
        EntityLivingBase lentity = (EntityLivingBase)pEntityCaps.getCapsValue(32, new Object[0]);
        this.renderItems(lentity, pModelMulti.render, pRealBlock, lactions[pIndex], litemstacks[pIndex]);
        return true;
    }

    public void renderItemsHead(ModelMultiBase pModelMulti, IModelCaps pEntityCaps) {
        ItemStack lis = (ItemStack)pEntityCaps.getCapsValue(306, new Object[0]);
        EntityLivingBase lentity = (EntityLivingBase)pEntityCaps.getCapsValue(32, new Object[0]);
        this.renderItems(lentity, pModelMulti.render, true, null, lis);
    }

    protected void renderItems(EntityLivingBase pEntityLiving, Render pRender, boolean pRealBlock, EnumAction pAction, ItemStack pItemStack) {
        this.itemstack = pItemStack;
        this.renderItems(pEntityLiving, pRender, pRealBlock, pAction);
    }

    protected void renderItems(EntityLivingBase pEntityLiving, Render pRender, boolean pRealBlock, EnumAction pAction) {
        if (this.itemstack == null) {
            return;
        }
        GL11.glPushMatrix();
        Item litem = this.itemstack.func_77973_b();
        if (this.adjust) {
            float var6;
            float f2;
            if (pRealBlock && litem instanceof ItemBlock) {
                f2 = 0.625f;
                GL11.glScalef((float)f2, (float)(-f2), (float)(-f2));
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (pRealBlock && litem instanceof ItemSkull) {
                f2 = 1.0625f;
                GL11.glScalef((float)f2, (float)(-f2), (float)(-f2));
            } else if (litem instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)litem).func_149645_b())) {
                var6 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.2125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(var6 *= 0.75f), (float)(-var6), (float)var6);
            } else if (litem instanceof ItemBow) {
                var6 = 0.625f;
                GL11.glTranslatef((float)-0.05f, (float)0.125f, (float)0.3125f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)var6, (float)(-var6), (float)var6);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (litem.func_77662_d()) {
                var6 = 0.625f;
                if (litem.func_77629_n_()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                if (pAction == EnumAction.block) {
                    GL11.glTranslatef((float)0.05f, (float)0.0f, (float)-0.1f);
                    GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.1f);
                GL11.glScalef((float)var6, (float)(-var6), (float)var6);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                var6 = 0.375f;
                GL11.glTranslatef((float)0.15f, (float)0.15f, (float)-0.05f);
                GL11.glScalef((float)var6, (float)var6, (float)var6);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        if (pRealBlock && litem instanceof ItemSkull) {
            String lsowner = "";
            if (this.itemstack.func_77942_o() && this.itemstack.func_77978_p().func_74764_b("SkullOwner")) {
                lsowner = this.itemstack.func_77978_p().func_74779_i("SkullOwner");
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            W_Client.renderSkeletonHead(TileEntitySkullRenderer.field_147536_b, -0.5f, 0.0f, -0.5f, 1, 180.0f, this.itemstack.func_77960_j(), lsowner);
        } else if (pRealBlock && litem instanceof ItemBlock) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int var4 = pEntityLiving.func_70070_b(0.0f);
            int var5 = var4 % 65536;
            int var6 = var4 / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var5 / 1.0f), (float)((float)var6 / 1.0f));
            GL11.glEnable((int)2884);
            this.renderBlock(this.itemstack);
            GL11.glDisable((int)2884);
        } else {
            for (int j = 0; j <= (litem.func_77623_v() ? 1 : 0); ++j) {
                int k = this.itemstack.func_77973_b().func_82790_a(this.itemstack, j);
                float f15 = (float)(k >> 16 & 0xFF) / 255.0f;
                float f17 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f19 = (float)(k & 0xFF) / 255.0f;
                GL11.glColor4f((float)f15, (float)f17, (float)f19, (float)1.0f);
                RenderManager.field_78727_a.field_78721_f.func_78443_a(pEntityLiving, this.itemstack, j);
            }
        }
        GL11.glPopMatrix();
    }

    private void renderBlock(ItemStack par2ItemStack) {
        GL11.glPushMatrix();
        TextureManager texturemanager = Minecraft.func_71410_x().field_71446_o;
        Item item = par2ItemStack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (par2ItemStack.func_94608_d() == 0 && item instanceof ItemBlock) {
            texturemanager.func_110577_a(texturemanager.func_130087_a(0));
            GL11.glDisable((int)2896);
            if (item instanceof ItemCloth) {
                GL11.glEnable((int)3042);
                GL11.glDepthMask((boolean)false);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glAlphaFunc((int)516, (float)0.001f);
                this.renderBlocksIr.func_147800_a(block, par2ItemStack.func_77960_j(), 1.0f);
                GL11.glDepthMask((boolean)true);
                GL11.glDisable((int)3042);
            } else {
                this.renderBlocksIr.func_147800_a(block, par2ItemStack.func_77960_j(), 1.0f);
            }
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
    }

    public void setRotatePriority(int pValue) {
        this.rotatePriority = pValue;
    }

    protected void setRotation() {
        switch (this.rotatePriority) {
            case 0: {
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX == 0.0f) break;
                GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 1: {
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleX == 0.0f) break;
                GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 2: {
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (this.rotateAngleY == 0.0f) break;
                GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY == 0.0f) break;
                GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (this.rotateAngleZ == 0.0f) break;
                GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 5: {
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleZ == 0.0f) break;
                GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected void renderObject(float par1, boolean pRendering) {
        GL11.glGetFloat((int)2982, (FloatBuffer)this.matrix);
        if (pRendering && this.isRendering) {
            GL11.glPushMatrix();
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            GL11.glCallList((int)this.displayList);
            GL11.glPopMatrix();
        }
        if (this.childModels != null) {
            for (int li = 0; li < this.childModels.size(); ++li) {
                this.childModels.get(li).render(par1, pRendering);
            }
        }
    }

    public ModelRenderer loadMatrix() {
        GL11.glLoadMatrix((FloatBuffer)this.matrix);
        if (this.isInvertX) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        }
        return this;
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public ModelRenderer setMirror(boolean flag) {
        this.mirror = flag;
        return this;
    }

    public boolean getVisible() {
        return this.showModel;
    }

    public void setVisible(boolean flag) {
        this.showModel = flag;
    }

    public float getRotateAngleX() {
        return this.rotateAngleX;
    }

    public float getRotateAngleDegX() {
        return this.rotateAngleX * 57.295776f;
    }

    public float setRotateAngleX(float value) {
        this.rotateAngleX = value;
        return this.rotateAngleX;
    }

    public float setRotateAngleDegX(float value) {
        this.rotateAngleX = value * ((float)Math.PI / 180);
        return this.rotateAngleX;
    }

    public float addRotateAngleX(float value) {
        return this.rotateAngleX += value;
    }

    public float addRotateAngleDegX(float value) {
        return this.rotateAngleX += value * ((float)Math.PI / 180);
    }

    public float getRotateAngleY() {
        return this.rotateAngleY;
    }

    public float getRotateAngleDegY() {
        return this.rotateAngleY * 57.295776f;
    }

    public float setRotateAngleY(float value) {
        this.rotateAngleY = value;
        return this.rotateAngleY;
    }

    public float setRotateAngleDegY(float value) {
        this.rotateAngleY = value * ((float)Math.PI / 180);
        return this.rotateAngleY;
    }

    public float addRotateAngleY(float value) {
        return this.rotateAngleY += value;
    }

    public float addRotateAngleDegY(float value) {
        return this.rotateAngleY += value * ((float)Math.PI / 180);
    }

    public float getRotateAngleZ() {
        return this.rotateAngleZ;
    }

    public float getRotateAngleDegZ() {
        return this.rotateAngleZ * 57.295776f;
    }

    public float setRotateAngleZ(float value) {
        this.rotateAngleZ = value;
        return this.rotateAngleZ;
    }

    public float setRotateAngleDegZ(float value) {
        this.rotateAngleZ = value * ((float)Math.PI / 180);
        return this.rotateAngleZ;
    }

    public float addRotateAngleZ(float value) {
        return this.rotateAngleZ += value;
    }

    public float addRotateAngleDegZ(float value) {
        return this.rotateAngleZ += value * ((float)Math.PI / 180);
    }

    public ModelRenderer setRotateAngle(float x, float y, float z) {
        this.rotateAngleX = x;
        this.rotateAngleY = y;
        this.rotateAngleZ = z;
        return this;
    }

    public ModelRenderer setRotateAngleDeg(float x, float y, float z) {
        this.rotateAngleX = x * ((float)Math.PI / 180);
        this.rotateAngleY = y * ((float)Math.PI / 180);
        this.rotateAngleZ = z * ((float)Math.PI / 180);
        return this;
    }

    public float getRotationPointX() {
        return this.rotationPointX;
    }

    public float setRotationPointX(float value) {
        this.rotationPointX = value;
        return this.rotationPointX;
    }

    public float addRotationPointX(float value) {
        return this.rotationPointX += value;
    }

    public float getRotationPointY() {
        return this.rotationPointY;
    }

    public float setRotationPointY(float value) {
        this.rotationPointY = value;
        return this.rotationPointY;
    }

    public float addRotationPointY(float value) {
        return this.rotationPointY += value;
    }

    public float getRotationPointZ() {
        return this.rotationPointZ;
    }

    public float setRotationPointZ(float value) {
        this.rotationPointZ = value;
        return this.rotationPointZ;
    }

    public float addRotationPointZ(float value) {
        return this.rotationPointZ += value;
    }

    public ModelRenderer setScale(float pX, float pY, float pZ) {
        this.scaleX = pX;
        this.scaleY = pY;
        this.scaleZ = pZ;
        return this;
    }

    public float setScaleX(float pValue) {
        this.scaleX = pValue;
        return this.scaleX;
    }

    public float setScaleY(float pValue) {
        this.scaleY = pValue;
        return this.scaleY;
    }

    public float setScaleZ(float pValue) {
        this.scaleZ = pValue;
        return this.scaleZ;
    }
}

