/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib.multiModel.texture;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mmmlibx.lib.FileLoaderBase;
import mmmlibx.lib.MMMLib;
import mmmlibx.lib.multiModel.model.AbstractModelBase;
import mmmlibx.lib.multiModel.model.mc162.ModelLittleMaid_Orign;
import mmmlibx.lib.multiModel.texture.MultiModelContainer;
import net.minecraft.util.ResourceLocation;

public class MultiModelManager
extends FileLoaderBase {
    protected static final String[] defNames = new String[]{"mob_littlemaid0.png", "mob_littlemaid1.png", "mob_littlemaid2.png", "mob_littlemaid3.png", "mob_littlemaid4.png", "mob_littlemaid5.png", "mob_littlemaid6.png", "mob_littlemaid7.png", "mob_littlemaid8.png", "mob_littlemaid9.png", "mob_littlemaida.png", "mob_littlemaidb.png", "mob_littlemaidc.png", "mob_littlemaidd.png", "mob_littlemaide.png", "mob_littlemaidf.png", "mob_littlemaidw.png", "mob_littlemaid_a00.png", "mob_littlemaid_a01.png"};
    public static MultiModelManager instance = new MultiModelManager();
    protected AbstractModelBase[] defaultModel;
    protected Map<String, AbstractModelBase[]> models = new HashMap<String, AbstractModelBase[]>();
    protected Map<String, String> modelNames = new HashMap<String, String>();
    protected Map<String, MultiModelContainer> textures;
    protected List<String> preFixs;

    public MultiModelManager() {
        this.defaultModel = this.getModelBase(ModelLittleMaid_Orign.class);
        this.preFixs = new ArrayList<String>();
        this.preFixs.add("/mob/littleMaid/");
        this.preFixs.add("/textures/entity/littleMaid/");
        this.preFixs.add("/multiModel/");
        this.textures = new HashMap<String, MultiModelContainer>();
    }

    @Override
    public boolean isZipLoad() {
        return true;
    }

    @Override
    public void execute() {
        super.execute();
        this.setModels();
    }

    @Override
    public void decodeZip(File pFile) {
        super.decodeZip(pFile);
    }

    @Override
    public boolean load(File pFile, String pFileName, InputStream pInputStream) {
        if (MMMLib.proxy.isClient() && this.addModelClass(pFileName)) {
            return true;
        }
        return this.addTexture(pFile, pFileName);
    }

    protected boolean addModelClass(String pFileName) {
        if (pFileName.endsWith(".class") && pFileName.indexOf("$") == -1) {
            String lcname = pFileName.substring(0, pFileName.length() - 6);
            if (lcname.startsWith("/")) {
                lcname = lcname.substring(1);
            }
            lcname = lcname.replace("/", ".");
            try {
                ClassLoader lcl = this.getClass().getClassLoader();
                Class<?> lc = lcl.loadClass(lcname);
                if (AbstractModelBase.class.isAssignableFrom(lc) && !Modifier.isAbstract(lc.getModifiers())) {
                    Class<?> lca = lc;
                    int lindex = lcname.lastIndexOf(95);
                    if (lindex > -1) {
                        String lname = lcname.substring(lindex + 1, lcname.length());
                        this.models.put(lcname, this.getModelBase(lca));
                        this.modelNames.put(lname, lcname);
                        MMMLib.Debug("get MultiModelClass: %s(%s)", lname, lcname);
                        return true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected boolean addTexture(File pFile, String pFileName) {
        if (pFileName.endsWith(".png")) {
            if (!pFileName.startsWith("/")) {
                pFileName = "/" + pFileName;
            }
            for (String lfix : this.preFixs) {
                String lname;
                int lcol;
                int lindex = pFileName.indexOf(lfix);
                if (lindex <= -1 || (lcol = this.getIndex(lname = pFileName.substring(pFileName.lastIndexOf(47)))) <= -1) continue;
                lname = pFileName.substring(lindex + lfix.length(), pFileName.lastIndexOf(47));
                lname.replace('/', '.');
                MultiModelContainer lcon = this.textures.get(lname);
                if (lcon == null) {
                    lcon = new MultiModelContainer();
                    this.textures.put(lname, lcon);
                }
                lcon.addTexture(lcol, new ResourceLocation(pFileName));
                return true;
            }
        }
        return false;
    }

    protected void setModels() {
        MMMLib.Debug("setModels execute.", new Object[0]);
        for (Map.Entry<String, String> entry : this.modelNames.entrySet()) {
            MMMLib.Debug("models: %s - %s", entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.textures.entrySet()) {
            String lmname = entry.getKey();
            MultiModelContainer lcont = (MultiModelContainer)entry.getValue();
            if (lcont.defaultModel != null) continue;
            MMMLib.Debug("checkModel: %s(%d)", lmname, lcont.getTextureCount());
            int lindex = lmname.lastIndexOf(95);
            if (lindex > 0) {
                lmname = lmname.substring(lindex + 1, lmname.length());
                lcont.defaultModel = this.getModelFromName(lmname);
                continue;
            }
            lcont.defaultModel = this.defaultModel;
        }
    }

    protected AbstractModelBase[] getModelFromName(String pName) {
        String ls = this.modelNames.get(pName);
        return ls == null ? this.defaultModel : this.models.get(ls);
    }

    protected AbstractModelBase[] getModelBase(Class<? extends AbstractModelBase> pClass) {
        try {
            AbstractModelBase lo = pClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (lo instanceof AbstractModelBase) {
                AbstractModelBase[] lamb;
                AbstractModelBase lmodel = lo;
                float[] lsize = lmodel.getArmorModelsSize();
                if (lsize != null && lsize.length > 0) {
                    lamb = new AbstractModelBase[1 + lsize.length];
                    int li = 1;
                    Constructor<? extends AbstractModelBase> lc = pClass.getConstructor(Float.TYPE);
                    for (float lf : lsize) {
                        lamb[li++] = lc.newInstance(Float.valueOf(lf));
                    }
                } else {
                    lamb = new AbstractModelBase[]{lmodel};
                }
                return lamb;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected int getIndex(String name) {
        for (int i = 0; i < defNames.length; ++i) {
            if (!name.endsWith(defNames[i])) continue;
            return i;
        }
        Pattern p = Pattern.compile("_([0-9a-f]+).png");
        Matcher m = p.matcher(name);
        if (m.find()) {
            return Integer.decode("0x" + m.group(1));
        }
        return -1;
    }

    public MultiModelContainer getMultiModel(String pName) {
        MultiModelContainer lcont = this.textures.get(pName);
        if (lcont == null) {
            lcont = this.textures.get("default");
        }
        return lcont;
    }
}

