/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import mcjty.lostcities.api.RailChunkType;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.NormalTerrainGenerator;
import mcjty.lostcities.dimensions.world.lost.BiomeInfo;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.DamageArea;
import mcjty.lostcities.dimensions.world.lost.Direction;
import mcjty.lostcities.dimensions.world.lost.Highway;
import mcjty.lostcities.dimensions.world.lost.Orientation;
import mcjty.lostcities.dimensions.world.lost.Railway;
import mcjty.lostcities.dimensions.world.lost.Transform;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import mcjty.lostcities.dimensions.world.lost.cityassets.BuildingPart;
import mcjty.lostcities.dimensions.world.lost.cityassets.CompiledPalette;
import mcjty.lostcities.dimensions.world.lost.cityassets.Palette;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.GeometryTools;
import mcjty.lostcities.varia.PrimerTools;
import mcjty.lostcities.varia.Tools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class LostCitiesTerrainGenerator
extends NormalTerrainGenerator {
    private static int g_seed = 123456789;
    private final int groundLevel;
    private final int waterLevel;
    private static boolean charsSetup = false;
    public static char airChar;
    public static char hardAirChar;
    public static char glowstoneChar;
    public static char baseChar;
    public static char liquidChar;
    public static char leavesChar;
    public static char leaves2Char;
    public static char leaves3Char;
    public static char ironbarsChar;
    public static char grassChar;
    public static char bedrockChar;
    public static char endportalChar;
    public static char endportalFrameChar;
    public static char torchChar;
    public static char goldBlockChar;
    public static char diamondBlockChar;
    public static char spawnerChar;
    public static char chestChar;
    private static Set<Character> rotatableChars;
    private static Set<Character> railChars;
    private static Set<Character> glassChars;
    private static Set<Character> charactersNeedingTodo;
    private Character street;
    private Character streetBase;
    private Character street2;
    private int streetBorder;
    private NoiseGeneratorPerlin rubbleNoise;
    private NoiseGeneratorPerlin leavesNoise;
    private NoiseGeneratorPerlin ruinNoise;
    private static char[] randomLeafs;
    private double[] rubbleBuffer = new double[256];
    private double[] leavesBuffer = new double[256];
    private double[] ruinBuffer = new double[256];

    public LostCitiesTerrainGenerator(LostCityChunkGenerator provider) {
        super(provider);
        this.groundLevel = provider.profile.GROUNDLEVEL;
        this.waterLevel = provider.profile.WATERLEVEL;
        this.rubbleNoise = new NoiseGeneratorPerlin(provider.rand, 4);
        this.leavesNoise = new NoiseGeneratorPerlin(provider.rand, 4);
        this.ruinNoise = new NoiseGeneratorPerlin(provider.rand, 4);
    }

    public static char getRandomLeaf() {
        if (randomLeafs == null) {
            int i;
            randomLeafs = new char[128];
            for (i = 0; i < 20; ++i) {
                LostCitiesTerrainGenerator.randomLeafs[i] = leaves2Char;
            }
            while (i < 40) {
                LostCitiesTerrainGenerator.randomLeafs[i] = leaves3Char;
                ++i;
            }
            while (i < randomLeafs.length) {
                LostCitiesTerrainGenerator.randomLeafs[i] = leavesChar;
                ++i;
            }
        }
        return randomLeafs[LostCitiesTerrainGenerator.fastrand128()];
    }

    public static Set<Character> getRailChars() {
        if (railChars == null) {
            railChars = new HashSet<Character>();
            LostCitiesTerrainGenerator.addStates(Blocks.field_150448_aq, railChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150318_D, railChars);
        }
        return railChars;
    }

    public static Set<Character> getGlassChars() {
        if (glassChars == null) {
            glassChars = new HashSet<Character>();
            LostCitiesTerrainGenerator.addStates(Blocks.field_150359_w, glassChars);
            LostCitiesTerrainGenerator.addStates((Block)Blocks.field_150399_cn, glassChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150410_aZ, glassChars);
            LostCitiesTerrainGenerator.addStates((Block)Blocks.field_150397_co, glassChars);
        }
        return glassChars;
    }

    public static Set<Character> getCharactersNeedingTodo() {
        if (charactersNeedingTodo == null) {
            charactersNeedingTodo = new HashSet<Character>();
            charactersNeedingTodo.add(Character.valueOf(torchChar));
            charactersNeedingTodo.add(Character.valueOf(spawnerChar));
            charactersNeedingTodo.add(Character.valueOf(chestChar));
            charactersNeedingTodo.add(Character.valueOf(glowstoneChar));
            charactersNeedingTodo.add(Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.ACACIA))));
            charactersNeedingTodo.add(Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.BIRCH))));
            charactersNeedingTodo.add(Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.OAK))));
            charactersNeedingTodo.add(Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.SPRUCE))));
            charactersNeedingTodo.add(Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.DARK_OAK))));
            charactersNeedingTodo.add(Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.JUNGLE))));
        }
        return charactersNeedingTodo;
    }

    public static Set<Character> getRotatableChars() {
        if (rotatableChars == null) {
            rotatableChars = new HashSet<Character>();
            LostCitiesTerrainGenerator.addStates(Blocks.field_150400_ck, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150487_bG, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150389_bf, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150370_cb, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150390_bg, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150401_cl, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150481_bH, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150387_bl, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150476_ad, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_185769_cV, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_180396_cN, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150372_bz, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150485_bF, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150446_ar, rotatableChars);
            LostCitiesTerrainGenerator.addStates(Blocks.field_150468_ap, rotatableChars);
        }
        return rotatableChars;
    }

    private static void addStates(Block block, Set<Character> set) {
        for (int m = 0; m < 16; ++m) {
            try {
                IBlockState state = block.func_176203_a(m);
                set.add(Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)state)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setupChars() {
        if (!charsSetup) {
            airChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150350_a.func_176223_P());
            hardAirChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150483_bI.func_176223_P());
            glowstoneChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150426_aN.func_176223_P());
            baseChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150348_b.func_176223_P());
            liquidChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150355_j.func_176223_P());
            leavesChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false)));
            leaves2Char = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE));
            leaves3Char = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE));
            ironbarsChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150411_aY.func_176223_P());
            grassChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150349_c.func_176223_P());
            bedrockChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150357_h.func_176223_P());
            endportalChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150384_bq.func_176223_P());
            endportalFrameChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150378_br.func_176223_P());
            torchChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150478_aa.func_176223_P());
            goldBlockChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150340_R.func_176223_P());
            diamondBlockChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150484_ah.func_176223_P());
            spawnerChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150474_ac.func_176223_P());
            chestChar = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150486_ae.func_176223_P());
            charsSetup = true;
        }
    }

    private static int fastrand() {
        g_seed = 214013 * g_seed + 2531011;
        return g_seed >> 16 & Short.MAX_VALUE;
    }

    public static int fastrand128() {
        g_seed = 214013 * g_seed + 2531011;
        return g_seed >> 16 & 0x7F;
    }

    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, this.provider);
        this.street = info.getCompiledPalette().get(info.getCityStyle().getStreetBlock().charValue());
        this.streetBase = info.getCompiledPalette().get(info.getCityStyle().getStreetBaseBlock().charValue());
        this.street2 = info.getCompiledPalette().get(info.getCityStyle().getStreetVariantBlock().charValue());
        this.streetBorder = (16 - info.getCityStyle().getStreetWidth()) / 2;
        if (info.isCity) {
            this.doCityChunk(chunkX, chunkZ, primer, info);
        } else {
            this.doNormalChunk(chunkX, chunkZ, primer, info);
        }
        Railway.RailChunkInfo railInfo = info.getRailInfo();
        if (railInfo.getType() != RailChunkType.NONE) {
            this.generateRailways(primer, info, railInfo);
        }
        this.generateRailwayDungeons(primer, info);
        this.fixTorches(primer, info);
        this.provider.rand.setSeed((long)chunkX * 257017164707L + (long)chunkZ * 101754694003L);
        if (info.getDamageArea().hasExplosions()) {
            this.breakBlocksForDamage(chunkX, chunkZ, primer, info);
            this.fixAfterExplosionNew(primer, info, this.provider.rand);
        }
        this.generateDebris(primer, this.provider.rand, info);
    }

    private void fixTorches(ChunkPrimer primer, BuildingInfo info) {
        List<Integer> torches = info.getTorchTodo();
        if (torches.isEmpty()) {
            return;
        }
        char tn = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH));
        char ts = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH));
        char tw = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST));
        char te = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST));
        char tu = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP));
        for (Integer idx : torches) {
            if (primer.field_177860_a[idx] != torchChar) continue;
            int x = idx >> 12 & 0xF;
            int z = idx >> 8 & 0xF;
            if (primer.field_177860_a[idx - 1] != airChar) {
                primer.field_177860_a[idx.intValue()] = tu;
                continue;
            }
            if (x > 0 && primer.field_177860_a[idx - 4096] != airChar) {
                primer.field_177860_a[idx.intValue()] = te;
                continue;
            }
            if (x < 15 && primer.field_177860_a[idx + 4096] != airChar) {
                primer.field_177860_a[idx.intValue()] = tw;
                continue;
            }
            if (z > 0 && primer.field_177860_a[idx - 256] != airChar) {
                primer.field_177860_a[idx.intValue()] = ts;
                continue;
            }
            if (z >= 15 || primer.field_177860_a[idx + 256] == airChar) continue;
            primer.field_177860_a[idx.intValue()] = tn;
        }
        info.clearTorchTodo();
    }

    public void doCoreChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.generateHeightmap(chunkX, chunkZ);
        for (int x4 = 0; x4 < 4; ++x4) {
            int l = x4 * 5;
            int i1 = (x4 + 1) * 5;
            for (int z4 = 0; z4 < 4; ++z4) {
                int k1 = (l + z4) * 33;
                int l1 = (l + z4 + 1) * 33;
                int i2 = (i1 + z4) * 33;
                int j2 = (i1 + z4 + 1) * 33;
                for (int height32 = 0; height32 < 32; ++height32) {
                    double d1 = this.heightMap[k1 + height32];
                    double d2 = this.heightMap[l1 + height32];
                    double d3 = this.heightMap[i2 + height32];
                    double d4 = this.heightMap[j2 + height32];
                    double d5 = (this.heightMap[k1 + height32 + 1] - d1) * 0.125;
                    double d6 = (this.heightMap[l1 + height32 + 1] - d2) * 0.125;
                    double d7 = (this.heightMap[i2 + height32 + 1] - d3) * 0.125;
                    double d8 = (this.heightMap[j2 + height32 + 1] - d4) * 0.125;
                    for (int h = 0; h < 8; ++h) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        int height = height32 * 8 + h;
                        for (int x = 0; x < 4; ++x) {
                            int index = x + x4 * 4 << 12 | 0 + z4 * 4 << 8 | height;
                            int maxheight = 256;
                            index -= maxheight;
                            double d16 = (d11 - d10) * 0.25;
                            double d15 = d10 - d16;
                            for (int z = 0; z < 4; ++z) {
                                double d;
                                index += maxheight;
                                d15 += d16;
                                if (d > 0.0) {
                                    primer.field_177860_a[index] = baseChar;
                                    continue;
                                }
                                if (height >= this.waterLevel) continue;
                                primer.field_177860_a[index] = liquidChar;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void doNormalChunk(int chunkX, int chunkZ, ChunkPrimer primer, BuildingInfo info) {
        this.flattenChunkToCityBorder(chunkX, chunkZ, primer);
        this.generateBridges(primer, info);
        this.generateHighways(chunkX, chunkZ, primer, info);
    }

    private void breakBlocksForDamage(int chunkX, int chunkZ, ChunkPrimer primer, BuildingInfo info) {
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        DamageArea damageArea = info.getDamageArea();
        boolean clear = false;
        float damageFactor = 1.0f;
        for (int yy = 0; yy < 16; ++yy) {
            int index;
            if (!clear && !damageArea.hasExplosions(yy)) continue;
            if (clear || damageArea.isCompletelyDestroyed(yy)) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int height = yy * 16;
                        index = x << 12 | (z << 8) + height;
                        for (int y = 0; y < 16; ++y) {
                            primer.field_177860_a[index] = (index & 0xFF) < this.waterLevel ? liquidChar : airChar;
                            ++index;
                        }
                    }
                }
                clear = true;
                continue;
            }
            for (int y = 0; y < 16; ++y) {
                int cntDamaged = 0;
                int cntAir = 0;
                index = yy * 16 + y;
                int cury = yy * 16 + y;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        char d = primer.field_177860_a[index];
                        if (d != airChar || (index & 0xFF) < this.waterLevel) {
                            Character newd;
                            float damage = damageArea.getDamage(cx + x, cury, cz + z) * damageFactor;
                            if ((double)damage >= 0.001 && (newd = damageArea.damageBlock(Character.valueOf(d), this.provider, cury, damage, info.getCompiledPalette())).charValue() != d) {
                                primer.field_177860_a[index] = newd.charValue();
                                ++cntDamaged;
                            }
                        } else {
                            ++cntAir;
                        }
                        index += 256;
                    }
                }
                int tot = cntDamaged + cntAir;
                if (tot > 250) {
                    damageFactor = 200.0f;
                    clear = true;
                    continue;
                }
                if (tot > 220) {
                    damageFactor *= 1.4f;
                    continue;
                }
                if (tot <= 180) continue;
                damageFactor *= 1.2f;
            }
        }
    }

    private void generateHighways(int chunkX, int chunkZ, ChunkPrimer primer, BuildingInfo info) {
        int levelZ;
        int levelX = Highway.getXHighwayLevel(chunkX, chunkZ, this.provider);
        if (levelX == (levelZ = Highway.getZHighwayLevel(chunkX, chunkZ, this.provider)) && levelX >= 0) {
            this.generateHighwayPart(primer, info, levelX, Transform.ROTATE_NONE, info.getXmax(), info.getZmax(), "_bi");
        } else if (levelX >= 0 && levelZ >= 0) {
            if (levelX == 0) {
                this.generateHighwayPart(primer, info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), "");
                this.generateHighwayPart(primer, info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), "");
            } else {
                this.generateHighwayPart(primer, info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), "");
                this.generateHighwayPart(primer, info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), "");
            }
        } else if (levelX >= 0) {
            this.generateHighwayPart(primer, info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), "");
        } else if (levelZ >= 0) {
            this.generateHighwayPart(primer, info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), "");
        }
    }

    private void generateHighwayPart(ChunkPrimer primer, BuildingInfo info, int level, Transform transform, BuildingInfo adjacent1, BuildingInfo adjacent2, String suffix) {
        int index;
        int z;
        int x;
        int height;
        BuildingPart part;
        int highwayGroundLevel = this.provider.profile.GROUNDLEVEL + level * 6;
        if (info.isTunnel(level)) {
            part = AssetRegistries.PARTS.get("highway_tunnel" + suffix);
            this.generatePart(primer, info, part, transform, 0, highwayGroundLevel, 0, true);
        } else if (info.isCity && level <= adjacent1.cityLevel && level <= adjacent2.cityLevel && adjacent1.isCity && adjacent2.isCity) {
            part = AssetRegistries.PARTS.get("highway_open" + suffix);
            height = this.generatePart(primer, info, part, transform, 0, highwayGroundLevel, 0, true);
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    index = x << 12 | z << 8;
                    this.clearRange(primer, index, height, height + 15);
                }
            }
        } else {
            part = AssetRegistries.PARTS.get("highway_bridge" + suffix);
            height = this.generatePart(primer, info, part, transform, 0, highwayGroundLevel, 0, true);
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    index = x << 12 | z << 8;
                    this.clearRange(primer, index, height, height + 15);
                }
            }
        }
        Character support = part.getMetaChar("support");
        if (support != null) {
            char sup = info.getCompiledPalette().get(support.charValue()).charValue();
            int x1 = transform.rotateX(0, 15);
            int z1 = transform.rotateZ(0, 15);
            int index1 = x1 << 12 | (z1 << 8) + highwayGroundLevel - 1;
            int x2 = transform.rotateX(0, 0);
            int z2 = transform.rotateZ(0, 0);
            int index2 = x2 << 12 | (z2 << 8) + highwayGroundLevel - 1;
            for (int y = 0; y < 40; ++y) {
                boolean done = false;
                if (primer.field_177860_a[index1] == airChar || primer.field_177860_a[index1] == liquidChar) {
                    primer.field_177860_a[index1] = sup;
                    done = true;
                }
                if (primer.field_177860_a[index2] == airChar || primer.field_177860_a[index2] == liquidChar) {
                    primer.field_177860_a[index2] = sup;
                    done = true;
                }
                --index1;
                --index2;
                if (!done) break;
            }
        }
    }

    private void clearRange(ChunkPrimer primer, int index, int height1, int height2) {
        if (this.waterLevel > this.groundLevel) {
            PrimerTools.setBlockStateRangeSafe(primer, index + height1, index + this.waterLevel, liquidChar);
            PrimerTools.setBlockStateRangeSafe(primer, index + this.waterLevel, index + height2, airChar);
        } else {
            PrimerTools.setBlockStateRange(primer, index + height1, index + height2, airChar);
        }
    }

    private void generateBridges(ChunkPrimer primer, BuildingInfo info) {
        if (info.getHighwayXLevel() == 0 || info.getHighwayZLevel() == 0) {
            return;
        }
        BuildingPart bt = info.hasXBridge(this.provider);
        if (bt != null) {
            this.generateBridge(primer, info, bt, Orientation.X);
        } else {
            bt = info.hasZBridge(this.provider);
            if (bt != null) {
                this.generateBridge(primer, info, bt, Orientation.Z);
            }
        }
    }

    private void generateBridge(ChunkPrimer primer, BuildingInfo info, BuildingPart bt, Orientation orientation) {
        block18: {
            int x;
            int index;
            int z;
            for (int x2 = 0; x2 < 16; ++x2) {
                for (int z2 = 0; z2 < 16; ++z2) {
                    int index2 = x2 << 12 | (z2 << 8) + this.groundLevel + 1;
                    for (int l = 0; l < bt.getSliceCount(); ++l) {
                        Character b;
                        Character c = b = orientation == Orientation.X ? bt.get(info, x2, l, z2) : bt.get(info, z2, l, x2);
                        if (b.charValue() == torchChar) {
                            if (this.provider.profile.GENERATE_LIGHTING) {
                                info.addTorchTodo(index2);
                            } else {
                                b = Character.valueOf(airChar);
                            }
                        }
                        primer.field_177860_a[index2++] = b.charValue();
                    }
                }
            }
            Character support = bt.getMetaChar("support");
            if (support == null) break block18;
            char sup = info.getCompiledPalette().get(support.charValue()).charValue();
            BuildingInfo minDir = orientation.getMinDir().get(info);
            BuildingInfo maxDir = orientation.getMaxDir().get(info);
            if (minDir.hasBridge(this.provider, orientation) != null && maxDir.hasBridge(this.provider, orientation) != null) {
                for (int y = this.waterLevel - 10; y <= this.groundLevel; ++y) {
                    this.setBridgeSupport(primer, 7, y, 7, sup);
                    this.setBridgeSupport(primer, 7, y, 8, sup);
                    this.setBridgeSupport(primer, 8, y, 7, sup);
                    this.setBridgeSupport(primer, 8, y, 8, sup);
                }
            }
            if (minDir.hasBridge(this.provider, orientation) == null) {
                if (orientation == Orientation.X) {
                    int x3 = 0;
                    for (z = 6; z <= 9; ++z) {
                        index = x3 << 12 | (z << 8) + this.groundLevel;
                        primer.field_177860_a[index] = sup;
                    }
                } else {
                    int z3 = 0;
                    for (x = 6; x <= 9; ++x) {
                        index = x << 12 | (z3 << 8) + this.groundLevel;
                        primer.field_177860_a[index] = sup;
                    }
                }
            }
            if (maxDir.hasBridge(this.provider, orientation) == null) {
                if (orientation == Orientation.X) {
                    int x4 = 15;
                    for (z = 6; z <= 9; ++z) {
                        index = x4 << 12 | (z << 8) + this.groundLevel;
                        primer.field_177860_a[index] = sup;
                    }
                } else {
                    int z4 = 15;
                    for (x = 6; x <= 9; ++x) {
                        index = x << 12 | (z4 << 8) + this.groundLevel;
                        primer.field_177860_a[index] = sup;
                    }
                }
            }
        }
    }

    private void setBridgeSupport(ChunkPrimer primer, int x, int y, int z, char sup) {
        int index = x << 12 | (z << 8) + y;
        primer.field_177860_a[index] = sup;
    }

    private int getHeightAt00Corner(BuildingInfo info) {
        int h = this.getHeightForChunk(info);
        h = Math.min(h, this.getHeightForChunk(info.getXmin()));
        h = Math.min(h, this.getHeightForChunk(info.getZmin()));
        h = Math.min(h, this.getHeightForChunk(info.getXmin().getZmin()));
        return h;
    }

    private int getHeightForChunk(BuildingInfo info) {
        if (info.isCity) {
            return info.getCityGroundLevel();
        }
        if (info.isOcean()) {
            return this.groundLevel - 4;
        }
        return info.getCityGroundLevel();
    }

    private void flattenChunkToCityBorder(int chunkX, int chunkZ, ChunkPrimer primer) {
        double dist;
        int z;
        int x;
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, this.provider);
        float h00 = this.getHeightAt00Corner(info);
        float h10 = this.getHeightAt00Corner(info.getXmax());
        float h01 = this.getHeightAt00Corner(info.getZmax());
        float h11 = this.getHeightAt00Corner(info.getXmax().getZmax());
        ArrayList<GeometryTools.AxisAlignedBB2D> boxes = new ArrayList<GeometryTools.AxisAlignedBB2D>();
        ArrayList<GeometryTools.AxisAlignedBB2D> boxesDownwards = new ArrayList<GeometryTools.AxisAlignedBB2D>();
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                GeometryTools.AxisAlignedBB2D box;
                if (x == 0 && z == 0) continue;
                int ccx = chunkX + x;
                int ccz = chunkZ + z;
                BuildingInfo info2 = BuildingInfo.getBuildingInfo(ccx, ccz, this.provider);
                if (info2.isCity) {
                    box = new GeometryTools.AxisAlignedBB2D(ccx * 16, ccz * 16, ccx * 16 + 15, ccz * 16 + 15);
                    boxes.add(box);
                    continue;
                }
                if (info2.getMaxHighwayLevel() < 0 || info2.isTunnel(info2.getMaxHighwayLevel())) continue;
                box = new GeometryTools.AxisAlignedBB2D(ccx * 16, ccz * 16, ccx * 16 + 15, ccz * 16 + 15);
                box.height = this.provider.profile.GROUNDLEVEL + info2.getMaxHighwayLevel() * 6;
                boxesDownwards.add(box);
            }
        }
        if (!boxes.isEmpty()) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    double mindist = 1.0E9;
                    int height = this.bipolate(h11, h01, h10, h00, x, z);
                    for (GeometryTools.AxisAlignedBB2D box : boxes) {
                        dist = GeometryTools.squaredDistanceBoxPoint(box, cx + x, cz + z);
                        if (!(dist < mindist)) continue;
                        mindist = dist;
                    }
                    int offset = (int)(Math.sqrt(mindist) * 2.0);
                    this.flattenChunkBorder(primer, x, offset, z, this.provider.rand, height);
                }
            }
        }
        if (!boxesDownwards.isEmpty()) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    double mindist = 1.0E9;
                    int minheight = 1000000000;
                    for (GeometryTools.AxisAlignedBB2D box : boxesDownwards) {
                        dist = GeometryTools.squaredDistanceBoxPoint(box, cx + x, cz + z);
                        if (dist < mindist) {
                            mindist = dist;
                        }
                        if (box.height >= minheight) continue;
                        minheight = box.height;
                    }
                    int height = minheight;
                    int offset = (int)(Math.sqrt(mindist) * 2.0);
                    this.flattenChunkBorderDownwards(primer, x, offset, z, this.provider.rand, height);
                }
            }
        }
    }

    public static boolean isWaterBiome(LostCityChunkGenerator provider, ChunkCoord coord) {
        BiomeInfo biomeInfo = BiomeInfo.getBiomeInfo(provider, coord);
        Biome[] biomes = biomeInfo.getBiomes();
        return LostCitiesTerrainGenerator.isWaterBiome(biomes[55]) || LostCitiesTerrainGenerator.isWaterBiome(biomes[54]) || LostCitiesTerrainGenerator.isWaterBiome(biomes[56]);
    }

    private static boolean isWaterBiome(Biome biome) {
        return biome == Biomes.field_76771_b || biome == Biomes.field_150575_M || biome == Biomes.field_76776_l || biome == Biomes.field_76781_i || biome == Biomes.field_76777_m || biome == Biomes.field_76787_r || biome == Biomes.field_150577_O;
    }

    private void flattenChunkBorder(ChunkPrimer primer, int x, int offset, int z, Random rand, int level) {
        int index = x << 12 | z << 8;
        for (int y = 0; y <= level - offset - rand.nextInt(2); ++y) {
            char b = primer.field_177860_a[index];
            if (b != bedrockChar) {
                primer.field_177860_a[index] = baseChar;
            }
            ++index;
        }
        int r = rand.nextInt(2);
        index = x << 12 | z << 8;
        this.clearRange(primer, index, level + offset + r, 230);
    }

    private void flattenChunkBorderDownwards(ChunkPrimer primer, int x, int offset, int z, Random rand, int level) {
        int r = rand.nextInt(2);
        int index = x << 12 | z << 8;
        this.clearRange(primer, index, level + offset + r, 230);
    }

    private void doCityChunk(int chunkX, int chunkZ, ChunkPrimer primer, BuildingInfo info) {
        int index;
        int z;
        int x;
        boolean building = info.hasBuilding;
        Random rand = new Random(this.provider.seed * 377L + (long)chunkZ * 341873128712L + (long)chunkX * 132897987541L);
        rand.nextFloat();
        rand.nextFloat();
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                index = x << 12 | z << 8;
                PrimerTools.setBlockStateRange(primer, index, index + this.provider.profile.BEDROCK_LAYER, bedrockChar);
            }
        }
        if (this.waterLevel > this.groundLevel) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    index = x << 12 | z << 8;
                    PrimerTools.setBlockStateRange(primer, index + this.groundLevel, index + this.waterLevel, liquidChar);
                }
            }
        }
        if (building) {
            this.generateBuilding(primer, info);
        } else {
            this.generateStreet(primer, info, rand);
        }
        if (this.provider.profile.RUINS) {
            this.generateRuins(primer, info);
        }
        int levelX = info.getHighwayXLevel();
        int levelZ = info.getHighwayZLevel();
        if (!building) {
            Railway.RailChunkInfo railInfo = info.getRailInfo();
            if (levelX < 0 && levelZ < 0 && !railInfo.getType().isSurface()) {
                this.generateStreetDecorations(primer, info);
            }
        }
        if (levelX >= 0 || levelZ >= 0) {
            this.generateHighways(chunkX, chunkZ, primer, info);
        }
        if (this.provider.profile.RUBBLELAYER) {
            this.generateRubble(primer, chunkX, chunkZ, info);
        }
    }

    private void generateRailwayDungeons(ChunkPrimer primer, BuildingInfo info) {
        if (info.railDungeon == null) {
            return;
        }
        if (info.getZmin().getRailInfo().getType() == RailChunkType.HORIZONTAL || info.getZmax().getRailInfo().getType() == RailChunkType.HORIZONTAL) {
            int height = this.provider.profile.GROUNDLEVEL + -18;
            this.generatePart(primer, info, info.railDungeon, Transform.ROTATE_NONE, 0, height, 0, false);
        }
    }

    private void generateRailways(ChunkPrimer primer, BuildingInfo info, Railway.RailChunkInfo railInfo) {
        BuildingPart part;
        int height = this.provider.profile.GROUNDLEVEL + railInfo.getLevel() * 6;
        RailChunkType type = railInfo.getType();
        Transform transform = Transform.ROTATE_NONE;
        boolean needsStaircase = false;
        switch (type) {
            case NONE: {
                return;
            }
            case STATION_SURFACE: 
            case STATION_EXTENSION_SURFACE: {
                if (railInfo.getLevel() < info.cityLevel) {
                    part = AssetRegistries.PARTS.get("station_underground");
                    break;
                }
                if (railInfo.getPart() != null) {
                    part = AssetRegistries.PARTS.get(railInfo.getPart());
                    break;
                }
                part = AssetRegistries.PARTS.get("station_open");
                break;
            }
            case STATION_UNDERGROUND: {
                part = AssetRegistries.PARTS.get("station_underground_stairs");
                needsStaircase = true;
                break;
            }
            case STATION_EXTENSION_UNDERGROUND: {
                part = AssetRegistries.PARTS.get("station_underground");
                break;
            }
            case RAILS_END_HERE: {
                part = AssetRegistries.PARTS.get("rails_horizontal_end");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case HORIZONTAL: {
                part = AssetRegistries.PARTS.get("rails_horizontal");
                RailChunkType type1 = info.getXmin().getRailInfo().getType();
                RailChunkType type2 = info.getXmax().getRailInfo().getType();
                if (type1.isStation() || type2.isStation() || primer.field_177860_a[Tools.calcIndex(3, height + 2, 3)] != liquidChar || primer.field_177860_a[Tools.calcIndex(12, height + 2, 3)] != liquidChar || primer.field_177860_a[Tools.calcIndex(3, height + 2, 12)] != liquidChar || primer.field_177860_a[Tools.calcIndex(12, height + 2, 12)] != liquidChar || primer.field_177860_a[Tools.calcIndex(3, height + 4, 7)] != liquidChar || primer.field_177860_a[Tools.calcIndex(12, height + 4, 8)] != liquidChar) break;
                part = AssetRegistries.PARTS.get("rails_horizontal_water");
                break;
            }
            case VERTICAL: {
                part = AssetRegistries.PARTS.get("rails_vertical");
                if (primer.field_177860_a[Tools.calcIndex(3, height + 2, 3)] == liquidChar && primer.field_177860_a[Tools.calcIndex(12, height + 2, 3)] == liquidChar && primer.field_177860_a[Tools.calcIndex(3, height + 2, 12)] == liquidChar && primer.field_177860_a[Tools.calcIndex(12, height + 2, 12)] == liquidChar && primer.field_177860_a[Tools.calcIndex(3, height + 4, 7)] == liquidChar && primer.field_177860_a[Tools.calcIndex(12, height + 4, 8)] == liquidChar) {
                    part = AssetRegistries.PARTS.get("rails_vertical_water");
                }
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case THREE_SPLIT: {
                part = AssetRegistries.PARTS.get("rails_3split");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case GOING_DOWN_TWO_FROM_SURFACE: 
            case GOING_DOWN_FURTHER: {
                part = AssetRegistries.PARTS.get("rails_down2");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case GOING_DOWN_ONE_FROM_SURFACE: {
                part = AssetRegistries.PARTS.get("rails_down1");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case DOUBLE_BEND: {
                part = AssetRegistries.PARTS.get("rails_bend");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            default: {
                part = AssetRegistries.PARTS.get("rails_flat");
            }
        }
        this.generatePart(primer, info, part, transform, 0, height, 0, false);
        Character railMainBlock = info.getCityStyle().getRailMainBlock();
        char rail = info.getCompiledPalette().get(railMainBlock.charValue()).charValue();
        if (type == RailChunkType.HORIZONTAL) {
            int z;
            if (info.getZmin().railDungeon != null) {
                for (z = 0; z < 4; ++z) {
                    primer.field_177860_a[Tools.calcIndex((int)6, (int)(height + 1), (int)z)] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)6, (int)(height + 2), (int)z)] = airChar;
                    primer.field_177860_a[Tools.calcIndex((int)6, (int)(height + 3), (int)z)] = airChar;
                    primer.field_177860_a[Tools.calcIndex((int)7, (int)(height + 1), (int)z)] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)7, (int)(height + 2), (int)z)] = airChar;
                    primer.field_177860_a[Tools.calcIndex((int)7, (int)(height + 3), (int)z)] = airChar;
                }
                for (z = 0; z < 3; ++z) {
                    primer.field_177860_a[Tools.calcIndex((int)5, (int)(height + 2), (int)z)] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)5, (int)(height + 3), (int)z)] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)5, (int)(height + 4), (int)z)] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)6, (int)(height + 4), (int)z)] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)7, (int)(height + 4), (int)z)] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)8, (int)(height + 2), (int)z)] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)8, (int)(height + 3), (int)z)] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)8, (int)(height + 4), (int)z)] = rail;
                }
            }
            if (info.getZmax().railDungeon != null) {
                for (z = 0; z < 5; ++z) {
                    primer.field_177860_a[Tools.calcIndex((int)6, (int)(height + 1), (int)(15 - z))] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)6, (int)(height + 2), (int)(15 - z))] = airChar;
                    primer.field_177860_a[Tools.calcIndex((int)6, (int)(height + 3), (int)(15 - z))] = airChar;
                    primer.field_177860_a[Tools.calcIndex((int)7, (int)(height + 1), (int)(15 - z))] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)7, (int)(height + 2), (int)(15 - z))] = airChar;
                    primer.field_177860_a[Tools.calcIndex((int)7, (int)(height + 3), (int)(15 - z))] = airChar;
                }
                for (z = 0; z < 4; ++z) {
                    primer.field_177860_a[Tools.calcIndex((int)5, (int)(height + 2), (int)(15 - z))] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)5, (int)(height + 3), (int)(15 - z))] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)5, (int)(height + 4), (int)(15 - z))] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)6, (int)(height + 4), (int)(15 - z))] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)7, (int)(height + 4), (int)(15 - z))] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)8, (int)(height + 2), (int)(15 - z))] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)8, (int)(height + 3), (int)(15 - z))] = rail;
                    primer.field_177860_a[Tools.calcIndex((int)8, (int)(height + 4), (int)(15 - z))] = rail;
                }
            }
        }
        if (railInfo.getRails() < 3) {
            switch (railInfo.getType()) {
                case NONE: {
                    break;
                }
                case STATION_SURFACE: 
                case STATION_EXTENSION_SURFACE: 
                case STATION_UNDERGROUND: 
                case STATION_EXTENSION_UNDERGROUND: 
                case HORIZONTAL: {
                    int index;
                    int x;
                    if (railInfo.getRails() == 1) {
                        for (x = 0; x < 16; ++x) {
                            index = x << 12 | 1280 + height + 1;
                            primer.field_177860_a[index] = rail;
                            index = x << 12 | 2304 + height + 1;
                            primer.field_177860_a[index] = rail;
                        }
                    } else {
                        for (x = 0; x < 16; ++x) {
                            index = x << 12 | 1792 + height + 1;
                            primer.field_177860_a[index] = rail;
                        }
                    }
                    break;
                }
                case GOING_DOWN_TWO_FROM_SURFACE: 
                case GOING_DOWN_FURTHER: 
                case GOING_DOWN_ONE_FROM_SURFACE: {
                    int y;
                    int index;
                    int x;
                    if (railInfo.getRails() == 1) {
                        for (x = 0; x < 16; ++x) {
                            for (y = height + 1; y < height + part.getSliceCount(); ++y) {
                                index = x << 12 | 1280 + y;
                                if (LostCitiesTerrainGenerator.getRailChars().contains(Character.valueOf(primer.field_177860_a[index]))) {
                                    primer.field_177860_a[index] = rail;
                                }
                                index = x << 12 | 2304 + y;
                                if (!LostCitiesTerrainGenerator.getRailChars().contains(Character.valueOf(primer.field_177860_a[index]))) continue;
                                primer.field_177860_a[index] = rail;
                            }
                        }
                    } else {
                        for (x = 0; x < 16; ++x) {
                            for (y = height + 1; y < height + part.getSliceCount(); ++y) {
                                index = x << 12 | 1792 + y;
                                if (!LostCitiesTerrainGenerator.getRailChars().contains(Character.valueOf(primer.field_177860_a[index]))) continue;
                                primer.field_177860_a[index] = rail;
                            }
                        }
                    }
                    break;
                }
                case THREE_SPLIT: {
                    break;
                }
                case VERTICAL: {
                    break;
                }
            }
        }
        if (needsStaircase) {
            part = AssetRegistries.PARTS.get("station_staircase");
            for (int i = railInfo.getLevel() + 1; i < info.cityLevel; ++i) {
                height = this.provider.profile.GROUNDLEVEL + i * 6;
                this.generatePart(primer, info, part, transform, 0, height, 0, false);
            }
            height = this.provider.profile.GROUNDLEVEL + info.cityLevel * 6;
            part = AssetRegistries.PARTS.get("station_staircase_surface");
            this.generatePart(primer, info, part, transform, 0, height, 0, false);
        }
    }

    private void generateStreetDecorations(ChunkPrimer primer, BuildingInfo info) {
        Direction stairDirection = info.getActualStairDirection();
        if (stairDirection != null) {
            Transform transform;
            BuildingPart stairs = info.stairType;
            int oy = info.getCityGroundLevel() + 1;
            switch (stairDirection) {
                case XMIN: {
                    transform = Transform.ROTATE_NONE;
                    break;
                }
                case XMAX: {
                    transform = Transform.ROTATE_180;
                    break;
                }
                case ZMIN: {
                    transform = Transform.ROTATE_90;
                    break;
                }
                case ZMAX: {
                    transform = Transform.ROTATE_270;
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot happen!");
                }
            }
            this.generatePart(primer, info, stairs, transform, 0, oy, 0, false);
        }
    }

    private Blob findBlob(List<Blob> blobs, int index) {
        for (Blob blob : blobs) {
            if (!blob.contains(index)) continue;
            return blob;
        }
        return null;
    }

    private void fixAfterExplosionNew(ChunkPrimer primer, BuildingInfo info, Random rand) {
        Blob blob;
        int start = info.getDamageArea().getLowestExplosionHeight();
        if (start == -1) {
            return;
        }
        int end = info.getDamageArea().getHighestExplosionHeight();
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index = x << 12 | (z << 8) + start;
                for (int y = start; y < end; ++y) {
                    Blob blob2;
                    char p = primer.field_177860_a[index];
                    if (p != airChar && p != liquidChar && (blob2 = this.findBlob(blobs, index)) == null) {
                        blob2 = new Blob(start, end + 6);
                        blob2.scan(info, primer, airChar, liquidChar, new BlockPos(x, y, z));
                        blobs.add(blob2);
                    }
                    ++index;
                }
            }
        }
        blobs.sort((o1, o2) -> {
            int y1 = o1.destroyOrMoveThis(this.provider) ? ((Blob)o1).lowestY : 1000;
            int y2 = o2.destroyOrMoveThis(this.provider) ? ((Blob)o2).lowestY : 1000;
            return y1 - y2;
        });
        Blob blocksToMove = new Blob(0, 256);
        Iterator iterator = blobs.iterator();
        while (iterator.hasNext() && (blob = (Blob)iterator.next()).destroyOrMoveThis(this.provider)) {
            if (rand.nextFloat() < this.provider.profile.DESTROY_OR_MOVE_CHANCE || blob.connectedBlocks.size() < this.provider.profile.DESTROY_SMALL_SECTIONS_SIZE || blob.connections < 5) {
                for (Integer index2 : blob.connectedBlocks) {
                    primer.field_177860_a[index2.intValue()] = (index2 & 0xFF) < this.waterLevel ? liquidChar : airChar;
                }
                continue;
            }
            blocksToMove.connectedBlocks.addAll(blob.connectedBlocks);
        }
        for (Integer index : blocksToMove.connectedBlocks) {
            Integer n;
            char c = primer.field_177860_a[index];
            primer.field_177860_a[index.intValue()] = (index & 0xFF) < this.waterLevel ? liquidChar : airChar;
            Integer index2 = index;
            Integer n2 = index = Integer.valueOf(index - 1);
            for (int y = index & 0xFF; y > 2 && (blocksToMove.contains(index) || primer.field_177860_a[index] == airChar || primer.field_177860_a[index] == liquidChar); --y) {
                n2 = index;
                n = index = Integer.valueOf(index - 1);
            }
            n2 = index;
            n = index = Integer.valueOf(index + 1);
            primer.field_177860_a[index.intValue()] = c;
        }
    }

    private void generateRubble(ChunkPrimer primer, int chunkX, int chunkZ, BuildingInfo info) {
        this.rubbleBuffer = this.rubbleNoise.func_151599_a(this.rubbleBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
        this.leavesBuffer = this.leavesNoise.func_151599_a(this.leavesBuffer, (double)(chunkX * 64), (double)(chunkZ * 64), 16, 16, 0.015625, 0.015625, 4.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int i;
                double vl;
                double vr = this.provider.profile.RUBBLE_DIRT_SCALE < 0.01f ? 0.0 : this.rubbleBuffer[x + z * 16] / (double)this.provider.profile.RUBBLE_DIRT_SCALE;
                double d = vl = this.provider.profile.RUBBLE_LEAVE_SCALE < 0.01f ? 0.0 : this.leavesBuffer[x + z * 16] / (double)this.provider.profile.RUBBLE_LEAVE_SCALE;
                if (!(vr > 0.5) && !(vl > 0.5)) continue;
                int height = this.getInterpolatedHeight(info, x, z);
                int index = x << 12 | (z << 8) + height;
                if (primer.field_177860_a[index - 1] != airChar && primer.field_177860_a[index - 1] != liquidChar) {
                    i = 0;
                    while ((double)i < vr) {
                        if (primer.field_177860_a[index] == airChar || primer.field_177860_a[index] == liquidChar) {
                            primer.field_177860_a[index] = baseChar;
                        }
                        ++index;
                        ++i;
                    }
                }
                if (primer.field_177860_a[index - 1] != baseChar) continue;
                i = 0;
                while ((double)i < vl) {
                    if (primer.field_177860_a[index] == airChar || primer.field_177860_a[index] == liquidChar) {
                        primer.field_177860_a[index++] = LostCitiesTerrainGenerator.getRandomLeaf();
                    }
                    ++i;
                }
            }
        }
    }

    private int getInterpolatedHeight(BuildingInfo info, int x, int z) {
        if (x < 8 && z < 8) {
            float h00 = info.getXmin().getZmin().getCityGroundLevelOutsideLower();
            float h10 = info.getZmin().getCityGroundLevelOutsideLower();
            float h01 = info.getXmin().getCityGroundLevelOutsideLower();
            float h11 = info.getCityGroundLevelOutsideLower();
            return this.bipolate(h00, h10, h01, h11, x + 8, z + 8);
        }
        if (x >= 8 && z < 8) {
            float h00 = info.getZmin().getCityGroundLevelOutsideLower();
            float h10 = info.getXmax().getZmin().getCityGroundLevelOutsideLower();
            float h01 = info.getCityGroundLevelOutsideLower();
            float h11 = info.getXmax().getCityGroundLevelOutsideLower();
            return this.bipolate(h00, h10, h01, h11, x - 8, z + 8);
        }
        if (x < 8 && z >= 8) {
            float h00 = info.getXmin().getCityGroundLevelOutsideLower();
            float h10 = info.getCityGroundLevelOutsideLower();
            float h01 = info.getXmin().getZmax().getCityGroundLevelOutsideLower();
            float h11 = info.getZmax().getCityGroundLevelOutsideLower();
            return this.bipolate(h00, h10, h01, h11, x + 8, z - 8);
        }
        float h00 = info.getCityGroundLevelOutsideLower();
        float h10 = info.getXmax().getCityGroundLevelOutsideLower();
        float h01 = info.getZmax().getCityGroundLevelOutsideLower();
        float h11 = info.getXmax().getZmax().getCityGroundLevelOutsideLower();
        return this.bipolate(h00, h10, h01, h11, x - 8, z - 8);
    }

    private int bipolate(float h00, float h10, float h01, float h11, int dx, int dz) {
        float factor = (15.0f - (float)dx) / 15.0f;
        float h0 = h00 + (h10 - h00) * factor;
        float h1 = h01 + (h11 - h01) * factor;
        float h = h0 + (h1 - h0) * (15.0f - (float)dz) / 15.0f;
        return (int)h;
    }

    private void generateRuins(ChunkPrimer primer, BuildingInfo info) {
        if (info.ruinHeight < 0.0f) {
            return;
        }
        int chunkX = info.chunkX;
        int chunkZ = info.chunkZ;
        double d0 = 0.03125;
        this.ruinBuffer = this.ruinNoise.func_151599_a(this.ruinBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        boolean doLeaves = this.provider.profile.RUBBLELAYER;
        if (doLeaves) {
            this.leavesBuffer = this.leavesNoise.func_151599_a(this.leavesBuffer, (double)(chunkX * 64), (double)(chunkZ * 64), 16, 16, 0.015625, 0.015625, 4.0);
        }
        int baseheight = (int)((float)(info.getCityGroundLevel() + 1) + info.ruinHeight * (float)info.getNumFloors() * 6.0f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double v = this.ruinBuffer[x + z * 16];
                int height = baseheight + (int)v;
                int index = x << 12 | (z << 8) + height;
                height = info.getMaxHeight() + 10 - height;
                int vl = 0;
                if (doLeaves) {
                    vl = (int)(this.provider.profile.RUBBLE_LEAVE_SCALE < 0.01f ? 0.0 : this.leavesBuffer[x + z * 16] / (double)this.provider.profile.RUBBLE_LEAVE_SCALE);
                }
                while (height > 0) {
                    Character damage = info.getCompiledPalette().canBeDamagedToIronBars(Character.valueOf(primer.field_177860_a[index]));
                    if ((damage != null || primer.field_177860_a[index - 1] == ironbarsChar) && primer.field_177860_a[index - 1] != airChar && primer.field_177860_a[index - 1] != liquidChar && this.provider.rand.nextFloat() < 0.2f) {
                        primer.field_177860_a[index++] = ironbarsChar;
                    } else if (vl > 0) {
                        while (primer.field_177860_a[index - 1] == airChar || primer.field_177860_a[index - 1] == liquidChar) {
                            --index;
                            ++height;
                        }
                        primer.field_177860_a[index++] = LostCitiesTerrainGenerator.getRandomLeaf();
                        --vl;
                    } else {
                        primer.field_177860_a[index++] = airChar;
                    }
                    --height;
                }
            }
        }
    }

    private void generateStreet(ChunkPrimer primer, BuildingInfo info, Random rand) {
        int z;
        int x;
        boolean canDoParks;
        for (int x2 = 0; x2 < 16; ++x2) {
            for (int z2 = 0; z2 < 16; ++z2) {
                int index = x2 << 12 | z2 << 8;
                PrimerTools.setBlockStateRange(primer, index + this.provider.profile.BEDROCK_LAYER, index + this.groundLevel - 5, baseChar);
            }
        }
        boolean xRail = info.hasXCorridor();
        boolean zRail = info.hasZCorridor();
        for (int x3 = 0; x3 < 16; ++x3) {
            for (int z3 = 0; z3 < 16; ++z3) {
                int index = x3 << 12 | z3 << 8;
                PrimerTools.setBlockStateRange(primer, index + this.groundLevel - 5, index + info.getCityGroundLevel(), baseChar);
            }
        }
        if (xRail || zRail) {
            this.generateCorridors(primer, info, xRail, zRail);
        }
        Railway.RailChunkInfo railInfo = info.getRailInfo();
        boolean bl = canDoParks = info.getHighwayXLevel() != info.cityLevel && info.getHighwayZLevel() != info.cityLevel && railInfo.getType() != RailChunkType.STATION_SURFACE && (railInfo.getType() != RailChunkType.STATION_EXTENSION_SURFACE || railInfo.getLevel() < info.cityLevel);
        if (canDoParks) {
            int height = info.getCityGroundLevel();
            BuildingInfo.StreetType streetType = info.streetType;
            boolean elevated = info.isElevatedParkSection();
            if (elevated) {
                Character elevationBlock = info.getCityStyle().getParkElevationBlock();
                char elevation = info.getCompiledPalette().get(elevationBlock.charValue()).charValue();
                streetType = BuildingInfo.StreetType.PARK;
                for (int x4 = 0; x4 < 16; ++x4) {
                    for (int z4 = 0; z4 < 16; ++z4) {
                        primer.field_177860_a[x4 << 12 | (z4 << 8) + height] = elevation;
                    }
                }
                ++height;
            }
            switch (streetType) {
                case NORMAL: {
                    this.generateNormalStreetSection(primer, info, height);
                    break;
                }
                case FULL: {
                    this.generateFullStreetSection(primer, height);
                    break;
                }
                case PARK: {
                    this.generateParkSection(primer, info, height, elevated);
                }
            }
            ++height;
            if (streetType == BuildingInfo.StreetType.PARK || info.fountainType != null) {
                BuildingPart part = streetType == BuildingInfo.StreetType.PARK ? info.parkType : info.fountainType;
                this.generatePart(primer, info, part, Transform.ROTATE_NONE, 0, height, 0, false);
            }
            this.generateRandomVegetation(primer, info, rand, height);
            this.generateFrontPart(primer, info, height, info.getXmin(), Transform.ROTATE_NONE);
            this.generateFrontPart(primer, info, height, info.getZmin(), Transform.ROTATE_90);
            this.generateFrontPart(primer, info, height, info.getXmax(), Transform.ROTATE_180);
            this.generateFrontPart(primer, info, height, info.getZmax(), Transform.ROTATE_270);
        }
        if (this.doBorder(info, Direction.XMIN)) {
            x = 0;
            for (int z5 = 0; z5 < 16; ++z5) {
                this.generateBorder(primer, info, canDoParks, x, z5);
            }
        }
        if (this.doBorder(info, Direction.XMAX)) {
            x = 15;
            for (int z6 = 0; z6 < 16; ++z6) {
                this.generateBorder(primer, info, canDoParks, x, z6);
            }
        }
        if (this.doBorder(info, Direction.ZMIN)) {
            z = 0;
            for (int x5 = 0; x5 < 16; ++x5) {
                this.generateBorder(primer, info, canDoParks, x5, z);
            }
        }
        if (this.doBorder(info, Direction.ZMAX)) {
            z = 15;
            for (int x6 = 0; x6 < 16; ++x6) {
                this.generateBorder(primer, info, canDoParks, x6, z);
            }
        }
    }

    private void generateFrontPart(ChunkPrimer primer, BuildingInfo info, int height, BuildingInfo adj, Transform rot) {
        if (info.hasFrontPartFrom(adj)) {
            this.generatePart(primer, adj, adj.frontType, rot, 0, height, 0, false);
        }
    }

    private void generateCorridors(ChunkPrimer primer, BuildingInfo info, boolean xRail, boolean zRail) {
        IBlockState railx = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
        char railxC = (char)Block.field_176229_d.func_148747_b((Object)railx);
        IBlockState railz = Blocks.field_150448_aq.func_176223_P();
        char railzC = (char)Block.field_176229_d.func_148747_b((Object)railz);
        Character corridorRoofBlock = info.getCityStyle().getCorridorRoofBlock();
        Character corridorGlassBlock = info.getCityStyle().getCorridorGlassBlock();
        CompiledPalette palette = info.getCompiledPalette();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index = x << 12 | z << 8;
                if (xRail && z >= 7 && z <= 10 || zRail && x >= 7 && x <= 10) {
                    int height = this.groundLevel - 5;
                    char b = xRail && z == 10 ? railxC : (zRail && x == 10 ? railzC : airChar);
                    primer.field_177860_a[index + height++] = b;
                    primer.field_177860_a[index + height++] = airChar;
                    primer.field_177860_a[index + height++] = airChar;
                    if (xRail && x == 7 && (z == 8 || z == 9) || zRail && z == 7 && (x == 8 || x == 9)) {
                        char glass = palette.get(corridorGlassBlock.charValue()).charValue();
                        primer.field_177860_a[index + height++] = glass;
                        info.addGenericTodo(new BlockPos(x, height, z));
                        primer.field_177860_a[index + height++] = glowstoneChar;
                        continue;
                    }
                    char roof = palette.get(corridorRoofBlock.charValue()).charValue();
                    primer.field_177860_a[index + height++] = roof;
                    primer.field_177860_a[index + height++] = roof;
                    continue;
                }
                PrimerTools.setBlockStateRange(primer, index + this.groundLevel - 5, index + info.getCityGroundLevel(), baseChar);
            }
        }
    }

    private void generateRandomVegetation(ChunkPrimer primer, BuildingInfo info, Random rand, int height) {
        int x;
        int z;
        int cnt;
        float v;
        int index;
        int z2;
        int x2;
        if (info.getXmin().hasBuilding) {
            for (x2 = 0; x2 < this.provider.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; ++x2) {
                for (z2 = 0; z2 < 16; ++z2) {
                    index = x2 << 12 | (z2 << 8) + height;
                    while (primer.field_177860_a[index - 1] == airChar) {
                        --index;
                    }
                    v = Math.min(0.8f, this.provider.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(this.provider.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS + 1 - x2));
                    for (cnt = 0; rand.nextFloat() < v && cnt < 30; ++cnt) {
                        primer.field_177860_a[index++] = LostCitiesTerrainGenerator.getRandomLeaf();
                    }
                }
            }
        }
        if (info.getXmax().hasBuilding) {
            for (x2 = 15 - this.provider.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; x2 < 15; ++x2) {
                for (z2 = 0; z2 < 16; ++z2) {
                    index = x2 << 12 | (z2 << 8) + height;
                    while (primer.field_177860_a[index - 1] == airChar) {
                        --index;
                    }
                    v = Math.min(0.8f, this.provider.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(x2 - 14 + this.provider.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS));
                    for (cnt = 0; rand.nextFloat() < v && cnt < 30; ++cnt) {
                        primer.field_177860_a[index++] = LostCitiesTerrainGenerator.getRandomLeaf();
                    }
                }
            }
        }
        if (info.getZmin().hasBuilding) {
            for (z = 0; z < this.provider.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; ++z) {
                for (x = 0; x < 16; ++x) {
                    index = x << 12 | (z << 8) + height;
                    while (primer.field_177860_a[index - 1] == airChar) {
                        --index;
                    }
                    v = Math.min(0.8f, this.provider.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(this.provider.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS + 1 - z));
                    for (cnt = 0; rand.nextFloat() < v && cnt < 30; ++cnt) {
                        primer.field_177860_a[index++] = LostCitiesTerrainGenerator.getRandomLeaf();
                    }
                }
            }
        }
        if (info.getZmax().hasBuilding) {
            for (z = 15 - this.provider.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; z < 15; ++z) {
                for (x = 0; x < 16; ++x) {
                    index = x << 12 | (z << 8) + height;
                    while (primer.field_177860_a[index - 1] == airChar) {
                        --index;
                    }
                    v = this.provider.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(z - 14 + this.provider.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS);
                    for (cnt = 0; rand.nextFloat() < v && cnt < 30; ++cnt) {
                        primer.field_177860_a[index++] = LostCitiesTerrainGenerator.getRandomLeaf();
                    }
                }
            }
        }
    }

    private void generateParkSection(ChunkPrimer primer, BuildingInfo info, int height, boolean elevated) {
        boolean el00 = info.getXmin().getZmin().isElevatedParkSection();
        boolean el10 = info.getZmin().isElevatedParkSection();
        boolean el20 = info.getXmax().getZmin().isElevatedParkSection();
        boolean el01 = info.getXmin().isElevatedParkSection();
        boolean el21 = info.getXmax().isElevatedParkSection();
        boolean el02 = info.getXmin().getZmax().isElevatedParkSection();
        boolean el12 = info.getZmax().isElevatedParkSection();
        boolean el22 = info.getXmax().getZmax().isElevatedParkSection();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                char b;
                if (x == 0 || x == 15 || z == 0 || z == 15) {
                    b = this.street.charValue();
                    if (elevated) {
                        if (x == 0 && z == 0) {
                            if (el01 && el00 && el10) {
                                b = grassChar;
                            }
                        } else if (x == 15 && z == 0) {
                            if (el21 && el20 && el10) {
                                b = grassChar;
                            }
                        } else if (x == 0 && z == 15) {
                            if (el01 && el02 && el12) {
                                b = grassChar;
                            }
                        } else if (x == 15 && z == 15) {
                            if (el12 && el22 && el21) {
                                b = grassChar;
                            }
                        } else if (x == 0) {
                            if (el01) {
                                b = grassChar;
                            }
                        } else if (x == 15) {
                            if (el21) {
                                b = grassChar;
                            }
                        } else if (z == 0) {
                            if (el10) {
                                b = grassChar;
                            }
                        } else if (z == 15 && el12) {
                            b = grassChar;
                        }
                    }
                } else {
                    b = grassChar;
                }
                primer.field_177860_a[x << 12 | (z << 8) + height] = b;
            }
        }
    }

    private void generateFullStreetSection(ChunkPrimer primer, int height) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                char b = this.isSide(x, z) ? this.street.charValue() : this.street2.charValue();
                primer.field_177860_a[x << 12 | (z << 8) + height] = b;
            }
        }
    }

    private void generateNormalStreetSection(ChunkPrimer primer, BuildingInfo info, int height) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                char b = this.streetBase.charValue();
                if (this.isStreetBorder(x, z)) {
                    if (x <= this.streetBorder && z > this.streetBorder && z < 15 - this.streetBorder && (BuildingInfo.hasRoadConnection(info, info.getXmin()) || info.getXmin().hasXBridge(this.provider) != null)) {
                        b = this.street.charValue();
                    } else if (x >= 15 - this.streetBorder && z > this.streetBorder && z < 15 - this.streetBorder && (BuildingInfo.hasRoadConnection(info, info.getXmax()) || info.getXmax().hasXBridge(this.provider) != null)) {
                        b = this.street.charValue();
                    } else if (z <= this.streetBorder && x > this.streetBorder && x < 15 - this.streetBorder && (BuildingInfo.hasRoadConnection(info, info.getZmin()) || info.getZmin().hasZBridge(this.provider) != null)) {
                        b = this.street.charValue();
                    } else if (z >= 15 - this.streetBorder && x > this.streetBorder && x < 15 - this.streetBorder && (BuildingInfo.hasRoadConnection(info, info.getZmax()) || info.getZmax().hasZBridge(this.provider) != null)) {
                        b = this.street.charValue();
                    }
                } else {
                    b = this.street.charValue();
                }
                primer.field_177860_a[x << 12 | (z << 8) + height] = b;
            }
        }
    }

    private void generateBorder(ChunkPrimer primer, BuildingInfo info, boolean canDoParks, int x, int z) {
        Character borderBlock = info.getCityStyle().getBorderBlock();
        Character wallBlock = info.getCityStyle().getWallBlock();
        char wall = info.getCompiledPalette().get(wallBlock.charValue()).charValue();
        int index = x << 12 | z << 8;
        int y = this.groundLevel - 6;
        this.setBlocksFromPalette(primer, index + y, index + info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
        if (canDoParks) {
            primer.field_177860_a[index + info.getCityGroundLevel() + 1] = !this.borderNeedsConnectionToAdjacentChunk(info, x, z) ? wall : airChar;
        }
    }

    private boolean borderNeedsConnectionToAdjacentChunk(BuildingInfo info, int x, int z) {
        for (Direction direction : Direction.VALUES) {
            if (!direction.atSide(x, z)) continue;
            BuildingInfo adjacent = direction.get(info);
            if (adjacent.getActualStairDirection() == direction.getOpposite()) {
                BuildingPart stairType = adjacent.stairType;
                Integer z1 = stairType.getMetaInteger("z1");
                Integer z2 = stairType.getMetaInteger("z2");
                Transform transform = direction.getOpposite().getRotation();
                int xx1 = transform.rotateX(15, z1);
                int zz1 = transform.rotateZ(15, z1);
                int xx2 = transform.rotateX(15, z2);
                int zz2 = transform.rotateZ(15, z2);
                if (x >= Math.min(xx1, xx2) && x <= Math.max(xx1, xx2) && z >= Math.min(zz1, zz2) && z <= Math.max(zz1, zz2)) {
                    return true;
                }
            }
            if (adjacent.hasBridge(this.provider, direction.getOrientation()) == null) continue;
            return true;
        }
        return false;
    }

    private int generatePart(ChunkPrimer primer, BuildingInfo info, BuildingPart part, Transform transform, int ox, int oy, int oz, boolean airWaterLevel) {
        CompiledPalette compiledPalette = info.getCompiledPalette();
        boolean combinedWithPart = false;
        for (int x = 0; x < part.getXSize(); ++x) {
            for (int z = 0; z < part.getZSize(); ++z) {
                char[] vs = part.getVSlice(x, z);
                if (vs == null) continue;
                int rx = ox + transform.rotateX(x, z);
                int rz = oz + transform.rotateZ(x, z);
                int index = rx << 12 | (rz << 8) + oy;
                int len = vs.length;
                for (int y = 0; y < len; ++y) {
                    IBlockState bs;
                    char c = vs[y];
                    Character b = compiledPalette.get(c);
                    if (b == null) {
                        if (!combinedWithPart) {
                            Palette localPalette = part.getLocalPalette();
                            combinedWithPart = true;
                            if (localPalette != null) {
                                compiledPalette = new CompiledPalette(compiledPalette, localPalette);
                                b = compiledPalette.get(c);
                            }
                        }
                        if (b == null) {
                            throw new RuntimeException("Could not find entry '" + c + "' in the palette for part '" + part.getName() + "'!");
                        }
                    }
                    if (transform != Transform.ROTATE_NONE) {
                        if (LostCitiesTerrainGenerator.getRotatableChars().contains(b)) {
                            bs = (IBlockState)Block.field_176229_d.func_148745_a((int)b.charValue());
                            bs = bs.func_185907_a(transform.getMcRotation());
                            b = Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)bs));
                        } else if (LostCitiesTerrainGenerator.getRailChars().contains(b)) {
                            PropertyEnum shapeProperty;
                            bs = (IBlockState)Block.field_176229_d.func_148745_a((int)b.charValue());
                            if (bs.func_177230_c() == Blocks.field_150448_aq) {
                                shapeProperty = BlockRail.field_176565_b;
                            } else if (bs.func_177230_c() == Blocks.field_150318_D) {
                                shapeProperty = BlockRailPowered.field_176568_b;
                            } else {
                                throw new RuntimeException("Error with rail!");
                            }
                            BlockRailBase.EnumRailDirection shape = (BlockRailBase.EnumRailDirection)bs.func_177229_b((IProperty)shapeProperty);
                            bs = bs.func_177226_a((IProperty)shapeProperty, (Comparable)transform.transform(shape));
                            b = Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)bs));
                        }
                    }
                    if (b.charValue() != airChar) {
                        if (b.charValue() == hardAirChar) {
                            b = airWaterLevel ? Character.valueOf(oy + y < this.waterLevel ? liquidChar : airChar) : Character.valueOf(airChar);
                        } else if (LostCitiesTerrainGenerator.getCharactersNeedingTodo().contains(b)) {
                            if (b.charValue() == torchChar) {
                                if (this.provider.profile.GENERATE_LIGHTING) {
                                    info.addTorchTodo(index);
                                } else {
                                    b = Character.valueOf(airChar);
                                }
                            } else if (b.charValue() == spawnerChar) {
                                if (this.provider.profile.GENERATE_SPAWNERS && !info.noLoot) {
                                    String mobid = part.getMobID(info, x, y, z);
                                    info.getTodoChunk(rx, rz).addSpawnerTodo(new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz), new BuildingInfo.ConditionTodo(mobid, part.getName(), info));
                                } else {
                                    b = Character.valueOf(airChar);
                                }
                            } else if (b.charValue() == chestChar) {
                                if (!info.noLoot) {
                                    String lootTable = part.getLootTable(info, x, y, z);
                                    info.getTodoChunk(rx, rz).addChestTodo(new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz), new BuildingInfo.ConditionTodo(lootTable, part.getName(), info));
                                }
                            } else if (b.charValue() == glowstoneChar) {
                                info.getTodoChunk(rx, rz).addGenericTodo(new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz));
                            } else {
                                bs = (IBlockState)Block.field_176229_d.func_148745_a((int)b.charValue());
                                if (bs.func_177230_c() == Blocks.field_150345_g) {
                                    if (this.provider.profile.AVOID_FOLIAGE) {
                                        b = Character.valueOf(airChar);
                                    } else {
                                        info.getTodoChunk(rx, rz).addSaplingTodo(new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz));
                                    }
                                }
                            }
                        }
                        primer.field_177860_a[index] = b.charValue();
                    }
                    ++index;
                }
            }
        }
        return oy + part.getSliceCount();
    }

    private void generateDebris(ChunkPrimer primer, Random rand, BuildingInfo info) {
        this.generateDebrisFromChunk(primer, rand, info.getXmin(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) / 16.0f));
        this.generateDebrisFromChunk(primer, rand, info.getXmax(), (xx, zz) -> Float.valueOf((float)xx.intValue() / 16.0f));
        this.generateDebrisFromChunk(primer, rand, info.getZmin(), (xx, zz) -> Float.valueOf((15.0f - (float)zz.intValue()) / 16.0f));
        this.generateDebrisFromChunk(primer, rand, info.getZmax(), (xx, zz) -> Float.valueOf((float)zz.intValue() / 16.0f));
        this.generateDebrisFromChunk(primer, rand, info.getXmin().getZmin(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) * (15.0f - (float)zz.intValue()) / 256.0f));
        this.generateDebrisFromChunk(primer, rand, info.getXmax().getZmax(), (xx, zz) -> Float.valueOf((float)(xx * zz) / 256.0f));
        this.generateDebrisFromChunk(primer, rand, info.getXmin().getZmax(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) * (float)zz.intValue() / 256.0f));
        this.generateDebrisFromChunk(primer, rand, info.getXmax().getZmin(), (xx, zz) -> Float.valueOf((float)xx.intValue() * (15.0f - (float)zz.intValue()) / 256.0f));
    }

    private void generateDebrisFromChunk(ChunkPrimer primer, Random rand, BuildingInfo adjacentInfo, BiFunction<Integer, Integer, Float> locationFactor) {
        if (adjacentInfo.hasBuilding) {
            char filler = adjacentInfo.getCompiledPalette().get(adjacentInfo.getBuilding().getFillerBlock()).charValue();
            float damageFactor = adjacentInfo.getDamageArea().getDamageFactor();
            if (damageFactor > 0.5f) {
                int blocks = (1 + adjacentInfo.getNumFloors()) * 1000;
                float damage = Math.max(1.0f, damageFactor * 0.7f);
                int destroyedBlocks = (int)((float)blocks * damage);
                destroyedBlocks /= this.provider.profile.DEBRIS_TO_NEARBYCHUNK_FACTOR;
                int h = adjacentInfo.getMaxHeight() + 10;
                for (int i = 0; i < destroyedBlocks; ++i) {
                    Character b;
                    int x = rand.nextInt(16);
                    int z = rand.nextInt(16);
                    if (!(rand.nextFloat() < locationFactor.apply(x, z).floatValue())) continue;
                    int index = x << 12 | (z << 8) + h;
                    while (primer.field_177860_a[index] == airChar || primer.field_177860_a[index] == liquidChar) {
                        --index;
                    }
                    ++index;
                    switch (rand.nextInt(5)) {
                        case 0: {
                            b = Character.valueOf(ironbarsChar);
                            break;
                        }
                        default: {
                            b = Character.valueOf(filler);
                        }
                    }
                    primer.field_177860_a[index] = b.charValue();
                }
            }
        }
    }

    private boolean doBorder(BuildingInfo info, Direction direction) {
        BuildingInfo adjacent = direction.get(info);
        if (this.isHigherThenNearbyStreetChunk(info, adjacent)) {
            return true;
        }
        return !adjacent.isCity && adjacent.cityLevel <= info.cityLevel;
    }

    private boolean isHigherThenNearbyStreetChunk(BuildingInfo info, BuildingInfo adjacent) {
        if (!adjacent.isCity) {
            return false;
        }
        if (adjacent.hasBuilding) {
            return adjacent.cityLevel + adjacent.getNumFloors() < info.cityLevel;
        }
        return adjacent.cityLevel < info.cityLevel;
    }

    private void setBlocksFromPalette(ChunkPrimer primer, int start, int end, CompiledPalette palette, char character) {
        if (palette.isSimple(character)) {
            char b = palette.get(character).charValue();
            PrimerTools.setBlockStateRangeSafe(primer, start, end, b);
        } else {
            while (start < end) {
                primer.field_177860_a[start++] = palette.get(character).charValue();
            }
        }
    }

    private void generateBuilding(ChunkPrimer primer, BuildingInfo info) {
        int z;
        int lowestLevel = info.getCityGroundLevel() - info.floorsBelowGround * 6;
        Character borderBlock = info.getCityStyle().getBorderBlock();
        CompiledPalette palette = info.getCompiledPalette();
        char fillerBlock = info.getBuilding().getFillerBlock();
        for (int x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                char filler;
                int index = x << 12 | z << 8;
                if (this.isSide(x, z)) {
                    PrimerTools.setBlockStateRange(primer, index + this.provider.profile.BEDROCK_LAYER, index + lowestLevel - 10, baseChar);
                    for (int y = lowestLevel - 10; y < lowestLevel; ++y) {
                        primer.field_177860_a[index + y] = palette.get(borderBlock.charValue()).charValue();
                    }
                } else {
                    PrimerTools.setBlockStateRange(primer, index + this.provider.profile.BEDROCK_LAYER, index + lowestLevel, baseChar);
                }
                if (primer.field_177860_a[index + lowestLevel] != airChar) continue;
                primer.field_177860_a[index + lowestLevel] = filler = palette.get(fillerBlock).charValue();
            }
        }
        int height = lowestLevel;
        for (int f = -info.floorsBelowGround; f <= info.getNumFloors(); ++f) {
            boolean isTop;
            BuildingPart part = info.getFloor(f);
            this.generatePart(primer, info, part, Transform.ROTATE_NONE, 0, height, 0, false);
            part = info.getFloorPart2(f);
            if (part != null) {
                this.generatePart(primer, info, part, Transform.ROTATE_NONE, 0, height, 0, false);
            }
            boolean bl = isTop = f == info.getNumFloors();
            if (!isTop) {
                this.generateDoors(primer, info, height + 1, f);
            }
            height += 6;
        }
        if (info.floorsBelowGround > 0) {
            for (int x = 0; x < 16; ++x) {
                int index = x << 12 | 0;
                this.setBlocksFromPalette(primer, index + lowestLevel, index + Math.min(info.getCityGroundLevel(), info.getZmin().getCityGroundLevel()) + 1, palette, fillerBlock);
                index = x << 12 | 0xF00;
                this.setBlocksFromPalette(primer, index + lowestLevel, index + Math.min(info.getCityGroundLevel(), info.getZmax().getCityGroundLevel()) + 1, palette, fillerBlock);
            }
            for (z = 1; z < 15; ++z) {
                int index = 0 | z << 8;
                this.setBlocksFromPalette(primer, index + lowestLevel, index + Math.min(info.getCityGroundLevel(), info.getXmin().getCityGroundLevel()) + 1, palette, fillerBlock);
                index = 0xF000 | z << 8;
                this.setBlocksFromPalette(primer, index + lowestLevel, index + Math.min(info.getCityGroundLevel(), info.getXmax().getCityGroundLevel()) + 1, palette, fillerBlock);
            }
        }
        if (info.floorsBelowGround >= 1) {
            this.generateCorridorConnections(primer, info);
        }
    }

    private char getDoor(Block door, boolean upper, boolean left, EnumFacing facing) {
        IBlockState bs = door.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)(upper ? BlockDoor.EnumDoorHalf.UPPER : BlockDoor.EnumDoorHalf.LOWER)).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(left ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT)).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing);
        return (char)Block.field_176229_d.func_148747_b((Object)bs);
    }

    private void generateDoors(ChunkPrimer primer, BuildingInfo info, int height, int f) {
        int z;
        int index;
        int x;
        char filler = info.getCompiledPalette().get(info.getBuilding().getFillerBlock()).charValue();
        --height;
        if (info.hasConnectionAtX(f + info.floorsBelowGround)) {
            x = 0;
            if (this.hasConnectionWithBuilding(f, info, info.getXmin())) {
                index = x << 12 | 0x600;
                PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
                index = x << 12 | 0x900;
                PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
                index = x << 12 | 0x700;
                primer.field_177860_a[index + height] = filler;
                primer.field_177860_a[index + height + 1] = airChar;
                primer.field_177860_a[index + height + 2] = airChar;
                primer.field_177860_a[index + height + 3] = filler;
                index = x << 12 | 0x800;
                primer.field_177860_a[index + height] = filler;
                primer.field_177860_a[index + height + 1] = airChar;
                primer.field_177860_a[index + height + 2] = airChar;
                primer.field_177860_a[index + height + 3] = filler;
            } else if (this.hasConnectionToTopOrOutside(f, info, info.getXmin())) {
                index = x << 12 | 0x600;
                PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
                index = x << 12 | 0x900;
                PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
                index = x << 12 | 0x700;
                primer.field_177860_a[index + height] = filler;
                primer.field_177860_a[index + height + 1] = this.getDoor(info.doorBlock, false, true, EnumFacing.EAST);
                primer.field_177860_a[index + height + 2] = this.getDoor(info.doorBlock, true, true, EnumFacing.EAST);
                primer.field_177860_a[index + height + 3] = filler;
                index = x << 12 | 0x800;
                primer.field_177860_a[index + height] = filler;
                primer.field_177860_a[index + height + 1] = this.getDoor(info.doorBlock, false, false, EnumFacing.EAST);
                primer.field_177860_a[index + height + 2] = this.getDoor(info.doorBlock, true, false, EnumFacing.EAST);
                primer.field_177860_a[index + height + 3] = filler;
            }
        }
        if (this.hasConnectionWithBuildingMax(f, info, info.getXmax(), Orientation.X)) {
            x = 15;
            index = x << 12 | 0x600;
            PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
            index = x << 12 | 0x900;
            PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
            index = x << 12 | 0x700;
            primer.field_177860_a[index + height] = filler;
            primer.field_177860_a[index + height + 1] = airChar;
            primer.field_177860_a[index + height + 2] = airChar;
            primer.field_177860_a[index + height + 3] = filler;
            index = x << 12 | 0x800;
            primer.field_177860_a[index + height] = filler;
            primer.field_177860_a[index + height + 1] = airChar;
            primer.field_177860_a[index + height + 2] = airChar;
            primer.field_177860_a[index + height + 3] = filler;
        } else if (this.hasConnectionToTopOrOutside(f, info, info.getXmax()) && info.getXmax().hasConnectionAtXFromStreet(f + info.getXmax().floorsBelowGround)) {
            x = 15;
            index = x << 12 | 0x600;
            PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
            index = x << 12 | 0x900;
            PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
            index = x << 12 | 0x700;
            primer.field_177860_a[index + height] = filler;
            primer.field_177860_a[index + height + 1] = this.getDoor(info.doorBlock, false, false, EnumFacing.WEST);
            primer.field_177860_a[index + height + 2] = this.getDoor(info.doorBlock, true, false, EnumFacing.WEST);
            primer.field_177860_a[index + height + 3] = filler;
            index = x << 12 | 0x800;
            primer.field_177860_a[index + height] = filler;
            primer.field_177860_a[index + height + 1] = this.getDoor(info.doorBlock, false, true, EnumFacing.WEST);
            primer.field_177860_a[index + height + 2] = this.getDoor(info.doorBlock, true, true, EnumFacing.WEST);
            primer.field_177860_a[index + height + 3] = filler;
        }
        if (info.hasConnectionAtZ(f + info.floorsBelowGround)) {
            z = 0;
            if (this.hasConnectionWithBuilding(f, info, info.getZmin())) {
                index = 0x6000 | z << 8;
                PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
                index = 0x9000 | z << 8;
                PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
                index = 0x7000 | z << 8;
                primer.field_177860_a[index + height] = filler;
                primer.field_177860_a[index + height + 1] = airChar;
                primer.field_177860_a[index + height + 2] = airChar;
                primer.field_177860_a[index + height + 3] = filler;
                index = 0x8000 | z << 8;
                primer.field_177860_a[index + height] = filler;
                primer.field_177860_a[index + height + 1] = airChar;
                primer.field_177860_a[index + height + 2] = airChar;
                primer.field_177860_a[index + height + 3] = filler;
            } else if (this.hasConnectionToTopOrOutside(f, info, info.getZmin())) {
                index = 0x6000 | z << 8;
                PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
                index = 0x9000 | z << 8;
                PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
                index = 0x7000 | z << 8;
                primer.field_177860_a[index + height] = filler;
                primer.field_177860_a[index + height + 1] = this.getDoor(info.doorBlock, false, true, EnumFacing.NORTH);
                primer.field_177860_a[index + height + 2] = this.getDoor(info.doorBlock, true, true, EnumFacing.NORTH);
                primer.field_177860_a[index + height + 3] = filler;
                index = 0x8000 | z << 8;
                primer.field_177860_a[index + height] = filler;
                primer.field_177860_a[index + height + 1] = this.getDoor(info.doorBlock, false, false, EnumFacing.NORTH);
                primer.field_177860_a[index + height + 2] = this.getDoor(info.doorBlock, true, false, EnumFacing.NORTH);
                primer.field_177860_a[index + height + 3] = filler;
            }
        }
        if (this.hasConnectionWithBuildingMax(f, info, info.getZmax(), Orientation.Z)) {
            z = 15;
            index = 0x6000 | z << 8;
            PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
            index = 0x9000 | z << 8;
            PrimerTools.setBlockStateRange(primer, index + height, index + height + 4, filler);
            index = 0x7000 | z << 8;
            primer.field_177860_a[index + height] = filler;
            primer.field_177860_a[index + height + 1] = airChar;
            primer.field_177860_a[index + height + 2] = airChar;
            primer.field_177860_a[index + height + 3] = filler;
            index = 0x8000 | z << 8;
            primer.field_177860_a[index + height] = filler;
            primer.field_177860_a[index + height + 1] = airChar;
            primer.field_177860_a[index + height + 2] = airChar;
            primer.field_177860_a[index + height + 3] = filler;
        } else if (this.hasConnectionToTopOrOutside(f, info, info.getZmax()) && info.getZmax().hasConnectionAtZFromStreet(f + info.getZmax().floorsBelowGround)) {
            z = 15;
            index = 0x6000 | z << 8;
            PrimerTools.setBlockStateRange(primer, index + height, index + height + 3, filler);
            index = 0x9000 | z << 8;
            PrimerTools.setBlockStateRange(primer, index + height, index + height + 3, filler);
            index = 0x7000 | z << 8;
            primer.field_177860_a[index + height] = filler;
            primer.field_177860_a[index + height + 1] = this.getDoor(info.doorBlock, false, false, EnumFacing.SOUTH);
            primer.field_177860_a[index + height + 2] = this.getDoor(info.doorBlock, true, false, EnumFacing.SOUTH);
            primer.field_177860_a[index + height + 3] = filler;
            index = 0x8000 | z << 8;
            primer.field_177860_a[index + height] = filler;
            primer.field_177860_a[index + height + 1] = this.getDoor(info.doorBlock, false, true, EnumFacing.SOUTH);
            primer.field_177860_a[index + height + 2] = this.getDoor(info.doorBlock, true, true, EnumFacing.SOUTH);
            primer.field_177860_a[index + height + 3] = filler;
        }
    }

    private void generateCorridorConnections(ChunkPrimer primer, BuildingInfo info) {
        int x;
        int z;
        int index;
        int z2;
        int x2;
        if (info.getXmin().hasXCorridor()) {
            x2 = 0;
            for (z2 = 7; z2 <= 10; ++z2) {
                index = x2 << 12 | z2 << 8;
                PrimerTools.setBlockStateRange(primer, index + this.groundLevel - 5, index + this.groundLevel - 2, airChar);
            }
        }
        if (info.getXmax().hasXCorridor()) {
            x2 = 15;
            for (z2 = 7; z2 <= 10; ++z2) {
                index = x2 << 12 | z2 << 8;
                PrimerTools.setBlockStateRange(primer, index + this.groundLevel - 5, index + this.groundLevel - 2, airChar);
            }
        }
        if (info.getZmin().hasXCorridor()) {
            z = 0;
            for (x = 7; x <= 10; ++x) {
                index = x << 12 | z << 8;
                PrimerTools.setBlockStateRange(primer, index + this.groundLevel - 5, index + this.groundLevel - 2, airChar);
            }
        }
        if (info.getZmax().hasXCorridor()) {
            z = 15;
            for (x = 7; x <= 10; ++x) {
                index = x << 12 | z << 8;
                PrimerTools.setBlockStateRange(primer, index + this.groundLevel - 5, index + this.groundLevel - 2, airChar);
            }
        }
    }

    private boolean hasConnectionWithBuildingMax(int localLevel, BuildingInfo info, BuildingInfo info2, Orientation x) {
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        int level = localAdjacent + info2.floorsBelowGround;
        return info2.hasBuilding && (localAdjacent >= 0 && localAdjacent < info2.getNumFloors() || localAdjacent < 0 && -localAdjacent <= info2.floorsBelowGround) && info2.hasConnectionAt(level, x);
    }

    private boolean hasConnectionToTopOrOutside(int localLevel, BuildingInfo info, BuildingInfo info2) {
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        return info2.isCity && !info2.hasBuilding && localLevel == 0 && localAdjacent == 0 || info2.hasBuilding && localAdjacent == info2.getNumFloors();
    }

    private boolean hasConnectionWithBuilding(int localLevel, BuildingInfo info, BuildingInfo info2) {
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        return info2.hasBuilding && (localAdjacent >= 0 && localAdjacent < info2.getNumFloors() || localAdjacent < 0 && -localAdjacent <= info2.floorsBelowGround);
    }

    private boolean isSide(int x, int z) {
        return x == 0 || x == 15 || z == 0 || z == 15;
    }

    private boolean isStreetBorder(int x, int z) {
        return x <= this.streetBorder || x >= 15 - this.streetBorder || z <= this.streetBorder || z >= 15 - this.streetBorder;
    }

    static {
        rotatableChars = null;
        railChars = null;
        glassChars = null;
        charactersNeedingTodo = null;
        randomLeafs = null;
    }

    private static class Blob {
        private final int starty;
        private final int endy;
        private final Set<Integer> connectedBlocks = new HashSet<Integer>();
        private final Map<Integer, Integer> blocksPerY = new HashMap<Integer, Integer>();
        private int connections = 0;
        private int lowestY;
        private int highestY;
        private float avgdamage;
        private int cntMindamage;

        public Blob(int starty, int endy) {
            this.starty = starty;
            this.endy = endy;
            this.lowestY = 256;
            this.highestY = 0;
        }

        public float getAvgdamage() {
            return this.avgdamage;
        }

        public int getCntMindamage() {
            return this.cntMindamage;
        }

        public boolean contains(int index) {
            return this.connectedBlocks.contains(index);
        }

        public int getLowestY() {
            return this.lowestY;
        }

        public int getHighestY() {
            return this.highestY;
        }

        public Set<Integer> cut(int y) {
            HashSet<Integer> toRemove = new HashSet<Integer>();
            for (Integer block : this.connectedBlocks) {
                if ((block & 0xFF) < y) continue;
                toRemove.add(block);
            }
            this.connectedBlocks.removeAll(toRemove);
            return toRemove;
        }

        public int needsSplitting() {
            float averageBlocksPerLevel = (float)this.connectedBlocks.size() / (float)(this.highestY - this.lowestY + 1);
            int connectionThresshold = (int)(averageBlocksPerLevel / 10.0f);
            if (connectionThresshold <= 0) {
                return -1;
            }
            int cuttingY = -1;
            int cuttingCount = 1000000;
            for (int y = this.lowestY; y <= this.highestY; ++y) {
                if (y < 3 || this.blocksPerY.get(y) > connectionThresshold) continue;
                if (this.blocksPerY.get(y) < cuttingCount) {
                    cuttingCount = this.blocksPerY.get(y);
                    cuttingY = y;
                    continue;
                }
                if (this.blocksPerY.get(y) <= cuttingCount * 4) continue;
                return cuttingY;
            }
            return -1;
        }

        public boolean destroyOrMoveThis(LostCityChunkGenerator provider) {
            return this.connections < 5 || (float)this.connections / (float)this.connectedBlocks.size() < provider.profile.DESTROY_LONE_BLOCKS_FACTOR;
        }

        private boolean isOutside(BuildingInfo info, int x, int y, int z) {
            if (x < 0) {
                if (y <= info.getXmin().getMaxHeight() + 3) {
                    ++this.connections;
                }
                return true;
            }
            if (x > 15) {
                if (y <= info.getXmax().getMaxHeight() + 3) {
                    ++this.connections;
                }
                return true;
            }
            if (z < 0) {
                if (y <= info.getZmin().getMaxHeight() + 3) {
                    ++this.connections;
                }
                return true;
            }
            if (z > 15) {
                if (y <= info.getZmax().getMaxHeight() + 3) {
                    ++this.connections;
                }
                return true;
            }
            if (y < this.starty) {
                this.connections += 5;
                return true;
            }
            return false;
        }

        public void scan(BuildingInfo info, ChunkPrimer primer, char air, char liquid, BlockPos pos) {
            DamageArea damageArea = info.getDamageArea();
            this.avgdamage = 0.0f;
            this.cntMindamage = 0;
            ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
            todo.add(pos);
            while (!todo.isEmpty()) {
                int z;
                int y;
                pos = (BlockPos)todo.poll();
                int x = pos.func_177958_n();
                int index = Tools.calcIndex(x, y = pos.func_177956_o(), z = pos.func_177952_p());
                if (this.connectedBlocks.contains(index) || this.isOutside(info, x, y, z) || primer.field_177860_a[index] == air || primer.field_177860_a[index] == liquid) continue;
                this.connectedBlocks.add(index);
                float damage = damageArea.getDamage(x, y, z);
                if (damage < 0.01f) {
                    ++this.cntMindamage;
                }
                this.avgdamage += damage;
                if (!this.blocksPerY.containsKey(y)) {
                    this.blocksPerY.put(y, 1);
                } else {
                    this.blocksPerY.put(y, this.blocksPerY.get(y) + 1);
                }
                if (y < this.lowestY) {
                    this.lowestY = y;
                }
                if (y > this.highestY) {
                    this.highestY = y;
                }
                todo.add(pos.func_177984_a());
                todo.add(pos.func_177977_b());
                todo.add(pos.func_177974_f());
                todo.add(pos.func_177976_e());
                todo.add(pos.func_177968_d());
                todo.add(pos.func_177978_c());
            }
            this.avgdamage /= (float)this.connectedBlocks.size();
        }
    }
}

