/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lostcities.api.IChunkPrimerFactory;
import mcjty.lostcities.api.ILostChunkGenerator;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.ChunkHeightmap;
import mcjty.lostcities.dimensions.world.LostCitiesTerrainGenerator;
import mcjty.lostcities.dimensions.world.LostGenCaves;
import mcjty.lostcities.dimensions.world.LostWorldType;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import mcjty.lostcities.dimensions.world.lost.cityassets.Condition;
import mcjty.lostcities.dimensions.world.lost.cityassets.ConditionContext;
import mcjty.lostcities.dimensions.world.lost.cityassets.WorldStyle;
import mcjty.lostcities.varia.ChunkCoord;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.EntityId;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;

public class LostCityChunkGenerator
implements IChunkGenerator,
ILostChunkGenerator {
    public LostCityProfile profile;
    public WorldStyle worldStyle;
    public Random rand;
    public long seed;
    public int dimensionId;
    public World worldObj;
    public WorldType worldType;
    public final LostCitiesTerrainGenerator terrainGenerator;
    private ChunkGeneratorSettings settings = null;
    private Biome[] biomesForGeneration;
    private MapGenBase caveGenerator;
    private Map<ChunkCoord, ChunkPrimer> cachedPrimers = new HashMap<ChunkCoord, ChunkPrimer>();
    private Map<ChunkCoord, ChunkHeightmap> cachedHeightmaps = new HashMap<ChunkCoord, ChunkHeightmap>();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private StructureOceanMonument oceanMonumentGenerator = new StructureOceanMonument();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavine();
    public IChunkPrimerFactory otherGenerator = null;
    private static final EntityId FIXER = new EntityId();

    public ChunkGeneratorSettings getSettings() {
        if (this.settings == null) {
            ChunkGeneratorSettings.Factory factory = new ChunkGeneratorSettings.Factory();
            this.settings = factory.func_177864_b();
        }
        return this.settings;
    }

    public LostCityChunkGenerator(World world, IChunkPrimerFactory otherGenerator) {
        this(world, world.func_72905_C());
        this.otherGenerator = otherGenerator;
    }

    public LostCityChunkGenerator(World world, long seed) {
        this.caveGenerator = new LostGenCaves(this);
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)this.oceanMonumentGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.dimensionId = world.field_73011_w.getDimension();
        this.profile = LostWorldType.getProfile(world);
        System.out.println("LostCityChunkGenerator.LostCityChunkGenerator: profile=" + this.profile.getName());
        this.worldStyle = AssetRegistries.WORLDSTYLES.get(this.profile.getWorldStyle());
        if (this.worldStyle == null) {
            throw new RuntimeException("Unknown worldstyle '" + this.profile.getWorldStyle() + "'!");
        }
        String generatorOptions = this.profile.GENERATOR_OPTIONS;
        if (generatorOptions != null && !generatorOptions.isEmpty()) {
            this.settings = ChunkGeneratorSettings.Factory.func_177865_a((String)generatorOptions).func_177864_b();
        }
        this.worldObj = world;
        this.worldType = world.func_72912_H().func_76067_t();
        this.seed = seed;
        this.rand = new Random((seed + 516L) * 314L);
        byte waterLevel = (byte)(this.profile.GROUNDLEVEL - this.profile.WATERLEVEL_OFFSET);
        world.func_181544_b((int)waterLevel);
        this.terrainGenerator = new LostCitiesTerrainGenerator(this);
        this.terrainGenerator.setup(world);
    }

    public ChunkPrimer generatePrimer(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        if (this.otherGenerator != null) {
            this.otherGenerator.fillChunk(chunkX, chunkZ, chunkprimer);
        } else {
            this.terrainGenerator.doCoreChunk(chunkX, chunkZ, chunkprimer);
        }
        return chunkprimer;
    }

    public ChunkHeightmap getHeightmap(int chunkX, int chunkZ) {
        ChunkCoord key = new ChunkCoord(this.worldObj.field_73011_w.getDimension(), chunkX, chunkZ);
        if (this.cachedHeightmaps.containsKey(key)) {
            return this.cachedHeightmaps.get(key);
        }
        if (this.cachedPrimers.containsKey(key)) {
            ChunkHeightmap heightmap = new ChunkHeightmap(this.cachedPrimers.get(key));
            this.cachedHeightmaps.put(key, heightmap);
            return heightmap;
        }
        ChunkPrimer primer = this.generatePrimer(chunkX, chunkZ);
        this.cachedPrimers.put(key, primer);
        ChunkHeightmap heightmap = new ChunkHeightmap(this.cachedPrimers.get(key));
        this.cachedHeightmaps.put(key, heightmap);
        return heightmap;
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer chunkprimer;
        LostCitiesTerrainGenerator.setupChars();
        boolean isCity = BuildingInfo.isCity(chunkX, chunkZ, this);
        if (isCity) {
            chunkprimer = new ChunkPrimer();
        } else {
            ChunkCoord key = new ChunkCoord(this.worldObj.field_73011_w.getDimension(), chunkX, chunkZ);
            if (this.cachedPrimers.containsKey(key)) {
                chunkprimer = this.cachedPrimers.get(key);
                this.cachedPrimers.remove(key);
            } else {
                chunkprimer = this.generatePrimer(chunkX, chunkZ);
            }
            if (!this.cachedHeightmaps.containsKey(key)) {
                this.cachedHeightmaps.put(key, new ChunkHeightmap(chunkprimer));
            }
        }
        this.terrainGenerator.generate(chunkX, chunkZ, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.terrainGenerator.replaceBlocksForBiome(chunkX, chunkZ, chunkprimer, this.biomesForGeneration);
        if (this.profile.GENERATE_CAVES) {
            this.caveGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (!(!this.profile.GENERATE_RAVINES || this.profile.PREVENT_LAKES_RAVINES_IN_CITIES && isCity)) {
            this.ravineGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.profile.GENERATE_MINESHAFTS) {
            this.mineshaftGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.profile.GENERATE_VILLAGES) {
            if (this.profile.PREVENT_VILLAGES_IN_CITIES) {
                if (!isCity) {
                    this.villageGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
                }
            } else {
                this.villageGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
            }
        }
        if (this.profile.GENERATE_STRONGHOLDS) {
            this.strongholdGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.profile.GENERATE_SCATTERED) {
            this.scatteredFeatureGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.profile.GENERATE_OCEANMONUMENTS) {
            this.oceanMonumentGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, chunkX, chunkZ);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateTrees(Random random, int chunkX, int chunkZ, World world, LostCityChunkGenerator provider) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, provider);
        for (BlockPos pos : info.getSaplingTodo()) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() != Blocks.field_150345_g) continue;
            ((BlockSapling)Blocks.field_150345_g).func_176476_e(world, pos, state, random);
        }
        info.clearSaplingTodo();
    }

    private void generateVines(Random random, int chunkX, int chunkZ, World world, LostCityChunkGenerator provider) {
        int x;
        int y;
        int z;
        int bottom;
        BuildingInfo adjacent;
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, provider);
        if (info.hasBuilding) {
            adjacent = info.getXmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < info.getMaxHeight(); ++y) {
                    if (!(random.nextFloat() < provider.profile.VINE_CHANCE)) continue;
                    this.createVineStrip(random, world, bottom, BlockVine.field_176280_O, new BlockPos(cx + 16, y, cz + z), new BlockPos(cx + 15, y, cz + z));
                }
            }
        }
        if (info.getXmax().hasBuilding) {
            adjacent = info.getXmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? info.getMaxHeight() : info.getCityGroundLevel() + 3);
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(random.nextFloat() < provider.profile.VINE_CHANCE)) continue;
                    this.createVineStrip(random, world, bottom, BlockVine.field_176278_M, new BlockPos(cx + 15, y, cz + z), new BlockPos(cx + 16, y, cz + z));
                }
            }
        }
        if (info.hasBuilding) {
            adjacent = info.getZmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < info.getMaxHeight(); ++y) {
                    if (!(random.nextFloat() < provider.profile.VINE_CHANCE)) continue;
                    this.createVineStrip(random, world, bottom, BlockVine.field_176273_b, new BlockPos(cx + x, y, cz + 16), new BlockPos(cx + x, y, cz + 15));
                }
            }
        }
        if (info.getZmax().hasBuilding) {
            adjacent = info.getZmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? info.getMaxHeight() : info.getCityGroundLevel() + 3);
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(random.nextFloat() < provider.profile.VINE_CHANCE)) continue;
                    this.createVineStrip(random, world, bottom, BlockVine.field_176279_N, new BlockPos(cx + x, y, cz + 15), new BlockPos(cx + x, y, cz + 16));
                }
            }
        }
    }

    private void createVineStrip(Random random, World world, int bottom, PropertyBool direction, BlockPos pos, BlockPos vineHolderPos) {
        if (world.func_175623_d(vineHolderPos)) {
            return;
        }
        if (!world.func_175623_d(pos)) {
            return;
        }
        world.func_175656_a(pos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)direction, (Comparable)Boolean.valueOf(true)));
        pos = pos.func_177977_b();
        while (pos.func_177956_o() >= bottom && random.nextFloat() < 0.8f) {
            if (!world.func_175623_d(pos)) {
                return;
            }
            world.func_175656_a(pos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)direction, (Comparable)Boolean.valueOf(true)));
            pos = pos.func_177977_b();
        }
    }

    public static String fixEntityId(String id) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", id);
        nbt = FIXER.func_188217_a(nbt);
        return nbt.func_74779_i("id");
    }

    private void generateLootSpawners(Random random, int chunkX, int chunkZ, World world, LostCityChunkGenerator chunkGenerator) {
        BlockPos pos;
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, chunkGenerator);
        for (Pair<BlockPos, BuildingInfo.ConditionTodo> pair : info.getMobSpawnerTodo()) {
            int floor;
            TileEntity tileentity;
            pos = (BlockPos)pair.getKey();
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150474_ac || !((tileentity = world.func_175625_s(pos)) instanceof TileEntityMobSpawner)) continue;
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileentity;
            BuildingInfo.ConditionTodo todo = (BuildingInfo.ConditionTodo)pair.getValue();
            String condition = todo.getCondition();
            Condition cnd = AssetRegistries.CONDITIONS.get(condition);
            if (cnd == null) {
                throw new RuntimeException("Cannot find condition '" + condition + "'!");
            }
            int level = (pos.func_177956_o() - this.profile.GROUNDLEVEL) / 6;
            ConditionContext conditionContext = new ConditionContext(level, floor = (pos.func_177956_o() - info.getCityGroundLevel()) / 6, info.floorsBelowGround, info.getNumFloors(), todo.getPart(), todo.getBuilding(), info.chunkX, info.chunkZ);
            String randomValue = cnd.getRandomValue(random, conditionContext);
            if (randomValue == null) {
                throw new RuntimeException("Condition '" + cnd.getName() + "' did not return a valid mob!");
            }
            String fixedId = LostCityChunkGenerator.fixEntityId(randomValue);
            MobSpawnerBaseLogic mobspawnerbaselogic = spawner.func_145881_a();
            mobspawnerbaselogic.func_190894_a(new ResourceLocation(fixedId));
            spawner.func_70296_d();
        }
        info.clearMobSpawnerTodo();
        for (Pair<BlockPos, BuildingInfo.ConditionTodo> pair : info.getChestTodo()) {
            pos = (BlockPos)pair.getKey();
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() != Blocks.field_150486_ae || !chunkGenerator.profile.GENERATE_LOOT) continue;
            this.createLootChest(info, random, world, pos, (BuildingInfo.ConditionTodo)pair.getRight());
        }
        info.clearChestTodo();
        for (BlockPos pos2 : info.getGenericTodo()) {
            IBlockState state = world.func_180495_p(pos2);
            if (state.func_177230_c() != Blocks.field_150426_aN) continue;
            world.func_180501_a(pos2, state, 3);
        }
        info.clearGenericTodo();
    }

    private void createLootChest(BuildingInfo info, Random random, World world, BlockPos pos, BuildingInfo.ConditionTodo todo) {
        world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH));
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityChest && todo != null) {
            String lootTable = todo.getCondition();
            int level = (pos.func_177956_o() - this.profile.GROUNDLEVEL) / 6;
            int floor = (pos.func_177956_o() - info.getCityGroundLevel()) / 6;
            ConditionContext conditionContext = new ConditionContext(level, floor, info.floorsBelowGround, info.getNumFloors(), todo.getPart(), todo.getBuilding(), info.chunkX, info.chunkZ);
            String randomValue = AssetRegistries.CONDITIONS.get(lootTable).getRandomValue(random, conditionContext);
            ((TileEntityChest)tileentity).func_189404_a(new ResourceLocation(randomValue), random.nextLong());
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int i2;
        int l1;
        int k1;
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        World w = this.worldObj;
        Biome Biome2 = w.getBiomeForCoordsBody(new BlockPos(x + 16, 0, z + 16));
        this.rand.setSeed(w.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ w.func_72905_C());
        boolean flag = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, w, this.rand, chunkX, chunkZ, flag));
        ChunkPos cp = new ChunkPos(chunkX, chunkZ);
        if (this.profile.GENERATE_MINESHAFTS) {
            this.mineshaftGenerator.func_175794_a(w, this.rand, cp);
        }
        if (this.profile.GENERATE_VILLAGES) {
            if (this.profile.PREVENT_VILLAGES_IN_CITIES) {
                if (!BuildingInfo.isCity(chunkX, chunkZ, this)) {
                    flag = this.villageGenerator.func_175794_a(w, this.rand, cp);
                }
            } else {
                flag = this.villageGenerator.func_175794_a(w, this.rand, cp);
            }
        }
        if (this.profile.GENERATE_STRONGHOLDS) {
            this.strongholdGenerator.func_175794_a(w, this.rand, cp);
        }
        if (this.profile.GENERATE_SCATTERED) {
            this.scatteredFeatureGenerator.func_175794_a(w, this.rand, cp);
        }
        if (this.profile.GENERATE_OCEANMONUMENTS) {
            this.oceanMonumentGenerator.func_175794_a(w, this.rand, cp);
        }
        if (this.profile.GENERATE_LAKES) {
            boolean isCity = BuildingInfo.isCity(chunkX, chunkZ, this);
            if (!this.profile.PREVENT_LAKES_RAVINES_IN_CITIES || !isCity) {
                if (Biome2 != Biomes.field_76769_d && Biome2 != Biomes.field_76786_s && !flag && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)w, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                    k1 = x + this.rand.nextInt(16) + 8;
                    l1 = this.rand.nextInt(256);
                    i2 = z + this.rand.nextInt(16) + 8;
                    new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(w, this.rand, new BlockPos(k1, l1, i2));
                }
                if (TerrainGen.populate((IChunkGenerator)this, (World)w, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !flag && this.rand.nextInt(8) == 0) {
                    k1 = x + this.rand.nextInt(16) + 8;
                    l1 = this.rand.nextInt(this.rand.nextInt(248) + 8);
                    i2 = z + this.rand.nextInt(16) + 8;
                    if (l1 < this.profile.GROUNDLEVEL - this.profile.WATERLEVEL_OFFSET || this.rand.nextInt(10) == 0) {
                        new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(w, this.rand, new BlockPos(k1, l1, i2));
                    }
                }
            }
        }
        boolean doGen = false;
        if (this.profile.GENERATE_DUNGEONS) {
            doGen = TerrainGen.populate((IChunkGenerator)this, (World)w, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
            for (k1 = 0; doGen && k1 < 8; ++k1) {
                l1 = x + this.rand.nextInt(16) + 8;
                i2 = this.rand.nextInt(256);
                int j2 = z + this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(w, this.rand, new BlockPos(l1, i2, j2));
            }
        }
        BlockPos pos = new BlockPos(x, 0, z);
        Biome2.func_180624_a(w, this.rand, pos);
        if (TerrainGen.populate((IChunkGenerator)this, (World)w, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)w, (Biome)Biome2, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        }
        x += 8;
        z += 8;
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)w, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (k1 = 0; doGen && k1 < 16; ++k1) {
            for (l1 = 0; l1 < 16; ++l1) {
                i2 = w.func_175725_q(new BlockPos(x + k1, 0, z + l1)).func_177956_o();
                if (w.func_175670_e(new BlockPos(k1 + x, i2 - 1, l1 + z), false)) {
                    w.func_180501_a(new BlockPos(k1 + x, i2 - 1, l1 + z), Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!w.func_175708_f(new BlockPos(k1 + x, i2, l1 + z), true)) continue;
                w.func_180501_a(new BlockPos(k1 + x, i2, l1 + z), Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
        this.generateTrees(this.rand, chunkX, chunkZ, w, this);
        this.generateVines(this.rand, chunkX, chunkZ, w, this);
        this.generateLootSpawners(this.rand, chunkX, chunkZ, w, this);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, w, this.rand, chunkX, chunkZ, flag));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        boolean flag = false;
        if (this.profile.GENERATE_OCEANMONUMENTS && chunkIn.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, new ChunkPos(x, z));
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.getDefaultCreatures(creatureType, pos);
    }

    private List getDefaultCreatures(EnumCreatureType creatureType, BlockPos pos) {
        Biome Biome2 = this.worldObj.getBiomeForCoordsBody(pos);
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.profile.GENERATE_SCATTERED && this.scatteredFeatureGenerator.func_175795_b(pos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (this.profile.GENERATE_OCEANMONUMENTS && this.oceanMonumentGenerator.func_175796_a(this.worldObj, pos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        }
        return Biome2.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_180706_b(worldIn, position, findUnexplored) : null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        if (this.profile.GENERATE_MINESHAFTS) {
            this.mineshaftGenerator.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.profile.GENERATE_VILLAGES) {
            if (this.profile.PREVENT_VILLAGES_IN_CITIES) {
                if (!BuildingInfo.isCity(x, z, this)) {
                    this.villageGenerator.func_186125_a(this.worldObj, x, z, null);
                }
            } else {
                this.villageGenerator.func_186125_a(this.worldObj, x, z, null);
            }
        }
        if (this.profile.GENERATE_STRONGHOLDS) {
            this.strongholdGenerator.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.profile.GENERATE_SCATTERED) {
            this.scatteredFeatureGenerator.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.profile.GENERATE_OCEANMONUMENTS) {
            this.oceanMonumentGenerator.func_186125_a(this.worldObj, x, z, null);
        }
    }

    public boolean func_193414_a(World p_193414_1_, String p_193414_2_, BlockPos p_193414_3_) {
        if ("Stronghold".equals(p_193414_2_) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_175795_b(p_193414_3_);
        }
        if ("Monument".equals(p_193414_2_) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_175795_b(p_193414_3_);
        }
        if ("Village".equals(p_193414_2_) && this.villageGenerator != null) {
            return this.villageGenerator.func_175795_b(p_193414_3_);
        }
        if ("Mineshaft".equals(p_193414_2_) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(p_193414_3_);
        }
        return "Temple".equals(p_193414_2_) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_175795_b(p_193414_3_) : false;
    }

    @Override
    public ILostChunkInfo getChunkInfo(int chunkX, int chunkZ) {
        return BuildingInfo.getBuildingInfo(chunkX, chunkZ, this);
    }

    @Override
    public int getRealHeight(int level) {
        return this.profile.GROUNDLEVEL + level * 6;
    }
}

