/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lostcities.LostCities;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LostWorldFilteredBiomeProvider
extends BiomeProvider {
    private final BiomeProvider original;
    private final String[] allowedBiomeFactors;
    private List<Pair<Float, Biome>> biomes = null;
    private final Map<String, Biome> translationMap = new HashMap<String, Biome>();

    public LostWorldFilteredBiomeProvider(BiomeProvider original, String[] allowedBiomeFactors) {
        this.original = original;
        this.allowedBiomeFactors = allowedBiomeFactors;
    }

    private void parseAllowedBiomes() {
        if (this.biomes != null) {
            return;
        }
        this.biomes = new ArrayList<Pair<Float, Biome>>();
        for (String s : this.allowedBiomeFactors) {
            String[] split = StringUtils.split((String)s, (char)'=');
            float f = Float.parseFloat(split[1]);
            String biomeId = split[0];
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeId));
            if (biome == null) {
                for (Biome b : Biome.field_185377_q) {
                    ResourceLocation registryName = b.getRegistryName();
                    if (registryName == null || !biomeId.equals(registryName.func_110623_a())) continue;
                    biome = b;
                    break;
                }
            }
            if (biome != null) {
                this.biomes.add((Pair<Float, Biome>)Pair.of((Object)Float.valueOf(f), (Object)biome));
                continue;
            }
            LostCities.logger.warn("Could not find biome '" + biomeId + "'!");
        }
    }

    private Biome translate(Biome biome) {
        if (!this.translationMap.containsKey(biome.func_185359_l())) {
            this.parseAllowedBiomes();
            Biome bestFit = null;
            double bestDist = 1.0E9;
            for (Pair<Float, Biome> pair : this.biomes) {
                Biome b = (Biome)pair.getRight();
                double distance = LostWorldFilteredBiomeProvider.calculateBiomeDistance(biome, b) * (double)((Float)pair.getLeft()).floatValue();
                if (!(distance < bestDist)) continue;
                bestDist = distance;
                bestFit = b;
            }
            if (bestFit == null) {
                bestFit = Biomes.field_76772_c;
            }
            this.translationMap.put(biome.func_185359_l(), bestFit);
        }
        return this.translationMap.get(biome.func_185359_l());
    }

    private static double calculateBiomeDistance(Biome a, Biome b) {
        if (a == b) {
            return -1000.0;
        }
        float dr = a.func_76727_i() - b.func_76727_i();
        float dt = a.func_185353_n() - b.func_185353_n();
        float dv = a.func_185360_m() - b.func_185360_m();
        float dh = a.func_185355_j() - b.func_185355_j();
        return Math.sqrt(dr * dr + dt * dt + dv * dv + dh * dh);
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.translate(this.original.func_180631_a(pos));
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        biomes = this.original.func_76937_a(biomes, x, z, width, height);
        for (int i = 0; i < biomes.length; ++i) {
            biomes[i] = this.translate(biomes[i]);
        }
        return biomes;
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        oldBiomeList = this.original.func_76933_b(oldBiomeList, x, z, width, depth);
        for (int i = 0; i < oldBiomeList.length; ++i) {
            oldBiomeList[i] = this.translate(oldBiomeList[i]);
        }
        return oldBiomeList;
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        return this.func_76933_b(listToReuse, x, z, width, length);
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        return this.original.func_180630_a(x, z, range, biomes, random);
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        return true;
    }

    public boolean func_190944_c() {
        return false;
    }

    public Biome func_190943_d() {
        return null;
    }
}

