/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import mcjty.lostcities.api.IChunkPrimerFactory;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.LostWorldFilteredBiomeProvider;
import mcjty.lostcities.dimensions.world.LostWorldType;
import mcjty.lostcities.gui.GuiLostCityConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LostWorldTypeAdapter
extends WorldType {
    private final String otherWorldtype;
    private BiomeProvider biomeProvider = null;
    private IChunkGenerator otherGenerator = null;
    private IChunkPrimerFactory factory = null;

    public LostWorldTypeAdapter(String other) {
        super("lc_" + other);
        this.otherWorldtype = other;
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        if (this.otherGenerator == null) {
            for (WorldType type : WorldType.field_77139_a) {
                if (!this.otherWorldtype.equals(type.func_77127_a())) continue;
                WorldType orig = world.func_72912_H().func_76067_t();
                world.func_72912_H().func_76085_a(type);
                this.otherGenerator = type.getChunkGenerator(world, generatorOptions);
                world.func_72912_H().func_76085_a(orig);
                if (!(this.otherGenerator instanceof IChunkPrimerFactory)) break;
                this.factory = (IChunkPrimerFactory)this.otherGenerator;
                break;
            }
        }
        return new LostCityChunkGenerator(world, this.factory);
    }

    private BiomeProvider getInternalBiomeProvider(World world) {
        if (this.biomeProvider == null) {
            for (WorldType type : WorldType.field_77139_a) {
                if (!this.otherWorldtype.equals(type.func_77127_a())) continue;
                WorldType orig = world.func_72912_H().func_76067_t();
                world.func_72912_H().func_76085_a(type);
                this.biomeProvider = type.getBiomeProvider(world);
                world.func_72912_H().func_76085_a(orig);
                break;
            }
        }
        return this.biomeProvider;
    }

    public BiomeProvider getBiomeProvider(World world) {
        LostCityProfile profile = LostWorldType.getProfile(world);
        if (profile.ALLOWED_BIOME_FACTORS.length == 0) {
            return this.getInternalBiomeProvider(world);
        }
        return new LostWorldFilteredBiomeProvider(this.getInternalBiomeProvider(world), profile.ALLOWED_BIOME_FACTORS);
    }

    public boolean isCustomizable() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onCustomizeButton(Minecraft mc, GuiCreateWorld guiCreateWorld) {
        mc.func_147108_a((GuiScreen)new GuiLostCityConfiguration(guiCreateWorld));
    }
}

