/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.lost.BiomeInfo;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import mcjty.lostcities.dimensions.world.lost.cityassets.CityStyle;
import mcjty.lostcities.dimensions.world.lost.cityassets.PredefinedCity;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class City {
    private static Map<ChunkCoord, PredefinedCity> predefinedCityMap = null;
    private static Map<ChunkCoord, PredefinedCity.PredefinedBuilding> predefinedBuildingMap = null;

    public static void cleanCache() {
        predefinedCityMap = null;
        predefinedBuildingMap = null;
    }

    private static PredefinedCity getPredefinedCity(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (predefinedCityMap == null) {
            predefinedCityMap = new HashMap<ChunkCoord, PredefinedCity>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                predefinedCityMap.put(new ChunkCoord(city.getDimension(), city.getChunkX(), city.getChunkZ()), city);
            }
        }
        if (predefinedCityMap.isEmpty()) {
            return null;
        }
        return predefinedCityMap.get(new ChunkCoord(provider.dimensionId, chunkX, chunkZ));
    }

    public static PredefinedCity.PredefinedBuilding getPredefinedBuilding(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (predefinedBuildingMap == null) {
            predefinedBuildingMap = new HashMap<ChunkCoord, PredefinedCity.PredefinedBuilding>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedCity.PredefinedBuilding building : city.getPredefinedBuildings()) {
                    predefinedBuildingMap.put(new ChunkCoord(city.getDimension(), city.getChunkX() + building.getRelChunkX(), city.getChunkZ() + building.getRelChunkZ()), building);
                }
            }
        }
        if (predefinedBuildingMap.isEmpty()) {
            return null;
        }
        return predefinedBuildingMap.get(new ChunkCoord(provider.dimensionId, chunkX, chunkZ));
    }

    public static boolean isCityCenter(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider);
        if (city != null) {
            return true;
        }
        Random rand = new Random(provider.seed + (long)chunkZ * 797003437L + (long)chunkX * 295075153L);
        rand.nextFloat();
        rand.nextFloat();
        return rand.nextFloat() < provider.profile.CITY_CHANCE;
    }

    public static float getCityRadius(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider);
        if (city != null) {
            return city.getRadius();
        }
        Random rand = new Random(provider.seed + (long)chunkZ * 100001653L + (long)chunkX * 295075153L);
        rand.nextFloat();
        rand.nextFloat();
        return provider.profile.CITY_MINRADIUS + rand.nextInt(provider.profile.CITY_MAXRADIUS - provider.profile.CITY_MINRADIUS);
    }

    public static String getCityStyleForCityCenter(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider);
        if (city != null && city.getCityStyle() != null) {
            return city.getCityStyle();
        }
        Random rand = new Random(provider.seed + (long)chunkZ * 899809363L + (long)chunkX * 256203221L);
        rand.nextFloat();
        rand.nextFloat();
        return provider.worldStyle.getRandomCityStyle(provider, chunkX, chunkZ, rand);
    }

    public static CityStyle getCityStyle(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        Random rand = new Random(provider.seed + (long)chunkZ * 593441843L + (long)chunkX * 217645177L);
        rand.nextFloat();
        rand.nextFloat();
        int offset = (provider.profile.CITY_MAXRADIUS + 15) / 16;
        ArrayList<Pair<Float, String>> styles = new ArrayList<Pair<Float, String>>();
        for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
            for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                float radius;
                float sqdist;
                if (!City.isCityCenter(cx, cz, provider) || !((sqdist = (float)((cx * 16 - chunkX * 16) * (cx * 16 - chunkX * 16) + (cz * 16 - chunkZ * 16) * (cz * 16 - chunkZ * 16))) < (radius = City.getCityRadius(cx, cz, provider)) * radius)) continue;
                float dist = (float)Math.sqrt(sqdist);
                float factor = (radius - dist) / radius;
                styles.add((Pair<Float, String>)Pair.of((Object)Float.valueOf(factor), (Object)City.getCityStyleForCityCenter(chunkX, chunkZ, provider)));
            }
        }
        String cityStyleName = styles.isEmpty() ? provider.worldStyle.getRandomCityStyle(provider, chunkX, chunkZ, rand) : Tools.getRandomFromList(rand, styles);
        return AssetRegistries.CITYSTYLES.get(cityStyleName);
    }

    public static float getCityFactor(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        Biome[] biomes;
        PredefinedCity.PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, provider);
        if (predefinedBuilding != null) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX - 1, chunkZ, provider);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX - 1, chunkZ - 1, provider);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ - 1, provider);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return 1.0f;
        }
        long seed = provider.seed;
        float factor = 0.0f;
        int offset = (provider.profile.CITY_MAXRADIUS + 15) / 16;
        for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
            for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                float radius;
                float sqdist;
                if (!City.isCityCenter(cx, cz, provider) || !((sqdist = (float)((cx * 16 - chunkX * 16) * (cx * 16 - chunkX * 16) + (cz * 16 - chunkZ * 16) * (cz * 16 - chunkZ * 16))) < (radius = City.getCityRadius(cx, cz, provider)) * radius)) continue;
                float dist = (float)Math.sqrt(sqdist);
                factor += (radius - dist) / radius;
            }
        }
        Float foundFactor = null;
        for (int cx = -1; cx <= 1; ++cx) {
            for (int cz = -1; cz <= 1; ++cz) {
                Biome[] biomes2 = BiomeInfo.getBiomeInfo(provider, new ChunkCoord(provider.dimensionId, chunkX + cx, chunkZ + cz)).getBiomes();
                if (!City.isTooHighForBuilding(biomes2)) continue;
                return 0.0f;
            }
        }
        for (Biome biome : biomes = BiomeInfo.getBiomeInfo(provider, new ChunkCoord(provider.dimensionId, chunkX, chunkZ)).getBiomes()) {
            ResourceLocation object;
            Map<String, Float> map = provider.profile.getBiomeFactorMap();
            Float f = map.get((object = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome)).toString());
            if (f == null) continue;
            foundFactor = f;
            break;
        }
        factor = foundFactor == null ? (factor *= provider.profile.CITY_DEFAULT_BIOME_FACTOR.floatValue()) : (factor *= foundFactor.floatValue());
        if (factor < 0.0f) {
            return 0.0f;
        }
        if (factor > 1.0f) {
            return 1.0f;
        }
        return factor;
    }

    public static boolean isTooHighForBuilding(Biome[] biomes) {
        return biomes[55].func_185355_j() > 4.0f || biomes[54].func_185355_j() > 4.0f || biomes[56].func_185355_j() > 4.0f || biomes[5].func_185355_j() > 4.0f || biomes[95].func_185355_j() > 4.0f;
    }
}

