/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lostcities.dimensions.world.lost.cityassets.IAsset;

public class AbstractAssetRegistry<T extends IAsset> {
    private final Map<String, T> assets = new HashMap<String, T>();
    private final List<String> assetNames = new ArrayList<String>();

    public void register(T building) {
        this.assets.put(building.getName(), building);
        this.assetNames.add(building.getName());
    }

    public T get(String name) {
        if (name == null) {
            return null;
        }
        IAsset t = (IAsset)this.assets.get(name);
        if (t != null) {
            t.init();
        }
        return (T)t;
    }

    public T get(int i) {
        IAsset t = (IAsset)this.assets.get(this.assetNames.get(i));
        if (t != null) {
            t.init();
        }
        return (T)t;
    }

    public Iterable<T> getIterable() {
        return this.assets.values();
    }

    public int getCount() {
        return this.assets.size();
    }

    public String getName(int i) {
        return this.assetNames.get(i);
    }

    public void reset() {
        this.assets.clear();
    }

    public void writeToJson(JsonArray array) {
        for (Map.Entry<String, T> entry : this.assets.entrySet()) {
            array.add((JsonElement)((IAsset)entry.getValue()).writeToJSon());
        }
    }
}

