/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import mcjty.lostcities.dimensions.world.lost.cityassets.ConditionContext;
import mcjty.lostcities.dimensions.world.lost.cityassets.IAsset;
import org.apache.commons.lang3.tuple.Pair;

public class Building
implements IAsset {
    private String name;
    private int minFloors = -1;
    private int minCellars = -1;
    private int maxFloors = -1;
    private int maxCellars = -1;
    private char fillerBlock;
    private final List<Pair<Predicate<ConditionContext>, String>> parts = new ArrayList<Pair<Predicate<ConditionContext>, String>>();
    private final List<Pair<Predicate<ConditionContext>, String>> parts2 = new ArrayList<Pair<Predicate<ConditionContext>, String>>();

    public Building(JsonObject object) {
        this.readFromJSon(object);
    }

    public Building(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        if (object.getAsJsonObject().has("minfloors")) {
            this.minFloors = object.getAsJsonObject().get("minfloors").getAsInt();
        }
        if (object.getAsJsonObject().has("mincellars")) {
            this.minCellars = object.getAsJsonObject().get("mincellars").getAsInt();
        }
        if (object.getAsJsonObject().has("maxfloors")) {
            this.maxFloors = object.getAsJsonObject().get("maxfloors").getAsInt();
        }
        if (object.getAsJsonObject().has("maxcellars")) {
            this.maxCellars = object.getAsJsonObject().get("maxcellars").getAsInt();
        }
        if (!object.getAsJsonObject().has("filler")) {
            throw new RuntimeException("'filler' is required for building '" + this.name + "'!");
        }
        this.fillerBlock = object.getAsJsonObject().get("filler").getAsCharacter();
        this.readParts(object, this.parts, "parts");
        this.readParts(object, this.parts2, "parts2");
    }

    public void readParts(JsonObject object, List<Pair<Predicate<ConditionContext>, String>> p, String partSection) {
        p.clear();
        if (!object.has(partSection)) {
            return;
        }
        JsonArray partArray = object.get(partSection).getAsJsonArray();
        for (JsonElement element : partArray) {
            String partName = element.getAsJsonObject().get("part").getAsString();
            Predicate<ConditionContext> test = ConditionContext.parseTest(element);
            this.addPart(test, partName, p);
        }
    }

    @Override
    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("building"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        JsonArray partArray = new JsonArray();
        for (Pair<Predicate<ConditionContext>, String> part : this.parts) {
            JsonObject partObject = new JsonObject();
            partObject.add("test", (JsonElement)new JsonPrimitive("@todo"));
            partObject.add("part", (JsonElement)new JsonPrimitive((String)part.getRight()));
            partArray.add((JsonElement)partObject);
        }
        object.add("parts", (JsonElement)partArray);
        return object;
    }

    public Building addPart(Predicate<ConditionContext> test, String partName, List<Pair<Predicate<ConditionContext>, String>> parts) {
        parts.add((Pair<Predicate<ConditionContext>, String>)Pair.of(test, (Object)partName));
        return this;
    }

    public int getMaxFloors() {
        return this.maxFloors;
    }

    public int getMaxCellars() {
        return this.maxCellars;
    }

    public int getMinFloors() {
        return this.minFloors;
    }

    public int getMinCellars() {
        return this.minCellars;
    }

    public char getFillerBlock() {
        return this.fillerBlock;
    }

    public String getRandomPart(Random random, ConditionContext info) {
        ArrayList<Object> partNames = new ArrayList<Object>();
        for (Pair<Predicate<ConditionContext>, String> pair : this.parts) {
            if (!((Predicate)pair.getLeft()).test(info)) continue;
            partNames.add(pair.getRight());
        }
        if (partNames.isEmpty()) {
            return null;
        }
        return (String)partNames.get(random.nextInt(partNames.size()));
    }

    public String getRandomPart2(Random random, ConditionContext info) {
        ArrayList<Object> partNames = new ArrayList<Object>();
        for (Pair<Predicate<ConditionContext>, String> pair : this.parts2) {
            if (!((Predicate)pair.getLeft()).test(info)) continue;
            partNames.add(pair.getRight());
        }
        if (partNames.isEmpty()) {
            return null;
        }
        return (String)partNames.get(random.nextInt(partNames.size()));
    }
}

