/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import mcjty.lostcities.dimensions.world.lost.cityassets.IAsset;

public class MultiBuilding
implements IAsset {
    private String name;
    private int dimX;
    private int dimZ;
    private String[][] buildings;

    public MultiBuilding(JsonObject object) {
        this.readFromJSon(object);
    }

    public MultiBuilding(String name, int dimX, int dimZ) {
        this.name = name;
        this.dimX = dimX;
        this.dimZ = dimZ;
        this.buildings = new String[dimX][dimZ];
    }

    public MultiBuilding set(int x, int z, String building) {
        this.buildings[x][z] = building;
        return this;
    }

    public String get(int x, int z) {
        return this.buildings[x][z];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        this.dimX = object.get("dimx").getAsInt();
        this.dimZ = object.get("dimz").getAsInt();
        JsonArray buildingArray = object.get("buildings").getAsJsonArray();
        this.buildings = new String[this.dimX][this.dimZ];
        for (int z = 0; z < this.dimZ; ++z) {
            JsonArray ar = buildingArray.get(z).getAsJsonArray();
            for (int x = 0; x < this.dimX; ++x) {
                this.buildings[z][x] = ar.get(x).getAsString();
            }
        }
    }

    @Override
    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("multibuilding"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        object.add("dimx", (JsonElement)new JsonPrimitive((Number)this.dimX));
        object.add("dimz", (JsonElement)new JsonPrimitive((Number)this.dimZ));
        JsonArray buildingArray = new JsonArray();
        for (String[] b : this.buildings) {
            JsonArray a = new JsonArray();
            for (String s : b) {
                a.add((JsonElement)new JsonPrimitive(s));
            }
            buildingArray.add((JsonElement)a);
        }
        object.add("buildings", (JsonElement)buildingArray);
        return object;
    }
}

