/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import mcjty.lostcities.dimensions.world.lost.cityassets.IAsset;

public class PredefinedCity
implements IAsset {
    private String name;
    private int dimension;
    private int chunkX;
    private int chunkZ;
    private int radius;
    private String cityStyle;
    private final List<PredefinedBuilding> predefinedBuildings = new ArrayList<PredefinedBuilding>();

    public PredefinedCity(JsonObject object) {
        this.readFromJSon(object);
    }

    public PredefinedCity(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        this.dimension = object.get("dimension").getAsInt();
        this.chunkX = object.get("chunkx").getAsInt();
        this.chunkZ = object.get("chunkz").getAsInt();
        this.radius = object.get("radius").getAsInt();
        if (object.has("citystyle")) {
            this.cityStyle = object.get("citystyle").getAsString();
        }
        JsonArray buildings = this.getArraySafe(object, "buildings");
        for (JsonElement element : buildings) {
            boolean multi;
            String building;
            JsonObject o = element.getAsJsonObject();
            if (o.has("building")) {
                building = o.get("building").getAsString();
                multi = false;
            } else {
                building = o.get("multibuilding").getAsString();
                multi = true;
            }
            int relChunkX = o.get("chunkx").getAsInt();
            int relChunkZ = o.get("chunkz").getAsInt();
            PredefinedBuilding b = new PredefinedBuilding(building, relChunkX, relChunkZ, multi);
            this.predefinedBuildings.add(b);
        }
    }

    private JsonArray getArraySafe(JsonObject object, String key) {
        if (object.has(key)) {
            return object.get(key).getAsJsonArray();
        }
        return new JsonArray();
    }

    @Override
    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("city"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        return object;
    }

    public List<PredefinedBuilding> getPredefinedBuildings() {
        return this.predefinedBuildings;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public int getRadius() {
        return this.radius;
    }

    public String getCityStyle() {
        return this.cityStyle;
    }

    public static class PredefinedBuilding {
        private final String building;
        private final int relChunkX;
        private final int relChunkZ;
        private final boolean multi;

        public PredefinedBuilding(String building, int relChunkX, int relChunkZ, boolean multi) {
            this.building = building;
            this.relChunkX = relChunkX;
            this.relChunkZ = relChunkZ;
            this.multi = multi;
        }

        public String getBuilding() {
            return this.building;
        }

        public int getRelChunkX() {
            return this.relChunkX;
        }

        public int getRelChunkZ() {
            return this.relChunkZ;
        }

        public boolean isMulti() {
            return this.multi;
        }
    }
}

