/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.lost.BiomeInfo;
import mcjty.lostcities.dimensions.world.lost.cityassets.IAsset;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class WorldStyle
implements IAsset {
    private String name;
    private String outsideStyle;
    private final List<Pair<Predicate<Info>, Pair<Float, String>>> cityStyleSelector = new ArrayList<Pair<Predicate<Info>, Pair<Float, String>>>();

    public WorldStyle(JsonObject object) {
        this.readFromJSon(object);
    }

    public WorldStyle(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        this.outsideStyle = object.get("outsidestyle").getAsString();
        JsonArray array = object.get("citystyles").getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject o = element.getAsJsonObject();
            float factor = o.get("factor").getAsFloat();
            String building = o.get("citystyle").getAsString();
            Predicate<Info> predicate = info -> true;
            if (o.has("biomes")) {
                JsonArray ar = o.get("biomes").getAsJsonArray();
                HashSet<String> biomes = new HashSet<String>();
                for (JsonElement el : ar) {
                    Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(el.getAsString()));
                    if (biome == null) continue;
                    biomes.add(((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome)).toString());
                }
                predicate = info -> this.hasBiomes((Info)info, (Set<String>)biomes);
            }
            this.cityStyleSelector.add((Pair<Predicate<Info>, Pair<Float, String>>)Pair.of(predicate, (Object)Pair.of((Object)Float.valueOf(factor), (Object)building)));
        }
    }

    private boolean isValidBiome(Set<String> biomeSet, Biome biome) {
        ResourceLocation object = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
        return biomeSet.contains(object.toString());
    }

    private boolean hasBiomes(Info info, Set<String> biomeSet) {
        Biome[] biomes = info.biomes;
        return this.isValidBiome(biomeSet, biomes[55]) || this.isValidBiome(biomeSet, biomes[54]) || this.isValidBiome(biomeSet, biomes[56]) || this.isValidBiome(biomeSet, biomes[5]) || this.isValidBiome(biomeSet, biomes[95]);
    }

    public String getOutsideStyle() {
        return this.outsideStyle;
    }

    @Override
    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("worldstyle"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        object.add("outsidestyle", (JsonElement)new JsonPrimitive(this.outsideStyle));
        JsonArray array = new JsonArray();
        for (Pair<Predicate<Info>, Pair<Float, String>> pair : this.cityStyleSelector) {
            JsonObject o = new JsonObject();
            Pair ff = (Pair)pair.getValue();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)ff.getKey()));
            o.add("citystyle", (JsonElement)new JsonPrimitive((String)ff.getValue()));
            array.add((JsonElement)o);
        }
        object.add("citystyles", (JsonElement)array);
        return object;
    }

    public String getRandomCityStyle(LostCityChunkGenerator provider, int chunkX, int chunkZ, Random random) {
        Biome[] biomes = BiomeInfo.getBiomeInfo(provider, new ChunkCoord(provider.dimensionId, chunkX, chunkZ)).getBiomes();
        Info info = new Info(biomes, chunkX, chunkZ);
        ArrayList<Pair<Float, String>> ct = new ArrayList<Pair<Float, String>>();
        for (Pair<Predicate<Info>, Pair<Float, String>> pair : this.cityStyleSelector) {
            if (!((Predicate)pair.getKey()).test(info)) continue;
            ct.add((Pair<Float, String>)pair.getValue());
        }
        return Tools.getRandomFromList(random, ct);
    }

    private static class Info {
        private Biome[] biomes;
        private int chunkX;
        private int chunkZ;

        public Info(Biome[] biomes, int chunkX, int chunkZ) {
            this.biomes = biomes;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }
    }
}

