/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;

public interface ISpecialArmor {
    public ArmorProperties getProperties(rh var1, abp var2, qb var3, double var4, int var6);

    public int getArmorDisplay(xl var1, abp var2, int var3);

    public void damageArmor(rh var1, abp var2, qb var3, int var4, int var5);

    public static class ArmorProperties
    implements Comparable<ArmorProperties> {
        public int Priority = 0;
        public int AbsorbMax = Integer.MAX_VALUE;
        public double AbsorbRatio = 0.0;
        public int Slot = 0;
        private static final boolean DEBUG = false;

        public ArmorProperties(int priority, double ratio, int max) {
            this.Priority = priority;
            this.AbsorbRatio = ratio;
            this.AbsorbMax = max;
        }

        public static float ApplyArmor(rh entity, abp[] inventory, qb source, double damage) {
            damage *= 25.0;
            ArrayList<ArmorProperties> dmgVals = new ArrayList<ArmorProperties>();
            for (int x = 0; x < inventory.length; ++x) {
                ISpecialArmor armor;
                abp stack = inventory[x];
                if (stack == null) continue;
                ArmorProperties prop = null;
                if (stack.b() instanceof ISpecialArmor) {
                    armor = (ISpecialArmor)stack.b();
                    prop = armor.getProperties(entity, stack, source, damage / 25.0, x).copy();
                } else if (stack.b() instanceof zn && !source.e()) {
                    armor = (zn)stack.b();
                    prop = new ArmorProperties(0, (double)((zn)armor).c / 25.0, armor.o() + 1 - stack.k());
                }
                if (prop == null) continue;
                prop.Slot = x;
                dmgVals.add(prop);
            }
            if (dmgVals.size() > 0) {
                ArmorProperties[] props = dmgVals.toArray(new ArmorProperties[dmgVals.size()]);
                ArmorProperties.StandardizeList(props, damage);
                int level = props[0].Priority;
                double ratio = 0.0;
                for (ArmorProperties prop : props) {
                    if (level != prop.Priority) {
                        damage -= damage * ratio;
                        ratio = 0.0;
                        level = prop.Priority;
                    }
                    ratio += prop.AbsorbRatio;
                    double absorb = damage * prop.AbsorbRatio;
                    if (!(absorb > 0.0)) continue;
                    abp stack = inventory[prop.Slot];
                    int itemDamage = (int)(absorb / 25.0 < 1.0 ? 1.0 : absorb / 25.0);
                    if (stack.b() instanceof ISpecialArmor) {
                        ((ISpecialArmor)stack.b()).damageArmor(entity, stack, source, itemDamage, prop.Slot);
                    } else {
                        stack.a(itemDamage, entity);
                    }
                    if (stack.b > 0) continue;
                    inventory[prop.Slot] = null;
                }
                damage -= damage * ratio;
            }
            return (float)(damage / 25.0);
        }

        private static void StandardizeList(ArmorProperties[] armor, double damage) {
            Arrays.sort(armor);
            int start = 0;
            double total = 0.0;
            int priority = armor[0].Priority;
            int pStart = 0;
            boolean pChange = false;
            boolean pFinished = false;
            for (int x = 0; x < armor.length; ++x) {
                int y2;
                total += armor[x].AbsorbRatio;
                if (x != armor.length - 1 && armor[x].Priority == priority) continue;
                if (armor[x].Priority != priority) {
                    total -= armor[x].AbsorbRatio;
                    --x;
                    pChange = true;
                }
                if (total > 1.0) {
                    for (y2 = start; y2 <= x; ++y2) {
                        double newRatio = armor[y2].AbsorbRatio / total;
                        if (newRatio * damage > (double)armor[y2].AbsorbMax) {
                            armor[y2].AbsorbRatio = (double)armor[y2].AbsorbMax / damage;
                            total = 0.0;
                            for (int z2 = pStart; z2 <= y2; ++z2) {
                                total += armor[z2].AbsorbRatio;
                            }
                            start = y2 + 1;
                            x = y2;
                            break;
                        }
                        armor[y2].AbsorbRatio = newRatio;
                        pFinished = true;
                    }
                    if (!pChange || !pFinished) continue;
                    damage -= damage * total;
                    total = 0.0;
                    start = x + 1;
                    priority = armor[start].Priority;
                    pStart = start;
                    pChange = false;
                    pFinished = false;
                    if (!(damage <= 0.0)) continue;
                    for (y2 = x + 1; y2 < armor.length; ++y2) {
                        armor[y2].AbsorbRatio = 0.0;
                    }
                } else {
                    for (y2 = start; y2 <= x; ++y2) {
                        total -= armor[y2].AbsorbRatio;
                        if (damage * armor[y2].AbsorbRatio > (double)armor[y2].AbsorbMax) {
                            armor[y2].AbsorbRatio = (double)armor[y2].AbsorbMax / damage;
                        }
                        total += armor[y2].AbsorbRatio;
                    }
                    damage -= damage * total;
                    total = 0.0;
                    if (x == armor.length - 1) continue;
                    start = x + 1;
                    priority = armor[start].Priority;
                    pStart = start;
                    pChange = false;
                    if (!(damage <= 0.0)) continue;
                    for (y2 = x + 1; y2 < armor.length; ++y2) {
                        armor[y2].AbsorbRatio = 0.0;
                    }
                }
                break;
            }
        }

        @Override
        public int compareTo(ArmorProperties o) {
            if (o.Priority != this.Priority) {
                return o.Priority - this.Priority;
            }
            double left = this.AbsorbRatio == 0.0 ? 0.0 : (double)this.AbsorbMax * 100.0 / this.AbsorbRatio;
            double right = o.AbsorbRatio == 0.0 ? 0.0 : (double)o.AbsorbMax * 100.0 / o.AbsorbRatio;
            return (int)(left - right);
        }

        public String toString() {
            return String.format("%d, %d, %f, %d", this.Priority, this.AbsorbMax, this.AbsorbRatio, this.AbsorbRatio == 0.0 ? 0 : (int)((double)this.AbsorbMax * 100.0 / this.AbsorbRatio));
        }

        public ArmorProperties copy() {
            return new ArmorProperties(this.Priority, this.AbsorbRatio, this.AbsorbMax);
        }
    }
}

