/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import cpw.mods.fml.common.Optional;
import de.teamlapen.vampirism.entity.VampireMob;
import de.teamlapen.vampirism.entity.minions.IMinion;
import de.teamlapen.vampirism.entity.minions.IMinionCommand;
import de.teamlapen.vampirism.entity.minions.IMinionLord;
import de.teamlapen.vampirism.entity.minions.MinionHelper;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.network.UpdateEntityPacket;
import de.teamlapen.vampirism.tileEntity.TileEntityBloodAltar1;
import de.teamlapen.vampirism.tileEntity.TileEntityBloodAltar2;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="mcp.mobius.waila.api.IWailaDataProvider", modid="Waila")
public class WailaDataProvider
implements IWailaDataProvider,
IWailaEntityProvider {
    @Optional.Method(modid="Waila")
    public static void callbackRegister(IWailaRegistrar register) {
        WailaDataProvider instance = new WailaDataProvider();
        register.addConfig("vampirism", "option.vampirism.showAltarInfo", true);
        register.addConfig("vampirism", "option.vampirism.showPlayerInfo", true);
        register.addConfig("vampirism", "option.vampirism.showEntityInfo", true);
        register.registerBodyProvider((IWailaDataProvider)instance, TileEntityBloodAltar1.class);
        register.registerBodyProvider((IWailaDataProvider)instance, TileEntityBloodAltar2.class);
        register.registerNBTProvider((IWailaDataProvider)instance, TileEntityBloodAltar1.class);
        register.registerBodyProvider((IWailaEntityProvider)instance, EntityPlayer.class);
        register.registerBodyProvider((IWailaEntityProvider)instance, EntityCreature.class);
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof TileEntityBloodAltar1) {
            tag.func_74768_a("vampirism:bloodLeft", ((TileEntityBloodAltar1)te).getBloodLeft());
        }
        return tag;
    }

    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        UpdateEntityPacket.ISyncableExtendedProperties vampire;
        if (config.getConfig("option.vampirism.showPlayerInfo", true) && entity instanceof EntityPlayer && ((VampirePlayer)(vampire = VampirePlayer.get((EntityPlayer)entity))).getLevel() > 0) {
            currenttip.add(String.format("%s: %d", StatCollector.func_74838_a((String)"text.vampirism.vampirelevel"), ((VampirePlayer)vampire).getLevel()));
            if (((VampirePlayer)vampire).isVampireLord()) {
                currenttip.add(SpecialChars.WHITE + StatCollector.func_74838_a((String)"entity.vampirism.vampireLord.name"));
            }
        }
        if (config.getConfig("option.vampirism.showEntityInfo", true) && entity instanceof EntityCreature && VampirePlayer.get(accessor.getPlayer()).getLevel() > 0) {
            vampire = VampireMob.get((EntityCreature)entity);
            IMinion minion = MinionHelper.getMinionFromEntity(entity);
            int blood = ((VampireMob)vampire).getBlood();
            if (blood >= 0) {
                currenttip.add(String.format("%s%s: %d", SpecialChars.RED, StatCollector.func_74838_a((String)"text.vampirism.entitysblood"), blood));
            }
            if (minion != null) {
                currenttip.add(SpecialChars.GREEN + StatCollector.func_74838_a((String)"text.vampirism.minion"));
                IMinionLord lord = minion.getLord();
                if (lord != null) {
                    currenttip.add(String.format("%s%s: %s", SpecialChars.WHITE, StatCollector.func_74838_a((String)"text.vampirism.lord"), lord.getRepresentingEntity().func_70005_c_()));
                    IMinionCommand c = minion.getCommand(minion.getActiveCommandId());
                    if (c != null) {
                        currenttip.add(String.format("%s%s: %s", SpecialChars.WHITE, StatCollector.func_74838_a((String)"text.vampirism.current_task"), StatCollector.func_74838_a((String)c.getUnlocalizedName())));
                    }
                }
            }
        }
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (config.getConfig("option.vampirism.showAltarInfo", true)) {
            TileEntity tile = accessor.getTileEntity();
            if (tile instanceof TileEntityBloodAltar1) {
                TileEntityBloodAltar1 altar1 = (TileEntityBloodAltar1)tile;
                if (altar1.isOccupied()) {
                    int blood = accessor.getNBTData().func_74764_b("vampirism:bloodLeft") ? accessor.getNBTData().func_74762_e("vampirism:bloodLeft") : altar1.getBloodLeft();
                    currenttip.add(String.format("%s%s: %d", SpecialChars.RED, StatCollector.func_74838_a((String)"text.vampirism.blood_left"), blood));
                }
            } else if (tile instanceof TileEntityBloodAltar2) {
                TileEntityBloodAltar2 altar2 = (TileEntityBloodAltar2)tile;
                currenttip.add(String.format("%s%s: %d/%d", SpecialChars.RED, StatCollector.func_74838_a((String)"text.vampirism.blood"), altar2.getBloodAmount(), altar2.getMaxBlood()));
            }
        }
        return currenttip;
    }

    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

