/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.vampirism.client.KeyInputEventHandler;
import de.teamlapen.vampirism.util.IPieElement;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.GuiIngameForge;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GUIPieMenu
extends GuiScreen {
    private static final ResourceLocation backgroundTex = new ResourceLocation("vampirism:textures/gui/pie-menu-bg.png");
    private static final ResourceLocation centerTex = new ResourceLocation("vampirism:textures/gui/pie-menu-center.png");
    private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    protected final ArrayList<IPieElement> elements;
    private int selectedElement = -1;
    private int elementCount;
    protected final int IS = 16;
    private final int BGS = 300;
    private final int RR = 60;
    private final int CS = 100;
    private double radDiff;
    protected final float bgred;
    protected final float bgblue;
    protected final float bggreen;
    protected final float bgalpha;
    protected final String name;

    public GUIPieMenu(long backgroundColor, String name) {
        this.field_146291_p = true;
        this.bgred = (float)(backgroundColor >> 16 & 0xFFL) / 255.0f;
        this.bgblue = (float)(backgroundColor >> 8 & 0xFFL) / 255.0f;
        this.bggreen = (float)(backgroundColor & 0xFFL) / 255.0f;
        this.bgalpha = (float)(backgroundColor >> 24 & 0xFFL) / 255.0f;
        this.name = name;
        this.elements = new ArrayList();
    }

    protected void afterIconDraw(IPieElement p, int x, int y) {
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawBackground(float cX, float cY) {
        float scale = ((float)this.field_146295_m / 2.0f + 16.0f + 16.0f) / 300.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)cX, (float)cY, (float)this.field_73735_i);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTex);
        GL11.glColor4f((float)this.bgred, (float)this.bggreen, (float)this.bgblue, (float)this.bgalpha);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)150.0f, (float)150.0f, (float)this.field_73735_i);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)150.0f, (float)-150.0f, (float)this.field_73735_i);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)-150.0f, (float)-150.0f, (float)this.field_73735_i);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)-150.0f, (float)150.0f, (float)this.field_73735_i);
        GL11.glEnd();
        if (this.elementCount > 1) {
            for (int i = 0; i < this.elementCount; ++i) {
                double rad = (double)i * this.radDiff + this.radDiff / 2.0;
                double cos = Math.cos(rad);
                double sin = Math.sin(rad);
                this.drawLine(cos * 60.0, sin * 60.0, cos * 300.0 / 2.0, sin * 300.0 / 2.0);
            }
        }
        GL11.glPopMatrix();
    }

    protected void drawLine(double x1, double y1, double x2, double y2) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glLineWidth((float)2.0f);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)x1, (double)y1, (double)this.field_73735_i);
        GL11.glVertex3d((double)x2, (double)y2, (double)this.field_73735_i);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean center;
        this.field_146297_k.field_71424_I.func_76320_a(this.name);
        int cX = this.field_146294_l / 2;
        int cY = this.field_146295_m / 2;
        double radius = this.field_146295_m / 4;
        this.drawBackground(cX, cY);
        double mouseRad = this.updateMouse(mouseX, mouseY, cX, cY, radius / 2.0);
        boolean bl = center = (double)((mouseX - cX) * (mouseX - cX) + (mouseY - cY) * (mouseY - cY)) < radius / 4.0 * (radius / 4.0);
        if (center) {
            this.selectedElement = -1;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            IPieElement s = this.elements.get(i);
            double rad = this.radDiff * (double)i;
            boolean selected = false;
            if (!center && mouseRad > rad - this.radDiff / 2.0 && mouseRad < rad + this.radDiff / 2.0) {
                selected = true;
            } else if (!center && rad == 0.0 && mouseRad > Math.PI * 2 - this.radDiff / 2.0) {
                selected = true;
            }
            int x = (int)((double)cX + Math.cos(rad) * radius) - 8;
            int y = (int)((double)cY - Math.sin(rad) * radius) - 8;
            float[] col = this.getColor(s);
            if (col != null) {
                GL11.glColor4f((float)col[0], (float)col[1], (float)col[2], (float)0.5f);
            }
            this.field_146297_k.func_110434_K().func_110577_a(WIDGETS);
            this.func_73729_b(x - 2, y - 2, 1, 1, 20, 20);
            if (selected) {
                this.func_73729_b(x - 3, y - 3, 1, 23, 22, 22);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (selected) {
                this.selectedElement = i;
                this.drawSelectedCenter(cX, cY, rad);
            }
            this.field_146297_k.func_110434_K().func_110577_a(s.getIconLoc());
            this.func_73729_b(x, y, s.getMinU(), s.getMinV(), 16, 16);
            this.afterIconDraw(s, x, y);
        }
        if (this.selectedElement == -1) {
            this.drawUnselectedCenter(cX, cY);
        } else {
            String name = StatCollector.func_74838_a((String)this.elements.get(this.selectedElement).getUnlocalizedName());
            int tx = cX - this.field_146297_k.field_71466_p.func_78256_a(name) / 2;
            int ty = this.field_146295_m / 7;
            this.field_146297_k.field_71466_p.func_78261_a(name, tx, ty, 0xFFFFFF);
        }
        this.field_146297_k.field_71424_I.func_76319_b();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawSelectedCenter(double cX, double cY, double rad) {
        double deg = Math.toDegrees(-rad);
        float scale = (float)this.field_146295_m / 4.0f / 100.0f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)cX, (double)cY, (double)this.field_73735_i);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        GL11.glRotated((double)deg, (double)0.0, (double)0.0, (double)1.0);
        this.field_146297_k.func_110434_K().func_110577_a(centerTex);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.5f, (float)1.0f);
        GL11.glVertex3d((double)50.0, (double)50.0, (double)this.field_73735_i);
        GL11.glTexCoord2f((float)0.5f, (float)0.0f);
        GL11.glVertex3d((double)50.0, (double)-50.0, (double)this.field_73735_i);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3d((double)-50.0, (double)-50.0, (double)this.field_73735_i);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3d((double)-50.0, (double)50.0, (double)this.field_73735_i);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private void drawUnselectedCenter(double cX, double cY) {
        float scale = (float)this.field_146295_m / 4.0f / 100.0f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)cX, (double)cY, (double)this.field_73735_i);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(centerTex);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3d((double)50.0, (double)50.0, (double)this.field_73735_i);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3d((double)50.0, (double)-50.0, (double)this.field_73735_i);
        GL11.glTexCoord2f((float)0.5f, (float)0.0f);
        GL11.glVertex3d((double)-50.0, (double)-50.0, (double)this.field_73735_i);
        GL11.glTexCoord2f((float)0.5f, (float)1.0f);
        GL11.glVertex3d((double)-50.0, (double)50.0, (double)this.field_73735_i);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    protected float[] getColor(IPieElement s) {
        return null;
    }

    protected abstract int getMenuKeyCode();

    public void func_73866_w_() {
        this.onGuiInit();
        this.elementCount = this.elements.size();
        this.radDiff = Math.PI * 2 / (double)this.elementCount;
        try {
            Mouse.setNativeCursor((Cursor)new Cursor(1, 1, 0, 0, 1, BufferUtils.createIntBuffer((int)1), null));
        }
        catch (LWJGLException e) {
            Logger.e("GuiPieMenu", "Failed to set empty cursor", new Object[]{e});
        }
        GuiIngameForge.renderCrosshairs = false;
    }

    protected void onElementSelected(int id) {
    }

    public void func_146281_b() {
        GuiIngameForge.renderCrosshairs = true;
        try {
            Mouse.setNativeCursor(null);
        }
        catch (LWJGLException e) {
            Logger.e("GuiSelectSkill", "Could not reset cursor", new Object[]{e});
        }
    }

    protected abstract void onGuiInit();

    private void setAbsoluteMouse(double x, double y) {
        x = x * (double)this.field_146297_k.field_71443_c / (double)this.field_146294_l;
        y = -(y + 1.0 - (double)this.field_146295_m) * (double)this.field_146297_k.field_71440_d / (double)this.field_146295_m;
        Mouse.setCursorPosition((int)((int)x), (int)((int)y));
    }

    private double updateMouse(int x, int y, int cX, int cY, double r) {
        int dx = x - cX;
        int dy = y - cY;
        double rad = Math.atan2(dy, -dx) + Math.PI;
        if ((double)Math.abs(dx) > Math.abs(Math.cos(rad) * r) + 8.0 || (double)Math.abs(dy) > Math.abs(Math.sin(rad) * r) + 8.0) {
            this.setAbsoluteMouse((double)dx / 1.5 + (double)cX + 4.0, (double)dy / 1.5 + (double)cY);
        }
        return rad;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.field_146297_k.field_71439_g.field_71158_b.func_78898_a();
        if (!KeyInputEventHandler.isKeyDown(this.getMenuKeyCode())) {
            if (this.selectedElement >= 0) {
                this.onElementSelected(this.selectedElement);
            }
            this.field_146297_k.func_147108_a(null);
        }
    }
}

