/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.GUISleepCoffin;
import de.teamlapen.vampirism.entity.VampireMob;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.entity.player.skills.Skills;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Helper;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

public class RenderHandler {
    private static final int ENTITY_NEAR_SQ_DISTANCE = 100;
    private EntityBat entityBat;
    private final Minecraft mc;
    private float eyeHeight;
    private float ySize;
    private boolean shiftedPosY;
    private int entityCooldownTicks;
    private int entityDisplayListId = 0;
    private int entitySphereListId = 0;
    private final int COMPILE_ENTITY_COOLDOWN;
    private final int ENTITY_RADIUS;
    private final int ENTITY_MIN_SQ_RADIUS;
    private final int BLOOD_VISION_FADE_TICKS = 80;
    private final int VAMPIRE_BIOME_FADE_TICKS = 160;
    private FloatBuffer fogColorBuffer;
    private int bloodVisionTicks = 0;
    private int vampireBiomeTicks = 0;

    public RenderHandler(Minecraft mc) {
        this.mc = mc;
        this.ENTITY_RADIUS = BALANCE.VAMPIRE_PLAYER_BLOOD_VISION_DISTANCE;
        this.ENTITY_MIN_SQ_RADIUS = BALANCE.VAMPIRE_PLAYER_BLOOD_VISION_MIN_DISTANCE * BALANCE.VAMPIRE_PLAYER_BLOOD_VISION_MIN_DISTANCE;
        this.COMPILE_ENTITY_COOLDOWN = Configs.blood_vision_recompile_ticks;
        this.entityDisplayListId = GL11.glGenLists((int)2);
        this.entitySphereListId = this.entityDisplayListId + 1;
        this.buildEntitySphere();
    }

    private void buildEntitySphere() {
        Sphere sphere = new Sphere();
        sphere.setDrawStyle(100012);
        sphere.setNormals(100000);
        sphere.setOrientation(100020);
        GL11.glNewList((int)this.entitySphereListId, (int)4864);
        sphere.draw(0.5f, 32, 32);
        GL11.glEndList();
    }

    private void compileEntitys() {
        GL11.glNewList((int)this.entityDisplayListId, (int)4864);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        WorldClient world = this.mc.field_71441_e;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        if (world == null || player == null) {
            return;
        }
        List list = world.func_72839_b((Entity)player, player.field_70121_D.func_72314_b((double)this.ENTITY_RADIUS, (double)this.ENTITY_RADIUS, (double)this.ENTITY_RADIUS));
        for (Object o : list) {
            if (!(o instanceof EntityCreature) && !(o instanceof EntityPlayer)) continue;
            EntityLivingBase e = (EntityLivingBase)o;
            int distance = (int)e.func_70068_e((Entity)player);
            if (distance <= 100 && distance >= this.ENTITY_MIN_SQ_RADIUS) {
                this.renderEntity(e, ((float)distance - (float)this.ENTITY_MIN_SQ_RADIUS) / (float)(100 - this.ENTITY_MIN_SQ_RADIUS));
                continue;
            }
            if (distance <= 100) continue;
            this.renderEntity(e, 1.0f);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glEndList();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71441_e == null) {
            return;
        }
        if (VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).getVision() != 2 || VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).gettingSundamage()) {
            if (this.bloodVisionTicks > 0) {
                --this.bloodVisionTicks;
            }
            if (this.vampireBiomeTicks > 10 && this.bloodVisionTicks == 15) {
                this.bloodVisionTicks = 0;
            }
        } else if (!Configs.disable_blood_vision) {
            if (this.bloodVisionTicks < 80) {
                ++this.bloodVisionTicks;
            }
            --this.entityCooldownTicks;
            if (this.entityCooldownTicks < 1) {
                this.compileEntitys();
                this.entityCooldownTicks = this.COMPILE_ENTITY_COOLDOWN;
            }
        }
        if (Configs.render_fog_vampire_biome && this.mc.field_71441_e.field_73011_w.field_76574_g != VampirismMod.castleDimensionId && Helper.isEntityInVampireBiome((Entity)this.mc.field_71439_g)) {
            if (this.vampireBiomeTicks < 160) {
                ++this.vampireBiomeTicks;
            }
        } else if (this.vampireBiomeTicks > 0) {
            --this.vampireBiomeTicks;
        }
    }

    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (event.entity instanceof EntityPlayer && (this.bloodVisionTicks > 0 || this.vampireBiomeTicks > 10)) {
            event.density = 1.0f;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui instanceof GuiSleepMP && VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).sleepingCoffin) {
            event.gui = new GUISleepCoffin();
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).isSkillActive(Skills.batMode)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (VampirePlayer.get(event.entityPlayer).isSkillActive(Skills.batMode)) {
            event.setCanceled(true);
            if (this.entityBat == null) {
                this.entityBat = new EntityBat(event.entity.field_70170_p);
                this.entityBat.func_82236_f(false);
            }
            EntityPlayer player = event.entityPlayer;
            float parTick = event.partialRenderTick;
            Render renderer = RenderManager.field_78727_a.func_78713_a((Entity)this.entityBat);
            this.entityBat.field_70760_ar = player.field_70760_ar;
            this.entityBat.field_70761_aq = player.field_70761_aq;
            this.entityBat.field_70173_aa = player.field_70173_aa;
            this.entityBat.field_70125_A = player.field_70125_A;
            this.entityBat.field_70177_z = player.field_70177_z;
            this.entityBat.field_70759_as = player.field_70759_as;
            this.entityBat.field_70126_B = player.field_70126_B;
            this.entityBat.field_70127_C = player.field_70127_C;
            this.entityBat.field_70758_at = player.field_70758_at;
            this.entityBat.func_82142_c(player.func_82150_aj());
            float f1 = this.entityBat.field_70126_B + (this.entityBat.field_70177_z - this.entityBat.field_70126_B) * parTick;
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)parTick;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)parTick;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)parTick;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(1.0 * (d0 - RenderManager.field_78725_b)), (double)(1.0 * (d1 - RenderManager.field_78726_c) + (event.entityPlayer == Minecraft.func_71410_x().field_71439_g && (!(Minecraft.func_71410_x().field_71462_r instanceof GuiInventory) && !(Minecraft.func_71410_x().field_71462_r instanceof GuiContainerCreative) || RenderManager.field_78727_a.field_78735_i != 180.0f) ? 1.000000011920929 - (double)event.entityPlayer.field_70129_M : 0.0)), (double)(1.0 * (d2 - RenderManager.field_78723_d)));
            renderer.func_76986_a((Entity)this.entityBat, 0.0, 0.0, 0.0, f1, event.partialRenderTick);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (this.mc.field_71441_e == null) {
            return;
        }
        if (VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).getVision() == 2 && !VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).gettingSundamage()) {
            double doubleX = this.mc.field_71439_g.field_70142_S + (this.mc.field_71439_g.field_70165_t - this.mc.field_71439_g.field_70142_S) * (double)event.partialTicks;
            double doubleY = this.mc.field_71439_g.field_70137_T + (this.mc.field_71439_g.field_70163_u - this.mc.field_71439_g.field_70137_T) * (double)event.partialTicks;
            double doubleZ = this.mc.field_71439_g.field_70136_U + (this.mc.field_71439_g.field_70161_v - this.mc.field_71439_g.field_70136_U) * (double)event.partialTicks;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GL11.glCallList((int)this.entityDisplayListId);
            GL11.glPopMatrix();
        }
        if (this.vampireBiomeTicks > 0) {
            this.renderVampireBiomeFog(this.vampireBiomeTicks);
        }
        if (this.bloodVisionTicks > 0) {
            this.renderBloodVisionFog(this.bloodVisionTicks);
        }
    }

    private void renderBloodVisionFog(int ticks) {
        float f = 80.0f / (float)ticks;
        GL11.glPushMatrix();
        boolean fog = GL11.glIsEnabled((int)2912);
        if (!fog) {
            GL11.glEnable((int)2912);
        }
        GL11.glFogi((int)2917, (int)9729);
        GL11.glFogf((int)2915, (float)(4.0f * f));
        GL11.glFogf((int)2916, (float)(5.5f * f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glFogf((int)2914, (float)1.0f);
        if (!fog) {
            GL11.glDisable((int)2912);
        }
        GL11.glPopMatrix();
    }

    private void renderVampireBiomeFog(int ticks) {
        float f = 160.0f / (float)ticks / 1.5f;
        GL11.glPushMatrix();
        boolean fog = GL11.glIsEnabled((int)2912);
        if (!fog) {
            GL11.glEnable((int)2912);
        }
        GL11.glFogi((int)2917, (int)9729);
        GL11.glFogf((int)2915, (float)(15.0f * f));
        GL11.glFogf((int)2916, (float)(50.5f * f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glFogf((int)2914, (float)1.0f);
        if (!fog) {
            GL11.glDisable((int)2912);
        }
        GL11.glPopMatrix();
    }

    private void renderEntity(EntityLivingBase entity, float f) {
        float red = 1.0f;
        float green = 0.0f;
        float blue = 0.0f;
        if (entity instanceof EntityCreature) {
            if (VampireMob.get((EntityCreature)entity).isVampire()) {
                red = 0.23127f;
                green = 0.04313f;
                blue = 0.04313f;
            } else if (VampireMob.get((EntityCreature)entity).getBlood() <= 0) {
                red = 0.039215f;
                green = 0.0745f;
                blue = 0.1647f;
            }
        } else if (entity instanceof EntityPlayer && VampirePlayer.get((EntityPlayer)entity).getLevel() > 0) {
            red = 0.039215f;
            green = 0.0745f;
            blue = 0.1647f;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)(entity.field_70131_O / 2.0f)), (double)entity.field_70161_v);
        GL11.glScalef((float)(entity.field_70130_N * 1.5f), (float)(entity.field_70131_O * 1.5f), (float)(entity.field_70130_N * 1.5f));
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)(0.5f * f));
        GL11.glCallList((int)this.entitySphereListId);
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (this.mc.field_71441_e != null) {
            if (event.phase == TickEvent.Phase.START) {
                if (VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).isSkillActive(Skills.batMode)) {
                    this.ySize = this.mc.field_71439_g.field_70129_M - 0.68f + this.mc.field_71439_g.getDefaultEyeHeight();
                    this.eyeHeight = this.mc.field_71439_g.eyeHeight;
                    this.mc.field_71439_g.field_70137_T -= (double)this.ySize;
                    this.mc.field_71439_g.field_70167_r -= (double)this.ySize;
                    this.mc.field_71439_g.field_70163_u -= (double)this.ySize;
                    this.mc.field_71439_g.eyeHeight = this.mc.field_71439_g.getDefaultEyeHeight();
                    this.shiftedPosY = true;
                }
            } else if (this.shiftedPosY) {
                this.shiftedPosY = false;
                this.mc.field_71439_g.field_70137_T += (double)this.ySize;
                this.mc.field_71439_g.field_70167_r += (double)this.ySize;
                this.mc.field_71439_g.field_70163_u += (double)this.ySize;
                this.mc.field_71439_g.eyeHeight = this.eyeHeight;
            }
        }
    }

    private FloatBuffer getFogColorBuffer() {
        if (this.fogColorBuffer == null) {
            this.fogColorBuffer = GLAllocation.func_74529_h((int)16);
            this.fogColorBuffer.put(1.0f).put(1.0f).put(1.0f);
            this.fogColorBuffer.flip();
        }
        return this.fogColorBuffer;
    }
}

