/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.coremod;

import de.teamlapen.vampirism.util.Logger;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class RenderClassTransformer
implements IClassTransformer {
    private static final String TAG = "RenderTransformer";
    private static final String CLASS_RENDER = "net.minecraft.client.renderer.entity.Render";
    private static final String CLASS_RENDER_NOTCH = "bno";
    private static final String METHOD_BET = "bindEntityTexture";
    private static final String METHOD_BET_SRG = "func_110777_b";
    private static final String METHOD_GET = "getEntityTexture";
    private static final String METHOD_GET_SRG = "func_110775_a";
    private static final String METHOD_BT = "bindTexture";
    private static final String METHOD_BT_SRG = "func_110776_a";

    public byte[] applyPatch(String name, byte[] basicClass, boolean obfuscated) {
        String betMethodName = "";
        String getMethodName = "";
        String btMethodName = "";
        if (obfuscated) {
            betMethodName = METHOD_BET_SRG;
            getMethodName = METHOD_GET_SRG;
            btMethodName = METHOD_BT_SRG;
        } else {
            betMethodName = METHOD_BET;
            getMethodName = METHOD_GET;
            btMethodName = METHOD_BT;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(betMethodName)) continue;
            Logger.d(TAG, "INSIDE bindEntityTexture METHOD", new Object[0]);
            InsnList toIn = new InsnList();
            LabelNode l0 = new LabelNode();
            toIn.add((AbstractInsnNode)l0);
            toIn.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toIn.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toIn.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toIn.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toIn.add((AbstractInsnNode)new MethodInsnNode(182, CLASS_RENDER.replace('.', '/'), getMethodName, "(Lnet/minecraft/entity/Entity;)Lnet/minecraft/util/ResourceLocation;", false));
            toIn.add((AbstractInsnNode)new MethodInsnNode(184, "de/teamlapen/vampirism/coremod/CoreHandler", "checkVampireTexture", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/util/ResourceLocation;", false));
            toIn.add((AbstractInsnNode)new MethodInsnNode(182, CLASS_RENDER.replace('.', '/'), btMethodName, "(Lnet/minecraft/util/ResourceLocation;)V", false));
            LabelNode l1 = new LabelNode();
            toIn.add((AbstractInsnNode)l1);
            toIn.add((AbstractInsnNode)new InsnNode(177));
            m.instructions.insert(toIn);
            Logger.d(TAG, "PATCH COMPLETE", new Object[0]);
            break;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.equals(CLASS_RENDER_NOTCH)) {
            Logger.i(TAG, "INSIDE OBFUSCATED RENDER CLASS - ABOUT TO PATCH: %s", name);
            return this.applyPatch(name, basicClass, true);
        }
        if (name.equals(CLASS_RENDER)) {
            Logger.i(TAG, "INSIDE RENDER CLASS - ABOUT TO PATCH: %s", name);
            return this.applyPatch(name, basicClass, false);
        }
        return basicClass;
    }
}

