/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import de.teamlapen.vampirism.ModBlocks;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.EntityBlindingBat;
import de.teamlapen.vampirism.entity.EntityDefaultVampireWithMinion;
import de.teamlapen.vampirism.entity.ai.DraculaAIHeal;
import de.teamlapen.vampirism.entity.minions.EntitySaveableVampireMinion;
import de.teamlapen.vampirism.entity.minions.EntityVampireMinion;
import de.teamlapen.vampirism.generation.castle.CastlePositionData;
import de.teamlapen.vampirism.network.SpawnCustomParticlePacket;
import de.teamlapen.vampirism.tileEntity.TileEntityBloodAltar2;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.VampireLordData;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import org.eclipse.jdt.annotation.NonNull;

public class EntityDracula
extends EntityDefaultVampireWithMinion
implements IBossDisplayData {
    private static final int DISAPPEAR_DELAY = 200;
    private static final int TELEPORT_THRESHOLD = 30;
    private static final int TELEPORT_DELAY = 80;
    private int disappearDelay;
    private int teleportDelay = 0;
    private final int maxTeleportDistanceX = 16;
    private final int maxTeleportDistanceY = 3;
    private final int maxTeleportDistanceZ = 16;
    private int damageCounter = 0;
    private static final String TAG = "Dracula";

    public EntityDracula(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DraculaAIHeal(this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false));
        this.field_70728_aV = 100;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BALANCE.MOBPROP.DRACULA_MAX_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(BALANCE.MOBPROP.DRACULA_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BALANCE.MOBPROP.DRACULA_MOVEMENT_SPEED);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    public void makeDisappear() {
        if (this.disappearDelay == 0) {
            this.disappearDelay = 200;
        }
    }

    @Override
    protected void attackedEntityAsMob(EntityLivingBase entity) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 2));
            entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 50));
            if (this.field_70146_Z.nextBoolean()) {
                entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 120));
            }
        }
    }

    public void func_70645_a(DamageSource src) {
        if (src.func_76364_f() instanceof EntityPlayer) {
            boolean flag = VampireLordData.get(this.field_70170_p).makeLord((EntityPlayer)src.func_76364_f());
            if (flag) {
                VampireLordData.get(this.field_70170_p).onDraculaDied();
            } else {
                VampireLordData.get(this.field_70170_p).setRegenerateCastleDim(true);
            }
            Logger.d(TAG, "Dracula (%s) was killed by a player", this);
        } else {
            CastlePositionData.Position pos = CastlePositionData.get(this.field_70170_p).findPosAtChunk(this.field_70176_ah, this.field_70164_aj, true);
            if (pos != null) {
                EntityDracula drac = (EntityDracula)EntityList.func_75620_a((String)"vampirism.dracula", (World)this.field_70170_p);
                boolean flag = Helper.spawnEntityInWorld(this.field_70170_p, AxisAlignedBB.func_72330_a((double)(pos.getLowerMainCastle().field_77276_a << 4), (double)pos.getHeight(), (double)(pos.getLowerMainCastle().field_77276_a << 4), (double)(pos.getUpperMainCastle().field_77276_a << 4), (double)(pos.getHeight() + 10), (double)(pos.getUpperMainCastle().field_77275_b << 4)), (Entity)drac, 10);
                if (flag) {
                    drac.makeCastleLord(pos);
                    drac.func_70606_j(10.0f);
                    Logger.i(TAG, "Dracula (%s) died inside a castle, but could be respawned", this);
                } else {
                    drac.func_70106_y();
                    VampireLordData.get(this.field_70170_p).setRegenerateCastleDim(true);
                    Logger.w(TAG, "Dracula (%s) died inside a castle and could not be respawned -> regenerate dimension", this);
                }
            } else {
                Logger.w(TAG, "Dracula (%s) died outside of a castle", this);
            }
        }
    }

    @Override
    public boolean func_110173_bK() {
        return super.func_110173_bK();
    }

    public void func_70074_a(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.restoreOnPlayerKill((EntityPlayer)entity);
        }
    }

    public void restoreOnPlayerKill(EntityPlayer player) {
        this.func_70606_j(this.func_110138_aP());
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("player_id", this.func_145782_y());
        data.func_74757_a("direct", true);
        VampirismMod.modChannel.sendToAll((IMessage)new SpawnCustomParticlePacket(0, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70161_v), MathHelper.func_76128_c((double)this.field_70161_v), 40, data));
        int x = (int)(this.field_70165_t - 25.0);
        while ((double)x < this.field_70165_t + 25.0) {
            int y = (int)(this.field_70163_u - 5.0);
            while ((double)y < this.field_70163_u + 10.0) {
                int z = (int)(this.field_70161_v - 25.0);
                while ((double)z < this.field_70161_v + 25.0) {
                    if (((Object)((Object)ModBlocks.bloodAltar2)).equals(this.field_70170_p.func_147439_a(x, y, z))) {
                        ((TileEntityBloodAltar2)this.field_70170_p.func_147438_o(x, y, z)).removeBlood(100);
                        ((TileEntityBloodAltar2)this.field_70170_p.func_147438_o(x, y, z)).addBlood(this.field_70146_Z.nextInt(100));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.8) {
            this.damageCounter = (int)((float)this.damageCounter + p_70097_2_ * 2.0f);
            if (this.damageCounter > 30 && !this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.damageCounter = 0;
                } else if (this.teleportRandomly()) {
                    this.damageCounter = 0;
                }
            }
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    @Override
    public void func_70636_d() {
        this.field_70703_bu = false;
        if (this.field_70789_a != null && this.field_70146_Z.nextInt(300) == 0) {
            this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            EntityVampireMinion minion;
            EntitySaveableVampireMinion entity;
            if (this.disappearDelay > 0 && --this.disappearDelay == 1) {
                this.teleportAway();
            }
            if (this.teleportDelay > 0) {
                --this.teleportDelay;
            }
            if (this.func_70090_H() || this.func_70058_J()) {
                this.teleportRandomly();
            }
            if (this.field_70173_aa % 60 == 0) {
                if (this.damageCounter > 30) {
                    if (this.teleportRandomly()) {
                        this.damageCounter = 0;
                    }
                } else {
                    this.damageCounter = 0;
                }
            }
            if (this.field_70789_a != null && this.field_70789_a instanceof EntityPlayer && this.getMinionHandler().getMinionCount() < 4 && this.field_70146_Z.nextInt(80) == 0 && (entity = (EntitySaveableVampireMinion)Helper.spawnEntityBehindEntity((EntityLivingBase)this.field_70789_a, "vampirism.vampireMinionS")) != null) {
                entity.setLord(this);
                entity.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 20000, 2));
                this.minionInHomeDist(entity);
            }
            if (this.field_70173_aa % 100 == 0 && this.func_110175_bO() && this.getMinionHandler().getMinionCount() < 1 && (minion = (EntityVampireMinion)Helper.spawnEntityInWorld(this.field_70170_p, this.getHome(), "vampirism.vampireMinionS", 3)) != null) {
                minion.setLord(this);
                minion.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 20000, 3));
            }
        }
        if (this.func_110143_aJ() > (float)(DraculaAIHeal.THRESHOLD * 2) && BALANCE.MOBPROP.DRACULA_REGENERATE_SECS >= 0 && this.field_70173_aa % (BALANCE.MOBPROP.DRACULA_REGENERATE_SECS * 20) == 0 && (this.func_142013_aG() == 0 || this.func_142013_aG() - this.field_70173_aa > 100)) {
            this.func_70691_i(5.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.isGettingSundamage()) {
            this.makeDisappear();
        }
        super.func_70636_d();
    }

    private boolean minionInHomeDist(EntityCreature minion) {
        if (this.func_110175_bO() && this.func_110176_b(MathHelper.func_76128_c((double)minion.field_70165_t), MathHelper.func_76128_c((double)minion.field_70163_u), MathHelper.func_76128_c((double)minion.field_70161_v))) {
            minion.func_70106_y();
            return false;
        }
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.disappearDelay = nbt.func_74762_e("ddelay");
    }

    private boolean teleportRandomly() {
        if (this.teleportDelay > 0) {
            return false;
        }
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        double d1 = this.field_70163_u + ((double)this.field_70146_Z.nextInt(4) - 1.5);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        if (this.func_110176_b(MathHelper.func_76128_c((double)d0), MathHelper.func_76128_c((double)d1), MathHelper.func_76128_c((double)d2)) && Helper.teleportTo((EntityLiving)this, d0, d1, d2, true)) {
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 60));
                this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 60, 2));
                this.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 60, 2));
                this.summonBats();
            }
            this.teleportDelay = 80;
            return true;
        }
        if (this.field_70146_Z.nextBoolean()) {
            this.teleportRandomly();
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("ddelay", this.disappearDelay);
    }

    public void makeCastleLord(@NonNull CastlePositionData.Position pos) {
        Logger.d(TAG, "Set draculas home pos", new Object[0]);
        ChunkCoordIntPair lc = pos.getLowerMainCastle();
        ChunkCoordIntPair uc = pos.getUpperMainCastle();
        if (lc == null || uc == null) {
            Logger.w(TAG, "Pos %s does not contain lc or uc when setting home", new Object[]{pos});
            return;
        }
        this.setHome(AxisAlignedBB.func_72330_a((double)(lc.field_77276_a << 4), (double)(pos.getHeight() - 1), (double)(lc.field_77275_b << 4), (double)((uc.field_77276_a << 4) + 15), (double)(pos.getHeight() + 5), (double)((uc.field_77275_b << 4) + 15)));
    }

    private void summonBats() {
        for (int i = 0; i < BALANCE.VP_SKILLS.SUMMON_BAT_COUNT; ++i) {
            Entity e = EntityList.func_75620_a((String)"vampirism.blinding_bat", (World)this.field_70170_p);
            ((EntityBlindingBat)e).restrictLiveSpan();
            e.func_82149_j((Entity)this);
            this.field_70170_p.func_72838_d(e);
        }
    }

    public void freezeSkill() {
        List l = this.field_70170_p.func_94576_a((Entity)this, this.field_70121_D.func_72314_b(10.0, 5.0, 10.0), this.getMinionHandler().getLivingBaseSelectorExludingMinions());
        for (Object o : l) {
            if (o instanceof EntityBlindingBat) continue;
            EntityLivingBase e = (EntityLivingBase)o;
            e.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, BALANCE.VP_SKILLS.FREEZE_DURATION * 20, 10));
            e.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, BALANCE.VP_SKILLS.FREEZE_DURATION * 20, 10));
            e.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, BALANCE.VP_SKILLS.FREEZE_DURATION * 20, 128));
            Helper.spawnParticlesAroundEntity(e, "snowshovel", 1.5, 40);
        }
    }

    @Override
    public int getMaxMinionCount() {
        return 100;
    }
}

