/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.entity.EntityHunterBase;
import de.teamlapen.vampirism.entity.EntityVampire;
import de.teamlapen.vampirism.entity.EntityVampireBase;
import de.teamlapen.vampirism.entity.ai.HunterAIDefendVillage;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.network.ISyncable;
import de.teamlapen.vampirism.network.UpdateEntityPacket;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.DifficultyCalculator;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public class EntityVampireHunter
extends EntityHunterBase
implements ISyncable,
DifficultyCalculator.IAdjustableLevel {
    private static final int MAX_LEVEL = 4;
    private boolean isLookingForHome;
    protected int level = 0;

    public EntityVampireHunter(World p_i1738_1_) {
        super(p_i1738_1_);
        this.func_70661_as().func_75498_b(true);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityVampire.class, 1.1, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.1, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityCreature.class, 0.9, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                if (entity instanceof EntityPlayer) {
                    return VampirePlayer.get((EntityPlayer)entity).getLevel() > BALANCE.VAMPIRE_HUNTER_ATTACK_LEVEL;
                }
                return false;
            }
        }));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVampireBase.class, 0, true));
        this.isLookingForHome = true;
        this.func_96120_a(0, 0.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes();
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        if (recentlyHit && this.field_70146_Z.nextInt(3) == 0) {
            this.func_145779_a((Item)ModItems.humanHeart, 1);
        }
    }

    protected boolean func_70692_ba() {
        return this.isLookingForHome && super.func_70692_ba();
    }

    public float func_70783_a(int p_70783_1_, int p_70783_2_, int p_70783_3_) {
        return 0.5f;
    }

    protected Item func_146068_u() {
        return null;
    }

    public Village getHomeVillage() {
        if (this.isLookingForHome) {
            return null;
        }
        ChunkCoordinates cc = this.func_110172_bL();
        return this.field_70170_p.field_72982_D.func_75550_a(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, 10);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("level")) {
            this.level = nbt.func_74762_e("level");
        }
    }

    protected void func_70609_aI() {
        this.field_70170_p.func_72869_a("depthsuspend", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5, 0.5, 0.5);
        this.field_70170_p.func_72869_a("mobSpellAmbient", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5, 0.5, 0.5);
        super.func_70609_aI();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.loadUpdateFromNBT(nbt);
        if (nbt.func_74764_b("looking_for_home")) {
            this.isLookingForHome = nbt.func_74767_n("looking_for_home");
            if (this.func_110175_bO()) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
            }
        }
    }

    public void setVillageArea(int p_110171_1_, int p_110171_2_, int p_110171_3_, int p_110171_4_) {
        super.func_110171_b(p_110171_1_, p_110171_2_, p_110171_3_, p_110171_4_);
        if (this.isLookingForHome) {
            this.isLookingForHome = false;
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, (double)0.9f, false));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new HunterAIDefendVillage(this));
        }
    }

    public void setCampArea(AxisAlignedBB box) {
        super.setHome(box);
        this.saveHome = true;
        this.isLookingForHome = false;
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
    }

    @Override
    public void setLevel(int level) {
        this.setLevel(level, false);
    }

    public void setLevel(int l, boolean sync) {
        if (l > 0 && l != this.level) {
            this.level = l;
            this.updateEntityAttributes();
            if (this.level == 1) {
                this.func_70062_b(0, new ItemStack((Item)ModItems.pitchfork));
            } else {
                this.func_70062_b(0, null);
            }
            if (this.level == 4) {
                this.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 100000, 1));
                this.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10000, 2));
            }
            if (sync && !this.field_70170_p.field_72995_K) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("level", this.level);
                Helper.sendPacketToPlayersAround(new UpdateEntityPacket((Entity)this, nbt), (Entity)this);
            }
        }
    }

    @Override
    public int suggestLevel(DifficultyCalculator.Difficulty d) {
        if (d.maxLevel == 14 && this.field_70146_Z.nextInt(d.maxLevel - d.avgLevel + 1) == 0) {
            return 4;
        }
        return this.field_70146_Z.nextInt(2) + 2;
    }

    protected void updateEntityAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BALANCE.MOBPROP.VAMPIRE_HUNTER_MAX_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(BALANCE.MOBPROP.VAMPIRE_HUNTER_ATTACK_DAMAGE * (double)this.level);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BALANCE.MOBPROP.VAMPIRE_HUNTER_MOVEMENT_SPEED);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("level", this.level);
        if (this.saveHome) {
            nbt.func_74757_a("looking_for_home", this.isLookingForHome);
        }
    }

    public boolean isLookingForHome() {
        return this.isLookingForHome;
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound nbt) {
        this.func_70014_b(nbt);
    }
}

