/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import de.teamlapen.vampirism.ModBlocks;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.EntityDracula;
import de.teamlapen.vampirism.network.SpawnCustomParticlePacket;
import de.teamlapen.vampirism.tileEntity.TileEntityBloodAltar2;
import de.teamlapen.vampirism.util.BALANCE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;

public class DraculaAIHeal
extends EntityAIBase {
    public static final int THRESHOLD = (int)(BALANCE.MOBPROP.DRACULA_MAX_HEALTH / 3.0);
    protected EntityDracula dracula;
    boolean checked;
    private boolean atAltar;
    private PathEntity path;
    private ChunkCoordinates currentPos;
    private List<ChunkCoordinates> positions = new ArrayList<ChunkCoordinates>();

    public DraculaAIHeal(EntityDracula dracula) {
        this.dracula = dracula;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.dracula.field_70170_p == null) {
            return false;
        }
        if (this.dracula.field_70173_aa % 10 != 0) {
            return false;
        }
        if (this.dracula.func_110143_aJ() < (float)THRESHOLD) {
            if (!this.checked) {
                this.checkForAltars();
            } else {
                this.updateAltars();
            }
            if (this.positions.size() > 0) {
                this.currentPos = this.positions.get(this.dracula.func_70681_au().nextInt(this.positions.size()));
                this.path = this.dracula.func_70661_as().func_75488_a((double)this.currentPos.field_71574_a, (double)this.currentPos.field_71572_b, (double)this.currentPos.field_71573_c);
                if (this.path != null) {
                    return true;
                }
                this.currentPos = null;
                this.path = null;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.dracula.func_110143_aJ() < (float)THRESHOLD + (this.dracula.func_110138_aP() - (float)THRESHOLD) / 2.0f && this.currentPos != null) {
            if (this.atAltar || this.dracula.field_70173_aa % 40 != 0 && !this.dracula.func_70661_as().func_75500_f()) {
                return true;
            }
            if (this.dracula.func_70661_as().func_75492_a((double)this.currentPos.field_71574_a, (double)this.currentPos.field_71572_b, (double)this.currentPos.field_71573_c, (double)0.9f)) {
                return true;
            }
        }
        return false;
    }

    public void func_75249_e() {
        this.dracula.func_70661_as().func_75484_a(this.path, (double)0.9f);
        this.path = null;
        this.atAltar = false;
        this.dracula.freezeSkill();
    }

    public void func_75246_d() {
        boolean remove = false;
        if (this.dracula.func_70092_e(this.currentPos.field_71574_a, this.currentPos.field_71572_b, this.currentPos.field_71573_c) < 8.0) {
            this.atAltar = true;
            this.dracula.func_70661_as().func_75499_g();
            if (this.isAltarAtPos(this.currentPos)) {
                TileEntityBloodAltar2 altar = this.getAltarTile(this.currentPos);
                if (altar.getBloodAmount() > 0) {
                    if (this.dracula.field_70173_aa % 5 == 0) {
                        NBTTagCompound data = new NBTTagCompound();
                        data.func_74768_a("player_id", this.dracula.func_145782_y());
                        data.func_74757_a("direct", true);
                        VampirismMod.modChannel.sendToAll((IMessage)new SpawnCustomParticlePacket(0, this.currentPos.field_71574_a, (double)this.currentPos.field_71572_b + 0.5, this.currentPos.field_71573_c, 2, data));
                        altar.removeBlood(5);
                        this.dracula.func_70691_i(10.0f);
                        this.dracula.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 6, 2));
                    }
                } else {
                    remove = true;
                }
            } else {
                remove = true;
            }
        } else {
            this.atAltar = false;
        }
        if (remove) {
            this.positions.remove(this.currentPos);
            this.currentPos = null;
        }
    }

    public void func_75251_c() {
        this.currentPos = null;
    }

    private void checkForAltars() {
        int x = (int)(this.dracula.field_70165_t - 25.0);
        while ((double)x < this.dracula.field_70165_t + 25.0) {
            int y = (int)(this.dracula.field_70163_u - 5.0);
            while ((double)y < this.dracula.field_70163_u + 10.0) {
                int z = (int)(this.dracula.field_70161_v - 25.0);
                while ((double)z < this.dracula.field_70161_v + 25.0) {
                    if (((Object)((Object)ModBlocks.bloodAltar2)).equals(this.dracula.field_70170_p.func_147439_a(x, y, z)) && ((TileEntityBloodAltar2)this.dracula.field_70170_p.func_147438_o(x, y, z)).getBloodAmount() > 0 && (!this.dracula.func_110175_bO() || this.dracula.func_110176_b(x, y, z))) {
                        this.positions.add(new ChunkCoordinates(x, y, z));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.checked = true;
    }

    private void updateAltars() {
        Iterator<ChunkCoordinates> iterator = this.positions.iterator();
        while (iterator.hasNext()) {
            ChunkCoordinates pos = iterator.next();
            if (this.isAltarAtPos(pos) && this.getAltarTile(pos).getBloodAmount() > 0) continue;
            iterator.remove();
        }
    }

    private boolean isAltarAtPos(ChunkCoordinates pos) {
        return ((Object)((Object)ModBlocks.bloodAltar2)).equals(this.dracula.field_70170_p.func_147439_a(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c));
    }

    private TileEntityBloodAltar2 getAltarTile(ChunkCoordinates pos) {
        return (TileEntityBloodAltar2)this.dracula.field_70170_p.func_147438_o(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
    }
}

