/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minions;

import de.teamlapen.vampirism.entity.minions.DefaultMinionCommand;
import de.teamlapen.vampirism.entity.minions.EntityRemoteVampireMinion;
import de.teamlapen.vampirism.entity.minions.MinionHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;

public class DefendAreaCommand
extends DefaultMinionCommand {
    protected final EntityRemoteVampireMinion minion;
    protected final EntityAIBase stay;
    protected final EntityAIBase attack;
    protected final EntityAITarget target;
    private final int MAX_DISTANCE = 7;
    private ChunkCoordinates oldHome;
    private int oldDist;

    public DefendAreaCommand(int id, EntityRemoteVampireMinion minion) {
        super(id);
        this.minion = minion;
        this.stay = new EntityAIMoveTowardsRestriction(minion.getRepresentingEntity(), 1.0);
        this.attack = new EntityAIAttackOnCollide((EntityCreature)minion, EntityLivingBase.class, 1.0, false);
        this.target = new EntityAINearestAttackableTarget(minion.getRepresentingEntity(), EntityMob.class, 0, true, true, MinionHelper.getEntitySelectorForMinion(minion, EntityMob.class, false, true));
    }

    @Override
    public int getMinU() {
        return 96;
    }

    @Override
    public int getMinV() {
        return 0;
    }

    @Override
    public String getUnlocalizedName() {
        return "minioncommand.vampirism.defendarea";
    }

    @Override
    public void onActivated() {
        this.minion.field_70714_bg.func_75776_a(1, this.stay);
        this.minion.field_70714_bg.func_75776_a(2, this.attack);
        this.minion.field_70715_bh.func_75776_a(2, (EntityAIBase)this.target);
        if (this.minion.func_110175_bO()) {
            this.oldHome = this.minion.func_110172_bL();
            this.oldDist = MathHelper.func_76141_d((float)this.minion.func_110174_bM());
        }
        this.minion.func_110171_b(MathHelper.func_76128_c((double)this.minion.field_70165_t), MathHelper.func_76128_c((double)this.minion.field_70163_u), MathHelper.func_76128_c((double)this.minion.field_70161_v), 7);
    }

    @Override
    public void onDeactivated() {
        this.minion.field_70714_bg.func_85156_a(this.stay);
        this.minion.field_70714_bg.func_85156_a(this.attack);
        this.minion.field_70715_bh.func_85156_a((EntityAIBase)this.target);
        if (this.oldHome != null) {
            this.minion.func_110171_b(this.oldHome.field_71574_a, this.oldHome.field_71572_b, this.oldHome.field_71573_c, this.oldDist);
        } else {
            this.minion.func_110177_bN();
        }
        this.oldHome = null;
    }
}

