/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minions;

import de.teamlapen.vampirism.entity.VampireMob;
import de.teamlapen.vampirism.entity.minions.EntitySaveableVampireMinion;
import de.teamlapen.vampirism.entity.minions.IMinion;
import de.teamlapen.vampirism.entity.minions.IMinionLord;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.eclipse.jdt.annotation.NonNull;

public class SaveableMinionHandler {
    private static final String TAG = "MinionHandler";
    private final ArrayList<IMinion> minions = new ArrayList();
    private ArrayList<IMinion> loadedMinions;
    private final IMinionLord lord;
    private final IEntitySelector livingBaseSelector;

    public SaveableMinionHandler(final @NonNull IMinionLord lord) {
        this.lord = lord;
        this.livingBaseSelector = new IEntitySelector(){

            public boolean func_82704_a(Entity e) {
                VampireMob mob;
                if (!(e instanceof EntityLivingBase)) {
                    return false;
                }
                if (e instanceof IMinion && lord.equals(((IMinion)e).getLord())) {
                    return false;
                }
                return !(e instanceof EntityCreature) || !(mob = VampireMob.get((EntityCreature)e)).isMinion() || !lord.equals(mob.getLord());
            }
        };
    }

    public void addLoadedMinions() {
        if (this.loadedMinions == null) {
            return;
        }
        ArrayList<IMinion> list = this.loadedMinions;
        this.loadedMinions = null;
        Logger.d(TAG, "Going to add " + list.size(), new Object[0]);
        World world = this.lord.getRepresentingEntity().field_70170_p;
        for (IMinion m : list) {
            EntityCreature entity = m.getRepresentingEntity();
            entity.field_98038_p = true;
            world.func_72838_d((Entity)entity);
            ((IMinion)entity).setLord(this.lord);
        }
        Logger.d(TAG, "Added " + list.size() + " minions", new Object[0]);
        list.clear();
    }

    public void checkMinions() {
        Iterator<IMinion> it = this.minions.iterator();
        while (it.hasNext()) {
            IMinion m = it.next();
            if (!m.getRepresentingEntity().field_70128_L && this.lord.equals(m.getLord())) continue;
            it.remove();
        }
    }

    public IEntitySelector getLivingBaseSelectorExludingMinions() {
        return this.livingBaseSelector;
    }

    public int getMinionCount() {
        return this.minions.size();
    }

    @Deprecated
    public ArrayList<IMinion> getMinionListForDebug() {
        return this.minions;
    }

    public int getMinionsLeft() {
        return Math.max(this.lord.getMaxMinionCount() - this.getMinionCount(), 0);
    }

    public NBTTagList getMinionsToSave() {
        NBTTagList list = new NBTTagList();
        for (IMinion m : this.minions) {
            if (!m.shouldBeSavedWithLord()) continue;
            EntityCreature e = m.getRepresentingEntity();
            boolean dead = e.field_70128_L;
            e.field_70128_L = false;
            NBTTagCompound nbt = new NBTTagCompound();
            m.getRepresentingEntity().func_98035_c(nbt);
            list.func_74742_a((NBTBase)nbt);
            if (!dead) continue;
            e.field_70128_L = true;
        }
        return list;
    }

    public void killMinions(boolean instant) {
        for (IMinion m : this.minions) {
            EntityCreature e = m.getRepresentingEntity();
            if (instant) {
                e.func_70106_y();
                continue;
            }
            e.func_70097_a(DamageSource.field_76376_m, 100.0f);
        }
    }

    public void loadMinions(NBTTagList list) {
        if (list == null || list.func_74745_c() == 0) {
            return;
        }
        this.loadedMinions = new ArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = list.func_150305_b(i);
            Entity entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.lord.getRepresentingEntity().field_70170_p);
            if (entity == null || !(entity instanceof IMinion)) continue;
            entity.field_70163_u += (double)entity.field_70131_O;
            this.loadedMinions.add((IMinion)entity);
        }
    }

    public void notifyCall(Call c) {
        for (IMinion m : this.minions) {
            if (!(m instanceof EntitySaveableVampireMinion)) continue;
            ((EntitySaveableVampireMinion)m).onCall(c);
        }
    }

    public void registerMinion(IMinion m, boolean force) {
        if (!m.shouldBeSavedWithLord()) {
            Logger.e(TAG, "Trying to register a non saveable minion %s at minion handler %s. This SHOULD NOT happen", m, this);
        } else {
            this.minions.add(m);
        }
    }

    public void teleportMinionsToLord() {
        EntityCreature e;
        ArrayList<IMinion> toTeleportDim = new ArrayList<IMinion>();
        EntityLivingBase e1 = this.lord.getRepresentingEntity();
        Iterator<IMinion> it = this.minions.iterator();
        while (it.hasNext()) {
            IMinion m = it.next();
            EntityCreature e2 = m.getRepresentingEntity();
            if (e1.field_71093_bK == e2.field_71093_bK) continue;
            toTeleportDim.add(m);
            it.remove();
        }
        for (IMinion m : this.minions) {
            e = m.getRepresentingEntity();
            e.func_82149_j((Entity)e1);
        }
        for (IMinion m : toTeleportDim) {
            e = m.getRepresentingEntity();
            e.func_71027_c(e1.field_71093_bK);
            e.field_71088_bW = e.func_82147_ab();
        }
    }

    public String toString() {
        return "MinionHandler for " + this.lord.toString() + " with " + this.getMinionCount() + " minions";
    }

    public void unregisterMinion(IMinion m) {
        this.minions.remove(m);
    }

    public static enum Call {
        DEFEND_LORD,
        ATTACK_NON_PLAYER,
        ATTACK,
        FOLLOW;

    }
}

