/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player;

import de.teamlapen.vampirism.util.BALANCE;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;

public abstract class PlayerModifiers {
    public static final String TAG = "PlayerModifier";
    public static final UUID speedModifierUUID = UUID.fromString("0FCBF922-DBEC-492A-82F5-99F73AFF5065");
    public static final UUID healthModifierUUID = UUID.fromString("56C17EFE-E3EC-4E27-A12F-99D2FE927B70");
    public static final UUID damageModifierUUID = UUID.fromString("7600D8C4-3517-40BE-8CB1-359D46705A0F");

    public static void addJumpBoost(int level, EntityPlayer p) {
        p.field_70181_x += PlayerModifiers.calculateModifierValue(level, BALANCE.VP_MODIFIERS.JUMP_LCAP, BALANCE.VP_MODIFIERS.JUMP_MAX_BOOST, BALANCE.VP_MODIFIERS.JUMP_TYPE);
    }

    public static void applyModifiers(int level, EntityPlayer p) {
        double m = 0.0;
        IAttributeInstance movement = p.func_110148_a(SharedMonsterAttributes.field_111263_d);
        PlayerModifiers.rmMod(movement, speedModifierUUID);
        m = PlayerModifiers.calculateModifierValue(level, BALANCE.VP_MODIFIERS.SPEED_LCAP, BALANCE.VP_MODIFIERS.SPEED_MAX_MOD, BALANCE.VP_MODIFIERS.SPEED_TYPE);
        movement.func_111121_a(new AttributeModifier(speedModifierUUID, "Vampire Speed Bonus", m, 2).func_111168_a(false));
        IAttributeInstance health = p.func_110148_a(SharedMonsterAttributes.field_111267_a);
        PlayerModifiers.rmMod(health, healthModifierUUID);
        m = PlayerModifiers.calculateModifierValue(level, BALANCE.VP_MODIFIERS.HEALTH_LCAP, BALANCE.VP_MODIFIERS.HEALTH_MAX_MOD, BALANCE.VP_MODIFIERS.HEALTH_TYPE);
        health.func_111121_a(new AttributeModifier(healthModifierUUID, "Vampire Health Bonus", m, 2).func_111168_a(false));
        IAttributeInstance damage = p.func_110148_a(SharedMonsterAttributes.field_111264_e);
        PlayerModifiers.rmMod(damage, damageModifierUUID);
        m = PlayerModifiers.calculateModifierValue(level, BALANCE.VP_MODIFIERS.STRENGTH_LCAP, BALANCE.VP_MODIFIERS.STRENGTH_MAX_MOD, BALANCE.VP_MODIFIERS.STRENGTH_TYPE);
        damage.func_111121_a(new AttributeModifier(damageModifierUUID, "Vampire Strength Bonus", m, 2).func_111168_a(false));
    }

    private static double calculateModifierValue(int level, int lcap, double maxMod, double type) {
        return Math.pow(level > lcap ? lcap : level, type) / Math.pow(lcap, type) * maxMod;
    }

    public static void rmMod(IAttributeInstance att, UUID uuid) {
        AttributeModifier m = att.func_111127_a(uuid);
        if (m != null) {
            att.func_111124_b(m);
        }
    }
}

