/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import de.teamlapen.vampirism.entity.player.PlayerModifiers;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.entity.player.skills.DefaultSkill;
import de.teamlapen.vampirism.entity.player.skills.ILastingSkill;
import de.teamlapen.vampirism.entity.player.skills.Skills;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class BatSkill
extends DefaultSkill
implements ILastingSkill {
    public static final float BAT_WIDTH = 0.5f;
    public static final float BAT_HEIGHT = 0.8f;
    public static final float BAT_EYE_HEIGHT = 0.68f;
    public static final float PLAYER_WIDTH = 0.6f;
    public static final float PLAYER_HEIGHT = 1.8f;
    public final UUID speedModifierUUID = UUID.fromString("eb7a2e48-ce60-4629-b5f5-7a196d1035af");
    public final UUID healthModifierUUID = UUID.fromString("4392fccb-4bfd-4290-b2e6-5cc91429053c");

    @Override
    public boolean canBeUsedBy(VampirePlayer vampire, EntityPlayer player) {
        return !vampire.gettingSundamage() && !vampire.isSkillActive(Skills.vampireRage);
    }

    @Override
    public int getCooldown() {
        return 1;
    }

    @Override
    public int getDuration(int level) {
        return 100000;
    }

    @Override
    public int getMinLevel() {
        return 4;
    }

    @Override
    public int getMinU() {
        return 64;
    }

    @Override
    public int getMinV() {
        return 0;
    }

    @Override
    public String getUnlocalizedName() {
        return "skill.vampirism.bat_skill";
    }

    @Override
    public boolean onActivated(VampirePlayer vampire, EntityPlayer player) {
        this.setModifier(player, true);
        double reduc = player.func_110143_aJ() - player.func_110138_aP();
        if (reduc < 0.0) {
            reduc = 0.0;
        }
        player.func_70606_j((float)((double)player.func_110143_aJ() - reduc));
        vampire.getExtraDataTag().func_74780_a("bat_skill_health", reduc);
        return true;
    }

    @Override
    public void onDeactivated(VampirePlayer vampire, EntityPlayer player) {
        this.setModifier(player, false);
        if (player.func_110143_aJ() > 0.0f) {
            player.func_70606_j((float)(vampire.getExtraDataTag().func_74769_h("bat_skill_health") + (double)player.func_110143_aJ()));
            if (player.field_70122_E) {
                player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 20, 100));
            }
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 60, 100));
        }
    }

    @Override
    public void onReActivated(VampirePlayer vampire, EntityPlayer player) {
        this.setModifier(player, true);
    }

    @Override
    public boolean onUpdate(VampirePlayer vampire, EntityPlayer player) {
        if (vampire.gettingSundamage() && !player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.cant_fly_day", new Object[0]));
            return true;
        }
        return false;
    }

    private void setModifier(EntityPlayer player, boolean enabled) {
        if (enabled) {
            IAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (health.func_111127_a(this.healthModifierUUID) == null) {
                health.func_111121_a(new AttributeModifier(this.healthModifierUUID, "Bat Health Reduction", -0.9, 2).func_111168_a(false));
            }
            player.field_71075_bZ.field_75101_c = true;
            player.field_71075_bZ.field_75100_b = true;
            player.func_71016_p();
        } else {
            IAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            PlayerModifiers.rmMod(health, this.healthModifierUUID);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
            }
            player.field_71075_bZ.field_75100_b = false;
            player.func_71016_p();
        }
    }
}

