/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation;

import cpw.mods.fml.common.IWorldGenerator;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.ModBiomes;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.EntityVampireHunter;
import de.teamlapen.vampirism.generation.castle.CastleGenerator;
import de.teamlapen.vampirism.generation.structures.GenerateBloodAltar;
import de.teamlapen.vampirism.generation.structures.GenerateHunterCamp;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.villages.VillageVampire;
import de.teamlapen.vampirism.villages.VillageVampireData;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenPlains;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenVampirism
implements IWorldGenerator {
    public static final CastleGenerator castleGenerator = new CastleGenerator();
    private final GenerateBloodAltar generateBloodAltar = new GenerateBloodAltar();
    private final GenerateHunterCamp generateHunterCamp = new GenerateHunterCamp();

    private void addEntities(World world, Random random, int x, int z) {
        if (world.field_73011_w.field_76577_b == WorldType.field_77138_c) {
            return;
        }
        try {
            int y = world.func_72976_f(x, z);
            Village v = world.field_72982_D.func_75550_a(x, y, z, 0);
            if (v == null) {
                return;
            }
            VillageVampire vv = VillageVampireData.get(world).getVillageVampire(v);
            if (vv == null) {
                return;
            }
            int spawnedHunter = world.func_72872_a(EntityVampireHunter.class, vv.getBoundingBox()).size();
            for (Entity e : Helper.spawnEntityInVillage(v, random.nextInt(3) - spawnedHunter, "vampirism.vampireHunter", world)) {
                ((EntityVampireHunter)e).setVillageArea(v.func_75577_a().field_71574_a, v.func_75577_a().field_71572_b, v.func_75577_a().field_71573_c, v.func_75568_b());
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void addStructures(World world, Random random, int x, int z) {
        int chance = random.nextInt(1000);
        boolean generatedStructure = false;
        BiomeGenBase biome = world.func_72959_q().func_76935_a(x, z);
        if (!(generatedStructure || chance >= BALANCE.ALTAR_1_SPAWN_CHANCE || biome != BiomeGenBase.field_76780_h && biome != BiomeGenBase.field_150585_R)) {
            int posX = x + random.nextInt(16);
            int posZ = z + random.nextInt(16);
            int posY = world.func_72976_f(posX + 1, posZ + 1);
            generatedStructure = this.generateBloodAltar.func_76484_a(world, random, posX, posY, posZ);
        }
        chance = random.nextInt(1000);
        int trees = biome.field_76760_I.field_76832_z;
        float bh = biome.field_76749_E;
        float prop = 1.0f;
        if (trees > 2 && trees < 11) {
            prop += (float)trees;
        }
        prop += bh * 5.0f;
        if (biome instanceof BiomeGenPlains) {
            prop *= 0.7f;
        }
        if (world.field_73011_w.field_76577_b.equals(WorldType.field_77138_c)) {
            prop = 0.2f;
        }
        if (!generatedStructure && !Configs.disable_hunter && (float)chance < (float)BALANCE.HUNTER_CAMP_SPAWN_CHANCE * prop && !biome.equals(ModBiomes.biomeVampireForest)) {
            float temp;
            int posX = x + random.nextInt(16);
            int posZ = z + random.nextInt(16);
            int posY = world.func_72976_f(x, z);
            if (world.func_147439_a(x, posY - 1, z).func_149688_o() == Material.field_151584_j) {
                --posY;
                while ((world.func_147439_a(x, posY, z).func_149688_o() == Material.field_151584_j || world.func_147437_c(x, posY, z)) && posY > 50) {
                    --posY;
                }
            }
            if (this.generateHunterCamp.isValidTemperature(temp = biome.func_150564_a(posX, posY, posZ))) {
                generatedStructure = this.generateHunterCamp.func_76484_a(world, random, posX, posY, posZ);
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX, chunkZ);
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX, chunkZ);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX, chunkZ);
            }
        }
        if (world.field_73011_w.field_76574_g == VampirismMod.castleDimensionId) {
            castleGenerator.checkBiome(world, chunkX, chunkZ, random, true);
        }
    }

    private void generateEnd(World world, Random random, int x, int z) {
    }

    private void generateNether(World world, Random random, int x, int z) {
    }

    private void generateSurface(World world, Random random, int x, int z) {
        this.addEntities(world, random, x << 12, z << 12);
        if (world.func_72912_H().func_76089_r()) {
            castleGenerator.checkBiome(world, x, z, random, false);
            this.addStructures(world, random, x << 4, z << 4);
        }
    }
}

