/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.castle;

import cpw.mods.fml.common.registry.GameRegistry;
import de.teamlapen.vampirism.util.Logger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlockList {
    public Block block;
    public String blockId;
    private final int[] meta;
    private LinkedList<BlockPosition> blockPositions;

    public BlockList(Block block, int[] meta) {
        this.block = block;
        this.blockPositions = new LinkedList();
        this.meta = meta;
    }

    public void addPosition(int x, int y, int z) {
        this.blockPositions.add(new BlockPosition(x, y, z));
    }

    public List<BlockPosition> getPositions() {
        return this.blockPositions;
    }

    public int getBlockMetaForRotation(int rotation) {
        if (rotation > 3) {
            rotation = 0;
        }
        return this.meta[rotation];
    }

    public void prepareForSave() {
        this.blockId = BlockList.getPairedIdForBlock(this.block);
        this.block = null;
    }

    public void finishLoad() {
        this.block = BlockList.getBlockForString(this.blockId);
        if (this.block == null) {
            Logger.w("BlockList", "Could not find block %s", this.blockId);
            this.block = Blocks.field_150348_b;
        }
        this.blockId = null;
    }

    public static String getPairedIdForBlock(Block block) {
        GameRegistry.UniqueIdentifier un = GameRegistry.findUniqueIdentifierFor((Block)block);
        String name = "";
        if (un != null) {
            name = un.modId + ":" + un.name;
        }
        return name;
    }

    public static Block getBlockForString(String str) {
        String[] parts = str.split(":");
        String modId = parts[0];
        String name = parts[1];
        return GameRegistry.findBlock((String)modId, (String)name);
    }

    public boolean equals(Block b, int[] meta) {
        return b.equals(this.block) && Arrays.equals(this.meta, meta);
    }

    public static class BlockPosition {
        public final int x;
        public final int y;
        public final int z;

        public BlockPosition(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

