/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.castle;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.teamlapen.vampirism.ModBiomes;
import de.teamlapen.vampirism.ModBlocks;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.biome.BiomeVampireForest;
import de.teamlapen.vampirism.generation.castle.BuildingTile;
import de.teamlapen.vampirism.generation.castle.CastlePositionData;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.ModdedEnumTypeAdapter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.annotation.Nullable;

public class CastleGenerator
extends WorldGenerator {
    private static final String TAG = "CastleGenerator";
    private static HashMap<String, BuildingTile> tileMap;
    private final int MAX_TRYS = 128;
    private final int MAX_CASTLES = 3;
    private final int MAX_SIZE = 6;
    private final int MIN_SIZE = 4;
    private final List biomes = new ArrayList();
    private String[][] tiles;
    private int[][][] houseDirs;
    private boolean pregenerating;

    public CastleGenerator() {
        this.biomes.add(ModBiomes.biomeVampireForest);
    }

    public static void loadTiles() {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapterFactory(ModdedEnumTypeAdapter.ENUM_FACTORY).create();
        tileMap = new HashMap();
        CastleGenerator.loadTile("wall", gson, tileMap);
        CastleGenerator.loadTile("flatDirt", gson, tileMap);
        CastleGenerator.loadTile("house1", gson, tileMap);
        CastleGenerator.loadTile("house2", gson, tileMap);
        CastleGenerator.loadTile("stables", gson, tileMap);
        CastleGenerator.loadTile("castlell", gson, tileMap);
        CastleGenerator.loadTile("castlelr", gson, tileMap);
        CastleGenerator.loadTile("castleur", gson, tileMap);
        CastleGenerator.loadTile("castleul", gson, tileMap);
        CastleGenerator.loadTile("blacksmith", gson, tileMap);
        CastleGenerator.loadTile("grave", gson, tileMap);
        CastleGenerator.loadTile("pasture", gson, tileMap);
        CastleGenerator.loadTile("entrancel", gson, tileMap);
        CastleGenerator.loadTile("entrancer", gson, tileMap);
        CastleGenerator.loadTile("path", gson, tileMap);
        CastleGenerator.loadTile("dirt2", gson, tileMap);
        CastleGenerator.loadTile("house3", gson, tileMap);
        CastleGenerator.loadTile("house4", gson, tileMap);
        CastleGenerator.loadTile("treasure", gson, tileMap);
        CastleGenerator.loadTile("wall_corner", gson, tileMap);
        CastleGenerator.loadTile("castle_lavall", gson, tileMap);
        CastleGenerator.loadTile("castle_lavaul", gson, tileMap);
        CastleGenerator.loadTile("castle_lavalr", gson, tileMap);
        CastleGenerator.loadTile("castle_lavaur", gson, tileMap);
        CastleGenerator.loadTile("castle_portalur", gson, tileMap);
        CastleGenerator.loadTile("castleul_button", gson, tileMap);
    }

    private static void loadTile(String name, Gson gson, Map<String, BuildingTile> addTo) {
        BuildingTile tile = CastleGenerator.loadTile(name, gson);
        if (tile != null) {
            addTo.put(name, tile);
        }
    }

    private static BuildingTile loadTile(String name, Gson gson) {
        BuildingTile tile = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(VampirismMod.class.getResourceAsStream("/assets/vampirism/building_tiles/" + name + ".json"));
            tile = (BuildingTile)gson.fromJson((Reader)inputStreamReader, BuildingTile.class);
            tile.finishLoading();
            inputStreamReader.close();
        }
        catch (IOException e) {
            Logger.e(TAG, e, "Failed to load tile %s", name);
        }
        catch (NullPointerException e) {
            Logger.e(TAG, e, "Did not find tile %s", name);
        }
        return tile;
    }

    public void checkBiome(World world, int chunkX, int chunkZ, Random rnd, boolean castleWorld) {
        CastlePositionData data = CastlePositionData.get(world);
        if (!data.checked) {
            if (castleWorld) {
                CastlePositionData.Position p = new CastlePositionData.Position(0, 0);
                p.setSize(6, 6);
                p.setDraculasDim();
                p.setHeight(36);
                data.positions.add(p);
            } else {
                data.positions.addAll(this.findPositions(world, rnd));
                if (data.positions.size() > 0) {
                    ListIterator<CastlePositionData.Position> iterator = data.positions.listIterator();
                    while (iterator.hasNext()) {
                        CastlePositionData.Position pos = iterator.next();
                        CastlePositionData.Position pos2 = this.optimizePosition(pos, world, rnd);
                        if (pos2 == null) {
                            Logger.d(TAG, "Dropping pos %s because it is to small", new Object[]{pos});
                            iterator.remove();
                            continue;
                        }
                        if (pos2.equals((Object)pos)) continue;
                        pos = pos2;
                        iterator.set(pos2);
                    }
                }
                if (data.positions.size() == 0) {
                    Logger.w(TAG, "Did not find any positions", new Object[0]);
                    if (world.field_73011_w.field_76574_g == 0) {
                        VampirismMod.vampireCastleFail = true;
                    }
                }
            }
            data.checked = true;
            data.func_76185_a();
        }
        if (data.positions.size() == 0 && data.fullyGeneratedPositions.size() == 0 && world.func_72807_a((chunkX << 4) + 8, (chunkZ << 4) + 8) instanceof BiomeVampireForest) {
            CastlePositionData.Position pos = new CastlePositionData.Position(chunkX, chunkZ);
            if ((pos = this.optimizePosition(pos, world, rnd)) != null) {
                data.positions.add(pos);
                data.func_76185_a();
                VampirismMod.vampireCastleFail = false;
                Logger.i(TAG, "Position List was empty, but found a vampire biome -> Added to list", new Object[0]);
            }
        }
        if (data.positions.size() > 0) {
            for (CastlePositionData.Position p : data.positions) {
                int k;
                int j;
                int i;
                if (!p.isChunkInPosition(chunkX, chunkZ)) continue;
                if (!p.hasTiles()) {
                    this.preGeneratePosition(p, world);
                    data.func_76185_a();
                }
                String s = p.getTileAt(chunkX - p.field_77276_a, chunkZ - p.field_77275_b);
                String[] param = s.split(",");
                int height = p.getHeight();
                if (height == -1) {
                    height = this.getAverageHeight(world.func_72964_e(chunkX, chunkZ));
                    p.setHeight(height);
                }
                for (i = chunkX << 4; i < (chunkX << 4) + 16; ++i) {
                    for (j = chunkZ << 4; j < (chunkZ << 4) + 16; ++j) {
                        for (k = height; k < height + 20; ++k) {
                            world.func_147468_f(i, k, j);
                        }
                    }
                }
                for (i = chunkX << 4; i < (chunkX << 4) + 16; ++i) {
                    for (j = chunkZ << 4; j < (chunkZ << 4) + 16; ++j) {
                        for (k = height - 1; k > height - 10; --k) {
                            world.func_147449_b(i, k, j, (Block)ModBlocks.cursedEarth);
                        }
                    }
                }
                for (i = 0; i < param.length; i += 2) {
                    int rotation = Integer.parseInt(param[i]);
                    BuildingTile tile = tileMap.get(param[i + 1]);
                    if (tile != null) {
                        tile.build(chunkX, chunkZ, world, height, rotation);
                        continue;
                    }
                    Logger.w(TAG, "Did not find tile %s", param[i + 1]);
                }
                p.markGenerated(chunkX, chunkZ);
                data.func_76185_a();
                break;
            }
        }
    }

    private List<CastlePositionData.Position> findPositions(World world, Random rnd) {
        Logger.d(TAG, "Looking for Positions", new Object[0]);
        long t = System.currentTimeMillis();
        double phy = rnd.nextDouble() * Math.PI * 2.0;
        LinkedList<CastlePositionData.Position> foundPos = new LinkedList<CastlePositionData.Position>();
        double radius = rnd.nextDouble() * 32.0 + 5.0;
        for (int i = 0; i < 128 && foundPos.size() < 3; ++i) {
            int x = (int)Math.round(Math.cos(phy) * radius);
            int z = (int)Math.round(Math.sin(phy) * radius);
            ChunkPosition chunkposition = world.func_72959_q().func_150795_a((x << 4) + 8, (z << 4) + 8, 112, this.biomes, rnd);
            if (chunkposition != null) {
                int cx = chunkposition.field_151329_a >> 4;
                int cz = chunkposition.field_151328_c >> 4;
                foundPos.add(new CastlePositionData.Position(cx, cz));
                Logger.d(TAG, "Found position %d %d", cx, cz);
                i += 8 - i % 8;
            }
            phy += 0.7853981633974483;
            if (i <= 0 || i % 8 != 0) continue;
            phy += 0.39269908169872414;
            radius *= 1.5 + rnd.nextDouble();
        }
        Logger.d(TAG, "Looking for positions took %s ms", System.currentTimeMillis() - t);
        return foundPos;
    }

    @Nullable
    private CastlePositionData.Position optimizePosition(CastlePositionData.Position position, World world, Random rnd) {
        int i;
        Logger.d(TAG, "Optimizing Position", new Object[0]);
        long t = System.currentTimeMillis();
        int TEST_SIZE = 10;
        int D_TEST_SIZE = 20;
        Boolean[][] biomes = new Boolean[20][20];
        for (int i2 = -10; i2 < 10; ++i2) {
            for (int j = -10; j < 10; ++j) {
                biomes[i2 + 10][j + 10] = ModBiomes.biomeVampireForest.equals(world.func_72959_q().func_76935_a((position.field_77276_a + i2 << 4) + 8, (position.field_77275_b + j << 4) + 8));
            }
        }
        Integer[][] help = new Integer[20][20];
        for (i = 0; i < 20; ++i) {
            help[i][0] = biomes[i][0] != false ? 1 : 0;
        }
        for (i = 0; i < 20; ++i) {
            help[0][i] = biomes[0][i] != false ? 1 : 0;
        }
        for (i = 1; i < 20; ++i) {
            for (int j = 1; j < 20; ++j) {
                help[i][j] = biomes[i][j] != false ? Integer.valueOf(Math.min(help[i - 1][j], Math.min(help[i][j - 1], help[i - 1][j - 1])) + 1) : Integer.valueOf(0);
            }
        }
        int[] max = new int[]{-1, -1, -1};
        for (int i3 = 2; i3 < 20; ++i3) {
            for (int j = 2; j < 20; ++j) {
                if (help[i3][j] <= max[0]) continue;
                max[0] = help[i3][j];
                max[1] = i3;
                max[2] = j;
            }
        }
        Logger.d(TAG, "Optimizing position took %s ms", System.currentTimeMillis() - t);
        if (max[0] >= 6) {
            int highcx = position.field_77276_a - 10 + max[1];
            int highcz = position.field_77275_b - 10 + max[2];
            int lowcx = highcx - max[0];
            int lowcz = highcz - max[0];
            Logger.d(TAG, "Found fitting area with size %d at coords %d %d (%d %d)", max[0], lowcx, lowcz, highcx, highcz);
            int sx = 4 + rnd.nextInt(Math.min(max[0] - 2, 6) - 4 + 1);
            int sz = 4 + rnd.nextInt(Math.min(max[0] - 2, 6) - 4 + 1);
            CastlePositionData.Position p = new CastlePositionData.Position(lowcx + (max[0] - sx) / 2, lowcz + (max[0] - sz) / 2);
            p.setSize(sx, sz);
            return p;
        }
        return null;
    }

    private void preGeneratePosition(CastlePositionData.Position position, World world) {
        if (position.hasSize()) {
            int z;
            int x;
            Random rnd = new Random();
            Logger.d(TAG, "Pregenerating position %s", new Object[]{position});
            if (this.pregenerating) {
                Logger.e(TAG, "Already pregenerating. Did not expect that.", new Object[0]);
                return;
            }
            this.pregenerating = true;
            int sx = position.getSizeX();
            int sz = position.getSizeZ();
            this.tiles = new String[sx][sz];
            this.houseDirs = new int[sx][sz][];
            for (int x2 = 0; x2 < sx; ++x2) {
                for (int z2 = 0; z2 < sz; ++z2) {
                    this.tiles[x2][z2] = "0,flatDirt";
                }
            }
            int ucx = sx / 2;
            int ucz = sz / 2;
            this.tiles[ucx][ucz] = "0,flatDirt,0,castlelr,2,path,1,path";
            this.tiles[ucx - 1][ucz] = "0,flatDirt,0,castlell,2,path,3,path";
            this.tiles[ucx - 1][ucz - 1] = "0,flatDirt,0,castleul,0,path,3,path";
            this.tiles[ucx][ucz - 1] = "0,flatDirt,0,castleur,0,path,1,path";
            if (position.isDraculasDim()) {
                String[] stringArray = this.tiles[ucx];
                int n = ucz;
                stringArray[n] = stringArray[n] + ",0,castle_lavalr";
                String[] stringArray2 = this.tiles[ucx - 1];
                int n2 = ucz;
                stringArray2[n2] = stringArray2[n2] + ",0,castle_lavall";
                String[] stringArray3 = this.tiles[ucx - 1];
                int n3 = ucz - 1;
                stringArray3[n3] = stringArray3[n3] + ",0,castle_lavaul,0,castleul_button";
                String[] stringArray4 = this.tiles[ucx];
                int n4 = ucz - 1;
                stringArray4[n4] = stringArray4[n4] + ",0,castle_lavaur";
            } else {
                String[] stringArray = this.tiles[ucx];
                int n = ucz - 1;
                stringArray[n] = stringArray[n] + ",0,castle_portalur";
            }
            this.addPathAndDir(ucx, ucz - 2, 2);
            this.addPathAndDir(ucx - 1, ucz - 2, 2);
            this.addPathAndDir(ucx, ucz + 1, 0);
            this.addPathAndDir(ucx - 1, ucz + 1, 0);
            this.addPathAndDir(ucx - 2, ucz, 1);
            this.addPathAndDir(ucx - 2, ucz - 1, 1);
            this.addPathAndDir(ucx + 1, ucz, 3);
            this.addPathAndDir(ucx + 1, ucz - 1, 3);
            boolean ulcorner = false;
            boolean flag = false;
            if (rnd.nextBoolean()) {
                flag = true;
                this.addPathAndDir(ucx - 2, ucz - 2, 2);
                this.addPathAndDir(ucx - 2, ucz - 1, 0);
                if (ucx - 3 >= 0 && (rnd.nextBoolean() || rnd.nextBoolean())) {
                    this.addPathAndDir(ucx - 3, ucz - 2, 1);
                    this.addPathAndDir(ucx - 2, ucz - 2, 3);
                    ulcorner = true;
                }
            }
            if (!flag || rnd.nextBoolean()) {
                this.addPathAndDir(ucx - 1, ucz - 2, 3);
                this.addPathAndDir(ucx - 2, ucz - 2, 1);
                if (ucz - 3 >= 0 && (rnd.nextBoolean() || rnd.nextBoolean())) {
                    this.addPathAndDir(ucx - 2, ucz - 3, 2);
                    this.addPathAndDir(ucx - 2, ucz - 2, 0);
                    ulcorner = true;
                }
            }
            if (ulcorner && ucz - 3 >= 0 && ucx - 3 >= 0) {
                if (rnd.nextBoolean()) {
                    this.addPathAndDir(ucx - 3, ucz - 3, 1);
                    this.addPathAndDir(ucx - 2, ucz - 3, 3);
                } else {
                    this.addPathAndDir(ucx - 3, ucz - 3, 2);
                    this.addPathAndDir(ucx - 3, ucz - 2, 0);
                }
            }
            boolean urcorner = false;
            flag = false;
            if (rnd.nextBoolean()) {
                flag = true;
                this.addPathAndDir(ucx + 1, ucz - 2, 3);
                this.addPathAndDir(ucx, ucz - 2, 1);
                if (ucz - 3 >= 0 && (rnd.nextBoolean() || rnd.nextBoolean())) {
                    this.addPathAndDir(ucx + 1, ucz - 3, 2);
                    this.addPathAndDir(ucx + 1, ucz - 2, 0);
                    urcorner = true;
                }
            }
            if (!flag || rnd.nextBoolean()) {
                this.addPathAndDir(ucx + 1, ucz - 2, 2);
                this.addPathAndDir(ucx + 1, ucz - 1, 0);
                if (ucx + 2 < sx) {
                    this.addPathAndDir(ucx + 2, ucz - 2, 3);
                    this.addPathAndDir(ucx + 1, ucz - 2, 1);
                    urcorner = true;
                }
            }
            if (urcorner && ucx + 2 < sx && ucz - 3 >= 0) {
                if (rnd.nextBoolean()) {
                    this.addPathAndDir(ucx + 1, ucz - 3, 1);
                    this.addPathAndDir(ucx + 2, ucz - 3, 3);
                } else {
                    this.addPathAndDir(ucx + 2, ucz - 2, 0);
                    this.addPathAndDir(ucx + 2, ucz - 3, 2);
                }
            }
            boolean lrcorner = false;
            flag = false;
            if (rnd.nextBoolean()) {
                flag = true;
                this.addPathAndDir(ucx + 1, ucz, 2);
                this.addPathAndDir(ucx + 1, ucz + 1, 0);
                if (ucx + 2 < sx && rnd.nextBoolean()) {
                    this.addPathAndDir(ucx + 2, ucz + 1, 3);
                    this.addPathAndDir(ucx + 1, ucz + 1, 1);
                    lrcorner = true;
                }
            }
            if (flag || rnd.nextBoolean()) {
                this.addPathAndDir(ucx + 1, ucz + 1, 3);
                this.addPathAndDir(ucx, ucz + 1, 1);
                if (ucz + 2 < sz && (rnd.nextBoolean() || rnd.nextBoolean())) {
                    this.addPathAndDir(ucx + 1, ucz + 2, 0);
                    this.addPathAndDir(ucx + 1, ucz + 1, 2);
                    lrcorner = true;
                }
            }
            if (lrcorner && ucx + 2 < sx && ucz + 2 < sz) {
                if (rnd.nextBoolean()) {
                    this.addPathAndDir(ucx + 2, ucz + 2, 0);
                    this.addPathAndDir(ucx + 2, ucz + 1, 2);
                } else {
                    this.addPathAndDir(ucx + 2, ucz + 2, 3);
                    this.addPathAndDir(ucx + 1, ucz + 2, 1);
                }
            }
            boolean llcorner = false;
            flag = false;
            if (rnd.nextBoolean()) {
                flag = true;
                this.addPathAndDir(ucx - 1, ucz + 1, 3);
                this.addPathAndDir(ucx - 2, ucz + 1, 1);
                if (ucz + 2 < sz && rnd.nextBoolean()) {
                    this.addPathAndDir(ucx + 1, ucz + 2, 0);
                    this.addPathAndDir(ucx + 1, ucz + 1, 2);
                    llcorner = true;
                }
            }
            if (!flag || rnd.nextBoolean()) {
                this.addPathAndDir(ucx - 2, ucz + 1, 0);
                this.addPathAndDir(ucx - 2, ucz, 2);
                if (ucx - 3 >= 0 && (rnd.nextBoolean() || rnd.nextBoolean())) {
                    this.addPathAndDir(ucx - 3, ucz + 1, 1);
                    this.addPathAndDir(ucx - 2, ucz + 1, 3);
                    llcorner = true;
                }
            }
            if (llcorner && ucx - 3 >= 0 && ucz + 2 < sz) {
                if (rnd.nextBoolean()) {
                    this.addPathAndDir(ucx - 3, ucz + 2, 0);
                    this.addPathAndDir(ucx - 3, ucz + 1, 2);
                } else {
                    this.addPathAndDir(ucx - 3, ucz + 2, 1);
                    this.addPathAndDir(ucx - 2, ucz + 2, 3);
                }
            }
            if (rnd.nextBoolean() || rnd.nextBoolean()) {
                this.addPathAndDir(ucx + 1, ucz, 0);
                this.addPathAndDir(ucx + 1, ucz - 1, 2);
                if (ucx + 2 < sx) {
                    if (rnd.nextBoolean()) {
                        this.addPathAndDir(ucx + 2, ucz - 1, 3);
                        this.addPathAndDir(ucx + 1, ucz - 1, 1);
                    }
                    if (rnd.nextBoolean()) {
                        this.addPathAndDir(ucx + 2, ucz, 3);
                        this.addPathAndDir(ucx + 1, ucz, 1);
                    }
                }
            }
            if (rnd.nextBoolean() || rnd.nextBoolean()) {
                this.addPathAndDir(ucx - 2, ucz, 0);
                this.addPathAndDir(ucx - 2, ucz - 1, 2);
                if (ucx - 3 >= 0) {
                    if (rnd.nextBoolean()) {
                        this.addPathAndDir(ucx - 3, ucz - 1, 1);
                        this.addPathAndDir(ucx - 2, ucz - 1, 3);
                    }
                    if (rnd.nextBoolean()) {
                        this.addPathAndDir(ucx - 3, ucz, 1);
                        this.addPathAndDir(ucx - 2, ucz, 3);
                    }
                }
            }
            boolean large = sx >= 6 && sz >= 6;
            for (x = 0; x < sx; ++x) {
                for (int z3 = 0; z3 < sz; ++z3) {
                    int[] dirs = this.houseDirs[x][z3];
                    if (dirs == null) continue;
                    if (large && x == 0 || x == 5 || z3 == 0 || z3 == 5) {
                        String[] stringArray = this.tiles[x];
                        int n = z3;
                        stringArray[n] = stringArray[n] + this.getRandomNonHouse(rnd, dirs, true);
                        continue;
                    }
                    String[] stringArray = this.tiles[x];
                    int n = z3;
                    stringArray[n] = stringArray[n] + this.getRandomHouse(rnd, dirs, true);
                }
            }
            for (z = sz - 1; z > sz / 2; --z) {
                this.addPathAndDir(sx / 2, z, 3);
                this.addPathAndDir(sx / 2 - 1, z, 1);
            }
            for (x = 0; x < sx; ++x) {
                String[] stringArray = this.tiles[x];
                stringArray[0] = stringArray[0] + ",2,wall";
            }
            for (x = 0; x < sx; ++x) {
                if (x == sx / 2) {
                    String[] stringArray = this.tiles[x];
                    int n = sz - 1;
                    stringArray[n] = stringArray[n] + ",0,entrancer";
                    continue;
                }
                if (x == sx / 2 - 1) {
                    String[] stringArray = this.tiles[x];
                    int n = sz - 1;
                    stringArray[n] = stringArray[n] + ",0,entrancel";
                    continue;
                }
                String[] stringArray = this.tiles[x];
                int n = sz - 1;
                stringArray[n] = stringArray[n] + ",0,wall";
            }
            z = 0;
            while (z < sz) {
                String[] stringArray = this.tiles[0];
                int n = z++;
                stringArray[n] = stringArray[n] + ",1,wall";
            }
            z = 0;
            while (z < sz) {
                String[] stringArray = this.tiles[sx - 1];
                int n = z++;
                stringArray[n] = stringArray[n] + ",3,wall";
            }
            String[] stringArray = this.tiles[0];
            stringArray[0] = stringArray[0] + ",1,wall_corner";
            String[] stringArray5 = this.tiles[0];
            int n = sz - 1;
            stringArray5[n] = stringArray5[n] + ",0,wall_corner";
            String[] stringArray6 = this.tiles[sx - 1];
            int n5 = sz - 1;
            stringArray6[n5] = stringArray6[n5] + ",3,wall_corner";
            String[] stringArray7 = this.tiles[sx - 1];
            stringArray7[0] = stringArray7[0] + ",2,wall_corner";
            position.setMainCastle(new ChunkCoordIntPair(position.field_77276_a + sx / 2 - 1, position.field_77275_b + sz / 2 - 1), new ChunkCoordIntPair(position.field_77276_a + sx / 2, position.field_77275_b + sz / 2));
            position.setTiles(this.tiles);
            this.houseDirs = null;
            this.tiles = null;
            this.pregenerating = false;
        }
    }

    private void addPathAndDir(int x, int z, int dir) {
        String[] stringArray = this.tiles[x];
        int n = z;
        stringArray[n] = stringArray[n] + "," + dir + ",path";
        int[] d = this.houseDirs[x][z];
        if (d == null) {
            d = new int[]{dir};
            this.houseDirs[x][z] = d;
            return;
        }
        this.houseDirs[x][z] = ArrayUtils.add((int[])d, (int)dir);
    }

    private String getRandomHouse(Random rnd, int[] dirs, boolean allowNonHouse) {
        String s;
        int dir = dirs[rnd.nextInt(dirs.length)];
        int type = rnd.nextInt(allowNonHouse ? 12 : 11);
        switch (type) {
            case 0: 
            case 1: {
                s = "house1";
                break;
            }
            case 2: 
            case 3: {
                s = "house2";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                s = "house3";
            }
            case 7: 
            case 8: {
                s = "house4";
            }
            case 9: {
                s = "blacksmith";
                break;
            }
            case 11: {
                return this.getRandomNonHouse(rnd, dirs, false);
            }
            default: {
                return rnd.nextBoolean() ? "" : ",0,dirt2";
            }
        }
        return "," + dir + "," + s;
    }

    private String getRandomNonHouse(Random rnd, int[] dirs, boolean allowHouse) {
        String s;
        int dir = dirs[rnd.nextInt(dirs.length)];
        int type = rnd.nextInt(allowHouse ? 6 : 5);
        switch (type) {
            case 0: {
                s = "grave";
                break;
            }
            case 1: {
                s = "stables";
                break;
            }
            case 2: {
                s = "pasture";
                break;
            }
            case 3: {
                s = "stables";
                break;
            }
            case 5: {
                return this.getRandomHouse(rnd, dirs, false);
            }
            default: {
                return rnd.nextBoolean() ? "" : ",0,dirt2";
            }
        }
        return "," + dir + "," + s;
    }

    private int getAverageHeight(Chunk chunk) {
        int[] map = chunk.field_76634_f;
        int sum = 0;
        for (int i = 0; i < map.length; ++i) {
            sum += map[i];
        }
        return MathHelper.func_76141_d((float)((float)sum / (float)map.length));
    }

    private void printMatrix(Object[][] objects) {
        for (int i = 0; i < objects.length; ++i) {
            System.out.println();
            for (int j = 0; j < objects[i].length; ++j) {
                System.out.print(String.valueOf(objects[i][j]));
            }
        }
    }

    public boolean func_76484_a(World p_76484_1_, Random p_76484_2_, int p_76484_3_, int p_76484_4_, int p_76484_5_) {
        return false;
    }

    public ChunkCoordIntPair findNearVampireBiome(World world, int x, int z, int maxDist) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < maxDist; ++i) {
            for (int j = -i; j < i; ++j) {
                if (world.func_72807_a(x + (i << 4), z + (j << 4)) instanceof BiomeVampireForest) {
                    Logger.d(TAG, "Took %d ms to find a vampire biome", (int)(System.currentTimeMillis() - start));
                    return new ChunkCoordIntPair((x >> 4) + i, (z >> 4) + j);
                }
                if (!(world.func_72807_a(x - (i << 4), z + (j << 4)) instanceof BiomeVampireForest)) continue;
                Logger.d(TAG, "Took %d ms to find a vampire biome", (int)(System.currentTimeMillis() - start));
                return new ChunkCoordIntPair((x >> 4) - i, (z >> 4) + j);
            }
        }
        Logger.d(TAG, "Took %d ms to not find a vampire biome", (int)(System.currentTimeMillis() - start));
        return null;
    }
}

