/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.villages;

import de.teamlapen.vampirism.util.Logger;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import org.eclipse.jdt.annotation.NonNull;

public class BiomeRegistrant {
    private static Set<BiomeGenBase> biomeSet;

    public static void addBiome(BiomeGenBase biome) {
        BiomeManager.addVillageBiome((BiomeGenBase)biome, (boolean)true);
    }

    public static void addBiomeById(int id) {
        BiomeGenBase biomeForId = null;
        for (BiomeGenBase biome : biomeSet) {
            if (biome.field_76756_M != id) continue;
            biomeForId = biome;
        }
        if (biomeForId != null) {
            BiomeRegistrant.addBiome(biomeForId);
        } else {
            Logger.w("BiomeRegistrant", "Can't find biome with ID %d", id);
        }
    }

    public static void addBiomeByName(@NonNull String name) {
        BiomeGenBase biomeForId = null;
        for (BiomeGenBase biome : biomeSet) {
            if (!name.equals(biome.field_76791_y)) continue;
            biomeForId = biome;
        }
        if (biomeForId != null) {
            BiomeRegistrant.addBiome(biomeForId);
        } else {
            Logger.w("BiomeRegistrant", "Can't find biome with name %s", name);
        }
    }

    public static void addBiomesByType(BiomeDictionary.Type type) {
        for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
            BiomeRegistrant.addBiome(biome);
        }
    }

    public static void addBiomesByTypeName(String name) {
        BiomeDictionary.Type type = BiomeDictionary.Type.valueOf((String)name);
        if (type != null) {
            BiomeRegistrant.addBiomesByType(type);
        } else {
            Logger.w("BiomeRegistrant", "Can't find type with name %s", name);
        }
    }

    private static Set<BiomeGenBase> fetchAllBiomes() {
        HashSet<BiomeGenBase> biomes = new HashSet<BiomeGenBase>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    public static void init() {
        biomeSet = BiomeRegistrant.fetchAllBiomes();
    }

    public static void removeBiome(BiomeGenBase biome) {
        BiomeManager.removeVillageBiome((BiomeGenBase)biome);
    }

    public static void removeBiomeById(int id) {
        BiomeGenBase biomeForId = null;
        for (BiomeGenBase biome : biomeSet) {
            if (biome.field_76756_M != id) continue;
            biomeForId = biome;
        }
        if (biomeForId != null) {
            BiomeRegistrant.removeBiome(biomeForId);
        } else {
            Logger.w("BiomeRegistrant", "Can't find biome with ID %d", id);
        }
    }

    public static void removeBiomeByName(@NonNull String name) {
        BiomeGenBase biomeForId = null;
        for (BiomeGenBase biome : biomeSet) {
            if (!name.equals(biome.field_76791_y)) continue;
            biomeForId = biome;
        }
        if (biomeForId != null) {
            BiomeRegistrant.removeBiome(biomeForId);
        } else {
            Logger.w("BiomeRegistrant", "Can't find biome with name %s", name);
        }
    }

    public static void removeBiomesByType(BiomeDictionary.Type type) {
        for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
            BiomeRegistrant.removeBiome(biome);
        }
    }

    public static void removeBiomesByTypeName(String name) {
        BiomeDictionary.Type type = BiomeDictionary.Type.valueOf((String)name);
        if (type != null) {
            BiomeRegistrant.removeBiomesByType(type);
        } else {
            Logger.w("BiomeRegistrant", "Can't find type with name %s", name);
        }
    }
}

