/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.guide;

import amerifrance.guideapi.api.GuideRegistry;
import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IPage;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.util.BookBuilder;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.categories.CategoryItemStack;
import amerifrance.guideapi.entries.EntryUniText;
import amerifrance.guideapi.pages.PageIRecipe;
import amerifrance.guideapi.pages.PageImage;
import amerifrance.guideapi.pages.PageLocImage;
import amerifrance.guideapi.pages.PageLocItemStack;
import amerifrance.guideapi.pages.PageLocText;
import amerifrance.guideapi.pages.PageUnlocImage;
import amerifrance.guideapi.pages.PageUnlocItemStack;
import amerifrance.guideapi.pages.PageUnlocText;
import cpw.mods.fml.common.registry.GameRegistry;
import de.teamlapen.vampirism.ModBlocks;
import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.guide.PageHolderWithLinks;
import de.teamlapen.vampirism.guide.PageTable;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.REFERENCE;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class VampirismGuide {
    public static Book vampirismGuide;
    private static List recipeList;
    public static List<CategoryAbstract> categories;
    private static HashMap<String, EntryAbstract> linkedEntries;

    public static EntryAbstract getLinkedEntry(String identifier) {
        return linkedEntries.get(identifier);
    }

    private static EntryAbstract addLink(String identifier, EntryAbstract entry) {
        linkedEntries.put(identifier, entry);
        return entry;
    }

    public static void registerGuide() {
        recipeList = CraftingManager.func_77594_a().func_77592_b();
        VampirismGuide.registerGettingStarted();
        VampirismGuide.registerItemsAndBlocks();
        VampirismGuide.registerLevels();
        VampirismGuide.registerMobs();
        VampirismGuide.registerVP();
        VampirismGuide.registerVampireLord();
        BookBuilder builder = new BookBuilder();
        builder.setCategories(categories).setUnlocBookTitle("guide.vampirism.book.title").setUnlocWelcomeMessage("guide.vampirism.welcomeMessage").setUnlocDisplayName("guide.vamprism.book.name").setBookColor(new Color(137, 8, 163)).setAuthor("--Team Lapen");
        builder.setSpawnWithBook(true);
        vampirismGuide = builder.build();
        GuideRegistry.registerBook((Book)vampirismGuide);
        ItemStack bookstack = GuideRegistry.getItemStackForBook((Book)vampirismGuide);
        GameRegistry.addShapelessRecipe((ItemStack)bookstack, (Object[])new Object[]{new ItemStack(Items.field_151122_aG), new ItemStack((Item)ModItems.vampireFang)});
        GameRegistry.addShapelessRecipe((ItemStack)bookstack, (Object[])new Object[]{new ItemStack(Items.field_151122_aG), new ItemStack((Item)ModItems.weakVampireFang)});
    }

    private static void registerGettingStarted() {
        ArrayList<EntryAbstract> entries = new ArrayList<EntryAbstract>();
        entries.add(VampirismGuide.createUnlocLongTextEntry("guide.vampirism.gettingStarted.overview.title", "guide.vampirism.gettingStarted.overview.text"));
        entries.add(VampirismGuide.createUnlocLongTextEntry("guide.vampirism.gettingStarted.firstSteps.title", "guide.vampirism.gettingStarted.firstSteps.text"));
        entries.add(VampirismGuide.createUnlocLongTextEntry("guide.vampirism.gettingStarted.asAVampire.title", "guide.vampirism.gettingStarted.asAVampire.text"));
        entries.add(VampirismGuide.createUnlocLongTextEntry("guide.vampirism.gettingStarted.biteableCreatures.title", "guide.vampirism.gettingStarted.biteableCreatures.text"));
        categories.add((CategoryAbstract)new CategoryItemStack(entries, "guide.vampirism.gettingStarted.category", new ItemStack((Item)ModItems.bloodBottle, 1, 19)));
    }

    private static void registerItemsAndBlocks() {
        ArrayList<Object> entries = new ArrayList<Object>();
        ArrayList<Object> found = new ArrayList<Object>();
        found.add(new PageLocItemStack(VampirismGuide.loc("item.vampirism.vampireFang.name") + "\n" + VampirismGuide.loc("guide.vampirism.itemsAndBlocks.found.vampireFang"), (Item)ModItems.vampireFang));
        found.add(new PageLocItemStack(VampirismGuide.loc("item.vampirism.weakVampireFang.name") + "\n" + VampirismGuide.loc("guide.vampirism.itemsAndBlocks.found.weakVampireFang"), (Item)ModItems.weakVampireFang));
        found.add(new PageIRecipe(VampirismGuide.getRecipe(ModItems.vampireFang)));
        found.add(new PageLocItemStack(VampirismGuide.loc("item.vampirism.humanHeart.name") + "\n" + VampirismGuide.loc("guide.vampirism.itemsAndBlocks.found.humanHearth"), (Item)ModItems.humanHeart));
        found.add(new PageLocItemStack(VampirismGuide.loc("item.vampirism.weakHumanHeart.name") + "\n" + VampirismGuide.loc("guide.vampirism.itemsAndBlocks.found.weakHumanHearth"), (Item)ModItems.weakHumanHeart));
        found.add(new PageIRecipe(VampirismGuide.getRecipe((Item)ModItems.humanHeart)));
        found.add(new PageUnlocItemStack("guide.vampirism.itemsAndBlocks.found.vampireFlower", (Block)ModBlocks.vampireFlower));
        found.add(new PageUnlocItemStack("guide.vampirism.itemsAndBlocks.found.bloodAltar1", (Block)ModBlocks.bloodAltar1));
        found.add(new PageUnlocItemStack("guide.vampirism.itemsAndBlocks.found.pureBlood", (Item)ModItems.pureBlood));
        entries.add(VampirismGuide.addLink("items_found", (EntryAbstract)new EntryUniText(found, "guide.vampirism.itemsAndBlocks.found.title")));
        String bBottle = VampirismGuide.locAndFormat("guide.vampirism.itemsAndBlocks.bBottle.text", VampirismMod.proxy.getKey(REFERENCE.KEY.AUTO));
        entries.add(VampirismGuide.createCraftableStackEntryLoc(new ItemStack((Item)ModItems.bloodBottle), bBottle));
        entries.add(VampirismGuide.createCraftableStackEntry(new ItemStack((Item)ModItems.sunscreen), "guide.vampirism.itemsAndBlocks.sunscreen.text"));
        ArrayList<Object> armor = new ArrayList<Object>();
        armor.add(new PageUnlocText("guide.vampirism.itemsAndBlocks.armor.text"));
        armor.add(new PageIRecipe(VampirismGuide.getRecipe((Item)ModItems.vampireHelmet)));
        armor.add(new PageIRecipe(VampirismGuide.getRecipe((Item)ModItems.vampireChestplate)));
        armor.add(new PageIRecipe(VampirismGuide.getRecipe((Item)ModItems.vampireLeggings)));
        armor.add(new PageIRecipe(VampirismGuide.getRecipe((Item)ModItems.vampireBoots)));
        entries.add(new EntryUniText(armor, "guide.vampirism.itemsAndBlocks.armor.title"));
        ArrayList<Object> altar = new ArrayList<Object>();
        altar.add(new PageLocText(VampirismGuide.locAndFormat("guide.vampirism.itemsAndBlocks.altars.altar2.text", 1, 3)));
        altar.add(new PageIRecipe(VampirismGuide.getRecipe((Block)ModBlocks.bloodAltar2)));
        altar.add(new PageUnlocText(VampirismGuide.locAndFormat("guide.vampirism.itemsAndBlocks.altars.altar4.text", VampirismGuide.loc(ModBlocks.bloodAltar4.func_149739_a() + ".name"), 4)));
        altar.add(new PageIRecipe(VampirismGuide.getRecipe((Block)ModBlocks.bloodAltar4)));
        altar.add(new PageIRecipe(VampirismGuide.getRecipe((Block)ModBlocks.bloodAltar4Tip)));
        entries.add(new EntryUniText(altar, "guide.vampirism.itemsAndBlocks.altars.title"));
        entries.add(VampirismGuide.createCraftableStackEntry(new ItemStack((Item)ModItems.coffin), "guide.vampirism.itemsAndBlocks.coffin.text"));
        EntryAbstract gemOfBinding = VampirismGuide.createCraftableStackEntry(new ItemStack((Item)ModItems.gemOfBinding), "guide.vampirism.itemsAndBlocks.used_for_minions");
        VampirismGuide.addLink("items_gemOfBinding", gemOfBinding);
        entries.add(gemOfBinding);
        EntryAbstract nameTag = VampirismGuide.createCraftableStackEntry(new ItemStack((Item)ModItems.minionNameTag), "guide.vampirism.itemsAndBlocks.used_for_minions");
        VampirismGuide.addLink("items_minion_name_tag", nameTag);
        entries.add(nameTag);
        EntryAbstract bloodEye = VampirismGuide.createCraftableStackEntry(new ItemStack((Item)ModItems.bloodEye), "guide.vampirism.itemsAndBlocks.blood_eye.text");
        VampirismGuide.addLink("items_blood_eye", bloodEye);
        entries.add(bloodEye);
        ArrayList<PageIRecipe> castleBlocks = new ArrayList<PageIRecipe>();
        castleBlocks.add(new PageIRecipe(VampirismGuide.getRecipe(new ItemStack((Block)ModBlocks.castleBlock, 1, 0))));
        castleBlocks.add(new PageIRecipe(VampirismGuide.getRecipe(new ItemStack((Block)ModBlocks.castleBlock, 1, 1))));
        castleBlocks.add(new PageIRecipe(VampirismGuide.getRecipe(new ItemStack((Block)ModBlocks.castleSlab, 1, 0))));
        castleBlocks.add(new PageIRecipe(VampirismGuide.getRecipe(new ItemStack((Block)ModBlocks.castleSlab, 1, 1))));
        castleBlocks.add(new PageIRecipe(VampirismGuide.getRecipe(new ItemStack((Block)ModBlocks.castleStairsPurple, 1))));
        castleBlocks.add(new PageIRecipe(VampirismGuide.getRecipe(new ItemStack((Block)ModBlocks.castleStairsDark, 1, 0))));
        entries.add(new EntryUniText(castleBlocks, ModBlocks.castleBlock.func_149739_a() + ".name"));
        categories.add((CategoryAbstract)new CategoryItemStack(entries, "guide.vampirism.itemsAndBlocks.category", new ItemStack((Item)ModItems.leechSword, 1)));
    }

    private static void registerLevels() {
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.add(VampirismGuide.createUnlocLongTextEntry("guide.vampirism.levels.introduction.title", "guide.vampirism.levels.introduction.text"));
        String at2t = VampirismGuide.locAndFormat("guide.vampirism.levels.altar2.title", 1, 3);
        ArrayList<PageIRecipe> pagesAt2 = new ArrayList<PageIRecipe>();
        String at2 = VampirismGuide.loc("guide.vampirism.levels.altar2.text");
        at2 = at2 + "\n";
        for (int i = 1; i <= 3; ++i) {
            at2 = at2 + VampirismGuide.loc("text.vampirism.entity_level") + " " + i + ": " + BALANCE.LEVELING.A2_getRequiredBlood(i) + " " + VampirismGuide.loc("text.vampirism.blood") + "\n";
        }
        pagesAt2.add(new PageIRecipe(VampirismGuide.getRecipe((Block)ModBlocks.bloodAltar2)));
        pagesAt2.addAll(PageHelper.pagesForLongText((String)at2));
        entries.add(new EntryUniText(pagesAt2, at2t));
        String at4t = VampirismGuide.locAndFormat("guide.vampirism.levels.altar4.title", 4);
        ArrayList<Object> pagesAt4 = new ArrayList<Object>();
        pagesAt4.add(new PageIRecipe(VampirismGuide.getRecipe((Block)ModBlocks.bloodAltar4)));
        pagesAt4.add(new PageIRecipe(VampirismGuide.getRecipe((Block)ModBlocks.bloodAltar4Tip)));
        pagesAt4.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc("guide.vampirism.levels.altar4.text")));
        pagesAt4.add(new PageHolderWithLinks(VampirismGuide.createItemRequirementsAltar4()).addLink("items_found"));
        pagesAt4.add(VampirismGuide.createStructureRequirementsAltar4());
        pagesAt4.add(new PageUnlocImage("guide.vampirism.levels.altar4.structure1.name", new ResourceLocation("vampirism:guide/screenshots/altar4_structure1.png"), false));
        pagesAt4.add(new PageUnlocImage("guide.vampirism.levels.altar4.structure2.name", new ResourceLocation("vampirism:guide/screenshots/altar4_structure2.png"), false));
        entries.add(VampirismGuide.addLink("level_altar_4", (EntryAbstract)new EntryUniText(pagesAt4, at4t)));
        categories.add((CategoryAbstract)new CategoryItemStack(entries, "guide.vampirism.levels.category", new ItemStack((Block)ModBlocks.bloodAltar2)));
    }

    private static IPage createItemRequirementsAltar4() {
        PageTable.Builder builder = new PageTable.Builder(3);
        builder.addUnlocLine("text.vampirism.entity_level", ModItems.pureBlood.func_77658_a() + ".name", ModItems.humanHeart.func_77658_a() + ".name");
        builder.addLine(4, 0, 5);
        builder.addLine(5, "1 Purity(1)", 0);
        builder.addLine(6, "1 Purity(1)", 5);
        builder.addLine(7, "1 Purity(2)", 0);
        builder.addLine(8, "1 Purity(2)", 5);
        builder.addLine(9, "1 Purity(3)", 5);
        builder.addLine(10, "1 Purity(3)", 5);
        builder.addLine(11, "1 Purity(4)", 10);
        builder.addLine(12, "1 Purity(4)", 5);
        builder.addLine(13, "2 Purity(5)", 0);
        builder.setHeadline(VampirismGuide.loc("guide.vampirism.levels.altar4.item_req"));
        return builder.build();
    }

    private static IPage createStructureRequirementsAltar4() {
        PageTable.Builder builder = new PageTable.Builder(3);
        builder.addUnlocLine("text.vampirism.entity_level", "text.vampirism.structure", "text.vampirism.pillar_blocks");
        builder.addLine(4, 1, Blocks.field_150417_aV.func_149732_F());
        builder.addLine(5, 1, Blocks.field_150417_aV.func_149732_F());
        builder.addLine(6, 1, Blocks.field_150417_aV.func_149732_F());
        builder.addLine(7, 1, Blocks.field_150339_S.func_149732_F());
        builder.addLine(8, 1, Blocks.field_150339_S.func_149732_F());
        builder.addLine(9, 2, Blocks.field_150339_S.func_149732_F());
        builder.addLine(10, 2, Blocks.field_150339_S.func_149732_F());
        builder.addLine(11, 2, Blocks.field_150340_R.func_149732_F());
        builder.addLine(12, 2, Blocks.field_150340_R.func_149732_F());
        builder.addLine(13, 2, Blocks.field_150340_R.func_149732_F());
        builder.setHeadline(VampirismGuide.loc("guide.vampirism.levels.altar4.struc_req"));
        return builder.build();
    }

    private static void registerMobs() {
        ArrayList<EntryUniText> entries = new ArrayList<EntryUniText>();
        ArrayList<PageImage> hunter = new ArrayList<PageImage>();
        hunter.add(new PageImage(new ResourceLocation("vampirism:guide/screenshots/hunter.png")));
        hunter.addAll(PageHelper.pagesForLongText((String)VampirismGuide.locAndFormat("guide.vampirism.mobs.hunter.text", BALANCE.VAMPIRE_HUNTER_ATTACK_LEVEL)));
        entries.add(new EntryUniText(hunter, "entity.vampirism.vampireHunter.name"));
        ArrayList<PageImage> vampire_npc = new ArrayList<PageImage>();
        vampire_npc.add(new PageImage(new ResourceLocation("vampirism:guide/screenshots/vampire.png")));
        vampire_npc.addAll(PageHelper.pagesForLongText((String)VampirismGuide.locAndFormat("guide.vampirism.mobs.vampire.text", BALANCE.VAMPIRE_FRIENDLY_LEVEL)));
        entries.add(new EntryUniText(vampire_npc, "entity.vampirism.vampire.name"));
        ArrayList<PageImage> vampire_baron = new ArrayList<PageImage>();
        vampire_baron.add(new PageImage(new ResourceLocation("vampirism:guide/screenshots/vampire_baron.png")));
        vampire_baron.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc("guide.vampirism.mobs.vampire_baron.text", true)));
        entries.add(new EntryUniText(vampire_baron, "entity.vampirism.vampireBaron.name"));
        ArrayList<PageImage> vampire_minion = new ArrayList<PageImage>();
        vampire_minion.add(new PageImage(new ResourceLocation("vampirism:guide/screenshots/vampire_minion.png")));
        vampire_minion.add(new PageImage(new ResourceLocation("vampirism:guide/screenshots/minion.png")));
        vampire_minion.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc("guide.vampirism.mobs.vampire_minion.text", true)));
        entries.add(new EntryUniText(vampire_minion, "guide.vampirism.mobs.vampire_minion.title"));
        ArrayList<PageImage> ghost = new ArrayList<PageImage>();
        ghost.add(new PageImage(new ResourceLocation("vampirism:guide/screenshots/ghost.png")));
        ghost.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc("guide.vampirism.mobs.ghost.text", true)));
        entries.add(new EntryUniText(ghost, "entity.vampirism.ghost.name"));
        ArrayList<IPage> dracula = new ArrayList<IPage>();
        dracula.add((IPage)new PageImage(new ResourceLocation("vampirism:guide/screenshots/dracula.png")));
        dracula.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc("guide.vampirism.mobs.dracula.text", true)));
        VampirismGuide.addLinksToPages(dracula, "lord_intro");
        entries.add(new EntryUniText(dracula, "entity.vampirism.dracula.name"));
        categories.add((CategoryAbstract)new CategoryItemStack(entries, "guide.vampirism.mobs.category", new ItemStack((Item)ModItems.vampireFang)));
    }

    private static void registerVP() {
        ArrayList<Object> entries = new ArrayList<Object>();
        ArrayList general = new ArrayList();
        String s = VampirismGuide.locAndFormat("guide.vampirism.vplayer.general.text", 14, VampirismMod.proxy.getKey(REFERENCE.KEY.VISION), VampirismMod.proxy.getKey(REFERENCE.KEY.SUCK), VampirismMod.proxy.getKey(REFERENCE.KEY.AUTO));
        if (BALANCE.VAMPIRE_PLAYER_LOOSE_LEVEL) {
            s = s + "\n\n" + VampirismGuide.loc("guide.vampirism.vplayer.general.loose_level");
        }
        general.addAll(PageHelper.pagesForLongText((String)s));
        entries.add(new EntryUniText(general, "guide.vampirism.vplayer.general.title"));
        ArrayList sun_damage = new ArrayList();
        sun_damage.addAll(PageHelper.pagesForLongText((String)VampirismGuide.locAndFormat("guide.vampirism.vplayer.sun_damage.text", new Object[0])));
        entries.add(new EntryUniText(sun_damage, "guide.vampirism.vplayer.sun_damage.title"));
        ArrayList<Object> skills = new ArrayList<Object>();
        skills.addAll(PageHelper.pagesForLongText((String)VampirismGuide.locAndFormat("guide.vampirism.vplayer.skills.text", new Object[0])));
        skills.add(new PageLocImage(VampirismGuide.loc("guide.vampirism.vplayer.skills.menu_text"), new ResourceLocation("vampirism:guide/screenshots/skills_menu.png"), false));
        skills.addAll(PageHelper.pagesForLongText((String)VampirismGuide.locAndFormat("guide.vampirism.vplayer.skills.bat_transformation", new Object[0])));
        skills.addAll(PageHelper.pagesForLongText((String)VampirismGuide.locAndFormat("guide.vampirism.vplayer.skills.revive_fallen", new Object[0])));
        skills.add(new PageLocText(VampirismGuide.loc("guide.vampirism.vplayer.skills.end", true)));
        entries.add(VampirismGuide.addLink("vampire_skills", (EntryAbstract)new EntryUniText(skills, "guide.vampirism.vplayer.skills.title")));
        categories.add((CategoryAbstract)new CategoryItemStack(entries, "guide.vampirism.vplayer.category", new ItemStack(Items.field_151144_bL, 1, 3)));
    }

    private static void registerVampireLord() {
        ArrayList<Object> entries = new ArrayList<Object>();
        ArrayList intro = new ArrayList();
        intro.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc("guide.vampirism.vlord.introduction.text", true)));
        entries.add(VampirismGuide.addLink("lord_intro", (EntryAbstract)new EntryUniText(intro, "guide.vampirism.vlord.introduction.title")));
        ArrayList<IPage> becomeOne = new ArrayList<IPage>();
        becomeOne.addAll(PageHelper.pagesForLongText((String)VampirismGuide.locAndFormat("guide.vampirism.vlord.become.text", 14, VampirismGuide.loc(ModItems.bloodEye.func_77658_a() + ".name"))));
        VampirismGuide.addLinksToPages(becomeOne, "items_blood_eye");
        entries.add(new EntryUniText(becomeOne, "guide.vampirism.vlord.become.title"));
        ArrayList<IPage> about = new ArrayList<IPage>();
        about.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc("guide.vampirism.vlord.about.text", true)));
        VampirismGuide.addLinksToPages(about, "lord_skills", "lord_minions", "lord_multiplayer");
        entries.add(new EntryUniText(about, "guide.vampirism.vlord.about.title"));
        ArrayList multiplayer = new ArrayList();
        multiplayer.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc("guide.vampirism.vlord.multiplayer.text", true)));
        entries.add(VampirismGuide.addLink("lord_multiplayer", (EntryAbstract)new EntryUniText(multiplayer, "guide.vampirism.vlord.multiplayer.title")));
        ArrayList<IPage> skills = new ArrayList<IPage>();
        skills.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc("guide.vampirism.vlord.skills.text", true)));
        VampirismGuide.addLinksToPages(skills, "vampire_skills");
        entries.add(VampirismGuide.addLink("lord_skills", (EntryAbstract)new EntryUniText(skills, "guide.vampirism.vlord.skills.title")));
        ArrayList<IPage> minions = new ArrayList<IPage>();
        minions.addAll(PageHelper.pagesForLongText((String)VampirismGuide.locAndFormat("guide.vampirism.vlord.minions.text", VampirismMod.proxy.getKey(REFERENCE.KEY.MINION_CONTROL), VampirismGuide.loc(ModItems.gemOfBinding.func_77658_a() + ".name"))));
        VampirismGuide.addLinksToPages(minions, "items_gemOfBinding", "items_minion_name_tag");
        entries.add(VampirismGuide.addLink("lord_minions", (EntryAbstract)new EntryUniText(minions, "guide.vampirism.vlord.minions.title")));
        categories.add((CategoryAbstract)new CategoryItemStack(entries, "guide.vampirism.vlord.category", new ItemStack((Item)ModItems.gemOfBinding)));
    }

    private static String loc(String unLoc) {
        return StatCollector.func_74838_a((String)unLoc);
    }

    private static String loc(String unLoc, boolean replace) {
        String s = VampirismGuide.loc(unLoc);
        if (replace) {
            s = s.replaceAll("/n", "\n");
        }
        return s;
    }

    private static String locAndFormat(String unLoc, Object ... objects) {
        return String.format(VampirismGuide.loc(unLoc, true), objects);
    }

    private static EntryAbstract createCraftableStackEntryLoc(ItemStack item, String locText) {
        ArrayList<PageIRecipe> pages = new ArrayList<PageIRecipe>();
        pages.addAll(PageHelper.pagesForLongText((String)locText, (ItemStack)item));
        pages.add(new PageIRecipe(VampirismGuide.getRecipe(item)));
        return new EntryUniText(pages, item.func_77977_a() + ".name");
    }

    private static EntryAbstract createUnlocLongTextEntry(String unlocTitle, String unlocText) {
        ArrayList pages = new ArrayList();
        pages.addAll(PageHelper.pagesForLongText((String)VampirismGuide.loc(unlocText, true)));
        return new EntryUniText(pages, unlocTitle);
    }

    private static EntryAbstract createCraftableStackEntry(ItemStack item, String unlocText) {
        return VampirismGuide.createCraftableStackEntryLoc(item, VampirismGuide.loc(unlocText));
    }

    private static IRecipe getRecipe(Item item) {
        return VampirismGuide.getRecipe(new ItemStack(item, 1));
    }

    private static IRecipe getRecipe(Block block) {
        return VampirismGuide.getRecipe(new ItemStack(block, 1));
    }

    private static IRecipe getRecipe(ItemStack stack) {
        for (Object obj : recipeList) {
            IRecipe recipe = (IRecipe)obj;
            if (recipe.func_77571_b() == null || !stack.func_77969_a(recipe.func_77571_b())) continue;
            return recipe;
        }
        return null;
    }

    private static void addLinksToPages(List<IPage> pages, String ... links) {
        ListIterator<IPage> it = pages.listIterator();
        while (it.hasNext()) {
            PageHolderWithLinks newP = new PageHolderWithLinks(it.next());
            for (String s : links) {
                newP.addLink(s);
            }
            it.set(newP);
        }
    }

    static {
        categories = new ArrayList<CategoryAbstract>();
        linkedEntries = new HashMap();
    }
}

