/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.teamlapen.vampirism.client.gui.VampireHudOverlay;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class RenderScreenRedPacket
implements IMessage {
    private int durationOn;
    private int durationOff;

    public RenderScreenRedPacket() {
    }

    public RenderScreenRedPacket(int durationOn, int durationOff) {
        this.durationOff = durationOff;
        this.durationOn = durationOn;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.durationOn = tag.func_74762_e("on");
        this.durationOff = tag.func_74762_e("off");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("on", this.durationOn);
        tag.func_74768_a("off", this.durationOff);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class RenderScreenRedManager {
        private final int on;
        private final int off;
        private int tick;

        public RenderScreenRedManager(int durationOn, int durationOff) {
            this.on = durationOn;
            this.off = durationOff;
            this.tick = this.on;
        }

        @SubscribeEvent
        public void onWorldTick(TickEvent.ClientTickEvent event) {
            if (event.phase.equals((Object)TickEvent.Phase.END)) {
                if (this.tick < -this.off) {
                    VampireHudOverlay.setRenderRed(0.0f);
                    FMLCommonHandler.instance().bus().unregister((Object)this);
                    return;
                }
                if (this.tick >= 0) {
                    VampireHudOverlay.setRenderRed(1.0f - (float)this.tick / (float)this.on * 1.0f);
                } else {
                    VampireHudOverlay.setRenderRed(((float)this.tick + (float)this.off) / (float)this.off);
                }
                --this.tick;
            }
        }
    }

    public static class Handler
    implements IMessageHandler<RenderScreenRedPacket, IMessage> {
        public IMessage onMessage(RenderScreenRedPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().bus().register((Object)new RenderScreenRedManager(message.durationOn, message.durationOff));
            return null;
        }
    }
}

