/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.render.particle.DarkLordParticle;
import de.teamlapen.vampirism.client.render.particle.FlyingBloodEntityParticle;
import de.teamlapen.vampirism.client.render.particle.FlyingBloodParticle;
import de.teamlapen.vampirism.client.render.particle.ParticleHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.TickRunnable;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SpawnCustomParticlePacket
implements IMessage {
    private NBTTagCompound data;
    private double posX;
    private double posY;
    private double posZ;
    private int amount;

    public SpawnCustomParticlePacket() {
    }

    public SpawnCustomParticlePacket(int type, double posX, double posY, double posZ, int amount, NBTTagCompound data) {
        this.data = data;
        this.data.func_74768_a("type", type);
        this.data.func_74780_a("posX", posX);
        this.data.func_74780_a("posY", posY);
        this.data.func_74780_a("posZ", posZ);
        this.data.func_74768_a("amount", amount);
    }

    public SpawnCustomParticlePacket(int type, double posX, double posY, double posZ, int amount) {
        this(type, posX, posY, posZ, amount, new NBTTagCompound());
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
        this.posX = this.data.func_74769_h("posX");
        this.posY = this.data.func_74769_h("posY");
        this.posZ = this.data.func_74769_h("posZ");
        this.amount = this.data.func_74762_e("amount");
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class Handler
    implements IMessageHandler<SpawnCustomParticlePacket, IMessage> {
        public IMessage onMessage(final SpawnCustomParticlePacket message, MessageContext ctx) {
            final WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return null;
            }
            try {
                switch (message.data.func_74762_e("type")) {
                    case 0: {
                        for (int i = 0; i < message.amount; ++i) {
                            FlyingBloodEntityParticle.addParticle(new FlyingBloodEntityParticle(message.posX, message.posY, message.posZ, message.data));
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < message.amount; ++i) {
                            FlyingBloodParticle.addParticle(new FlyingBloodParticle(message.posX, message.posY, message.posZ, message.data));
                        }
                        break;
                    }
                    case 2: {
                        Entity e = world.func_73045_a(message.data.func_74762_e("id"));
                        if (e != null && e instanceof EntityLivingBase) {
                            Helper.spawnParticlesAroundEntity((EntityLivingBase)e, message.data.func_74779_i("particle"), message.data.func_74769_h("distance"), message.amount);
                        }
                        break;
                    }
                    case 3: {
                        final Entity entity = world.func_73045_a(message.data.func_74762_e("id"));
                        if (entity == null) {
                            return null;
                        }
                        final boolean thePlayer = entity.equals((Object)Minecraft.func_71410_x().field_71439_g);
                        TickRunnable run = new TickRunnable(){
                            int tick = 0;

                            @Override
                            public boolean shouldContinue() {
                                return !entity.field_70128_L && this.tick < 100;
                            }

                            @Override
                            public void onTick() {
                                if (++this.tick % 5 == 0) {
                                    for (int i = 0; i < message.amount; ++i) {
                                        ParticleHandler.instance().addEffect(new DarkLordParticle((World)world, entity, thePlayer));
                                    }
                                }
                            }
                        };
                        VampirismMod.proxy.addTickRunnable(run);
                        break;
                    }
                    default: {
                        Logger.w("CustomParticlePacket", "Particle of type " + message.data.func_74762_e("type") + " is unknown", new Object[0]);
                        return null;
                    }
                }
            }
            catch (Exception e) {
                Logger.e("CustomParticlePacket", "Error", e);
            }
            return null;
        }
    }
}

