/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.teamlapen.vampirism.entity.VampireMob;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.network.ISyncable;
import de.teamlapen.vampirism.util.Logger;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.IExtendedEntityProperties;

public class UpdateEntityPacket
implements IMessage {
    private int id;
    private NBTTagCompound data;

    public UpdateEntityPacket() {
    }

    public UpdateEntityPacket(Entity entity) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        this.id = entity.func_145782_y();
        this.data = new NBTTagCompound();
        ((ISyncable)entity).writeFullUpdateToNBT(this.data);
    }

    public UpdateEntityPacket(Entity entity, NBTTagCompound data) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        this.id = entity.func_145782_y();
        this.data = data;
    }

    public UpdateEntityPacket(ISyncableExtendedProperties prop) {
        this.id = prop.getTheEntityID();
        this.data = new NBTTagCompound();
        prop.writeFullUpdateToNBT(this.data);
    }

    public UpdateEntityPacket(ISyncableExtendedProperties prop, NBTTagCompound nbt) {
        this.id = prop.getTheEntityID();
        this.data = nbt;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.id = tag.func_74762_e("id");
        this.data = tag.func_74775_l("data");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("id", this.id);
        tag.func_74782_a("data", (NBTBase)this.data);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static interface ISyncableExtendedProperties
    extends IExtendedEntityProperties,
    ISyncable {
        public int getTheEntityID();
    }

    public static class Handler
    implements IMessageHandler<UpdateEntityPacket, IMessage> {
        public static ISyncable tryToGetISyncable(Entity e) {
            if (e instanceof ISyncable) {
                return (ISyncable)e;
            }
            if (e instanceof EntityPlayer) {
                return VampirePlayer.get((EntityPlayer)e);
            }
            if (e instanceof EntityCreature) {
                return VampireMob.get((EntityCreature)e);
            }
            return null;
        }

        public IMessage onMessage(UpdateEntityPacket message, MessageContext ctx) {
            Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
            if (e != null) {
                ISyncable s = Handler.tryToGetISyncable(e);
                if (s != null) {
                    s.loadUpdateFromNBT(message.data);
                } else {
                    Logger.w("UpdateEntityPacket", "Trying to load data for " + e.toString() + ", but it does not implement ISyncable", new Object[0]);
                }
            }
            return null;
        }
    }
}

