/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileEntity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.ModPotion;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.item.ItemLeechSword;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class TileEntityBloodAltar1
extends TileEntity {
    private boolean occupied = false;
    private int bloodAmount;
    public final String OCCUPIED_NBTKEY = "occupied";
    public final String BLOOD_NBTKEY = "blood";
    public final String TICK_NBTKEY = "tick";
    public final String INFINITE_NBTKEY = "infinite";
    private final String TAG = "TEBloodAltar";
    public int distance = 25;
    private int tickCounter = 0;
    private TileEntityBeacon fakeBeacon;
    private boolean infinite = false;

    public boolean isInfinite() {
        return this.infinite;
    }

    public void dropSword() {
        if (this.isOccupied()) {
            EntityItem sword = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.getSwordToEject());
            this.field_145850_b.func_72838_d((Entity)sword);
            this.infinite = false;
        }
    }

    public int getBloodLeft() {
        return this.bloodAmount;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    @SideOnly(value=Side.CLIENT)
    public TileEntityBeacon getFakeBeacon() {
        return this.fakeBeacon;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    private ItemStack getSwordToEject() {
        ItemStack s = new ItemStack((Item)ModItems.leechSword, 1);
        ItemLeechSword.setBlood(s, this.bloodAmount);
        this.bloodAmount = 0;
        return s;
    }

    public boolean isActive() {
        return this.bloodAmount > 0;
    }

    public boolean isOccupied() {
        return this.occupied;
    }

    public void makeInfinite() {
        this.infinite = true;
        this.bloodAmount = 100;
        this.occupied = true;
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onActivated(EntityPlayer player, ItemStack itemStack) {
        if (this.occupied) {
            if (itemStack == null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.getSwordToEject());
            } else {
                this.dropSword();
            }
            this.occupied = false;
            this.func_70296_d();
        } else if (itemStack != null && ModItems.leechSword.equals(itemStack.func_77973_b())) {
            this.startRitual(player, itemStack);
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.occupied = nbt.func_74767_n("occupied");
        this.bloodAmount = nbt.func_74762_e("blood");
        this.tickCounter = nbt.func_74762_e("tick");
        if (nbt.func_74764_b("infinite")) {
            this.infinite = nbt.func_74767_n("infinite");
        }
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (world.field_72995_K) {
            this.fakeBeacon = new TileEntityBeacon();
            Helper.Reflection.setPrivateField(TileEntityBeacon.class, this.fakeBeacon, true, Helper.Obfuscation.getPosNames("TileEntityBeacon/field_146015_k"));
            this.fakeBeacon.func_145834_a(world);
        }
    }

    public void startRitual(EntityPlayer player, ItemStack itemStack) {
        if (VampirePlayer.get(player).getLevel() == 0) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.ritual_no_vampire", new Object[0]));
            return;
        }
        player.field_71071_by.func_146026_a(itemStack.func_77973_b());
        this.occupied = true;
        this.bloodAmount = ItemLeechSword.getBlood(itemStack);
        this.func_70296_d();
    }

    public void func_145845_h() {
        if (this.field_145850_b.func_82737_E() % 100L == 0L && !this.field_145850_b.field_72995_K && this.bloodAmount > 0) {
            if (!this.infinite) {
                --this.bloodAmount;
            }
            if (this.bloodAmount == 0) {
                this.func_70296_d();
            }
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b((double)this.distance, (double)this.distance, (double)this.distance);
            axisalignedbb.field_72337_e = this.field_145850_b.func_72800_K();
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, axisalignedbb);
            for (EntityPlayer entityplayer : list) {
                VampirePlayer vampire = VampirePlayer.get(entityplayer);
                if (vampire.getLevel() <= 0) continue;
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 120, 0, true));
                entityplayer.func_70690_d(new PotionEffect(ModPotion.saturation.field_76415_H, 120, 1, true));
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("occupied", this.occupied);
        nbt.func_74768_a("blood", this.bloodAmount);
        nbt.func_74768_a("tick", this.tickCounter);
        nbt.func_74757_a("infinite", this.infinite);
    }
}

