/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileEntity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.ModBlocks;
import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.ModPotion;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.network.RenderScreenRedPacket;
import de.teamlapen.vampirism.network.SpawnCustomParticlePacket;
import de.teamlapen.vampirism.tileEntity.InventoryTileEntity;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCompressed;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;

public class TileEntityBloodAltar4
extends InventoryTileEntity {
    private static final String TAG = "TEBAltar4";
    private int runningTick;
    private final int DURATION_TICK = 450;
    public static final int MIN_LEVEL = 4;
    private EntityPlayer player;
    private ChunkCoordinates[] tips;

    public TileEntityBloodAltar4() {
        super(new InventoryTileEntity.Slot[]{new InventoryTileEntity.Slot(ModItems.pureBlood, 44, 34), new InventoryTileEntity.Slot((Item)ModItems.humanHeart, 80, 34), new InventoryTileEntity.Slot(new InventoryTileEntity.IItemSelector(){

            @Override
            public boolean isItemAllowed(ItemStack item) {
                return false;
            }
        }, 116, 34)});
    }

    private boolean checkAndRemoveItems(int bloodMeta, int blood, int heart, int par3) {
        ItemStack stackPureBlood = this.func_70301_a(0);
        ItemStack stackHeart = this.func_70301_a(1);
        ItemStack stack3 = this.func_70301_a(2);
        if (blood > 0) {
            if (stackPureBlood == null || stackPureBlood.field_77994_a < blood) {
                return false;
            }
            if (stackPureBlood.func_77960_j() < bloodMeta) {
                return false;
            }
        }
        if (heart > 0 && (stackHeart == null || stackHeart.field_77994_a < heart)) {
            return false;
        }
        if (par3 > 0 && (stack3 == null || stack3.field_77994_a < par3)) {
            return false;
        }
        this.func_70298_a(0, blood);
        this.func_70298_a(1, heart);
        this.func_70298_a(2, par3);
        return true;
    }

    private LevReq checkLevelRequirement(EntityPlayer player, int sl) {
        if (sl == 0) {
            return LevReq.STRUCTURE_WRONG;
        }
        int pl = VampirePlayer.get(player).getLevel();
        if (pl < 4 || pl > 14) {
            return LevReq.LEVEL_WRONG;
        }
        if (pl == 4) {
            if (sl != 1) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(0, 0, 5, 0)) {
                return LevReq.ITEM_MISSING;
            }
        } else if (pl == 5) {
            if (sl != 1) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(0, 1, 0, 0)) {
                return LevReq.ITEM_MISSING;
            }
        } else if (pl == 6) {
            if (sl != 1) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(0, 1, 5, 0)) {
                return LevReq.ITEM_MISSING;
            }
        } else if (pl == 7) {
            if (sl != 2) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(1, 1, 0, 0)) {
                return LevReq.ITEM_MISSING;
            }
        } else if (pl == 8) {
            if (sl != 2) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(1, 1, 5, 0)) {
                return LevReq.ITEM_MISSING;
            }
        } else if (pl == 9) {
            if (sl != 3) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(2, 1, 5, 0)) {
                return LevReq.ITEM_MISSING;
            }
        } else if (pl == 10) {
            if (sl != 3) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(2, 1, 5, 0)) {
                return LevReq.ITEM_MISSING;
            }
        } else if (pl == 11) {
            if (sl != 4) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(3, 1, 10, 0)) {
                return LevReq.ITEM_MISSING;
            }
        } else if (pl == 12) {
            if (sl != 4) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(3, 1, 5, 0)) {
                return LevReq.ITEM_MISSING;
            }
        } else if (pl == 13) {
            if (sl != 4) {
                return LevReq.STRUCTURE_WRONG;
            }
            if (!this.checkAndRemoveItems(4, 2, 0, 0)) {
                return LevReq.ITEM_MISSING;
            }
        }
        return LevReq.OK;
    }

    private int determineLevel2() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Block type = null;
        ChunkCoordinates[] pos = this.findTips();
        if (pos.length != 6 && pos.length != 4) {
            Logger.d(TAG, "The tip count is wrong", new Object[0]);
            return 0;
        }
        boolean large = pos.length == 6;
        for (ChunkCoordinates p : pos) {
            for (int i = 1; i <= (large ? 3 : 2); ++i) {
                Block b = this.field_145850_b.func_147439_a(p.field_71574_a, p.field_71572_b - i, p.field_71573_c);
                if (type == null) {
                    type = b;
                    continue;
                }
                Logger.d(TAG, "Looking for %s but found %s at %d %d %d", type.func_149739_a(), b.func_149739_a(), p.field_71574_a, p.field_71572_b - i, p.field_71573_c);
                if (type.equals(b)) continue;
                return 0;
            }
        }
        if (large) {
            if (type instanceof BlockCompressed) {
                if (type.func_149728_f(1).equals(MapColor.field_151668_h)) {
                    return 3;
                }
                if (type.func_149728_f(1).equals(MapColor.field_151647_F)) {
                    return 4;
                }
            }
        } else {
            if (type instanceof BlockStoneBrick) {
                return 1;
            }
            if (type instanceof BlockCompressed && type.func_149728_f(1).equals(MapColor.field_151668_h)) {
                return 2;
            }
        }
        return 0;
    }

    private int[][][] rotateBy90(int[][][] matrix) {
        int[][][] result = new int[matrix.length][][];
        for (int y = 0; y < matrix.length; ++y) {
            result[y] = this.rotateBy90(matrix[y]);
        }
        return result;
    }

    private int[][] rotateBy90(int[][] matrix) {
        int M = matrix.length;
        int N = matrix[0].length;
        int[][] result = new int[N][M];
        for (int m = 0; m < M; ++m) {
            for (int n = 0; n < N; ++n) {
                result[N - 1 - n][m] = matrix[m][n];
            }
        }
        return result;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public String func_145825_b() {
        return "block.vampirism.bloodAltarTier4.name";
    }

    public PHASE getPhase() {
        if (this.runningTick < 1) {
            return PHASE.NOT_RUNNING;
        }
        if (this.runningTick == 1) {
            return PHASE.CLEAN_UP;
        }
        if (this.runningTick > 350) {
            return PHASE.PARTICLE_SPREAD;
        }
        if (this.runningTick < 290 && this.runningTick >= 250) {
            return PHASE.BEAM1;
        }
        if (this.runningTick < 250 && this.runningTick > 50) {
            return PHASE.BEAM2;
        }
        if (this.runningTick == 50) {
            return PHASE.LEVELUP;
        }
        if (this.runningTick < 50) {
            return PHASE.ENDING;
        }
        return PHASE.WAITING;
    }

    public EntityPlayer getPlayer() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.player;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int getRunningTick() {
        return this.runningTick;
    }

    public ChunkCoordinates[] getTips() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.tips;
    }

    private ChunkCoordinates[] findTips() {
        ArrayList<ChunkCoordinates> coord = new ArrayList<ChunkCoordinates>();
        int lx = this.field_145851_c - 3;
        int ly = this.field_145848_d;
        int lz = this.field_145849_e - 3;
        int hx = lx + 6;
        int hy = ly + 4;
        int hz = lz + 6;
        for (int x = lx; x <= hx; ++x) {
            for (int z = lz; z <= hz; ++z) {
                for (int y = ly; y <= hy; ++y) {
                    if (!this.field_145850_b.func_147439_a(x, y, z).equals((Object)ModBlocks.bloodAltar4Tip)) continue;
                    coord.add(new ChunkCoordinates(x, y, z));
                }
            }
        }
        return coord.toArray(new ChunkCoordinates[coord.size()]);
    }

    public void onBlockActivated(EntityPlayer player) {
        if (this.runningTick > 0) {
            return;
        }
        int sl = 0;
        try {
            sl = this.determineLevel2();
        }
        catch (Exception e) {
            Logger.e(TAG, e, "Failed to determine level", new Object[0]);
        }
        LevReq result = this.checkLevelRequirement(player, sl);
        Logger.d(TAG, "SL: " + sl + " Result: " + (Object)((Object)result), new Object[0]);
        if (result != LevReq.OK) {
            if (!this.field_145850_b.field_72995_K) {
                if (result == LevReq.ITEM_MISSING) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.ritual_missing_times", new Object[0]));
                }
                if (result == LevReq.STRUCTURE_WRONG) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.ritual_structure_wrong", new Object[0]));
                }
                if (result == LevReq.LEVEL_WRONG) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("text.vampirism.ritual_level_wrong", new Object[0]));
                }
            }
            return;
        }
        this.runningTick = 450;
        this.player = player;
        this.tips = this.findTips();
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < this.tips.length; ++i) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74768_a("destX", this.tips[i].field_71574_a);
                data.func_74768_a("destY", this.tips[i].field_71572_b);
                data.func_74768_a("destZ", this.tips[i].field_71573_c);
                data.func_74768_a("age", 100);
                VampirismMod.modChannel.sendToAll((IMessage)new SpawnCustomParticlePacket(1, this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, data));
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 450, 10));
        this.func_70296_d();
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        int tick = tagCompound.func_74762_e("tick");
        if (tick > 0 && this.player == null) {
            try {
                this.player = (EntityPlayer)this.field_145850_b.func_73045_a(tagCompound.func_74762_e("playerId"));
                this.tips = this.findTips();
                this.runningTick = tick;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.player == null) {
            this.runningTick = 0;
            this.tips = null;
        }
    }

    private void setBlocks(int lx, int ly, int lz, int hx, int hy, int hz, int[][][] structure) {
        for (int x = lx; x <= hx; ++x) {
            for (int z = lz; z <= hz; ++z) {
                for (int y = ly; y < hy; ++y) {
                    int type = structure[y - ly][z - lz][x - lx];
                    if (type == 0) {
                        this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150350_a);
                    }
                    if (type == 2) {
                        this.field_145850_b.func_147449_b(x, y, z, (Block)ModBlocks.bloodAltar4Tip);
                    }
                    if (type == 3) {
                        this.field_145850_b.func_147449_b(x, y, z, (Block)ModBlocks.bloodAltar4);
                    }
                    if (type == 4) {
                        this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150324_C);
                    }
                    if (type != 1) continue;
                    this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150417_aV);
                }
            }
        }
    }

    public void func_145845_h() {
        --this.runningTick;
        if (this.runningTick <= 0) {
            return;
        }
        if (this.player == null || this.player.field_70128_L) {
            this.runningTick = 1;
        } else {
            this.player.field_70159_w = 0.0;
            this.player.field_70181_x = this.player.field_70181_x >= 0.0 ? 0.0 : (this.player.field_70181_x /= 2.0);
            this.player.field_70179_y = 0.0;
        }
        PHASE phase = this.getPhase();
        if (!this.field_145850_b.field_72995_K) {
            if (phase.equals((Object)PHASE.PARTICLE_SPREAD) && this.runningTick % 15 == 0) {
                for (int i = 0; i < this.tips.length; ++i) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74768_a("destX", this.tips[i].field_71574_a);
                    data.func_74768_a("destY", this.tips[i].field_71572_b);
                    data.func_74768_a("destZ", this.tips[i].field_71573_c);
                    data.func_74768_a("age", 60);
                    VampirismMod.modChannel.sendToAll((IMessage)new SpawnCustomParticlePacket(1, this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, data));
                }
            }
            if (this.runningTick == 250) {
                VampirismMod.modChannel.sendTo((IMessage)new RenderScreenRedPacket(200, 50), (EntityPlayerMP)this.player);
            }
        }
        if (phase.equals((Object)PHASE.CLEAN_UP)) {
            this.player = null;
            this.tips = null;
            this.func_70296_d();
        }
        if (phase.equals((Object)PHASE.LEVELUP)) {
            VampirePlayer.get(this.player).levelUp();
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72908_a(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, "random.explode", 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                this.field_145850_b.func_72869_a("hugeexplosion", this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, 1.0, 0.0, 0.0);
            } else {
                this.player.func_70690_d(new PotionEffect(ModPotion.saturation.field_76415_H, 400, 2));
            }
            this.player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 400, 2));
            this.player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 400, 2));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("tick", this.runningTick);
        if (this.player != null) {
            tagCompound.func_74768_a("playerId", this.player.func_145782_y());
        }
    }

    public static enum PHASE {
        NOT_RUNNING,
        PARTICLE_SPREAD,
        BEAM1,
        BEAM2,
        WAITING,
        LEVELUP,
        ENDING,
        CLEAN_UP;

    }

    private static enum LevReq {
        OK,
        STRUCTURE_WRONG,
        ITEM_MISSING,
        LEVEL_WRONG;

    }
}

