/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.util.DefaultBoolean;
import de.teamlapen.vampirism.util.DefaultDouble;
import de.teamlapen.vampirism.util.DefaultInt;

public final class BALANCE {
    @DefaultInt(value=2, minValue=1, name="Player Level for Vampire Hunter Attack", comment="Vampirehunters attack players with a vampire level higher than this")
    public static int VAMPIRE_HUNTER_ATTACK_LEVEL;
    @DefaultInt(value=2, minValue=1, name="Player Level for Vampire Attack", comment="Vampires attack players unless their vampire level is higher than this")
    public static int VAMPIRE_FRIENDLY_LEVEL;
    @DefaultInt(value=5, minValue=0, name="Vampire Hunter Spawn", comment="Not used anymore")
    public static int VAMPIRE_HUNTER_SPAWN_PROBE;
    @DefaultInt(value=100, minValue=0, name="Vampire Spawn Probe", comment="")
    public static int VAMPIRE_SPAWN_PROBE;
    @DefaultInt(value=30, minValue=0, name="Vampire Lord Spawn Probe", comment="Not used anymore")
    public static int VAMPIRE_LORD_SPAWN_PROBE;
    @DefaultBoolean(value=true, name="Vampire Player Loose Level", comment="Whether vampireplayers should loose level if killed by a hunter")
    public static boolean VAMPIRE_PLAYER_LOOSE_LEVEL;
    @DefaultInt(value=1, name="Player min turn level", comment="Minimum vampire level a player need to have to turn other creatures")
    public static int VAMPIRE_PLAYER_MIN_TURN_LEVEL;
    @DefaultDouble(value=7.0, minValue=0.0, name="Vampire Player Sun Damage", comment="")
    public static double VAMPIRE_PLAYER_SUN_DAMAGE;
    @DefaultInt(value=2, minValue=1, name="Vampire Player Creeper Avoidance Level", comment="")
    public static int VAMPIRE_PLAYER_CREEPER_AVOID_LEVEL;
    @DefaultInt(value=10, comment="Probability that a vampire gives you sanguinare (1/n)", name="Sanguinare Probability", minValue=1)
    public static int VAMPIRE_PLAYER_SANGUINARE_PROB;
    @DefaultInt(value=1200, comment="Duration of the sanguinare vampiris effect in seconds", name="Sanguinare Duration", minValue=1)
    public static int VAMPIRE_PLAYER_SANGUINARE_DURATION;
    @DefaultInt(value=6, name="Bite damage", minValue=0)
    public static int VAMPIRE_PLAYER_BITE_DMG;
    @DefaultInt(value=40, name="Blood vision max distance", minValue=5)
    public static int VAMPIRE_PLAYER_BLOOD_VISION_DISTANCE;
    @DefaultInt(value=5, name="Blood vision mix distance", minValue=0)
    public static int VAMPIRE_PLAYER_BLOOD_VISION_MIN_DISTANCE;
    @DefaultInt(value=60, comment="Duration of the sanguinare vampiris effect in seconds", name="Sanguinare Duration for Mobs", minValue=1)
    public static int VAMPIRE_MOB_SANGUINARE_DURATION;
    @DefaultDouble(value=1.0, minValue=0.01, maxValue=1.0, name="Mob Health to Suck Blood", comment="Not used anymore")
    public static double SUCK_BLOOD_HEALTH_REQUIREMENT;
    @DefaultDouble(value=1.0, minValue=0.1, maxValue=4.0, name="Blood Saturation", comment="Influences the blood usage.")
    public static double BLOOD_SATURATION;
    @DefaultInt(value=4, minValue=1, maxValue=100, name="Blood Exhaustion per Level", comment="Amount of exhaustion, which has to be reached to loose one blood")
    public static int BLOOD_EXH_PER_BL;
    @DefaultInt(value=3, minValue=-1, name="Create dead mob probability", comment="1/n Propability to create a dead mob entity. -1 to disable, 0 to always")
    public static int DEAD_MOB_PROP;
    @DefaultInt(value=50, minValue=0, maxValue=1000, name="Altar of regeneration spawn chance", comment="Chance that a altar is generated. n/1000 for each valid chunk")
    public static int ALTAR_1_SPAWN_CHANCE;
    @DefaultInt(value=30, minValue=0, maxValue=1000, name="Hunter camp spawn chance", comment="Chance that a camp is generated. n/1000 for each valid chunk")
    public static int HUNTER_CAMP_SPAWN_CHANCE;

    public static float getVampirePlayerNightVision(int level) {
        float nv = (float)level == 0.0f ? 0.0f : 1.0f - (float)(2 / level);
        return nv < 0.0f ? 0.0f : nv;
    }

    public static class VV_PROP {
        @DefaultInt(value=4, minValue=1, name="Hunter's Tolerance for Biting Villagers", comment="How many villagers can be bitten until the hunters get agressive")
        public static int BITTEN_UNTIL_AGRESSIVE;
        @DefaultInt(value=4, minValue=1, name="Hunter's Tolerance for Killing Villagers", comment="How many villagers have to be killed by Vampires until the hunters get agressive")
        public static int CONVERTED_UNTIL_AGRESSIVE;
        @DefaultInt(value=50, minValue=1, name="Villagers Forgiveness Rate", comment="Determines how fast the villages forget about their fallen citizens.")
        public static int REDUCE_RATE;
    }

    public static class VP_SKILLS {
        @DefaultInt(value=60, minValue=0, name="Regeneration Cool Down", comment="In seconds")
        public static int REGEN_COOLDOWN;
        @DefaultInt(value=20, minValue=0, name="Regeneration Duration", comment="In seconds")
        public static int REGEN_DURATION;
        @DefaultInt(value=4, minValue=-1, name="Regeneration Min Level", comment="Set to -1 to deactivate this skill")
        public static int REGEN_MIN_LEVEL;
        @DefaultInt(value=60, minValue=0, name="Weather Cool Down", comment="In seconds")
        public static int WEATHER_COOLDOWN;
        @DefaultInt(value=4, minValue=-1, name="Weather Min Level", comment="Set to -1 to deactivate this skill")
        public static int WEATHER_MIN_LEVEL;
        @DefaultInt(value=60, minValue=0, name="Revive Fallen Cool Down", comment="In seconds")
        public static int REVIVE_FALLEN_COOLDOWN;
        @DefaultInt(value=7, minValue=-1, name="Revive Fallen Min Level", comment="Set to -1 to deactivate this skill")
        public static int REVIVE_FALLEN_MIN_LEVEL;
        @DefaultInt(value=20, minValue=0, name="Vampire Rage Cool Down", comment="Vampire Rage cooldown duration")
        public static int RAGE_COOLDOWN;
        @DefaultInt(value=10, minValue=1, name="Vampire Rage Duration", comment="Standard Vampire Rage duration")
        public static int RAGE_MIN_DURATION;
        @DefaultInt(value=5, minValue=0, name="Vampire Rage Duration Increase", comment="Vampire Rage duration increase per level")
        public static int RAGE_DUR_PL;
        @DefaultInt(value=8, minValue=-1, name="Vampire Rage Min Level", comment="Set to -1 to deactivate this skill")
        public static int RAGE_MIN_LEVEL;
        @DefaultInt(value=10, name="Invisibility (Vampire Lord) Duration")
        public static int INVISIBILITY_DURATION;
        @DefaultInt(value=45, name="Invisibility Cooldown")
        public static int INVISIBILITY_COOLDOWN;
        @DefaultInt(value=2, minValue=1, name="Bat Speed Modifier")
        public static int BAT_SPEED_MOD;
        @DefaultInt(value=3, minValue=-1, name="Bat Transformation Min Level")
        public static int BAT_MIN_LEVEL;
        @DefaultInt(value=5, minValue=-1, name="Summon blinding bats Min Level")
        public static int SUMMON_BAT_MIN_LEVEL;
        @DefaultInt(value=300, minValue=1, name="Summon blinding bats cooldown")
        public static int SUMMON_BAT_COOLDOWN;
        @DefaultInt(value=16, minValue=1, name="Summon blinding bats count")
        public static int SUMMON_BAT_COUNT;
        @DefaultInt(value=60, minValue=1, name="Lord teleport max distance")
        public static int TELEPORT_MAX_DISTANCE;
        @DefaultInt(value=30, minValue=1, name="Lord teleport cooldown")
        public static int TELEPORT_COOLDOWN;
        @DefaultInt(value=0, minValue=-1, maxValue=0, name="Teleport min level", comment="Can only be -1 (disabled) or 0 (enabled")
        public static int TELEPORT_MIN_LEVEL;
        @DefaultInt(value=60, minValue=1, name="Freeze cooldown")
        public static int FREEZE_COOLDOWN;
        @DefaultInt(value=0, minValue=-1, maxValue=0, name="Freeze min level", comment="Can only be -1 (disabled) or 0 (enabled")
        public static int FREEZE_MIN_LEVEL;
        @DefaultInt(value=6, minValue=1, maxValue=30, name="Freeze duration")
        public static int FREEZE_DURATION;

        public static int getVampireLordDuration(int level) {
            if (level < RAGE_MIN_LEVEL) {
                return 0;
            }
            return 20 * (RAGE_MIN_DURATION + (level - RAGE_MIN_LEVEL) * RAGE_DUR_PL);
        }
    }

    public static class VP_MODIFIERS {
        @DefaultDouble(value=1.0, minValue=0.5, maxValue=2.0, name="Health Max Modifier", comment="")
        public static double HEALTH_MAX_MOD;
        @DefaultInt(value=20, minValue=10, maxValue=40, name="Health Level Cap", comment="")
        public static int HEALTH_LCAP;
        @DefaultDouble(value=0.5, minValue=0.5, maxValue=1.0, name="Health Type", comment="0.5 for square root, 1 for linear")
        public static double HEALTH_TYPE;
        @DefaultDouble(value=1.0, minValue=0.5, maxValue=2.0, name="Strength Max Modifier", comment="")
        public static double STRENGTH_MAX_MOD;
        @DefaultInt(value=20, minValue=10, maxValue=40, name="Strength Level Cap", comment="")
        public static int STRENGTH_LCAP;
        @DefaultDouble(value=0.5, minValue=0.5, maxValue=1.0, name="Strength Modifier Type", comment="0.5 for square root, 1 for linear")
        public static double STRENGTH_TYPE;
        @DefaultDouble(value=0.3, minValue=0.15, maxValue=5.0, name="Speed Max Modifier", comment="")
        public static double SPEED_MAX_MOD;
        @DefaultInt(value=15, minValue=7, maxValue=100, name="Speed Level Cap", comment="")
        public static int SPEED_LCAP;
        @DefaultDouble(value=0.5, minValue=0.1, maxValue=1.0, name="Speed Type", comment="")
        public static double SPEED_TYPE;
        @DefaultDouble(value=0.2, minValue=0.1, maxValue=0.4, name="Jump Max Boost", comment="")
        public static double JUMP_MAX_BOOST;
        @DefaultInt(value=6, minValue=3, maxValue=100, name="Jump Level Cap", comment="")
        public static int JUMP_LCAP;
        @DefaultDouble(value=0.5, minValue=0.1, maxValue=1.0, name="Jump Type", comment="")
        public static double JUMP_TYPE;
    }

    public static class MOBPROP {
        @DefaultDouble(value=20.0, minValue=10.0, maxValue=40.0, name="Vampire Max Health", comment="")
        public static double VAMPIRE_MAX_HEALTH;
        @DefaultDouble(value=5.0, minValue=2.5, maxValue=10.0, name="Vampire Attack Damage", comment="")
        public static double VAMPIRE_ATTACK_DAMAGE;
        @DefaultDouble(value=0.3, minValue=0.1, maxValue=0.6, name="Vampire Movement Speed", comment="")
        public static double VAMPIRE_MOVEMENT_SPEED;
        @DefaultInt(value=10, minValue=5, maxValue=20, name="Distance where Hunter Attacks Vampire", comment="")
        public static int VAMPIRE_DISTANCE_HUNTER;
        @DefaultDouble(value=130.0, minValue=20.0, maxValue=150.0, name="Vampire Lord Max Health", comment="")
        public static double VAMPIRE_LORD_MAX_HEALTH;
        @DefaultDouble(value=7.0, minValue=1.0, maxValue=14.0, name="Vampire Lord Attack Damage", comment="")
        public static double VAMPIRE_LORD_ATTACK_DAMAGE;
        @DefaultDouble(value=0.35, minValue=0.1, maxValue=0.6, name="Vampire Lord Movement Speed", comment="")
        public static double VAMPIRE_LORD_MOVEMENT_SPEED;
        @DefaultDouble(value=1.27, minValue=1.0, maxValue=2.0, name="Vampire Lord Improvement per Level", comment="For each higher level the stats are multiplied with this factor")
        public static double VAMPIRE_LORD_IMPROVEMENT_PER_LEVEL;
        @DefaultDouble(value=35.0, minValue=15.0, maxValue=70.0, name="Vampire Hunter Max Health", comment="")
        public static double VAMPIRE_HUNTER_MAX_HEALTH;
        @DefaultDouble(value=2.5, minValue=1.0, maxValue=5.0, name="Vampire Hunter Attack Damage", comment="")
        public static double VAMPIRE_HUNTER_ATTACK_DAMAGE;
        @DefaultDouble(value=0.28, minValue=0.1, maxValue=0.6, name="Vampire Hunter Movement Speed", comment="")
        public static double VAMPIRE_HUNTER_MOVEMENT_SPEED;
        @DefaultInt(value=5, minValue=0, maxValue=20, name="Maximum Vampire Hunters per Village", comment="")
        public static int VAMPIRE_HUNTER_MAX_PER_VILLAGE;
        @DefaultDouble(value=1.4, minValue=1.0, maxValue=3.0, name="Vampire Hunter Agressive Multiplier", comment="")
        public static double VAMPIRE_HUNTER_AGRESSIVE_MULT;
        @DefaultDouble(value=20.0, minValue=5.0, maxValue=200.0, name="Vampire Minion Max Health", comment="")
        public static double VAMPIRE_MINION_MAX_HEALTH;
        @DefaultDouble(value=6.0, minValue=1.5, maxValue=20.0, name="Vampire Minion Attack Damage", comment="")
        public static double VAMPIRE_MINION_ATTACK_DAMAGE;
        @DefaultDouble(value=0.25, minValue=0.1, maxValue=0.5, name="Vampire Minion Movement Speed", comment="")
        public static double VAMPIRE_MINION_MOVEMENT_SPEED;
        @DefaultInt(value=5, minValue=-1, name="Vampire Minion Regenerate Seconds", comment="Regenerate 1 heart every n seconds. -1 to disable")
        public static int VAMPIRE_MINION_REGENERATE_SECS;
        @DefaultDouble(value=300.0, minValue=50.0, maxValue=150.0, name="Dracula Max Health", comment="")
        public static double DRACULA_MAX_HEALTH;
        @DefaultDouble(value=12.0, minValue=5.0, maxValue=20.0, name="Dracula Attack Damage", comment="")
        public static double DRACULA_ATTACK_DAMAGE;
        @DefaultDouble(value=0.4, minValue=0.2, maxValue=0.8, name="Dracula Movement Speed", comment="")
        public static double DRACULA_MOVEMENT_SPEED;
        @DefaultInt(value=5, minValue=-1, name="Dracula Regenerate Seconds", comment="Regenerate 1 heart every n seconds. -1 to disable")
        public static int DRACULA_REGENERATE_SECS;
        @DefaultDouble(value=1.0, minValue=0.0, name="Vampire Mob Default DMG")
        public static double VAMPIRE_MOB_DEFAULT_DMG;
    }

    public static class LEVELING {
        @DefaultInt(value=40, minValue=20, maxValue=800, name="Minimum Blood for Altar 2", comment="Blood required for the first level up with altar 2")
        public static int ALTAR_2_MIN_BLOOD;
        @DefaultInt(value=30, minValue=10, maxValue=600, name="Extra Blood per Level", comment="Extra blood per level required")
        public static int ALTAR_2_ADD_BLOOD_PER_LEVEL;

        public static int A2_getRequiredBlood(int level) {
            return ALTAR_2_MIN_BLOOD + (level - 1) * ALTAR_2_ADD_BLOOD_PER_LEVEL;
        }
    }
}

