/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import cpw.mods.fml.common.gameevent.TickEvent;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class VampireLordData
extends WorldSavedData {
    private static final String IDENTIFIER = "vampirism_lord_data";
    private static final String TAG = "VampLordData";
    private boolean shouldRegenerateCastleDim = false;
    private boolean portalEnabled = true;
    private final List<UUID> lords = new ArrayList<UUID>();
    private long joinTime = -1L;
    private long lastOnlineTime;
    private final List<UUID> disabledLord = new ArrayList<UUID>();

    public boolean shouldRegenerateCastleDim() {
        return this.shouldRegenerateCastleDim;
    }

    public void setRegenerateCastleDim(boolean shouldRegenerateCastleDim) {
        this.shouldRegenerateCastleDim = shouldRegenerateCastleDim;
    }

    public boolean isPortalEnabled() {
        return this.portalEnabled;
    }

    public boolean canCallDracula() {
        return this.lords.isEmpty() || Configs.mulitple_lords;
    }

    public static VampireLordData get(World world) {
        VampireLordData data = (VampireLordData)world.field_72988_C.func_75742_a(VampireLordData.class, IDENTIFIER);
        if (data == null) {
            data = new VampireLordData(IDENTIFIER);
            world.field_72988_C.func_75745_a(IDENTIFIER, (WorldSavedData)data);
        }
        return data;
    }

    public VampireLordData(String identifier) {
        super(identifier);
    }

    public boolean isLord(EntityPlayer player) {
        return this.lords.contains(player.func_110124_au());
    }

    public boolean makeLord(EntityPlayer player) {
        if (VampirePlayer.get(player).setVampireLord(true)) {
            if (!this.lords.contains(player.func_110124_au())) {
                if (!Configs.mulitple_lords && !this.lords.isEmpty()) {
                    for (UUID uuid : this.lords) {
                        EntityPlayer p = this.getPlayerFormUUID(uuid);
                        if (p == null) continue;
                        VampirePlayer.get(p).setVampireLord(false);
                        p.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.lord.vampire_replace", new Object[0]));
                    }
                    this.lords.clear();
                }
                this.lords.add(player.func_110124_au());
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.lord.become", new Object[0]));
                Helper.sendMessageToAllExcept(player, new ChatComponentText(player.getDisplayName() + " ").func_150257_a((IChatComponent)new ChatComponentTranslation("text.vampirism.lord.other_player_become", new Object[0])));
            }
            this.lastOnlineTime = MinecraftServer.func_71276_C().func_71218_a(0).func_82737_E();
            this.func_76185_a();
            return true;
        }
        return false;
    }

    public boolean replaceLord(EntityPlayer oldPlayer, EntityPlayer newPlayer) {
        if (VampirePlayer.get(newPlayer).setVampireLord(true)) {
            this.lords.remove(oldPlayer.func_110124_au());
            oldPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.lord.vampire_kill_replace", new Object[0]));
            if (!this.lords.contains(newPlayer)) {
                this.lords.add(newPlayer.func_110124_au());
                newPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.lord.become", new Object[0]));
                Helper.sendMessageToAllExcept(newPlayer, new ChatComponentText(newPlayer.getDisplayName() + " ").func_150257_a((IChatComponent)new ChatComponentTranslation("text.vampirism.lord.other_player_become", new Object[0])));
            }
            this.func_76185_a();
            return true;
        }
        return false;
    }

    public void makeNoLord(EntityPlayer player, String reason) {
        this.lords.remove(player.func_110124_au());
        if (!Configs.mulitple_lords) {
            this.openAndRegenDim(true);
        }
        if (reason != null) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation(reason, new Object[0]));
        }
        VampirePlayer.get(player).setVampireLord(false);
        this.func_76185_a();
    }

    public void onDraculaDied() {
        if (Configs.mulitple_lords) {
            this.openAndRegenDim(false);
        } else {
            this.portalEnabled = false;
            this.func_76185_a();
        }
    }

    public String getLordNamesAsString() {
        String s = "";
        for (UUID uuid : this.lords) {
            EntityPlayer p = this.getPlayerFormUUID(uuid);
            if (p != null) {
                s = s + p.getDisplayName() + " \n";
                continue;
            }
            s = s + uuid.toString() + " \n";
        }
        return s;
    }

    private void checkLords() {
        if (!Configs.mulitple_lords && this.lords.size() > 0) {
            if (this.getPlayerFormUUID(this.lords.get(0)) == null) {
                this.joinTime = -1L;
                if (this.shouldLooseLord(this.lords.get(0))) {
                    Logger.d(TAG, "Lord %s is offline and looses his lord status", this.lords.get(0));
                    this.disabledLord.add(this.lords.remove(0));
                    this.openAndRegenDim(true);
                    this.func_76185_a();
                }
            } else if (this.joinTime == -1L) {
                this.joinTime = MinecraftServer.func_71276_C().field_71305_c[0].func_82737_E();
            } else if (MinecraftServer.func_71276_C().func_71218_a(0).func_82737_E() - this.joinTime > 200L) {
                this.lastOnlineTime = MinecraftServer.func_71276_C().func_71218_a(0).func_82737_E();
                this.func_76185_a();
            }
        }
    }

    private void openAndRegenDim(boolean message) {
        this.shouldRegenerateCastleDim = true;
        this.portalEnabled = true;
        if (message) {
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentTranslation("text.vampirism.lord.new_lord_castle", new Object[0]));
        }
        this.func_76185_a();
    }

    private boolean shouldLooseLord(UUID uuid) {
        if (MinecraftServer.func_71276_C().func_71264_H()) {
            return false;
        }
        boolean flag = false;
        for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayer p = (EntityPlayer)o;
            if (VampirePlayer.get(p).getLevel() != 14 || this.isLord(p)) continue;
            flag = true;
        }
        return flag && MathHelper.func_76141_d((float)(((float)MinecraftServer.func_71276_C().func_71218_a(0).func_82737_E() - (float)this.lastOnlineTime) / 24000.0f)) > Configs.looseLordDaysCount;
    }

    private EntityPlayer getPlayerFormUUID(UUID uuid) {
        List l = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayer e : l) {
            if (!e.func_110124_au().equals(uuid)) continue;
            return e;
        }
        return null;
    }

    private void checkDisabledLords() {
        Iterator<UUID> it = this.disabledLord.iterator();
        while (it.hasNext()) {
            UUID uuid = it.next();
            EntityPlayer player = this.getPlayerFormUUID(uuid);
            if (player != null) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.lord.vampire_replace_absence", new Object[0]));
                it.remove();
            }
            this.func_76185_a();
        }
    }

    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END) && MinecraftServer.func_71276_C().func_71259_af() % 100 == 0) {
            this.checkLords();
            this.checkDisabledLords();
        }
    }

    public void reset() {
        Iterator<UUID> it = this.lords.iterator();
        while (it.hasNext()) {
            EntityPlayer player = this.getPlayerFormUUID(it.next());
            if (player != null) {
                VampirePlayer.get(player).setVampireLord(false);
            }
            it.remove();
        }
        this.lastOnlineTime = 0L;
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("Vampire Lords were reset"));
        this.openAndRegenDim(true);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.shouldRegenerateCastleDim = nbt.func_74767_n("regenerate");
        this.portalEnabled = nbt.func_74767_n("portal");
        this.lastOnlineTime = nbt.func_74763_f("last_online");
        try {
            long m;
            long l;
            int i = 0;
            while (nbt.func_74764_b("lord_ls_" + i)) {
                l = nbt.func_74763_f("lord_ls_" + i);
                m = nbt.func_74763_f("lord_ms_" + i);
                this.lords.add(new UUID(m, l));
                ++i;
            }
            i = 0;
            while (nbt.func_74764_b("dis_lord_ls_" + i)) {
                l = nbt.func_74763_f("dis_lord_ls_" + i);
                m = nbt.func_74763_f("dis_lord_ms_" + i);
                this.disabledLord.add(new UUID(m, l));
                ++i;
            }
        }
        catch (Exception e) {
            Logger.e(TAG, e, "Failed to read lord uuids", new Object[0]);
        }
        Logger.d(TAG, "Loaded %d %d lords", this.lords.size(), this.disabledLord.size());
        if (!Configs.mulitple_lords && this.lords.size() > 1) {
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("The configuration was changed so that only one player can be a vampire lord at a time"));
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("Therefore all players loose their lord status"));
            this.openAndRegenDim(false);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        int i;
        nbt.func_74757_a("regenerate", this.shouldRegenerateCastleDim);
        nbt.func_74757_a("portal", this.portalEnabled);
        for (i = 0; i < this.lords.size(); ++i) {
            nbt.func_74772_a("lord_ls_" + i, this.lords.get(i).getLeastSignificantBits());
            nbt.func_74772_a("lord_ms_" + i, this.lords.get(i).getMostSignificantBits());
        }
        for (i = 0; i < this.disabledLord.size(); ++i) {
            nbt.func_74772_a("dis_lord_ls_" + i, this.disabledLord.get(i).getLeastSignificantBits());
            nbt.func_74772_a("dis_lord_ms_" + i, this.disabledLord.get(i).getMostSignificantBits());
        }
        nbt.func_74772_a("last_online", this.lastOnlineTime);
    }
}

