/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.resources;

import java.util.HashMap;
import mod.lucky.crafting.RecipeAddons;
import mod.lucky.drop.value.ValueParser;
import mod.lucky.resources.BaseResource;
import mod.lucky.resources.loader.BaseLoader;
import mod.lucky.util.LuckyReader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ResourceRecipes
extends BaseResource {
    private static Ingredient getIngredient(String s) {
        if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s))) {
            return null;
        }
        Item item = ValueParser.getItem(s, null);
        ItemStack itemStack = ValueParser.getItemStack(s, null);
        if (item != null) {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        }
        if (itemStack != null) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{itemStack});
        }
        return null;
    }

    @Override
    public void process(LuckyReader reader, BaseLoader loader) {
        try {
            String curLine;
            while ((curLine = reader.readLine()) != null) {
                int i;
                String[] recipePart = curLine.split(",");
                NonNullList ingredients = NonNullList.func_191196_a();
                ItemStack result = new ItemStack((IItemProvider)loader.getBlock());
                if (ResourceRecipes.getIngredient(recipePart[0]) != null) {
                    for (String part : recipePart) {
                        Ingredient ingredient = ResourceRecipes.getIngredient(part);
                        if (ingredient == null) continue;
                        ingredients.add((Object)ingredient);
                    }
                    ShapelessRecipe recipe = new ShapelessRecipe(loader.getBlock().getRegistryName(), "lucky", result, ingredients);
                    loader.addRecipe((IRecipe)recipe);
                    RecipeAddons.addRecipe((IRecipe)recipe);
                    continue;
                }
                HashMap<Character, Ingredient> ingredientKeys = new HashMap<Character, Ingredient>();
                ingredientKeys.put(Character.valueOf(' '), Ingredient.field_193370_a);
                int recipeEnd = 0;
                for (i = recipePart.length - 1; i > 0; i -= 2) {
                    Ingredient ingredient = ResourceRecipes.getIngredient(recipePart[i]);
                    if (ingredient == null) {
                        recipeEnd = i;
                        break;
                    }
                    ingredientKeys.put(Character.valueOf(recipePart[i - 1].toCharArray()[0]), ingredient);
                }
                for (i = 0; i <= recipeEnd; ++i) {
                    for (char c : recipePart[i].toCharArray()) {
                        ingredients.add(ingredientKeys.get(Character.valueOf(c)));
                    }
                }
                int width = recipePart[0].length();
                int height = recipeEnd + 1;
                ShapedRecipe recipe = new ShapedRecipe(loader.getBlock().getRegistryName(), "lucky", width, height, ingredients, result);
                loader.addRecipe((IRecipe)recipe);
                RecipeAddons.addRecipe((IRecipe)recipe);
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    @Override
    public String getPath() {
        return "recipes.txt";
    }

    @Override
    public boolean isOptional() {
        return true;
    }

    @Override
    public boolean postInit() {
        return true;
    }
}

