/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.structure;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.io.DataInputStream;
import java.util.zip.GZIPInputStream;
import mod.lucky.Lucky;
import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.structure.BlockPlacer;
import mod.lucky.structure.Structure;
import mod.lucky.structure.StructureUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class TemplateStructure
extends Structure {
    private Template template;

    private StructureProcessor createProcessor() {
        final Structure.BlockMode blockMode = this.blockMode;
        return new StructureProcessor(){

            public Template.BlockInfo func_215194_a(IWorldReader worldIn, BlockPos structPos, Template.BlockInfo oldBlockInfo, Template.BlockInfo newBlockInfo, PlacementSettings settings) {
                BlockState blockState = StructureUtils.applyBlockMode(blockMode, newBlockInfo.field_186243_b);
                if (blockState == null) {
                    blockState = worldIn.func_180495_p(newBlockInfo.field_186242_a);
                }
                return new Template.BlockInfo(newBlockInfo.field_186242_a, blockState, newBlockInfo.field_186244_c);
            }

            protected IStructureProcessorType func_215192_a() {
                return IStructureProcessorType.field_214920_b;
            }

            protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
                return new Dynamic(ops, ops.emptyMap());
            }
        };
    }

    @Override
    public void process(DropProcessData processData) {
        DropSingle drop = processData.getDropSingle();
        BlockPlacer blockPlacer = new BlockPlacer(processData.getRawWorld());
        Rotation rotation = StructureUtils.parseRotation(drop.getPropertyInt("rotation"));
        PlacementSettings placementSettings = new PlacementSettings().func_186220_a(rotation).func_207665_a(new BlockPos(this.centerPos)).func_186222_a(false).func_186218_a(null).func_215222_a(this.createProcessor());
        BlockPos adjustedPos = drop.getBlockPos().func_177973_b((Vec3i)new BlockPos(this.centerPos));
        this.template.func_189962_a(processData.getRawWorld(), adjustedPos, placementSettings, 2);
        if (this.blockUpdate) {
            blockPlacer.update();
        }
        this.processOverlay(processData);
    }

    @Override
    public void readFromFile() {
        CompoundNBT tag = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(this.openFileStream()));
            tag = CompressedStreamTools.func_74794_a((DataInputStream)dataInputStream);
            dataInputStream.close();
        }
        catch (Exception e) {
            Lucky.error(e, "Error loading structure '" + this.fileName + "'");
        }
        this.template = new Template();
        if (tag != null) {
            this.template.func_186256_b(tag);
        }
        this.size = this.template.func_186259_a();
        this.initCenterPos();
    }
}

