/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.ilexiconn.jurassicraft.JurassiCraft;
import net.ilexiconn.jurassicraft.client.gui.GuiButtonDinopad;
import net.ilexiconn.jurassicraft.common.container.ContainerDinoPad;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftSmart;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiDinoPad
extends GuiContainer {
    private EntityJurassiCraftSmart creature;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;
    private float renderRotation;
    private int pageNumber;
    private HashMap<Integer, String[]> dinoInfo = new HashMap();

    public GuiDinoPad(ContainerDinoPad container) {
        super((Container)container);
        if (container.creatureToAnalyze instanceof EntityJurassiCraftSmart) {
            this.creature = (EntityJurassiCraftSmart)container.creatureToAnalyze;
            this.xSize = 256;
            this.ySize = 176;
        } else {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (this.creature == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.dinoInfo.clear();
        if (this.creature != null) {
            for (int numberOfPages = 1; numberOfPages <= this.creature.getCreature().getInfoPageCount(); ++numberOfPages) {
                this.dinoInfo.put(numberOfPages, this.getCreatureInformation(numberOfPages));
            }
            this.renderRotation = 0.0f;
            this.pageNumber = 0;
            this.guiLeft = (this.field_146294_l - this.xSize) / 2;
            this.guiTop = (this.field_146295_m - this.ySize) / 2;
            this.field_146292_n.add(new GuiButtonDinopad(0, this.guiLeft + (this.xSize - 18) / 2, this.guiTop + 146, 0, 210, 18, 18));
            this.field_146292_n.add(new GuiButtonDinopad(1, this.guiLeft + (this.xSize - 18) / 2 - 14, this.guiTop + 146, 36, 210, 12, 18));
            this.field_146292_n.add(new GuiButtonDinopad(2, this.guiLeft + (this.xSize - 18) / 2 + 20, this.guiTop + 146, 60, 210, 12, 18));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        this.creature = null;
        super.func_146281_b();
    }

    protected void func_73869_a(char keyChar, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_73876_c() {
        if (this.creature == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (!this.creature.func_70089_S()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.renderRotation += 1.0f;
    }

    public void func_146284_a(GuiButton button) {
        if (this.creature != null) {
            if (button.field_146127_k == 0) {
                this.pageNumber = 0;
            } else if (button.field_146127_k == 1) {
                this.pageNumber = this.pageNumber > 0 ? --this.pageNumber : this.creature.getCreature().getInfoPageCount();
            } else if (button.field_146127_k == 2) {
                this.pageNumber = this.pageNumber < this.creature.getCreature().getInfoPageCount() ? ++this.pageNumber : 0;
            }
        }
    }

    protected void func_146976_a(float f, int x, int y) {
        if (this.creature != null) {
            this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation(JurassiCraft.getModId() + "textures/gui/guiDinoPad.png"));
            this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
            switch (this.pageNumber) {
                case 0: {
                    this.renderEmptyBars();
                    this.renderStatusBars();
                    if (this.creature.getCreature().getCreatureID() >= 0 && this.creature.getCreatureLength() > this.creature.getCreatureHeight()) {
                        this.renderCreature(this.guiLeft + 67, this.guiTop + 108, 55.0f / this.creature.getCreatureLength() * (0.4f + 0.6f * this.creature.getCreatureLength() / this.creature.getCreature().getMaxLength()) * 4.0f);
                    } else {
                        this.renderCreature(this.guiLeft + 67, this.guiTop + 108, 55.0f / this.creature.getCreatureHeight() * (0.4f + 0.6f * this.creature.getCreatureHeight() / this.creature.getCreature().getMaxHeight()) * 4.0f);
                    }
                    this.renderNameGenderStrings();
                    this.renderStatusStrings();
                    this.renderTamedStrings();
                    break;
                }
                default: {
                    this.renderNameGenderStrings();
                    this.renderCreatureInformation(this.pageNumber);
                }
            }
        }
    }

    private void renderEmptyBars() {
        this.func_73729_b(this.guiLeft + 140, this.guiTop + 55, 0, 202, 98, 8);
        this.func_73729_b(this.guiLeft + 140, this.guiTop + 80, 0, 202, 98, 8);
        this.func_73729_b(this.guiLeft + 140, this.guiTop + 105, 0, 202, 98, 8);
    }

    private void renderStatusBars() {
        this.func_73729_b(this.guiLeft + 141, this.guiTop + 56, 1, 177, this.creature.getCreatureHealthScaled(95), 5);
        this.func_73729_b(this.guiLeft + 141, this.guiTop + 81, 1, 182, this.creature.getCreatureAttackScaled(95), 5);
        this.func_73729_b(this.guiLeft + 141, this.guiTop + 106, 1, 187, this.creature.getCreatureSpeedScaled(95), 5);
    }

    private void renderNameGenderStrings() {
        if (this.creature.func_94056_bM()) {
            this.field_146289_q.func_78276_b(this.creature.func_94057_bL() + " (" + this.creature.getCreatureName() + ")", this.guiLeft + 127 - this.field_146289_q.func_78256_a(this.creature.func_94057_bL() + "(" + this.creature.getCreatureName() + ")") / 2, this.guiTop + 11, 0xE0E0E0);
        } else {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.creature") + ": " + this.creature.getCreatureName(), this.guiLeft + 127 - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"container.pad.creature") + ": " + this.creature.getCreatureName()) / 2, this.guiTop + 11, 0xE0E0E0);
        }
        this.field_146289_q.func_78276_b(this.creature.getCreatureAgeString() + ", " + this.creature.getCreatureGenderString(), this.guiLeft + 127 - this.field_146289_q.func_78256_a(this.creature.getCreatureAgeString() + ", " + this.creature.getCreatureGenderString()) / 2, this.guiTop + 19, 0xE0E0E0);
    }

    private void renderStatusStrings() {
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.health") + ": " + String.valueOf(this.creature.getCreatureCurrentHealth() + "/" + this.creature.getCreatureHealth()), this.guiLeft + 192 - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"container.pad.health") + String.valueOf(this.creature.getCreatureCurrentHealth() + "/" + this.creature.getCreatureHealth())) / 2, this.guiTop + 45, 0xE0E0E0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.attack") + ": " + String.valueOf(this.creature.getCreatureAttack()), this.guiLeft + 192 - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"container.pad.attack") + String.valueOf(this.creature.getCreatureAttack())) / 2, this.guiTop + 70, 0xE0E0E0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.speed") + ": " + String.valueOf(this.creature.getCreatureSpeed()), this.guiLeft + 192 - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"container.pad.speed") + String.valueOf(this.creature.getCreatureSpeed())) / 2, this.guiTop + 95, 0xE0E0E0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.height") + ": " + String.valueOf(this.creature.getCreatureHeight()), this.guiLeft + 192 - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"container.pad.height") + String.valueOf(this.creature.getCreatureHeight())) / 2, this.guiTop + 116, 0xE0E0E0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.length") + ": " + String.valueOf(this.creature.getCreatureLength()), this.guiLeft + 192 - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"container.pad.length") + String.valueOf(this.creature.getCreatureLength())) / 2, this.guiTop + 126, 0xE0E0E0);
    }

    private void renderTamedStrings() {
        if (this.creature.isTamed()) {
            if (this.creature.getCreature().isRidable() && this.creature.isCreatureAdult()) {
                this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.owner") + ": " + this.creature.getOwnerName(), this.guiLeft + 67 - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"container.pad.owner") + this.creature.getOwnerName()) / 2, this.guiTop + 112, 0xE0E0E0);
                this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.ridable"), this.guiLeft + 67 - this.field_146289_q.func_78256_a("Ridable") / 2, this.guiTop + 122, 0xE0E0E0);
            } else {
                this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.owner") + ": " + this.creature.getOwnerName(), this.guiLeft + 67 - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"container.pad.owner") + ": " + this.creature.getOwnerName()) / 2, this.guiTop + 122, 0xE0E0E0);
            }
        } else {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.pad.owner") + ": " + StatCollector.func_74838_a((String)"container.pad.none"), this.guiLeft + 67 - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"container.pad.owner") + ": " + StatCollector.func_74838_a((String)"container.pad.none")) / 2, this.guiTop + 122, 0xE0E0E0);
        }
    }

    private String[] getCreatureInformation(int page) {
        String info = StatCollector.func_74838_a((String)("container.pad.info." + this.creature.getCreature().getCreatureName() + ".page" + page));
        String[] pageInfo = new String[8];
        if (info != null && info != "") {
            int line = 0;
            int index = 0;
            int infoSize = info.length();
            while (infoSize >= 43) {
                index = 43;
                while (!String.valueOf(info.substring(0, index).charAt(index - 1)).equals(" ")) {
                    --index;
                }
                pageInfo[line] = info.substring(0, index - 1);
                info = info.substring(index, infoSize);
                infoSize = info.length();
                ++line;
            }
            pageInfo[line] = info;
        }
        return pageInfo;
    }

    private void renderCreatureInformation(int page) {
        if (this.dinoInfo.containsKey(page)) {
            for (int line = 0; line < this.dinoInfo.get(page).length; ++line) {
                this.field_146289_q.func_78276_b(this.dinoInfo.get(page)[line], this.guiLeft + 128 - this.field_146289_q.func_78256_a(this.dinoInfo.get(page)[line]) / 2, this.guiTop + 45 + 12 * line, 0xE0E0E0);
            }
        } else {
            this.field_146289_q.func_78276_b("Page missing! This is a bug!", this.guiLeft + 128 - this.field_146289_q.func_78256_a("Page missing! This is a bug!") / 2, this.guiTop + 45, 0xE0E0E0);
        }
    }

    private void renderCreature(float posX, float posY, float scale) {
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)posX, (float)posY, (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(1.5f * this.renderRotation), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)this.creature.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)this.creature, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }
}

