/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.client.gui.GuiOverride;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiScreenEvent;

@SideOnly(value=Side.CLIENT)
public class GuiHelper {
    private static final double timeU = 5.0E7;
    private static Map<GuiOverride, Class<? extends GuiScreen>> overrideMap = Maps.newHashMap();
    private static long initialTime = System.nanoTime();
    private static double deltaU = 0.0;
    private static long timer = System.currentTimeMillis();
    private Minecraft mc = Minecraft.func_71410_x();

    public static void addOverride(Class<? extends GuiScreen> clazz, GuiOverride gui) {
        overrideMap.put(gui, clazz);
    }

    public static List<GuiOverride> getOverridesForGui(Class<? extends GuiScreen> clazz) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<GuiOverride, Class<? extends GuiScreen>> e : overrideMap.entrySet()) {
            if (e.getValue() != clazz) continue;
            list.add(e.getKey());
        }
        return list;
    }

    public static Map<GuiOverride, Class<? extends GuiScreen>> getOverrides() {
        return overrideMap;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        for (Map.Entry<GuiOverride, Class<? extends GuiScreen>> e : GuiHelper.getOverrides().entrySet()) {
            if (event.gui.getClass() != e.getValue()) continue;
            GuiOverride gui = e.getKey();
            long currentTime = System.nanoTime();
            deltaU += (double)(currentTime - initialTime) / 5.0E7;
            initialTime = currentTime;
            gui.field_146294_l = event.gui.field_146294_l;
            gui.field_146295_m = event.gui.field_146295_m;
            gui.overriddenScreen = event.gui;
            if (deltaU >= 1.0) {
                gui.func_73876_c();
                deltaU -= 1.0;
            }
            if (System.currentTimeMillis() - timer > 1000L) {
                timer += 1000L;
            }
            gui.func_73863_a(event.mouseX, event.mouseY, event.renderPartialTicks);
            if (gui.field_146292_n.isEmpty()) continue;
            List buttonList = (List)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)event.gui, (String[])new String[]{"buttonList", "field_146292_n"});
            for (GuiButton button : gui.field_146292_n) {
                for (int i = 0; i < buttonList.size(); ++i) {
                    GuiButton button1 = (GuiButton)buttonList.get(i);
                    if (button.field_146127_k != button1.field_146127_k) continue;
                    buttonList.remove(button1);
                }
            }
            buttonList.addAll(gui.field_146292_n);
            ObfuscationReflectionHelper.setPrivateValue(GuiScreen.class, (Object)event.gui, (Object)buttonList, (String[])new String[]{"buttonList", "field_146292_n"});
        }
    }

    @SubscribeEvent
    public void onButtonPressPre(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        for (Map.Entry<GuiOverride, Class<? extends GuiScreen>> e : GuiHelper.getOverrides().entrySet()) {
            if (event.gui.getClass() != e.getValue()) continue;
            e.getKey().func_146284_a(event.button);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Pre event) {
        for (Map.Entry<GuiOverride, Class<? extends GuiScreen>> e : GuiHelper.getOverrides().entrySet()) {
            if (event.gui.getClass() != e.getValue()) continue;
            e.getKey().func_146280_a(this.mc, event.gui.field_146294_l, event.gui.field_146295_m);
        }
    }
}

