/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.ilexiconn.llibrary.client.gui.GuiSlotItemStackList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoublePlant;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiPickItem
extends GuiScreen {
    public String title;
    private GuiScreen parentScreen;
    private GuiSlotItemStackList itemList;
    private GuiTextField textField;
    private RenderItem renderItem = new RenderItem();
    private ArrayList<ItemStack> items = Lists.newArrayList();
    public ArrayList<ItemStack> itemsFiltered = Lists.newArrayList();
    private int selectedIndex;
    private int listWidth;

    public GuiPickItem(String t) {
        this.title = t;
        this.parentScreen = Minecraft.func_71410_x().field_71462_r;
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.func_146280_a(mc, w, h);
        this.textField = new GuiTextField(this.field_146289_q, 20, 30, 103, 12);
        this.textField.func_146203_f(40);
        for (Item item : Item.field_150901_e) {
            ItemStack itemstack = new ItemStack(item);
            if (item == null) continue;
            try {
                this.items.add(itemstack);
                ArrayList subItems = Lists.newArrayList();
                item.func_150895_a(item, null, (List)subItems);
                int maxDamage = subItems.size() - 1;
                while (item.func_77614_k() && itemstack.func_77960_j() < maxDamage) {
                    itemstack.func_77964_b(itemstack.func_77960_j() + 1);
                    if (item instanceof ItemDoublePlant || Block.func_149634_a((Item)item) instanceof BlockMobSpawner || Block.func_149634_a((Item)item) instanceof BlockDoublePlant || item instanceof ItemMonsterPlacer) continue;
                    this.items.add(new ItemStack(item, 1, itemstack.func_77960_j()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (ItemStack itemstack : this.items) {
            this.listWidth = Math.max(this.listWidth, this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)itemstack.func_82833_r())) + 30);
        }
        this.listWidth = Math.min(this.listWidth, 300);
        if (this.textField != null) {
            this.textField.field_146209_f = 20 + this.listWidth / 2 - this.textField.field_146218_h / 2;
            this.textField.field_146210_g = 30;
        }
        this.field_146292_n.add(new GuiButton(0, 20, this.field_146295_m - 40, this.listWidth, 20, "Select"));
        this.itemList = new GuiSlotItemStackList(this, this.listWidth);
        this.itemList.registerScrollButtons(this.field_146292_n, 7, 8);
    }

    public abstract void onSelectEntry(ItemStack var1, EntityPlayer var2);

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.onSelectEntry(this.itemsFiltered.get(this.selectedIndex), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    protected void func_73869_a(char c, int key) {
        Keyboard.enableRepeatEvents((boolean)true);
        this.textField.func_146201_a(c, key);
        if (key == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        this.textField.func_146192_a(mouseX, mouseY, button);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.filterItemsBySearch();
        this.itemList.drawScreen(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, 20 + this.listWidth / 2, 15, 0xFFFFFF);
        this.textField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void filterItemsBySearch() {
        this.itemsFiltered.clear();
        for (ItemStack itemstack : this.items) {
            try {
                String name = StatCollector.func_74838_a((String)itemstack.func_82833_r());
                Item item = itemstack.func_77973_b();
                boolean tabEquals = false;
                if (item != null) {
                    CreativeTabs tab;
                    CreativeTabs[] creativeTabsArray = item.getCreativeTabs();
                    int n = creativeTabsArray.length;
                    for (int i = 0; !(i >= n || (tab = creativeTabsArray[i]) != null && (tabEquals = StatCollector.func_74838_a((String)tab.func_78024_c()).toLowerCase().contains(this.textField.func_146179_b().toLowerCase()))); ++i) {
                    }
                }
                if (!name.toLowerCase().contains(this.textField.func_146179_b().toLowerCase()) && !tabEquals) continue;
                this.itemsFiltered.add(itemstack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void drawItemStack(int x, int y, ItemStack itemstack) {
        RenderHelper.func_74520_c();
        this.field_73735_i = 100.0f;
        this.renderItem.field_77023_b = 100.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        this.renderItem.func_77015_a(this.field_146297_k.field_71466_p, this.field_146297_k.field_71446_o, itemstack, x, y);
        this.renderItem.func_77021_b(this.field_146297_k.field_71466_p, this.field_146297_k.field_71446_o, itemstack, x, y);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        this.renderItem.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        RenderHelper.func_74518_a();
    }

    public void selectItemIndex(int var1) {
        this.selectedIndex = var1;
    }

    public boolean itemIndexSelected(int var1) {
        return this.selectedIndex == var1;
    }
}

