/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui;

import cpw.mods.fml.client.GuiScrollingList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import net.ilexiconn.llibrary.client.gui.GuiCheckForUpdates;
import net.ilexiconn.llibrary.common.json.container.JsonModUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSlotModUpdateContainerList
extends GuiScrollingList {
    private GuiCheckForUpdates parent;
    private ResourceLocation[] cachedLogo;
    private Dimension[] cachedLogoDimensions;

    public GuiSlotModUpdateContainerList(GuiCheckForUpdates parent, int listWidth) {
        super(parent.getMinecraftInstance(), listWidth, parent.field_146295_m, 20, parent.field_146295_m - 45, 20, 34);
        this.parent = parent;
        this.cachedLogo = new ResourceLocation[this.getSize()];
        this.cachedLogoDimensions = new Dimension[this.getSize()];
    }

    protected int getSize() {
        return this.parent.outdatedMods.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.selectItemIndex(index);
    }

    protected boolean isSelected(int index) {
        return this.parent.itemIndexSelected(index);
    }

    protected void drawBackground() {
        this.parent.func_146276_q_();
    }

    protected int getContentHeight() {
        return this.getSize() * 34 + 1;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    protected void drawSlot(int listIndex, int x, int y, int par4, Tessellator tessellator) {
        JsonModUpdate mod;
        if (listIndex < this.parent.outdatedMods.size() && (mod = this.parent.outdatedMods.get(listIndex)) != null) {
            int i = 36;
            this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a(mod.name, this.listWidth - 10), this.left + i, y + 2, 0xFFFFFF);
            this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a(mod.modid, this.listWidth - 10), this.left + i, y + 12, 0xCCCCCC);
            this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a(mod.currentVersion, this.listWidth - 10), this.left + i, y + 22, 0xCCCCCC);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = this.parent.getMinecraftInstance();
            TextureManager tm = mc.func_110434_K();
            if (this.cachedLogo[listIndex] == null) {
                BufferedImage logo = mod.thumbnail;
                if (logo != null) {
                    this.cachedLogo[listIndex] = tm.func_110578_a("mod_thumbnail", new DynamicTexture(logo));
                    this.cachedLogoDimensions[listIndex] = new Dimension(logo.getWidth(), logo.getHeight());
                }
            } else {
                mc.field_71446_o.func_110577_a(this.cachedLogo[listIndex]);
                double scaleX = (double)this.cachedLogoDimensions[listIndex].width / 32.0;
                double scaleY = (double)this.cachedLogoDimensions[listIndex].height / 32.0;
                double scale = 1.0;
                if (scaleX > 1.0 || scaleY > 1.0) {
                    scale = 1.0 / Math.max(scaleX, scaleY);
                }
                this.cachedLogoDimensions[listIndex].width = (int)((double)this.cachedLogoDimensions[listIndex].width * scale);
                this.cachedLogoDimensions[listIndex].height = (int)((double)this.cachedLogoDimensions[listIndex].height * scale);
                int top = y - 1;
                int offset = 21;
                Tessellator tess = Tessellator.field_78398_a;
                tess.func_78382_b();
                tess.func_78374_a((double)offset, (double)(top + this.cachedLogoDimensions[listIndex].height), 0.0, 0.0, 1.0);
                tess.func_78374_a((double)(offset + this.cachedLogoDimensions[listIndex].width), (double)(top + this.cachedLogoDimensions[listIndex].height), 0.0, 1.0, 1.0);
                tess.func_78374_a((double)(offset + this.cachedLogoDimensions[listIndex].width), (double)top, 0.0, 1.0, 0.0);
                tess.func_78374_a((double)offset, (double)top, 0.0, 0.0, 0.0);
                tess.func_78381_a();
            }
        }
    }
}

