/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.dictionary;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.EnumHelper;

public class WeaponDictionary {
    private static final int WEAPON_LIST_SIZE = 10240;
    private static WeaponInfo[] weaponList = new WeaponInfo[10240];
    private static ArrayList<Item>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerWeaponType(Item item, Type ... types) {
        types = WeaponDictionary.listSubTags(types);
        if (item != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    WeaponDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(item);
            }
            if (weaponList[Item.func_150891_b((Item)item)] == null) {
                WeaponDictionary.weaponList[Item.func_150891_b((Item)item)] = new WeaponInfo(types);
            } else {
                Collections.addAll(WeaponDictionary.weaponList[Item.func_150891_b((Item)item)].typeList, types);
            }
            return true;
        }
        return false;
    }

    public static Item[] getWeaponsForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new Item[0]);
        }
        return new Item[0];
    }

    public static Type[] getTypesForWeapon(Item item) {
        WeaponDictionary.checkRegistration(item);
        if (weaponList[Item.func_150891_b((Item)item)] != null) {
            return WeaponDictionary.weaponList[Item.func_150891_b((Item)item)].typeList.toArray(new Type[0]);
        }
        return new Type[0];
    }

    public static boolean areWeaponsEquivalent(Item itemA, Item itemB) {
        int a = Item.func_150891_b((Item)itemA);
        int b = Item.func_150891_b((Item)itemB);
        WeaponDictionary.checkRegistration(itemA);
        WeaponDictionary.checkRegistration(itemB);
        if (weaponList[a] != null && weaponList[b] != null) {
            for (Type type : WeaponDictionary.weaponList[a].typeList) {
                if (!WeaponDictionary.containsType(weaponList[b], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWeaponOfType(Item item, Type type) {
        WeaponDictionary.checkRegistration(item);
        return weaponList[Item.func_150891_b((Item)item)] != null && WeaponDictionary.containsType(weaponList[Item.func_150891_b((Item)item)], type);
    }

    public static boolean isWeaponRegistered(Item item) {
        return weaponList[Item.func_150891_b((Item)item)] != null;
    }

    public static boolean isWeaponRegistered(int itemID) {
        return weaponList[itemID] != null;
    }

    public static void makeBestGuess(Item item) {
    }

    private static void checkRegistration(Item item) {
    }

    private static boolean containsType(WeaponInfo info, Type type) {
        if (type.hasSubTags()) {
            for (Type remappedType : WeaponDictionary.listSubTags(type)) {
                if (!info.typeList.contains((Object)remappedType)) continue;
                return true;
            }
            return false;
        }
        return info.typeList.contains((Object)type);
    }

    private static Type[] listSubTags(Type ... types) {
        ArrayList subTags = Lists.newArrayList();
        for (Type type : types) {
            if (type.hasSubTags()) {
                subTags.addAll(type.subTags);
                continue;
            }
            subTags.add(type);
        }
        return subTags.toArray(new Type[subTags.size()]);
    }

    private static void registerVanillaWeapons() {
        WeaponDictionary.registerWeaponType(Items.field_151041_m, Type.SWORD, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151052_q, Type.SWORD, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151040_l, Type.SWORD, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151048_u, Type.SWORD, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151010_B, Type.SWORD, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151053_p, Type.AXE, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151049_t, Type.AXE, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151036_c, Type.AXE, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151056_x, Type.AXE, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151006_E, Type.AXE, Type.SHARP, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151039_o, Type.PICKAXE, Type.DULL, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151050_s, Type.PICKAXE, Type.DULL, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151035_b, Type.PICKAXE, Type.DULL, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151046_w, Type.PICKAXE, Type.DULL, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151005_D, Type.PICKAXE, Type.DULL, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151038_n, Type.SHOVEL, Type.DULL, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151051_r, Type.SHOVEL, Type.DULL, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151037_a, Type.SHOVEL, Type.DULL, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151047_v, Type.SHOVEL, Type.DULL, Type.MELEE);
        WeaponDictionary.registerWeaponType(Items.field_151011_C, Type.SHOVEL, Type.DULL, Type.MELEE);
    }

    static /* synthetic */ ArrayList[] access$202(ArrayList[] x0) {
        typeInfoList = x0;
        return x0;
    }

    static {
        WeaponDictionary.registerVanillaWeapons();
    }

    private static class WeaponInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public WeaponInfo(Type[] types) {
            Collections.addAll(this.typeList, types);
        }
    }

    public static enum Type {
        SWORD(new Type[0]),
        AXE(new Type[0]),
        PICKAXE(new Type[0]),
        SHOVEL(new Type[0]),
        NUNCHUCKS(new Type[0]),
        SPEAR(new Type[0]),
        WAND(new Type[0]),
        BOW(new Type[0]),
        HALBERD(new Type[0]),
        GUN(new Type[0]),
        MACE(new Type[0]),
        HAMMER(new Type[0]),
        SICLE(new Type[0]),
        SCYTHE(new Type[0]),
        KIFE(new Type[0]),
        CLAW(new Type[0]),
        GLOVE(new Type[0]),
        WHIP(new Type[0]),
        BOOMERANG(new Type[0]),
        SHARP(new Type[0]),
        DULL(new Type[0]),
        LIGHT(new Type[0]),
        HEAVY(new Type[0]),
        RANGED(new Type[0]),
        MELEE(new Type[0]),
        MELEE_RANGED(new Type[0]),
        THROWABLE(new Type[0]),
        MAGICAL(new Type[0]),
        EXPLOSIVE(new Type[0]),
        FIERY(new Type[0]),
        WATERY(new Type[0]),
        ICY(new Type[0]),
        ELECTRICAL(new Type[0]),
        DEATHLY(new Type[0]),
        PLANT_Y(new Type[0]),
        EARTHLY(new Type[0]),
        WINDY(new Type[0]),
        ENDER(new Type[0]),
        POISONED(new Type[0]),
        FUTURISTIC(new Type[0]),
        MEDIEVAL(new Type[0]),
        MODERN(new Type[0]);

        private List<Type> subTags;

        private Type(Type ... subTags) {
            this.subTags = Arrays.asList(subTags);
        }

        public static Type getType(String name, Type ... subTypes) {
            name = name.toUpperCase();
            for (Type t : Type.values()) {
                if (!t.name().equals(name)) continue;
                return t;
            }
            Type ret = (Type)EnumHelper.addEnum(Type.class, (String)name, (Class[])new Class[]{Type[].class}, (Object[])new Object[]{subTypes});
            if (ret.ordinal() >= typeInfoList.length) {
                WeaponDictionary.access$202(Arrays.copyOf(typeInfoList, ret.ordinal()));
            }
            return ret;
        }

        private boolean hasSubTags() {
            return this.subTags != null && !this.subTags.isEmpty();
        }
    }
}

