/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.update;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.Mod;
import java.io.IOException;
import java.util.ArrayList;
import net.ilexiconn.llibrary.common.json.JsonFactory;
import net.ilexiconn.llibrary.common.json.container.JsonModUpdate;
import net.ilexiconn.llibrary.common.web.WebHelper;

public class UpdateHelper {
    public static ArrayList<JsonModUpdate> modList = Lists.newArrayList();

    public static void registerUpdateChecker(Object mod, String url) throws IOException {
        JsonModUpdate json = (JsonModUpdate)JsonFactory.getGson().fromJson(WebHelper.downloadTextFile(url), JsonModUpdate.class);
        Class<?> modClass = mod.getClass();
        if (!modClass.isAnnotationPresent(Mod.class)) {
            return;
        }
        Mod annotation = modClass.getAnnotation(Mod.class);
        try {
            json.modid = annotation.modid();
            json.currentVersion = annotation.version();
            json.name = annotation.name();
            json.thumbnail = WebHelper.downloadImage(json.getIconUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        modList.add(json);
    }

    public static JsonModUpdate getModContainerById(String modid) {
        for (JsonModUpdate mod : modList) {
            if (!mod.modid.equals(modid)) continue;
            return mod;
        }
        return null;
    }
}

