/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.web;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class WebHelper {
    private static String pastebinURLPrefix = "http://pastebin.com/raw.php?i=";

    public static List<String> readPastebinAsList(String pasteId) throws IOException {
        return WebHelper.downloadTextFileList(pastebinURLPrefix + pasteId);
    }

    public static String readPastebin(String pasteId) throws IOException {
        return WebHelper.downloadTextFile(pastebinURLPrefix + pasteId);
    }

    public static List<String> downloadTextFileList(String urlString) throws IOException {
        String currentLine;
        ArrayList text = Lists.newArrayList();
        URL url = new URL(urlString);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((currentLine = reader.readLine()) != null) {
            text.add(currentLine);
        }
        reader.close();
        return text;
    }

    public static String downloadTextFile(String urlString) throws IOException {
        String currentLine;
        String text = "";
        URL url = new URL(urlString);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((currentLine = reader.readLine()) != null) {
            text = text + currentLine + "\r\n";
        }
        reader.close();
        return text;
    }

    public static byte[] download(String rawURL) throws IOException {
        URL url = new URL(rawURL);
        try {
            int i;
            InputStream in = url.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((i = in.read(buffer)) != -1) {
                baos.write(buffer, 0, i);
            }
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage downloadImage(String imageURL) throws IOException {
        URL url = new URL(imageURL);
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        return ImageIO.read(in);
    }
}

